/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface TokenList {
    public int getTokenCount();

    @NotNull
    public CharSequence getTokenizedText();

    public int getTokenStart(int var1);

    public int getTokenEnd(int var1);

    @NotNull
    default public TextRange getTokenRange(int index) {
        return new TextRange(this.getTokenStart(index), this.getTokenEnd(index));
    }

    public IElementType getTokenType(int var1);

    default public CharSequence getTokenText(int index) {
        if (index < 0 || index >= this.getTokenCount()) {
            return null;
        }
        return this.getTokenizedText().subSequence(this.getTokenStart(index), this.getTokenEnd(index));
    }

    default public boolean hasType(int index, @NotNull IElementType type) {
        if (type == null) {
            TokenList.$$$reportNull$$$0(0);
        }
        return this.getTokenType(index) == type;
    }

    default public boolean hasType(int index, IElementType ... types) {
        if (types == null) {
            TokenList.$$$reportNull$$$0(1);
        }
        return ArrayUtil.contains(this.getTokenType(index), types);
    }

    default public boolean hasType(int index, @NotNull TokenSet types) {
        if (types == null) {
            TokenList.$$$reportNull$$$0(2);
        }
        return types.contains(this.getTokenType(index));
    }

    default public int backWithBraceMatching(int index, @NotNull IElementType opening, @NotNull IElementType closing) {
        if (opening == null) {
            TokenList.$$$reportNull$$$0(3);
        }
        if (closing == null) {
            TokenList.$$$reportNull$$$0(4);
        }
        if (this.getTokenType(index) == closing) {
            int nesting = 1;
            while (nesting > 0 && index > 0) {
                IElementType type;
                if ((type = this.getTokenType(--index)) == closing) {
                    ++nesting;
                    continue;
                }
                if (type != opening) continue;
                --nesting;
            }
        }
        return index - 1;
    }

    default public int backWhile(int index, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(5);
        }
        while (this.hasType(index, toSkip)) {
            --index;
        }
        return index;
    }

    default public int forwardWhile(int index, @NotNull TokenSet toSkip) {
        if (toSkip == null) {
            TokenList.$$$reportNull$$$0(6);
        }
        while (this.hasType(index, toSkip)) {
            ++index;
        }
        return index;
    }

    @NotNull
    public Lexer asLexer();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opening";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closing";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lexer/TokenList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "backWithBraceMatching";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "backWhile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forwardWhile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

