/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.dto.HubChartDto;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.helm.model.FullDependencyInsertHandler;
import com.intellij.kubernetes.helm.model.HelmMetaClassDefinitionsKt;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.SimpleKeyValueInsertHandler;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.references.RegularHelmValueReference;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "Companion", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyNameMetaClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,586:1\n1#2:587\n1#2:608\n30#3,2:588\n30#3,2:592\n30#3,2:611\n66#4,2:590\n1563#5:594\n1634#5,3:595\n1617#5,9:598\n1869#5:607\n1870#5:609\n1626#5:610\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyNameMetaClass\n*L\n295#1:608\n277#1:588,2\n315#1:592,2\n282#1:611,2\n313#1:590,2\n291#1:594\n291#1:595,3\n295#1:598,9\n295#1:607\n295#1:609\n295#1:610\n*E\n"})
public final class DependencyNameMetaClass
extends YamlReferenceType {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DependencyNameMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(YamlStringType.getInstance().getTypeName());
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Collection charts;
        String string;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        YAMLMapping yAMLMapping = (YAMLMapping)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)((PsiElement)scalarValue), YAMLMapping.class);
        if (yAMLMapping == null) {
            return;
        }
        YAMLMapping dependencyMapping = yAMLMapping;
        HelmDependencyRepository helmDependencyRepository = HelmMetaClassDefinitionsKt.access$getRepoFromDependencyMapping(dependencyMapping);
        if (helmDependencyRepository == null) {
            return;
        }
        HelmDependencyRepository repo = helmDependencyRepository;
        String p0 = string = YamlUtilKt.getEffectiveText((YAMLValue)((YAMLValue)scalarValue));
        boolean bl = false;
        String string2 = ((CharSequence)p0).length() > 0 ? string : null;
        if (string2 == null) {
            return;
        }
        String chartName = string2;
        Callable<Collection> callable = () -> DependencyNameMetaClass.validateScalarValue$lambda$0(repo, chartName);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Collection collection = charts = (Collection)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
        boolean bl2 = collection != null ? collection.isEmpty() : false;
        if (bl2) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message((String)"HelmChartUnknownValuesInspection.cannot.find.chart.in.repository.message", (Object[])new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar scalarValue, @Nullable CompletionContext completionContext) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        YAMLMapping yAMLMapping = (YAMLMapping)YamlUtilKt.getTypedAncestorOrSelf((PsiElement)((PsiElement)scalarValue), YAMLMapping.class);
        if (yAMLMapping == null) {
            List<LookupElement> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        YAMLMapping dependencyMapping = yAMLMapping;
        HelmDependencyRepository repo = HelmMetaClassDefinitionsKt.access$getRepoFromDependencyMapping(dependencyMapping);
        Object object = ActionsKt.runReadAction(() -> DependencyNameMetaClass.getValueLookups$lambda$0(dependencyMapping));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Project project = (Project)object;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HelmIndex> serviceClass$iv = HelmIndex.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        HelmIndex helmIndex = (HelmIndex)object2;
        Callable<List> lookupListCalculator = () -> DependencyNameMetaClass.getValueLookups$lambda$1(repo, completionContext, helmIndex, project, dependencyMapping);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Object object3 = ApplicationUtil.runWithCheckCanceled(lookupListCalculator, (ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runWithCheckCanceled(...)");
        return (List)object3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)valueScalar));
        if (virtualFile == null) {
            return new PsiReference[0];
        }
        VirtualFile vfsFile = virtualFile;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)valueScalar;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLMapping yAMLMapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLMapping.class, (boolean)true);
        String version = yAMLMapping != null && (yAMLMapping = YamlUtilKt.get((YAMLMapping)yAMLMapping, (String)"version")) != null ? YamlUtilKt.getEffectiveText((YAMLValue)yAMLMapping) : null;
        Project project = valueScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile2 = vfsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart = chartManager.findChartByBaseDir(virtualFile2);
        if (chart != null) {
            String string = valueScalar.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            Chart chart2 = chart.findSubChart(string, version);
            if (chart2 != null) {
                Chart it = chart2;
                boolean bl = false;
                RegularHelmValueReference it2 = new RegularHelmValueReference((PsiElement)valueScalar, HelmResolveUtilKt.getRootPathInChart(it));
                boolean bl2 = false;
                PsiReference[] psiReferenceArray2 = new PsiReference[]{it2};
                psiReferenceArray = psiReferenceArray2;
                return psiReferenceArray;
            }
        }
        psiReferenceArray = new PsiReference[]{};
        return psiReferenceArray;
    }

    private static final Collection validateScalarValue$lambda$0(HelmDependencyRepository $repo, String $chartName) {
        return $repo.getDependencyCharts($chartName);
    }

    private static final Project getValueLookups$lambda$0(YAMLMapping $dependencyMapping) {
        return $dependencyMapping.getProject();
    }

    /*
     * WARNING - void declaration
     */
    private static final List getValueLookups$lambda$1(HelmDependencyRepository $repo, CompletionContext $completionContext, HelmIndex $helmIndex, Project $project, YAMLMapping $dependencyMapping) {
        List lookups;
        List list;
        List list2;
        if ($repo != null && $completionContext != null && $completionContext.getCompletionType() == CompletionType.BASIC && $completionContext.getInvocationCount() == 1) {
            Collection<String> collection = $repo.getDependencyNames();
            if (collection != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)Companion.DependencyNameInsertHandler.INSTANCE));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = DependencyNameMetaClass.getValueLookups$lambda$1$jointListOfLocalAndRemoteDependencies($helmIndex, $project, $dependencyMapping);
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupElementBuilder lookupElementBuilder;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HubChartDto it = (HubChartDto)element$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                if (string == null) {
                    LookupElementBuilder lookupElementBuilder2;
                    lookupElementBuilder = lookupElementBuilder2 = null;
                } else {
                    LookupElementBuilder lookupElementBuilder3 = LookupElementBuilder.create((Object)it).withLookupString(string).withPresentableText(it.getName());
                    String string2 = it.getVersion();
                    if (string2 == null) {
                        string2 = "no version";
                    }
                    HubRepoDto hubRepoDto = it.getRepository();
                    lookupElementBuilder = lookupElementBuilder3.withTailText(" (" + string2 + ")").withTypeText(hubRepoDto != null ? hubRepoDto.getName() : null, true).withInsertHandler((InsertHandler)FullDependencyInsertHandler.INSTANCE);
                }
                if (lookupElementBuilder == null) continue;
                LookupElementBuilder it$iv$iv = lookupElementBuilder;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        if ((list = (lookups = list2)) == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        return list;
    }

    private static final List<HubChartDto> getValueLookups$lambda$1$jointListOfLocalAndRemoteDependencies(HelmIndex helmIndex, Project project, YAMLMapping dependencyMapping) {
        Collection collection = (Collection)ActionsKt.runReadAction(() -> DependencyNameMetaClass.getValueLookups$lambda$1$jointListOfLocalAndRemoteDependencies$0(project, dependencyMapping));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection localDependencies = collection;
        return CollectionsKt.plus(helmIndex.getAllCharts(), (Iterable)localDependencies);
    }

    private static final Collection getValueLookups$lambda$1$jointListOfLocalAndRemoteDependencies$0(Project $project, YAMLMapping $dependencyMapping) {
        ComponentManager $this$service$iv = (ComponentManager)$project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart = ((ChartManager)object).findChartByMetadataElement((PsiElement)$dependencyMapping);
        return chart != null ? HelmMetaClassDefinitionsKt.getLocalRepositoryChartsAsHubCharts(chart) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass$Companion;", "", "<init>", "()V", "DependencyNameInsertHandler", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass$Companion$DependencyNameInsertHandler;", "Lcom/intellij/kubernetes/helm/model/SimpleKeyValueInsertHandler;", "<init>", "()V", "intellij.clouds.kubernetes.backend"})
        private static final class DependencyNameInsertHandler
        extends SimpleKeyValueInsertHandler {
            @NotNull
            public static final DependencyNameInsertHandler INSTANCE = new DependencyNameInsertHandler();

            private DependencyNameInsertHandler() {
                super("name");
            }
        }
    }
}

