/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public abstract class KubernetesComposedTypeBase
extends YamlMetaType {
    protected final List<YamlMetaType> myTypes;

    protected KubernetesComposedTypeBase(@NotNull String typeName, @NonNls @NotNull String displayName, List<YamlMetaType> types) {
        if (typeName == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(0);
        }
        if (displayName == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(1);
        }
        super(typeName, displayName);
        this.myTypes = KubernetesComposedTypeBase.copyList(types);
    }

    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        if (name == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(2);
        }
        return KubernetesComposedTypeBase.mergeFields(name, this.myTypes.stream().map(type -> type.findFeatureByName(name)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        if (existingFields == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(3);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        HashSet<String> processedNames = new HashSet<String>();
        LinkedHashSet<Field> result2 = new LinkedHashSet<Field>();
        for (YamlMetaType nextSubType : this.myTypes) {
            if (nextSubType instanceof YamlScalarType) continue;
            List subTypeCompletions = nextSubType.computeKeyCompletions(existingMapping);
            for (Field nextField : subTypeCompletions) {
                String nextFieldName = nextField.getName();
                if (processedNames.contains(nextFieldName)) continue;
                Field mergedField = this.findFeatureByName(nextFieldName);
                processedNames.add(nextFieldName);
                result2.add(mergedField);
            }
        }
        return new ArrayList<Field>(result2);
    }

    private boolean hasScalarSubtypes() {
        for (YamlMetaType type : this.myTypes) {
            if (type instanceof YamlScalarType) {
                return true;
            }
            if (!(type instanceof KubernetesComposedTypeBase) || !((KubernetesComposedTypeBase)type).hasScalarSubtypes()) continue;
            return true;
        }
        return false;
    }

    public void validateDeep(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        if (value == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(6);
        }
        this.validateValue(value, problemsHolder);
    }

    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        if (markup == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(7);
        }
        if (relation == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(8);
        }
        if (iteration == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(9);
        }
        if (relation == Field.Relation.SCALAR_VALUE || relation == Field.Relation.OBJECT_CONTENTS && this.hasScalarSubtypes()) {
            markup.append(": ");
        } else {
            markup.append(":");
            markup.increaseTabs(1);
            markup.newLineAndTabs(relation == Field.Relation.SEQUENCE_ITEM);
        }
        markup.appendCaret();
    }

    protected final Stream<YamlMetaType> streamSubTypes() {
        return this.myTypes.stream();
    }

    private static <T> List<T> copyList(@NotNull List<T> list) {
        if (list == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(10);
        }
        return list.isEmpty() ? Collections.emptyList() : new SmartList(list);
    }

    @Nullable
    private static Field mergeFields(@NotNull String theName, @NotNull List<Field> fields) {
        YamlMetaType sequentialCompositeType;
        if (theName == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(11);
        }
        if (fields == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(12);
        }
        if (fields.isEmpty()) {
            return null;
        }
        Map<Boolean, List<YamlMetaType>> typesGroupedByMultiplicity = KubernetesComposedTypeBase.splitByMultiplicity(fields);
        boolean required = fields.stream().allMatch(f -> f.isRequired());
        boolean deprecated = fields.stream().allMatch(f -> f.isDeprecated());
        boolean editable = fields.stream().anyMatch(f -> f.isEditable());
        boolean emptyAllowed = fields.stream().anyMatch(f -> f.isEmptyValueAllowed());
        boolean anyName = fields.stream().allMatch(f -> f.isAnyNameAllowed());
        List<YamlMetaType> singularTypes = typesGroupedByMultiplicity.get(false);
        YamlMetaType singularCompositeType = singularTypes != null && !singularTypes.isEmpty() ? KubernetesComposedTypeBase.composeTypes(singularTypes) : null;
        List<YamlMetaType> sequentialTypes = typesGroupedByMultiplicity.get(true);
        YamlMetaType yamlMetaType = sequentialCompositeType = sequentialTypes != null && !sequentialTypes.isEmpty() ? KubernetesComposedTypeBase.composeTypes(sequentialTypes) : null;
        assert (singularCompositeType != null || sequentialCompositeType != null);
        Field result2 = new Field(theName, singularCompositeType != null ? singularCompositeType : sequentialCompositeType);
        if (singularCompositeType == null) {
            result2.withMultiplicityMany();
        } else if (sequentialCompositeType != null) {
            result2.withRelationSpecificType(Field.Relation.SEQUENCE_ITEM, sequentialCompositeType);
        }
        if (required) {
            result2.setRequired();
        }
        if (deprecated) {
            result2.setDeprecated();
        }
        if (!editable) {
            result2.setNonEditable();
        }
        result2.withEmptyValueAllowed(emptyAllowed);
        if (anyName) {
            result2.withAnyName();
        }
        return result2;
    }

    private static Map<Boolean, List<YamlMetaType>> splitByMultiplicity(@NotNull List<Field> fields) {
        if (fields == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(13);
        }
        return fields.stream().collect(Collectors.groupingBy(field2 -> field2.isMany(), Collectors.mapping(field2 -> field2.getDefaultType(), Collectors.toList())));
    }

    protected static ProblemsHolder makeCopy(@NotNull ProblemsHolder original) {
        if (original == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(14);
        }
        return new ProblemsHolder(original.getManager(), original.getFile(), original.isOnTheFly());
    }

    protected static YamlMetaType composeTypes(@NotNull List<YamlMetaType> types) {
        if (types == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(15);
        }
        if (types.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String name = "composed[" + types.stream().map(YamlMetaType::getDisplayName).collect(Collectors.joining(",")) + "]";
        return new KubernetesComposedTypeBase(name, name, (List)types){};
    }

    @NotNull
    protected static PsiElement getElementToHighlight(@NotNull YAMLValue value) {
        if (value == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(16);
        }
        if (value instanceof YAMLScalar) {
            YAMLValue yAMLValue = value;
            if (yAMLValue == null) {
                KubernetesComposedTypeBase.$$$reportNull$$$0(17);
            }
            return yAMLValue;
        }
        PsiElement parent = value.getParent();
        if (parent instanceof YAMLDocument) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                KubernetesComposedTypeBase.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        if (parent instanceof YAMLSequenceItem) {
            PsiElement key = parent.getFirstChild();
            Object object = key != null ? key : value;
            if (object == null) {
                KubernetesComposedTypeBase.$$$reportNull$$$0(19);
            }
            return object;
        }
        if (parent instanceof YAMLKeyValue) {
            PsiElement key = ((YAMLKeyValue)parent).getKey();
            Object object = key != null ? key : value;
            if (object == null) {
                KubernetesComposedTypeBase.$$$reportNull$$$0(20);
            }
            return object;
        }
        YAMLValue yAMLValue = value;
        if (yAMLValue == null) {
            KubernetesComposedTypeBase.$$$reportNull$$$0(21);
        }
        return yAMLValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 17, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFields";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/kubernetes/model/KubernetesComposedTypeBase";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iteration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theName";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/kubernetes/model/KubernetesComposedTypeBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMissingFields";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFeatureByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeMissingFields";
                break;
            }
            case 4: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateDeep";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildInsertionSuffixMarkup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeFields";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitByMultiplicity";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeCopy";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "composeTypes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }
}

