/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaSyntaxErrorChecker {
    public static boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        String text;
        if (element == null) {
            JavaSyntaxErrorChecker.$$$reportNull$$$0(0);
        }
        String description = element.getErrorDescription();
        if (JavaSyntaxErrorChecker.isJavaDocProblem(element)) {
            return false;
        }
        if (description.equals(JavaPsiBundle.message("expected.semicolon", new Object[0]))) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiExpressionStatement && !PsiUtil.isStatement(parent)) {
                return false;
            }
            if (JavaSyntaxErrorChecker.isAfterUnclosedStringLiteral(element)) {
                return false;
            }
        } else if (description.equals(JavaPsiBundle.message("expected.comma.or.rparen", new Object[0])) ? JavaSyntaxErrorChecker.isAfterUnclosedStringLiteral(element) : description.equals(JavaPsiBundle.message("expected.class.or.interface", new Object[0])) && ((text = element.getText()).equals("sealed") || text.equals("non-sealed") || text.equals("value")) && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element) instanceof PsiClass) {
            return false;
        }
        return true;
    }

    public static boolean isJavaDocProblem(@NotNull PsiErrorElement element) {
        PsiElement parent;
        if (element == null) {
            JavaSyntaxErrorChecker.$$$reportNull$$$0(1);
        }
        return (parent = element.getParent()) instanceof PsiDocComment || parent instanceof PsiDocTag || parent instanceof PsiDocTagValue || parent != null && parent.getNode().getElementType() == JavaDocElementType.DOC_REFERENCE_HOLDER;
    }

    private static boolean isAfterUnclosedStringLiteral(@NotNull PsiErrorElement element) {
        String text;
        PsiJavaToken token;
        IElementType type;
        PsiElement prevLeaf;
        if (element == null) {
            JavaSyntaxErrorChecker.$$$reportNull$$$0(2);
        }
        return (prevLeaf = PsiTreeUtil.prevCodeLeaf((PsiElement)element)) instanceof PsiJavaToken && ((type = (token = (PsiJavaToken)prevLeaf).getTokenType()) == JavaTokenType.STRING_LITERAL ? (text = token.getText()).length() == 1 || !StringUtil.endsWithChar((CharSequence)text, (char)'\"') : (type == JavaTokenType.CHARACTER_LITERAL ? (text = token.getText()).length() == 1 || !StringUtil.endsWithChar((CharSequence)text, (char)'\'') : type == JavaTokenType.STRING_TEMPLATE_END && ((text = token.getText()).length() == 1 || !StringUtil.endsWithChar((CharSequence)text, (char)'\"'))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/JavaSyntaxErrorChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaDocProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterUnclosedStringLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

