/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lang.java.parser.JavaBinaryOperations;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.CStyleCommentBlock;
import com.intellij.psi.formatter.java.ChainMethodCallsBlockBuilder;
import com.intellij.psi.formatter.java.ImportHelperBase;
import com.intellij.psi.formatter.java.JavaFormatterAnnotationUtil;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.TextLineBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiSnippetAttribute;
import com.intellij.psi.javadoc.PsiSnippetAttributeList;
import com.intellij.psi.javadoc.PsiSnippetDocTag;
import com.intellij.psi.jsp.IJspClassLevelDeclarationStatement;
import com.intellij.psi.jsp.IJspCodeBlock;
import com.intellij.psi.jsp.IJspJavaComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSpacePropertyProcessor
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance(JavaSpacePropertyProcessor.class);
    private static final TokenSet REF_LIST_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.THROWS_KEYWORD, JavaTokenType.PERMITS_KEYWORD, JavaTokenType.WITH_KEYWORD});
    private static final TokenSet ESCAPED_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LT, JavaTokenType.LTLT, JavaTokenType.LTLTEQ, JavaTokenType.GT, JavaTokenType.GTGT, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.AND, JavaTokenType.ANDAND, JavaTokenType.ANDEQ, JavaTokenType.STRING_LITERAL});
    private static final Map<Pair<IElementType, IElementType>, Boolean> ourTokenStickingMatrix = new ConcurrentHashMap<Pair<IElementType, IElementType>, Boolean>();
    private Spacing myResult;
    private PsiElement myParent;
    private int myRole1;
    private int myRole2;
    private ASTNode myChild1;
    private ASTNode myChild2;
    private IElementType myType1;
    private IElementType myType2;
    private CommonCodeStyleSettings mySettings;
    private JavaCodeStyleSettings myJavaSettings;
    private ImportHelperBase myImportHelper;

    private JavaSpacePropertyProcessor(Block block, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        ASTNode child = AbstractJavaBlock.getTreeNode(block);
        if (child == null || JavaSpacePropertyProcessor.isErrorElement(child)) {
            this.myResult = Spacing.getReadOnlySpacing();
            return;
        }
        this.init(child);
        this.mySettings = settings;
        this.myJavaSettings = javaSettings;
        if (this.myChild1 == null) {
            if (FormatterUtil.isFormatterCalledExplicitly()) {
                this.createSpaceInCode(false);
            }
            return;
        }
        PsiElement myChild1Psi1 = this.myChild1.getPsi();
        PsiElement myChild1Psi2 = this.myChild2.getPsi();
        if (myChild1Psi1 == null || myChild1Psi1.getLanguage() != JavaLanguage.INSTANCE || myChild1Psi2 == null || myChild1Psi2.getLanguage() != JavaLanguage.INSTANCE) {
            return;
        }
        if (block instanceof TextLineBlock) {
            this.myResult = ((TextLineBlock)block).getSpacing();
            return;
        }
        if (block instanceof CStyleCommentBlock) {
            this.myResult = ((CStyleCommentBlock)block).getSpacing();
            return;
        }
        if (this.myChild2 != null && StdTokenSets.COMMENT_BIT_SET.contains(this.myType2)) {
            this.myResult = this.mySettings.KEEP_FIRST_COLUMN_COMMENT ? Spacing.createKeepingFirstColumnSpacing((int)0, (int)Integer.MAX_VALUE, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myParent != null) {
            this.myParent.accept((PsiElementVisitor)this);
            if (this.myResult == null) {
                ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
                if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (!JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                    this.myResult = Spacing.createSpacing((int)1, (int)Integer.MIN_VALUE, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myType1 == JavaTokenType.C_STYLE_COMMENT) {
                    this.myResult = null;
                } else if (!JavaSpacePropertyProcessor.shouldKeepSpace(this.myParent)) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
        }
    }

    private static boolean isErrorElement(ASTNode child) {
        return child != null && child.getPsi() instanceof PsiErrorElement;
    }

    private static boolean shouldKeepSpace(PsiElement parent) {
        ASTNode node = parent.getNode();
        if (node == null) {
            return true;
        }
        IElementType type = node.getElementType();
        if (type == JavaDocElementType.DOC_TAG_VALUE_ELEMENT) {
            return PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDocMethodOrFieldRef.class) != null;
        }
        return type == JavaDocElementType.DOC_COMMENT || type == JavaDocElementType.DOC_TAG || type == JavaDocElementType.DOC_INLINE_TAG;
    }

    private void init(ASTNode child) {
        ASTNode treePrev;
        if (child == null) {
            return;
        }
        for (treePrev = child.getTreePrev(); treePrev != null && FormatterUtil.containsWhiteSpacesOnly((ASTNode)treePrev); treePrev = treePrev.getTreePrev()) {
        }
        if (treePrev == null) {
            this.init(child.getTreeParent());
        } else {
            this.myChild2 = child;
            this.myChild1 = treePrev;
            CompositeElement parent = (CompositeElement)treePrev.getTreeParent();
            this.myParent = SourceTreeToPsiMap.treeElementToPsi((ASTNode)parent);
            this.myRole1 = parent.getChildRole(treePrev);
            this.myType1 = treePrev.getElementType();
            this.myRole2 = parent.getChildRole(child);
            this.myType2 = child.getElementType();
        }
    }

    @Override
    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(0);
        }
        if (this.myRole1 == 88 && this.myRole2 == 74) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 74 || this.myRole2 == 75) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    private void createSpaceInCode(boolean space) {
        this.createSpaceProperty(space, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(1);
        }
        if (this.myRole2 == 77) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole1 == 69) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else if (this.myRole1 == 74 ^ this.myRole2 == 75) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    @Override
    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(2);
        }
        this.visitArrayInitializer();
    }

    @Override
    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(3);
        }
        if (this.myType1 == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 18) {
            this.myResult = this.getSpaceBeforeClassLBrace(aClass);
        } else if (this.myRole1 == 18 || JavaSpacePropertyProcessor.isEndOfLineCommentAfterLBrace(this.myChild1)) {
            if (aClass.isEnum()) {
                this.createSpacingForEnumBraces(true);
            } else if (this.myRole2 == 19 && this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_BRACES ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else {
                this.myResult = aClass instanceof PsiAnonymousClass ? (this.myRole2 == 6 && JavaSpacePropertyProcessor.isTheOnlyClassMember(this.myChild2) ? Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS) : Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS)) : Spacing.createSpacing((int)1, (int)1, (int)(this.mySettings.BLANK_LINES_AFTER_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole2 == 19 && aClass.isEnum()) {
            this.createSpacingForEnumBraces(false);
        } else if (this.myRole1 == 23 && aClass.isEnum() && JavaSpacePropertyProcessor.isJavadocHoldingEnumConstant(this.myChild2)) {
            this.createParenthSpace(true, true);
        } else if (aClass instanceof PsiAnonymousClass && ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(this.myType1)) {
            ASTNode prev = this.myChild1.getTreePrev();
            if (prev.getElementType() == TokenType.WHITE_SPACE && !StringUtil.containsLineBreak((CharSequence)prev.getChars())) {
                prev = prev.getTreePrev();
            }
            if (prev.getElementType() == JavaTokenType.LBRACE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else {
                this.processClassBody();
            }
        } else if (this.myChild1.getElementType() == JavaTokenType.COMMA && this.myType2 == JavaTokenType.SEMICOLON && aClass.isEnum()) {
            this.createParenthSpace(true, false);
        } else if (aClass instanceof PsiAnonymousClass && this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else {
            this.processClassBody();
        }
    }

    private void createSpacingForEnumBraces(boolean isLbrace) {
        ASTNode node = this.myParent.getNode().findChildByType(JavaTokenType.LBRACE);
        int startOffset = node == null ? this.myParent.getTextOffset() : node.getTextRange().getStartOffset();
        int spaces = this.myJavaSettings.SPACE_INSIDE_ONE_LINE_ENUM_BRACES ? 1 : 0;
        TextRange textRange = new TextRange(startOffset, this.myParent.getTextRange().getEndOffset());
        int blankLinesCount = isLbrace ? this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS : this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE;
        this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesCount);
    }

    private static boolean isJavadocHoldingEnumConstant(@NotNull ASTNode node) {
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(4);
        }
        if (!(node instanceof EnumConstantElement)) {
            return false;
        }
        ASTNode firstChildNode = node.getFirstChildNode();
        return firstChildNode instanceof PsiDocComment;
    }

    @NotNull
    private Spacing getSpaceBeforeMethodLBrace(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(5);
        }
        int space = this.mySettings.SPACE_BEFORE_METHOD_LBRACE ? 1 : 0;
        int methodBraceStyle = this.mySettings.METHOD_BRACE_STYLE;
        if (methodBraceStyle == 1) {
            Spacing spacing = this.createNonLFSpace(space, null);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(6);
            }
            return spacing;
        }
        if (methodBraceStyle == 5) {
            TextRange headerRange = new TextRange(JavaSpacePropertyProcessor.getMethodHeaderStartOffset(method), JavaSpacePropertyProcessor.getMethodHeaderEndOffset(method));
            Spacing spacing = this.createNonLFSpace(space, headerRange);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(7);
            }
            return spacing;
        }
        if (this.shouldHandleAsSimpleMethod(method)) {
            TextRange rangeWithoutAnnotations = new TextRange(JavaSpacePropertyProcessor.getMethodHeaderStartOffset(method), method.getTextRange().getEndOffset());
            Spacing spacing = this.createNonLFSpace(space, rangeWithoutAnnotations);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(8);
            }
            return spacing;
        }
        Spacing spacing = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        if (spacing == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(9);
        }
        return spacing;
    }

    private static int getMethodHeaderEndOffset(@NotNull PsiMethod method) {
        PsiElement headerEnd;
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(10);
        }
        PsiElement psiElement = headerEnd = method.getBody() != null ? method.getBody().getPrevSibling() : null;
        if (headerEnd != null) {
            return headerEnd.getTextRange().getEndOffset();
        }
        return method.getTextRange().getEndOffset();
    }

    @NotNull
    private Spacing getSpaceBeforeClassLBrace(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(11);
        }
        int space = this.mySettings.SPACE_BEFORE_CLASS_LBRACE ? 1 : 0;
        int classBraceStyle = this.mySettings.CLASS_BRACE_STYLE;
        if (classBraceStyle == 1 || this.shouldHandleAsSimpleClass(aClass)) {
            Spacing spacing = this.createNonLFSpace(space, null);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(12);
            }
            return spacing;
        }
        if (classBraceStyle == 5) {
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            int startOffset = nameIdentifier == null ? this.myParent.getTextRange().getStartOffset() : nameIdentifier.getTextRange().getStartOffset();
            TextRange range = new TextRange(startOffset, this.myChild1.getTextRange().getEndOffset());
            Spacing spacing = this.createNonLFSpace(space, range);
            if (spacing == null) {
                JavaSpacePropertyProcessor.$$$reportNull$$$0(13);
            }
            return spacing;
        }
        Spacing spacing = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        if (spacing == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(14);
        }
        return spacing;
    }

    private Spacing getSpaceBeforeLBrace(@NotNull ASTNode lBraceBlock, boolean spaceBeforeLbrace, @Nullable TextRange nextLineIfWrappedOptionRange) {
        int space;
        if (lBraceBlock == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(15);
        }
        int n = space = spaceBeforeLbrace ? 1 : 0;
        if (this.mySettings.BRACE_STYLE == 1) {
            return this.createNonLFSpace(space, null);
        }
        if (this.mySettings.BRACE_STYLE == 5) {
            return this.createNonLFSpace(space, nextLineIfWrappedOptionRange);
        }
        if (this.shouldHandleAsSimpleBlock(lBraceBlock)) {
            return this.createNonLFSpace(space, lBraceBlock.getTextRange());
        }
        return Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private boolean shouldHandleAsSimpleClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(16);
        }
        if (!this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
            return false;
        }
        PsiElement lBrace = aClass.getLBrace();
        PsiElement rBrace = aClass.getRBrace();
        if (lBrace != null && rBrace != null) {
            PsiElement beforeLBrace = lBrace.getPrevSibling();
            if (beforeLBrace instanceof PsiWhiteSpace && beforeLBrace.textContains('\n')) {
                return false;
            }
            PsiElement betweenBraces = lBrace.getNextSibling();
            if (betweenBraces == rBrace || JavaSpacePropertyProcessor.isWhiteSpaceWithoutLineFeeds(betweenBraces) && betweenBraces.getNextSibling() == rBrace) {
                return true;
            }
        }
        return false;
    }

    private static boolean isWhiteSpaceWithoutLineFeeds(@Nullable PsiElement betweenBraces) {
        return betweenBraces instanceof PsiWhiteSpace && !betweenBraces.textContains('\n');
    }

    private boolean shouldHandleAsSimpleBlock(@NotNull ASTNode node) {
        PsiBlockStatement statement;
        PsiCodeBlock body;
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(17);
        }
        if (!this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
            return false;
        }
        PsiElement prev = node.getPsi().getPrevSibling();
        if (prev instanceof PsiWhiteSpace && prev.textContains('\n')) {
            return false;
        }
        PsiElement element = node.getPsi();
        return !node.textContains('\n') && (element instanceof PsiCodeBlock && this.shouldAddNewLineWhenBodyIsPresent(body = (PsiCodeBlock)element) || element instanceof PsiBlockStatement && this.shouldAddNewLineWhenBodyIsPresent((statement = (PsiBlockStatement)element).getCodeBlock()));
    }

    private boolean shouldAddNewLineWhenBodyIsPresent(@NotNull PsiCodeBlock body) {
        if (body == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(18);
        }
        return !this.myJavaSettings.NEW_LINE_WHEN_BODY_IS_PRESENTED || body.isEmpty();
    }

    private boolean shouldHandleAsSimpleMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(19);
        }
        if (!this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE) {
            return false;
        }
        PsiCodeBlock body = method.getBody();
        return body != null && !body.textContains('\n') && this.shouldAddNewLineWhenBodyIsPresent(body);
    }

    private static int getMethodHeaderStartOffset(@NotNull PsiMethod method) {
        PsiElement nextNonWsElem;
        PsiTypeParameterList typeParameterList;
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(20);
        }
        if ((typeParameterList = (PsiTypeParameterList)PsiTreeUtil.findChildOfType((PsiElement)method, PsiTypeParameterList.class)) != null && (nextNonWsElem = PsiTreeUtil.skipWhitespacesForward((PsiElement)typeParameterList)) != null) {
            return nextNonWsElem.getTextRange().getStartOffset();
        }
        return method.getTextRange().getStartOffset();
    }

    private static boolean isEndOfLineCommentAfterLBrace(@NotNull ASTNode node) {
        PsiElement beforeWs;
        PsiElement ws;
        if (node == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(21);
        }
        return node.getPsi() instanceof PsiComment && JavaSpacePropertyProcessor.isWhiteSpaceWithoutLineFeeds(ws = node.getPsi().getPrevSibling()) && PsiUtil.isJavaToken(beforeWs = ws.getPrevSibling(), JavaTokenType.LBRACE);
    }

    private static boolean isTheOnlyClassMember(ASTNode node) {
        ASTNode next = node.getTreeNext();
        if (next == null || next.getElementType() != JavaTokenType.RBRACE) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        return prev != null && prev.getElementType() == JavaTokenType.LBRACE;
    }

    private void processClassBody() {
        if (this.myChild1 instanceof IJspJavaComment || this.myChild2 instanceof IJspJavaComment) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (!this.processMethod()) {
            if (this.myRole2 == 6) {
                if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myRole1 == 4) {
                    int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)(this.mySettings.SPACE_BEFORE_CLASS_LBRACE ? 1 : 0), (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else if (this.myRole1 == 3) {
                    this.setAroundClassSpacing();
                } else {
                    int blankLines = this.getLinesAroundMethod() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 6) {
                if (this.myRole2 == 19) {
                    int minLineFeeds = JavaSpacePropertyProcessor.getMinLineFeedsBetweenRBraces(this.myChild1);
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else if (this.myRole2 == 3) {
                    this.setAroundClassSpacing();
                } else {
                    int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 3) {
                if (this.myRole2 == 19) {
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else {
                    int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 3) {
                if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
                } else {
                    int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 4) {
                if (this.myRole1 == 23) {
                    this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                } else if (this.myRole1 == 18) {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
                } else {
                    int blankLines = this.getLinesAroundField() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole1 == 4) {
                if (this.myRole2 == 23) {
                    ASTNode lastChildNode = this.myChild1.getLastChildNode();
                    if (lastChildNode != null && lastChildNode.getElementType() == JavaTokenType.SEMICOLON) {
                        this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                    } else {
                        this.createSpaceProperty(false, false, 0);
                    }
                } else if (this.myRole2 == 19) {
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
                } else {
                    int blankLines = this.getLinesAroundField() + 1;
                    this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            } else if (this.myRole2 == 23 || this.myType2 == JavaTokenType.SEMICOLON) {
                this.createSpaceProperty(false, false, 0);
            } else if (this.myRole1 == 23) {
                this.createSpaceProperty(this.mySettings.SPACE_AFTER_COMMA, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            } else if (this.myRole1 == 8) {
                this.processModifierList();
            } else if (this.myRole1 == 18 && this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else if (this.myRole2 == 12 || this.myRole2 == 13 || this.myRole2 == 127) {
                this.createSpaceInCode(true);
            } else if (this.myRole2 == 245) {
                this.createSpaceInCode(this.myJavaSettings.SPACE_BEFORE_OPENING_ANGLE_BRACKET_IN_TYPE_PARAMETER);
            } else if (this.myRole2 == 73) {
                this.createSpaceInCode(false);
            } else if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        }
    }

    private int getLineBreaksBeforeClassEnd() {
        return this.myParent instanceof PsiAnonymousClass ? 1 : this.mySettings.BLANK_LINES_BEFORE_CLASS_END + 1;
    }

    private void setAroundClassSpacing() {
        this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)(this.mySettings.BLANK_LINES_AROUND_CLASS + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
    }

    private boolean processMethod() {
        if (this.myRole2 == 5 || this.myType2 == JavaElementType.METHOD) {
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else if (this.myRole1 == 6) {
                int blankLines = this.myJavaSettings.BLANK_LINES_AROUND_INITIALIZER + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                int blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        } else if (this.myRole1 == 5 || this.myType1 == JavaElementType.METHOD) {
            int blankLines;
            if (this.myRole1 == 18) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
            } else {
                blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
            if (this.myRole2 == 19) {
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)this.getLineBreaksBeforeClassEnd(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                blankLines = this.getLinesAroundMethod() + 1;
                this.myResult = Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            }
        }
        return this.myResult != null;
    }

    private static int getMinLineFeedsBetweenRBraces(ASTNode leftNode) {
        if (leftNode == null || leftNode.getElementType() != JavaElementType.CLASS_INITIALIZER) {
            return 1;
        }
        ASTNode lbraceCandidate = leftNode.getTreePrev();
        return lbraceCandidate != null && lbraceCandidate.getElementType() == JavaTokenType.LBRACE ? 0 : 1;
    }

    private int getLinesAroundMethod() {
        boolean useInterfaceMethodSpacing = !JavaSpacePropertyProcessor.isClass(this.myParent) || JavaSpacePropertyProcessor.isAbstractMethod(this.myChild1) && JavaSpacePropertyProcessor.isAbstractMethod(this.myChild2);
        return useInterfaceMethodSpacing ? this.mySettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE : this.mySettings.BLANK_LINES_AROUND_METHOD;
    }

    private int getLinesAroundField() {
        boolean isParentAClass = JavaSpacePropertyProcessor.isClass(this.myParent);
        if (isParentAClass && JavaFormatterAnnotationUtil.isFieldWithAnnotations(this.myChild2)) {
            return this.myJavaSettings.BLANK_LINES_AROUND_FIELD_WITH_ANNOTATIONS;
        }
        if (isParentAClass) {
            return this.mySettings.BLANK_LINES_AROUND_FIELD;
        }
        return this.mySettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE;
    }

    private static boolean isClass(PsiElement parent) {
        if (parent instanceof PsiClass) {
            return !((PsiClass)parent).isInterface();
        }
        return false;
    }

    private static boolean isAbstractMethod(ASTNode node) {
        PsiMethod method;
        PsiElement psiElement = node.getPsi();
        return psiElement instanceof PsiMethod && JavaFormatterUtil.isExplicitlyAbstract(method = (PsiMethod)psiElement);
    }

    @Override
    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(22);
        }
        this.createSpaceInCode(true);
    }

    @Override
    public void visitEnumConstantInitializer(@NotNull PsiEnumConstantInitializer enumConstantInitializer) {
        if (enumConstantInitializer == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(23);
        }
        if (this.myRole2 == 12 || this.myRole2 == 13 || this.myRole2 == 127) {
            this.createSpaceInCode(true);
        } else {
            this.processMethod();
        }
    }

    @Override
    public void visitPatternVariable(@NotNull PsiPatternVariable variable) {
        if (variable == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(24);
        }
        super.visitPatternVariable(variable);
        if (this.myType1 == JavaElementType.TYPE && this.myType2 == JavaTokenType.IDENTIFIER) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitImportList(@NotNull PsiImportList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(25);
        }
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myType1) && ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(this.myType2)) {
            if (this.myImportHelper == null) {
                this.myImportHelper = new ImportHelperBase(this.myJavaSettings);
            }
            int emptyLines = this.myImportHelper.getEmptyLinesBetween((PsiImportStatementBase)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)this.myChild1), (PsiImportStatementBase)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)this.myChild2)) + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)emptyLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(26);
        }
        if (this.myType1 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.PACKAGE_STATEMENT) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_PACKAGE + 1;
            int keepLines = this.myType1 == JavaTokenType.C_STYLE_COMMENT ? this.mySettings.KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER : this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)keepLines);
        } else if (this.myType1 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_AFTER_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.IMPORT_LIST) {
            int lf = this.mySettings.BLANK_LINES_BEFORE_IMPORTS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaElementType.CLASS) {
            int lf = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)lf, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
    }

    @Override
    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(27);
        }
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38 || this.myType2 == JavaElementType.CODE_BLOCK) {
            if (this.myType2 == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_WHILE_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        }
    }

    @Override
    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(28);
        }
        if (this.myRole1 == 35 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.myRole2 == 38) {
            if (this.myType2 == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_DO_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myRole1 == 38 || this.myType2 == JavaElementType.CODE_BLOCK) {
            this.processOnNewLineCondition(this.mySettings.WHILE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_WHILE_KEYWORD);
        }
    }

    private void processOnNewLineCondition(boolean onNewLine, boolean createSpaceInline) {
        if (onNewLine) {
            this.myResult = !this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceProperty(createSpaceInline, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(29);
        }
        if (this.myType1 == JavaTokenType.THROW_KEYWORD) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(30);
        }
        if (this.myRole2 == 47 || this.myRole2 == 251) {
            boolean putRightChildOnNewLine;
            boolean bl = putRightChildOnNewLine = this.myRole2 == 47 ? this.mySettings.FINALLY_ON_NEW_LINE : this.mySettings.CATCH_ON_NEW_LINE;
            if (putRightChildOnNewLine) {
                this.processOnNewLineCondition(true, true);
            } else {
                boolean useSpace = this.myRole2 == 251 && this.mySettings.SPACE_BEFORE_CATCH_KEYWORD || this.myRole2 == 47 && this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD;
                this.createSpaceProperty(useSpace, false, 0);
            }
            return;
        }
        if (this.myRole2 == 48) {
            TextRange dependentRange = null;
            if (this.myChild1 instanceof PsiResourceList && this.mySettings.BRACE_STYLE == 5) {
                dependentRange = this.myChild1.getTextRange();
            }
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_TRY_LBRACE, dependentRange);
        } else if (this.myRole2 == 52) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, null);
        } else if (this.myType2 == JavaElementType.RESOURCE_LIST) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TRY_PARENTHESES);
        }
    }

    @Override
    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(31);
        }
        this.handleForeach();
    }

    @Override
    public void visitForeachPatternStatement(@NotNull PsiForeachPatternStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(32);
        }
        this.handleForeach();
    }

    private void handleForeach() {
        if (this.myRole1 == 37 && this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        } else if ((this.myRole1 == 125 || ElementType.JAVA_PATTERN_BIT_SET.contains(this.myType1)) && this.myRole2 == 87 && this.myJavaSettings.SPACE_BEFORE_COLON_IN_FOREACH || this.myRole1 == 87 && this.myRole2 == 124) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 38) {
            this.processLoopBody();
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(33);
        }
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
    }

    @Override
    public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(34);
        }
        if (this.myType1 == JavaTokenType.BREAK_KEYWORD && this.myType2 == JavaTokenType.IDENTIFIER) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    @Override
    public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(35);
        }
        if (this.myType1 == JavaTokenType.YIELD_KEYWORD && ElementType.EXPRESSION_BIT_SET.contains(this.myType2)) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    @Override
    public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(36);
        }
        if (this.myType1 == JavaTokenType.CONTINUE_KEYWORD && this.myType2 == JavaTokenType.IDENTIFIER) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(37);
        }
        if (this.myRole1 == 24) {
            this.createParenthSpace(this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createParenthSpace(this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP, this.mySettings.SPACE_WITHIN_PARENTHESES);
        }
    }

    @Override
    public void visitCodeBlock(@NotNull PsiCodeBlock block) {
        if (block == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(38);
        }
        this.processCodeBlock(this.keepInOneLine(block), block.getTextRange());
    }

    @Override
    public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
        if (codeFragment == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(39);
        }
        if (this.myChild1.getPsi() instanceof PsiStatement && this.myChild2.getPsi() instanceof PsiStatement) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private void processCodeBlock(boolean keepInOneLine, TextRange textRange) {
        boolean lhsStatement = this.myChild1.getPsi() instanceof PsiStatement;
        boolean rhsStatement = this.myChild2.getPsi() instanceof PsiStatement;
        if (this.myParent instanceof IJspCodeBlock) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 0 && !lhsStatement || this.myRole2 == 0 && !rhsStatement) {
            IElementType firstElementType = this.myType1;
            this.myResult = firstElementType == JavaTokenType.END_OF_LINE_COMMENT || firstElementType == JavaTokenType.C_STYLE_COMMENT ? Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : null;
        } else if (this.myRole1 == 18) {
            int spacesAfterLBrace;
            if (this.myRole2 == 19) {
                spacesAfterLBrace = this.mySettings.SPACE_WITHIN_BRACES ? 1 : 0;
            } else {
                int n = spacesAfterLBrace = this.mySettings.SPACE_WITHIN_BRACES || this.myJavaSettings.SPACES_INSIDE_BLOCK_BRACES_WHEN_BODY_IS_PRESENT ? 1 : 0;
            }
            if (!keepInOneLine) {
                ASTNode grandPa;
                ASTNode parentNode;
                int blankLines = 1;
                if (this.myParent != null && (parentNode = this.myParent.getNode()) != null && (grandPa = parentNode.getTreeParent()) != null && grandPa.getElementType() == JavaElementType.METHOD) {
                    blankLines += this.mySettings.BLANK_LINES_BEFORE_METHOD_BODY;
                }
                this.myResult = Spacing.createSpacing((int)spacesAfterLBrace, (int)spacesAfterLBrace, (int)blankLines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.myResult = Spacing.createDependentLFSpacing((int)spacesAfterLBrace, (int)spacesAfterLBrace, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.myRole2 == 19) {
            int spacesBeforeRBrace;
            int n = spacesBeforeRBrace = this.mySettings.SPACE_WITHIN_BRACES || this.myJavaSettings.SPACES_INSIDE_BLOCK_BRACES_WHEN_BODY_IS_PRESENT ? 1 : 0;
            this.myResult = !keepInOneLine ? Spacing.createSpacing((int)spacesBeforeRBrace, (int)spacesBeforeRBrace, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE) : Spacing.createDependentLFSpacing((int)spacesBeforeRBrace, (int)spacesBeforeRBrace, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
        } else if (this.myType1 == JavaElementType.SWITCH_LABEL_STATEMENT || this.myType2 == JavaElementType.SWITCH_LABEL_STATEMENT) {
            if (this.myType2 == JavaElementType.BLOCK_STATEMENT) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, null);
            } else {
                int lineFeeds = this.myType1 != JavaElementType.SWITCH_LABEL_STATEMENT || this.mySettings.CASE_STATEMENT_ON_NEW_LINE ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)lineFeeds, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (lhsStatement && rhsStatement) {
            int minSpaces = 0;
            int minLineFeeds = 1;
            PsiElement psi = this.myChild1.getPsi();
            if (this.mySettings.KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE && (FormatterUtil.isFormatterCalledExplicitly() || ApplicationManager.getApplication().isUnitTestMode()) || psi != null && PsiTreeUtil.hasErrorElements((PsiElement)psi)) {
                minSpaces = 1;
                minLineFeeds = 0;
                if (this.myChild1 != null) {
                    ASTNode lastElement = this.myChild1;
                    while (lastElement.getLastChildNode() != null) {
                        lastElement = lastElement.getLastChildNode();
                    }
                    if (lastElement instanceof PsiComment && lastElement.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
                        minLineFeeds = 1;
                    }
                }
            }
            this.myResult = Spacing.createSpacing((int)minSpaces, (int)0, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private boolean keepInOneLine(PsiCodeBlock block) {
        if (block.getParent() instanceof PsiMethod) {
            return this.shouldHandleAsSimpleMethod((PsiMethod)block.getParent());
        }
        if (block.getParent() instanceof PsiLambdaExpression) {
            return this.shouldHandleAsSimpleLambda((PsiLambdaExpression)block.getParent());
        }
        return this.shouldHandleAsSimpleBlock(block.getNode());
    }

    private boolean shouldHandleAsSimpleLambda(PsiLambdaExpression lambda) {
        boolean isSimpleLambda;
        PsiElement body = lambda.getBody();
        boolean bl = isSimpleLambda = this.mySettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE && !lambda.textContains('\n');
        if (body instanceof PsiCodeBlock) {
            PsiCodeBlock block = (PsiCodeBlock)body;
            return isSimpleLambda && this.shouldAddNewLineWhenBodyIsPresent(block);
        }
        return isSimpleLambda;
    }

    @Override
    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(40);
        }
        if (this.myRole2 == 31) {
            if (this.myType1 != JavaElementType.BLOCK_STATEMENT) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (this.mySettings.ELSE_ON_NEW_LINE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_BEFORE_ELSE_KEYWORD, false, 0);
            }
        } else if (this.myRole1 == 31) {
            if (this.myType2 == JavaElementType.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.createSpaceProperty(false, false, 0);
                } else {
                    this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            } else if (this.myType2 == JavaElementType.BLOCK_STATEMENT || this.myType2 == JavaElementType.CODE_BLOCK) {
                this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_ELSE_LBRACE, null);
            } else {
                this.createSpacingBeforeElementInsideControlStatement();
            }
        } else if (this.myType2 == JavaElementType.BLOCK_STATEMENT || this.myType2 == JavaElementType.CODE_BLOCK) {
            PsiExpression condition;
            boolean space = this.myRole2 == 34 ? this.mySettings.SPACE_BEFORE_ELSE_LBRACE : this.mySettings.SPACE_BEFORE_IF_LBRACE;
            TextRange dependentRange = null;
            if (this.myRole2 == 33 && (condition = statement.getCondition()) != null) {
                dependentRange = condition.getTextRange();
            }
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, space, dependentRange);
        } else if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.myRole2 == 33) {
            this.createSpacingBeforeElementInsideControlStatement();
        }
    }

    private void createSpacingBeforeElementInsideControlStatement() {
        if (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE && this.myType1 != JavaTokenType.END_OF_LINE_COMMENT) {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    private Spacing createNonLFSpace(int spaces, @Nullable TextRange dependantRange) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (dependantRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependantRange, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @Nullable
    private static ASTNode getPrevElementType(ASTNode child) {
        return FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)child);
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(41);
        }
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            IElementType i = expression.getOperationTokenType();
            if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
            } else if (i == JavaTokenType.OR || i == JavaTokenType.AND || i == JavaTokenType.XOR) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
            } else if (i == JavaTokenType.GT || i == JavaTokenType.LT || i == JavaTokenType.GE || i == JavaTokenType.LE) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
            } else if (JavaBinaryOperations.ADDITIVE_OPS.contains(i)) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
            } else if (JavaBinaryOperations.MULTIPLICATIVE_OPS.contains(i)) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
            } else if (JavaBinaryOperations.SHIFT_OPS.contains(i)) {
                this.createSpaceInCode(this.mySettings.SPACE_AROUND_SHIFT_OPERATORS);
            } else {
                this.createSpaceInCode(false);
            }
        }
    }

    @Override
    public void visitField(@NotNull PsiField field) {
        if (field == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(42);
        }
        if (this.myType1 == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.myRole1 == 10 || this.myRole2 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == JavaTokenType.SEMICOLON && this.isAllowedToMoveSemicolonInLongCallChain()) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myChild1.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myType2 == JavaTokenType.SEMICOLON) {
            this.createSpaceProperty(false, false, 0);
        } else if (this.myRole1 == 8) {
            this.createSpaceProperty(true, false, 0);
        }
    }

    @Override
    public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
        if (variable == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(43);
        }
        if (this.myRole1 == 20 || this.myRole2 == 20) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (JavaSpacePropertyProcessor.isFinalKeywordBefore(this.myChild2) && this.myType2 == JavaElementType.TYPE) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 8 || this.myRole2 == 71 || this.myRole1 == 71 || this.myRole2 == 10 || this.myRole1 == 10) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == JavaTokenType.SEMICOLON && this.isAllowedToMoveSemicolonInLongCallChain()) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myChild1.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myType2 == JavaTokenType.SEMICOLON) {
            PsiElement ppp;
            PsiElement pp = this.myParent.getParent();
            if (pp instanceof PsiDeclarationStatement && (ppp = pp.getParent()) instanceof PsiForStatement) {
                this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
                return;
            }
            this.createSpaceProperty(false, false, 0);
        }
    }

    private boolean isInsidePsiForStatement() {
        PsiElement ppp;
        PsiElement pp = this.myParent.getParent();
        return pp instanceof PsiDeclarationStatement && (ppp = pp.getParent()) instanceof PsiForStatement;
    }

    private static boolean isFinalKeywordBefore(ASTNode node) {
        ASTNode prevLeaf = TreeUtil.prevLeaf((ASTNode)node);
        if (prevLeaf != null && prevLeaf.getElementType() == TokenType.WHITE_SPACE) {
            prevLeaf = TreeUtil.prevLeaf((ASTNode)prevLeaf);
        }
        return prevLeaf != null && prevLeaf.getElementType() == JavaTokenType.FINAL_KEYWORD;
    }

    @Override
    public void visitMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(44);
        }
        if (this.myType1 == JavaDocElementType.DOC_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
            return;
        }
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        } else if (this.myRole1 == 14 && this.myRole2 == 16 || this.myRole1 == 245) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 17) {
            this.myResult = this.getSpaceBeforeMethodLBrace(method);
        } else if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (StdTokenSets.COMMENT_BIT_SET.contains(this.myType1) && (this.myRole2 == 8 || this.myRole2 == 71)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.myRole2 == 85 || this.myRole2 == 248) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 10) {
            this.createSpaceInCode(true);
        }
    }

    private void processModifierList() {
        if (this.mySettings.MODIFIER_LIST_WRAP) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 8 && this.myRole2 == 102) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if ((this.myRole2 == 10 || this.myRole2 == 245) && this.myChild1.getLastChildNode() != null && this.myChild1.getLastChildNode().getElementType() == JavaElementType.ANNOTATION || this.myRole1 == 8 && this.myRole2 == 19 || this.myRole1 == 8 && this.myRole2 == 11) {
            this.createSpaceProperty(true, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else {
            this.createSpaceProperty(true, false, 0);
        }
    }

    @Override
    public void visitModifierList(@NotNull PsiModifierList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(45);
        }
        this.myResult = this.myType1 == JavaElementType.ANNOTATION && this.myType2 == JavaTokenType.FINAL_KEYWORD ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (this.myType1 == JavaTokenType.END_OF_LINE_COMMENT ? Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
    }

    @Override
    public void visitParameterList(@NotNull PsiParameterList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(46);
        }
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createParenthSpace(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES);
        } else if (this.myRole2 == 25) {
            this.createParenthSpaceInMethodParameters(list, this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        } else if (this.myRole1 == 24) {
            this.createParenthSpaceInMethodParameters(list, this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        }
    }

    private void createParenthSpaceInMethodParameters(@NotNull PsiParameterList list, boolean shouldUseDependentSpacing) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(47);
        }
        if (shouldUseDependentSpacing && list.getParametersCount() > 1) {
            this.createSpaceWithLinefeedIfListWrapped(list.getParameters(), this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        } else {
            this.createParenthSpace(shouldUseDependentSpacing, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        }
    }

    @Override
    public void visitRecordHeader(@NotNull PsiRecordHeader recordHeader) {
        if (recordHeader == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(48);
        }
        if (this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.myJavaSettings.RPAREN_ON_NEW_LINE_IN_RECORD_HEADER, this.myJavaSettings.SPACE_WITHIN_RECORD_HEADER);
        } else if (this.myType1 == JavaTokenType.LPARENTH) {
            this.createParenthSpace(this.myJavaSettings.NEW_LINE_AFTER_LPAREN_IN_RECORD_HEADER, this.myJavaSettings.SPACE_WITHIN_RECORD_HEADER);
        } else if (this.myType1 == JavaTokenType.COMMA) {
            int minLineFeed = this.myJavaSettings.BLANK_LINES_BETWEEN_RECORD_COMPONENTS == 0 ? 0 : this.myJavaSettings.BLANK_LINES_BETWEEN_RECORD_COMPONENTS + 1;
            this.createSpaceProperty(this.mySettings.SPACE_AFTER_COMMA, this.mySettings.KEEP_LINE_BREAKS, minLineFeed, this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        } else if (this.myType2 == JavaTokenType.COMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    @Override
    public void visitDeconstructionList(@NotNull PsiDeconstructionList deconstructionList) {
        if (deconstructionList == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(49);
        }
        super.visitDeconstructionList(deconstructionList);
        if (this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.myJavaSettings.RPAREN_ON_NEW_LINE_IN_DECONSTRUCTION_PATTERN, this.myJavaSettings.SPACE_WITHIN_DECONSTRUCTION_LIST);
        } else if (this.myType1 == JavaTokenType.LPARENTH) {
            this.createParenthSpace(this.myJavaSettings.NEW_LINE_AFTER_LPAREN_IN_DECONSTRUCTION_PATTERN, this.myJavaSettings.SPACE_WITHIN_DECONSTRUCTION_LIST);
        } else if (this.myType1 == JavaTokenType.COMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myType2 == JavaTokenType.COMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    private void createParenthSpace(boolean onNewLine, boolean space) {
        this.createParenthSpace(onNewLine, space, this.myParent.getTextRange());
    }

    private void createParenthSpace(boolean onNewLine, boolean space, TextRange dependence) {
        if (onNewLine) {
            int spaces = space ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependence, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.createSpaceInCode(space);
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(50);
        }
        if (this.myRole1 == 8) {
            this.processModifierList();
        } else if (this.myRole1 == 63) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        } else if (this.myType2 == JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS) {
            this.createSpaceProperty(false, true, 0);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        } else if (!(this.myType1 != JavaDocTokenType.DOC_TAG_VALUE_TOKEN && this.myType1 != JavaDocElementType.DOC_TAG_VALUE_ELEMENT || this.myType2 != JavaDocTokenType.DOC_TAG_VALUE_TOKEN && this.myType2 != JavaDocElementType.DOC_TAG_VALUE_ELEMENT)) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(51);
        }
        if (this.myRole1 == 10 && this.myRole2 == 55 || this.myRole1 == 55 && this.myRole2 == 90) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitExpressionList(@NotNull PsiExpressionList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(52);
        }
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES);
        } else if (this.myRole2 == 25) {
            boolean space;
            boolean bl = space = this.myRole1 == 23 || this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
            if (this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE && list.getExpressionCount() > 1) {
                this.createSpaceWithLinefeedIfListWrapped(list.getExpressions(), space);
                return;
            }
            this.createSpaceInCode(space);
        } else if (this.myRole1 == 24) {
            boolean space = this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES;
            if (this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE && list.getExpressionCount() > 1) {
                this.createSpaceWithLinefeedIfListWrapped(list.getExpressions(), space);
                return;
            }
            this.createSpaceInCode(space);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    @Override
    public void visitCaseLabelElementList(@NotNull PsiCaseLabelElementList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(53);
        }
        if (this.myType1 == JavaTokenType.COMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myType2 == JavaTokenType.COMMA) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    private void createSpaceWithLinefeedIfListWrapped(PsiElement @NotNull [] psiElementList, boolean space) {
        if (psiElementList == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(54);
        }
        int length = psiElementList.length;
        assert (length > 1);
        int spaces = space ? 1 : 0;
        int startOffset = psiElementList[0].getTextRange().getStartOffset();
        int endOffset = psiElementList[length - 1].getTextRange().getEndOffset();
        this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)new TextRange(startOffset, endOffset), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @Override
    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(55);
        }
        if (this.myRole1 == 79 || this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SYNCHRONIZED_PARENTHESES);
        } else if (this.myRole2 == 60) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE, null);
        }
    }

    @Override
    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(56);
        }
        if (this.myType1 == JavaTokenType.CASE_KEYWORD) {
            this.createSpaceProperty(true, false, 0);
        } else if (this.myType2 == JavaTokenType.COLON) {
            this.createSpaceProperty(false, false, 0);
        } else if (this.myType1 == JavaTokenType.WHEN_KEYWORD || this.myType2 == JavaTokenType.WHEN_KEYWORD) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitSwitchLabeledRuleStatement(@NotNull PsiSwitchLabeledRuleStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(57);
        }
        if (this.myType1 == JavaTokenType.ARROW && this.myType2 == JavaElementType.BLOCK_STATEMENT) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, true, null);
        } else if (this.myType1 == JavaTokenType.CASE_KEYWORD || this.myType1 == JavaTokenType.ARROW || this.myType2 == JavaTokenType.ARROW) {
            this.createSpaceProperty(true, false, 0);
        } else if (this.myType1 == JavaTokenType.WHEN_KEYWORD || this.myType2 == JavaTokenType.WHEN_KEYWORD) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(58);
        }
        this.processSwitchBlock();
    }

    @Override
    public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(59);
        }
        this.processSwitchBlock();
    }

    private void processSwitchBlock() {
        if (this.myType1 == JavaTokenType.SWITCH_KEYWORD && this.myType2 == JavaTokenType.LPARENTH) {
            this.createSpaceProperty(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES, false, 0);
        } else if (this.myType1 == JavaTokenType.LPARENTH || this.myType2 == JavaTokenType.RPARENTH) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        } else if (this.myType2 == JavaElementType.CODE_BLOCK) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, null);
        }
    }

    @Override
    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(60);
        }
        boolean spaceAroundArrow = this.mySettings.SPACE_AROUND_LAMBDA_ARROW;
        int braceStyle = this.mySettings.LAMBDA_BRACE_STYLE;
        if (this.myType1 == JavaTokenType.ARROW && this.myType2 == JavaElementType.CODE_BLOCK && (braceStyle == 2 || braceStyle == 3 || braceStyle == 4)) {
            int space = spaceAroundArrow ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)space, (int)space, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else if (this.myType1 == JavaTokenType.ARROW || this.myType2 == JavaTokenType.ARROW) {
            this.createSpaceInCode(spaceAroundArrow);
        }
    }

    @Override
    public void visitModule(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(61);
        }
        if (this.myType2 == JavaTokenType.RBRACE || ElementType.JAVA_MODULE_STATEMENT_BIT_SET.contains(this.myType2)) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myType1 == JavaElementType.MODULE_REFERENCE || this.myType2 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(true);
        } else if (this.myType1 == JavaElementType.MODIFIER_LIST) {
            this.processModifierList();
        }
    }

    @Override
    public void visitModuleStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(62);
        }
        if (this.myType1 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(this.myType2 != JavaTokenType.SEMICOLON && this.myType2 != JavaTokenType.COMMA);
        }
        if (this.myType2 == JavaElementType.MODULE_REFERENCE) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(63);
        }
        if (this.myType1 == JavaTokenType.DOUBLE_COLON || this.myType2 == JavaTokenType.DOUBLE_COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_METHOD_REF_DBL_COLON);
        }
    }

    @Override
    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(64);
        }
        if (this.myRole2 == 24) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.myRole1 == 24) {
            ASTNode rparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.RPARENTH, true);
            if (rparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                this.createParenthSpace(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(this.myChild1.getTextRange().getStartOffset(), rparenth.getTextRange().getEndOffset()));
                if (this.myType2 == JavaElementType.EMPTY_STATEMENT) {
                    this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON || this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
                }
            }
        } else if (this.myRole2 == 25) {
            ASTNode lparenth = JavaSpacePropertyProcessor.findFrom(this.myChild2, JavaTokenType.LPARENTH, false);
            if (lparenth == null) {
                this.createSpaceInCode(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            } else {
                ASTNode prev = FormatterUtil.getPreviousLeaf((ASTNode)this.myChild2, (IElementType[])new IElementType[]{TokenType.WHITE_SPACE, TokenType.ERROR_ELEMENT});
                if (prev != null && prev.getElementType() == JavaTokenType.SEMICOLON) {
                    this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
                } else {
                    this.createParenthSpace(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, new TextRange(lparenth.getTextRange().getStartOffset(), this.myChild2.getTextRange().getEndOffset()));
                }
            }
        } else if (this.myRole1 == 39) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole1 == 32) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
        } else if (this.myRole1 == 41) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myRole2 == 38 || this.myType2 == JavaElementType.CODE_BLOCK) {
            this.processLoopBody();
        }
    }

    private void processLoopBody() {
        this.myResult = this.myType2 == JavaElementType.BLOCK_STATEMENT ? this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_FOR_LBRACE, null) : (this.mySettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
    }

    @Nullable
    private static ASTNode findFrom(ASTNode current, IElementType expected, boolean forward) {
        ASTNode node = current;
        while (node != null) {
            if (node.getElementType() == expected) {
                return node;
            }
            node = forward ? node.getTreeNext() : node.getTreePrev();
        }
        return null;
    }

    @Override
    public void visitCatchSection(@NotNull PsiCatchSection section) {
        if (section == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(65);
        }
        if (this.myRole2 == 49) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_CATCH_LBRACE, null);
        } else if (this.myRole2 == 50) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        } else if (this.myRole1 == 50 || this.myRole2 == 51) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        }
    }

    @Override
    public void visitResourceList(@NotNull PsiResourceList resourceList) {
        if (resourceList == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(66);
        }
        if (this.myType1 == JavaTokenType.LPARENTH && this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_RPAREN_ON_NEXT_LINE, false);
        } else if (this.myType1 == JavaTokenType.LPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_TRY_PARENTHESES);
        } else if (this.myType2 == JavaTokenType.RPARENTH) {
            this.createParenthSpace(this.mySettings.RESOURCE_LIST_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_TRY_PARENTHESES);
        } else if (this.myType1 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_SEMICOLON);
        } else if (this.myType2 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_SEMICOLON);
        }
    }

    @Override
    public void visitReferenceParameterList(@NotNull PsiReferenceParameterList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(67);
        }
        if (this.myRole1 == 121 && this.myRole2 == 122 || this.myRole1 == 120 && this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 121 && this.myRole2 == 120) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        } else if (this.myRole1 == 23 && this.myRole2 == 120) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
        } else if (this.myRole2 == 122) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        }
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(68);
        }
        if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_CAST_PARENTHESES);
        } else if (this.myRole1 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_TYPE_CAST);
        }
    }

    private void createSpaceProperty(boolean space, int keepBlankLines) {
        this.createSpaceProperty(space, this.mySettings.KEEP_LINE_BREAKS, keepBlankLines);
    }

    private void createSpaceProperty(boolean space, boolean keepLineBreaks, int keepBlankLines) {
        this.createSpaceProperty(space, keepLineBreaks, 0, keepBlankLines);
    }

    private void createSpaceProperty(boolean space, boolean keepLineBreaks, int minLineFeeds, int keepBlankLines) {
        ASTNode prev = JavaSpacePropertyProcessor.getPrevElementType(this.myChild2);
        if (prev != null && prev.getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            if (!space && !JavaSpacePropertyProcessor.canStickChildrenTogether(this.myChild1, this.myChild2)) {
                space = true;
            }
            this.myResult = Spacing.createSpacing((int)(space ? 1 : 0), (int)(space ? 1 : 0), (int)minLineFeeds, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
    }

    @Override
    public void visitReferenceList(@NotNull PsiReferenceList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(69);
        }
        if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 123 || this.myRole2 == 123) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_AROUND_TYPE_BOUNDS_IN_TYPE_PARAMETERS);
        } else if (REF_LIST_KEYWORDS.contains(this.myType1) || REF_LIST_KEYWORDS.contains(this.myType2)) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(70);
        }
        this.visitReferenceElement(expression);
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(71);
        }
        if (this.myRole2 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.myRole1 == 114) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.myRole2 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        } else if (this.myRole1 == 87) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        }
    }

    @Override
    public void visitStatement(@NotNull PsiStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(72);
        }
        if (this.myRole2 == 22 && this.isAllowedToMoveSemicolonInLongCallChain()) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myChild1.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole2 == 22) {
            this.createSpaceInCode(false);
        }
        if (statement instanceof IJspClassLevelDeclarationStatement) {
            this.processClassBody();
        }
    }

    @Override
    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(73);
        }
        if (this.myType2 == JavaTokenType.SEMICOLON) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 65) {
            this.createSpaceInCode(true);
        } else {
            super.visitReturnStatement(statement);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(74);
        }
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    @Override
    public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
        if (classParameter == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(75);
        }
        this.createSpaceInCode(true);
    }

    @Override
    public void visitTypeElement(@NotNull PsiTypeElement type) {
        if (type == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(76);
        }
        if (this.myType1 == JavaElementType.ANNOTATION || this.myType2 == JavaElementType.ANNOTATION) {
            this.createSpaceInCode(true);
        } else if (this.myType2 == JavaTokenType.ELLIPSIS || this.myType2 == JavaTokenType.LBRACKET || this.myType2 == JavaTokenType.RBRACKET) {
            this.createSpaceInCode(false);
        } else if (type.getType() instanceof PsiDisjunctionType) {
            this.createSpaceInCode(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
        } else {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitDeclarationStatement(@NotNull PsiDeclarationStatement declarationStatement) {
        if (declarationStatement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(77);
        }
        if (this.myRole2 == 23) {
            this.createSpaceProperty(false, false, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitTypeParameterList(@NotNull PsiTypeParameterList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(78);
        }
        if (this.myRole1 == 121 || this.myRole2 == 122) {
            this.createSpaceInCode(this.myJavaSettings.SPACES_WITHIN_ANGLE_BRACKETS);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        }
    }

    @Override
    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(79);
        }
        if (this.myRole1 == 246 && this.myRole2 == 53) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_AFTER_CLOSING_ANGLE_BRACKET_IN_TYPE_ARGUMENT);
        } else if (this.myRole2 == 246) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_TYPE_PARAMETER_LIST);
        } else if (this.myRole2 == 55 || this.myRole1 == 55) {
            this.createSpaceInCode(false);
        } else if (this.myType1 == JavaElementType.ANNOTATION) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(80);
        }
        if (this.myRole2 == 14) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ANOTATION_PARAMETER_LIST);
        } else if (this.myType1 == JavaTokenType.AT && this.myType2 == JavaElementType.JAVA_CODE_REFERENCE) {
            this.createSpaceInCode(false);
        }
    }

    @Override
    public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
        if (initializer == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(81);
        }
        if (this.myType2 == JavaElementType.CODE_BLOCK) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_METHOD_LBRACE, null);
        }
    }

    @Override
    public void visitAnnotationParameterList(@NotNull PsiAnnotationParameterList list) {
        if (list == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(82);
        }
        if (this.myRole1 == 24 && this.myRole2 == 25) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 24 && this.mySettings.SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE && this.myRole2 == 249) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 24 && this.myType2 == JavaElementType.NAME_VALUE_PAIR && this.myJavaSettings.NEW_LINE_AFTER_LPAREN_IN_ANNOTATION) {
            int spacesCount = this.mySettings.SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spacesCount, (int)spacesCount, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myType1 == JavaElementType.NAME_VALUE_PAIR && this.myRole2 == 25 && this.myJavaSettings.RPAREN_ON_NEW_LINE_IN_ANNOTATION) {
            this.myResult = Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.myRole1 == 24 || this.myRole2 == 25) {
            this.createSpaceInCode(this.mySettings.SPACE_WITHIN_ANNOTATION_PARENTHESES);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(false);
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
        if (pair == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(83);
        }
        if (this.myRole1 == 63 || this.myRole2 == 63) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_AROUND_ANNOTATION_EQ);
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
        if (initializer == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(84);
        }
        this.visitArrayInitializer();
    }

    private void visitArrayInitializer() {
        if (this.myRole1 == 18) {
            if (this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE) {
                int spaces = this.myRole2 != 19 ? (this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0) : (this.mySettings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES ? 1 : 0);
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                boolean addSpace = this.myRole2 != 19 ? this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES : this.mySettings.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES;
                this.createSpaceProperty(addSpace, this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.myRole2 == 18) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE);
        } else if (this.myRole2 == 19) {
            if (this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE) {
                int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            } else {
                this.createSpaceProperty(this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES, this.mySettings.KEEP_BLANK_LINES_BEFORE_RBRACE);
            }
        } else if (this.myRole1 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COMMA);
        } else if (this.myRole2 == 23) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COMMA);
        }
    }

    @Override
    public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
        if (enumConstant == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(85);
        }
        if (this.myRole2 == 73) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        } else if (this.myRole2 == 70) {
            this.myResult = this.getSpaceBeforeLBrace(this.myChild2, this.mySettings.SPACE_BEFORE_CLASS_LBRACE, null);
        } else if (this.myRole1 == 8 && this.myRole2 == 9) {
            this.createSpaceInCode(true);
        } else if (this.myRole1 == 7 && this.myRole2 == 9) {
            this.createParenthSpace(true, true);
        }
    }

    @Override
    public void visitDocTag(@NotNull PsiDocTag tag) {
        if (tag == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(86);
        }
        if (this.myType1 == JavaDocTokenType.DOC_TAG_NAME && this.myType2 == JavaDocElementType.DOC_TAG_VALUE_ELEMENT) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
    }

    @Override
    public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
        if (statement == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(87);
        }
        if (this.myType1 == JavaTokenType.ASSERT_KEYWORD) {
            this.createSpaceInCode(true);
        } else if (this.myType1 == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.myType2 == JavaTokenType.COLON) {
            this.createSpaceInCode(this.mySettings.SPACE_BEFORE_COLON);
        }
    }

    @Override
    public void visitParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(88);
        }
        if (this.myRole1 == 10 || this.myRole1 == 8) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitRecordComponent(@NotNull PsiRecordComponent recordComponent) {
        if (recordComponent == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(89);
        }
        if (this.myType1 == JavaElementType.TYPE && this.myType2 == JavaTokenType.IDENTIFIER) {
            this.createSpaceInCode(true);
        } else if (this.myType1 == JavaElementType.MODIFIER_LIST && this.myType2 == JavaElementType.TYPE) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitSnippetAttribute(@NotNull PsiSnippetAttribute attribute) {
        if (attribute == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(90);
        }
        this.createSpaceInCode(true);
    }

    @Override
    public void visitSnippetTag(@NotNull PsiSnippetDocTag snippetDocTag) {
        if (snippetDocTag == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(91);
        }
        if (this.myType1 == JavaDocTokenType.DOC_TAG_NAME && this.myType2 == JavaDocElementType.DOC_SNIPPET_TAG_VALUE) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitSnippetAttributeList(@NotNull PsiSnippetAttributeList attributeList) {
        if (attributeList == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(92);
        }
        if (this.myType1 == JavaDocElementType.DOC_SNIPPET_ATTRIBUTE && this.myType2 == JavaDocElementType.DOC_SNIPPET_ATTRIBUTE) {
            this.createSpaceInCode(true);
        }
    }

    @Override
    public void visitDeconstructionPattern(@NotNull PsiDeconstructionPattern deconstructionPattern) {
        if (deconstructionPattern == null) {
            JavaSpacePropertyProcessor.$$$reportNull$$$0(93);
        }
        if (this.myType1 == JavaElementType.TYPE && this.myType2 == JavaElementType.DECONSTRUCTION_LIST) {
            this.createSpaceInCode(this.myJavaSettings.SPACE_BEFORE_DECONSTRUCTION_LIST);
        } else if (this.myType1 == JavaElementType.DECONSTRUCTION_LIST && this.myType2 == JavaElementType.DECONSTRUCTION_PATTERN_VARIABLE) {
            this.createSpaceInCode(true);
        }
    }

    public static Spacing getSpacing(Block node, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        return new JavaSpacePropertyProcessor((Block)node, (CommonCodeStyleSettings)settings, (JavaCodeStyleSettings)javaSettings).myResult;
    }

    public static boolean canStickChildrenTogether(ASTNode child1, ASTNode child2) {
        if (child1 == null || child2 == null || child1.getElementType() == TokenType.WHITE_SPACE || child2.getElementType() == TokenType.WHITE_SPACE) {
            return true;
        }
        ASTNode token1 = TreeUtil.findLastLeaf((ASTNode)child1);
        LeafElement token2 = TreeUtil.findFirstLeaf((ASTNode)child2);
        LOG.assertTrue(token1 != null);
        LOG.assertTrue(token2 != null);
        IElementType type1 = token1.getElementType();
        IElementType type2 = token2.getElementType();
        if (!(type1 instanceof IJavaElementType) || !(type2 instanceof IJavaElementType)) {
            return true;
        }
        if (type1 == JavaTokenType.GE || type2 == JavaTokenType.GE) {
            return true;
        }
        if (type1 == JavaTokenType.GTGT && type2 != JavaTokenType.GT && type2 != JavaTokenType.EQ) {
            return true;
        }
        if (type1 != JavaTokenType.GT && type2 == JavaTokenType.GTGT) {
            return true;
        }
        if (ElementType.STRING_TEMPLATE_FRAGMENTS.contains(type1) || ElementType.STRING_TEMPLATE_FRAGMENTS.contains(type2)) {
            return true;
        }
        Pair key = Pair.pair((Object)type1, (Object)type2);
        Boolean result = ourTokenStickingMatrix.get(key);
        if (result == null) {
            Lexer lexer = JavaParserDefinition.createLexerWithMarkdownEscape(LanguageLevel.HIGHEST);
            String text1 = JavaSpacePropertyProcessor.unescapeTokenText(token1, type1);
            String text2 = JavaSpacePropertyProcessor.unescapeTokenText((ASTNode)token2, type2);
            lexer.start((CharSequence)(text1 + text2));
            IElementType reparsedType1 = lexer.getTokenType();
            String reparsedText1 = lexer.getTokenText();
            lexer.advance();
            IElementType reparsedType2 = lexer.getTokenType();
            String reparsedText2 = lexer.getTokenText();
            result = JavaSpacePropertyProcessor.sameTokens(type1, text1, reparsedType1, reparsedText1) && JavaSpacePropertyProcessor.sameTokens(type2, text2, reparsedType2, reparsedText2);
            ourTokenStickingMatrix.put((Pair<IElementType, IElementType>)key, result);
        }
        return result;
    }

    private static String unescapeTokenText(ASTNode token, IElementType type) {
        String text = token.getText();
        if (ESCAPED_TOKENS.contains(type) && StringUtil.startsWithChar((CharSequence)text, (char)'&')) {
            text = StringUtil.unescapeXmlEntities((String)text);
        }
        return text;
    }

    private boolean isAllowedToMoveSemicolonInLongCallChain() {
        if (!this.myJavaSettings.WRAP_SEMICOLON_AFTER_CALL_CHAIN) {
            return false;
        }
        if (Registry.is((String)"java.formatter.chained.calls.pre212.compatibility")) {
            return false;
        }
        if (!(this.myChild1 instanceof PsiMethodCallExpression) || this.myType1 != JavaElementType.METHOD_CALL_EXPRESSION) {
            return false;
        }
        if (this.isInsidePsiForStatement()) {
            return false;
        }
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>();
        JavaFormatterUtil.collectCallExpressionNodes(nodes, this.myChild1);
        return ChainMethodCallsBlockBuilder.isLongCallChain(nodes, this.mySettings);
    }

    private static boolean sameTokens(IElementType type, String text, IElementType reparsedType, String reparsedText) {
        return reparsedType == type || reparsedType == JavaTokenType.IDENTIFIER && ElementType.KEYWORD_BIT_SET.contains(type) && Objects.equals(text, reparsedText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 10: 
            case 19: 
            case 20: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/JavaSpacePropertyProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lBraceBlock";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstantInitializer";
                break;
            }
            case 24: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 25: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 67: 
            case 69: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 62: 
            case 64: 
            case 72: 
            case 73: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHeader";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionList";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementList";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceList";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classParameter";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationStatement";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordComponent";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetDocTag";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/JavaSpacePropertyProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpaceBeforeMethodLBrace";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpaceBeforeClassLBrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitNewExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayInitializerExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJavadocHoldingEnumConstant";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeMethodLBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodHeaderEndOffset";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeClassLBrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSpaceBeforeLBrace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddNewLineWhenBodyIsPresent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldHandleAsSimpleMethod";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMethodHeaderStartOffset";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isEndOfLineCommentAfterLBrace";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitInstanceOfExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstantInitializer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitPatternVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitImportList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileStatement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowStatement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitForeachStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitForeachPatternStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitYieldStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeBlock";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeFragment";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitPolyadicExpression";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitLocalVariable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitModifierList";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitParameterList";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createParenthSpaceInMethodParameters";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordHeader";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitDeconstructionList";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitExpressionList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitCaseLabelElementList";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createSpaceWithLinefeedIfListWrapped";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitSynchronizedStatement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabelStatement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchLabeledRuleStatement";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchExpression";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "visitModule";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitModuleStatement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodReferenceExpression";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "visitCatchSection";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitResourceList";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceParameterList";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeCastExpression";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceList";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitStatement";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "visitMethodCallExpression";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameter";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeElement";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "visitDeclarationStatement";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameterList";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotation";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "visitClassInitializer";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationParameterList";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "visitNameValuePair";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "visitDocTag";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "visitParameter";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "visitRecordComponent";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "visitSnippetAttribute";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "visitSnippetTag";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "visitSnippetAttributeList";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "visitDeconstructionPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

