/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.maven;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactEntityBuilder;
import com.intellij.java.workspace.entities.ArtifactEntityModifications;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntity;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntityBuilder;
import com.intellij.java.workspace.entities.ArtifactPropertiesEntityModifications;
import com.intellij.java.workspace.entities.CompositePackagingElementEntity;
import com.intellij.java.workspace.entities.CompositePackagingElementEntityBuilder;
import com.intellij.java.workspace.entities.PackagingElementEntity;
import com.intellij.javaee.maven.JavaeeImporterArtifact;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.LegacyBridgeJpsArtifactEntitySourceFactory;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J,\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\u001fJ\u0012\u0010\"\u001a\u0004\u0018\u00010\u0011*\u0006\u0012\u0002\b\u00030#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/javaee/maven/JavaeeImporterArtifacts;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;)V", "artifacts", "", "Lcom/intellij/javaee/maven/JavaeeImporterArtifact;", "currentProcessors", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCurrentProcessors", "()Ljava/util/concurrent/atomic/AtomicInteger;", "findArtifact", "name", "", "getArtifactsByType", "", "type", "Lcom/intellij/packaging/artifacts/ArtifactType;", "generateUniqueName", "baseName", "addArtifact", "artifactType", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "removeArtifact", "", "artifact", "applyToStorageIfProcessed", "propertiesTag", "Lcom/intellij/packaging/artifacts/ArtifactProperties;", "intellij.javaee.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJavaeeFacetHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaeeFacetHelpers.kt\ncom/intellij/javaee/maven/JavaeeImporterArtifacts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n295#2,2:213\n774#2:215\n865#2,2:216\n3301#2,10:219\n1869#2,2:229\n1#3:218\n*S KotlinDebug\n*F\n+ 1 JavaeeFacetHelpers.kt\ncom/intellij/javaee/maven/JavaeeImporterArtifacts\n*L\n120#1:213,2\n122#1:215\n122#1:216,2\n173#1:219,10\n175#1:229,2\n*E\n"})
public final class JavaeeImporterArtifacts {
    @NotNull
    private final Project project;
    @NotNull
    private final MutableEntityStorage storage;
    @NotNull
    private final List<JavaeeImporterArtifact> artifacts;
    @NotNull
    private final AtomicInteger currentProcessors;

    public JavaeeImporterArtifacts(@NotNull Project project, @NotNull MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.project = project;
        this.storage = storage;
        this.artifacts = new ArrayList();
        this.currentProcessors = new AtomicInteger();
    }

    @NotNull
    public final AtomicInteger getCurrentProcessors() {
        return this.currentProcessors;
    }

    @Nullable
    public final JavaeeImporterArtifact findArtifact(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.artifacts;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JavaeeImporterArtifact it = (JavaeeImporterArtifact)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<JavaeeImporterArtifact> getArtifactsByType(@NotNull ArtifactType type) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable $this$filter$iv = this.artifacts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JavaeeImporterArtifact it = (JavaeeImporterArtifact)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getArtifactType(), (Object)type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String generateUniqueName(String baseName) {
        String string = UniqueNameGenerator.generateUniqueName((String)baseName, arg_0 -> JavaeeImporterArtifacts.generateUniqueName$lambda$1(arg_0 -> JavaeeImporterArtifacts.generateUniqueName$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    @NotNull
    public final JavaeeImporterArtifact addArtifact(@NotNull String name, @NotNull ArtifactType artifactType, @NotNull CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        VirtualFileUrl outputUrl;
        VirtualFileUrl virtualFileUrl;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        String uniqueName = this.generateUniqueName(name);
        String outputPath = ArtifactUtil.getDefaultArtifactOutputPath((String)uniqueName, (Project)this.project);
        VirtualFileUrlManager fileManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        String string = outputPath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String string2 = VfsUtilCore.pathToUrl((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(...)");
            virtualFileUrl = fileManager.getOrCreateFromUrl(string2);
        } else {
            virtualFileUrl = null;
        }
        VirtualFileUrl virtualFileUrl2 = outputUrl = virtualFileUrl;
        Intrinsics.checkNotNull((Object)virtualFileUrl2);
        JavaeeImporterArtifact artifact = new JavaeeImporterArtifact(this.project, uniqueName, artifactType, virtualFileUrl2, rootElement, externalSource);
        this.artifacts.add(artifact);
        return artifact;
    }

    public final void removeArtifact(@NotNull JavaeeImporterArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        this.artifacts.remove(artifact);
    }

    public final void applyToStorageIfProcessed() {
        if (this.currentProcessors.get() > 0) {
            return;
        }
        for (JavaeeImporterArtifact artifact : this.artifacts) {
            EntitySource source = LegacyBridgeJpsArtifactEntitySourceFactory.Companion.getInstance(this.project).createEntitySourceForArtifact(artifact.getExternalSource());
            CompositePackagingElement<?> rootElement = artifact.getRootElement();
            PackagingElementEntity.Builder builder = rootElement.getOrAddEntityBuilder(this.storage, source, this.project);
            Intrinsics.checkNotNull((Object)builder, (String)"null cannot be cast to non-null type com.intellij.java.workspace.entities.CompositePackagingElementEntity.Builder<out com.intellij.java.workspace.entities.CompositePackagingElementEntity>");
            CompositePackagingElementEntity.Builder rootElementEntity = (CompositePackagingElementEntity.Builder)builder;
            String string = artifact.getName();
            String string2 = artifact.getArtifactType().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            ArtifactEntity artifactEntity = (ArtifactEntity)this.storage.addEntity((WorkspaceEntity.Builder)ArtifactEntityModifications.createArtifactEntity((String)string, (String)string2, (boolean)false, (EntitySource)source, arg_0 -> JavaeeImporterArtifacts.applyToStorageIfProcessed$lambda$0(artifact, rootElementEntity, arg_0)));
            for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
                Iterator iterator;
                String tag;
                WorkspaceEntity workspaceEntity;
                block8: {
                    ArtifactPropertiesEntity it;
                    ArtifactProperties<?> properties = artifact.getProperties(provider);
                    if (properties == null) {
                        Iterable $this$partition$iv = artifactEntity.getCustomProperties();
                        boolean $i$f$partition = false;
                        ArrayList first$iv = new ArrayList();
                        ArrayList second$iv = new ArrayList();
                        for (Object element$iv : $this$partition$iv) {
                            ArtifactPropertiesEntity it2 = (ArtifactPropertiesEntity)element$iv;
                            boolean bl = false;
                            boolean bl2 = Intrinsics.areEqual((Object)it2.getProviderType(), (Object)provider.getId()) ? first$iv.add(element$iv) : second$iv.add(element$iv);
                        }
                        List toBeRemoved = (List)new Pair(first$iv, second$iv).component1();
                        if (!((Collection)toBeRemoved).isEmpty()) {
                            Iterable $this$forEach$iv = toBeRemoved;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                it = (ArtifactPropertiesEntity)element$iv;
                                boolean bl = false;
                                this.storage.removeEntity((WorkspaceEntity)it);
                            }
                        }
                        workspaceEntity = Unit.INSTANCE;
                        continue;
                    }
                    tag = this.propertiesTag(properties);
                    Iterable iterable = artifactEntity.getCustomProperties();
                    for (Iterator iterator2 : iterable) {
                        it = (ArtifactPropertiesEntity)iterator2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getProviderType(), (Object)provider.getId())) continue;
                        iterator = iterator2;
                        break block8;
                    }
                    iterator = null;
                }
                ArtifactPropertiesEntity existingProperty = (ArtifactPropertiesEntity)iterator;
                workspaceEntity = existingProperty == null ? (WorkspaceEntity)ArtifactEntityModifications.modifyArtifactEntity((MutableEntityStorage)this.storage, (ArtifactEntity)artifactEntity, arg_0 -> JavaeeImporterArtifacts.applyToStorageIfProcessed$lambda$4(provider, artifactEntity, tag, arg_0)) : (WorkspaceEntity)ArtifactPropertiesEntityModifications.modifyArtifactPropertiesEntity((MutableEntityStorage)this.storage, (ArtifactPropertiesEntity)existingProperty, arg_0 -> JavaeeImporterArtifacts.applyToStorageIfProcessed$lambda$5(tag, arg_0));
            }
        }
        this.artifacts.clear();
    }

    private final String propertiesTag(ArtifactProperties<?> $this$propertiesTag) {
        String string;
        Object state = $this$propertiesTag.getState();
        if (state != null) {
            Element element = XmlSerializer.serialize$default((Object)state, null, (boolean)false, (int)6, null);
            if (element == null) {
                return null;
            }
            Element element2 = element;
            element2.setName("options");
            string = JDOMUtil.write((Element)element2);
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean generateUniqueName$lambda$0(JavaeeImporterArtifacts this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.findArtifact(it) == null;
    }

    private static final boolean generateUniqueName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit applyToStorageIfProcessed$lambda$0(JavaeeImporterArtifact $artifact, CompositePackagingElementEntity.Builder $rootElementEntity, ArtifactEntityBuilder $this$ArtifactEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactEntity, (String)"$this$ArtifactEntity");
        $this$ArtifactEntity.setOutputUrl($artifact.getOutputUrl());
        $this$ArtifactEntity.setRootElement((CompositePackagingElementEntityBuilder)$rootElementEntity);
        $this$ArtifactEntity.setIncludeInProjectBuild($artifact.isBuildOnMake());
        return Unit.INSTANCE;
    }

    private static final Unit applyToStorageIfProcessed$lambda$4(ArtifactPropertiesProvider $provider, ArtifactEntity $artifactEntity, String $tag, ArtifactEntityBuilder $this$modifyArtifactEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyArtifactEntity, (String)"$this$modifyArtifactEntity");
        Collection collection = $this$modifyArtifactEntity.getCustomProperties();
        String string = $provider.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        $this$modifyArtifactEntity.setCustomProperties(CollectionsKt.plus((Collection)collection, (Object)ArtifactPropertiesEntityModifications.createArtifactPropertiesEntity((String)string, (EntitySource)$artifactEntity.getEntitySource(), arg_0 -> JavaeeImporterArtifacts.applyToStorageIfProcessed$lambda$4$0($tag, arg_0))));
        return Unit.INSTANCE;
    }

    private static final Unit applyToStorageIfProcessed$lambda$4$0(String $tag, ArtifactPropertiesEntityBuilder $this$ArtifactPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$ArtifactPropertiesEntity, (String)"$this$ArtifactPropertiesEntity");
        $this$ArtifactPropertiesEntity.setPropertiesXmlTag($tag);
        return Unit.INSTANCE;
    }

    private static final Unit applyToStorageIfProcessed$lambda$5(String $tag, ArtifactPropertiesEntityBuilder $this$modifyArtifactPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyArtifactPropertiesEntity, (String)"$this$modifyArtifactPropertiesEntity");
        $this$modifyArtifactPropertiesEntity.setPropertiesXmlTag($tag);
        return Unit.INSTANCE;
    }
}

