/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitSuccessfulRebase
extends GitRebaseStatus {
    GitSuccessfulRebase() {
        super(GitRebaseStatus.Type.SUCCESS);
    }

    @NotNull
    @Nls
    public static String formatMessage(@Nullable String currentBranch, @Nullable String baseBranch, boolean withCheckout) {
        if (withCheckout) {
            String string = GitBundle.message((String)"rebase.notification.successful.rebased.checkout.message", (Object[])new Object[]{GitSuccessfulRebase.convertBooleanToInt(currentBranch != null), GitSuccessfulRebase.stripPrefix(currentBranch), GitSuccessfulRebase.convertBooleanToInt(baseBranch != null), GitSuccessfulRebase.stripPrefix(baseBranch)});
            if (string == null) {
                GitSuccessfulRebase.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = GitBundle.message((String)"rebase.notification.successful.rebased.message", (Object[])new Object[]{GitSuccessfulRebase.convertBooleanToInt(currentBranch != null), GitSuccessfulRebase.stripPrefix(currentBranch), GitSuccessfulRebase.convertBooleanToInt(baseBranch != null), GitSuccessfulRebase.stripPrefix(baseBranch)});
        if (string == null) {
            GitSuccessfulRebase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static String stripPrefix(@Nullable String branch) {
        return branch == null ? null : GitBranchUtil.stripRefsPrefix(branch);
    }

    private static int convertBooleanToInt(boolean expression) {
        return expression ? 1 : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase", "formatMessage"));
    }
}

