/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.provider.http.MnHttpUrlResolverKt;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "schemes", "", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "info", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "authorities", "Lcom/intellij/microservices/url/Authority;", "<init>", "(Ljava/util/List;Lcom/intellij/microservices/url/UrlPath;Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;Ljava/util/List;)V", "getSchemes", "()Ljava/util/List;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "getAuthorities", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "methods", "", "getMethods", "()Ljava/util/Set;", "source", "getSource", "()Ljava/lang/String;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "intellij.micronaut"})
public final class MnHttpUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final MnHttpMappingInfo info;
    @NotNull
    private final List<Authority> authorities;

    public MnHttpUrlTargetInfo(@NotNull List<String> schemes, @NotNull UrlPath path, @NotNull MnHttpMappingInfo info, @NotNull List<? extends Authority> authorities) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.schemes = schemes;
        this.path = path;
        this.info = info;
        this.authorities = authorities;
    }

    public /* synthetic */ MnHttpUrlTargetInfo(List list, UrlPath urlPath, MnHttpMappingInfo mnHttpMappingInfo, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
            list2 = list3;
        }
        this(list, urlPath, mnHttpMappingInfo, list2);
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Web.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        if (!this.info.isValid()) {
            return null;
        }
        return this.info.getMapping().getPsiElement();
    }

    @NotNull
    public Set<String> getMethods() {
        return UrlPathModelKt.getDeclaredHttpMethods((String)this.info.getMapping().getHttpMethod());
    }

    @NotNull
    public String getSource() {
        Object object = this.info.getHolder();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return MnHttpUrlResolverKt.getMnQueryParameterSupport().getParametersFromDeclarationContext(this.resolveToPsiElement());
    }
}

