/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.ContinuedFraction;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.Gamma;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J4\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/Beta;", "", "()V", "DEFAULT_EPSILON", "", "logBeta", "a", "b", "epsilon", "maxIterations", "", "regularizedBeta", "x", "plot-base"})
public final class Beta {
    @NotNull
    public static final Beta INSTANCE = new Beta();
    private static final double DEFAULT_EPSILON = 1.0E-14;

    private Beta() {
    }

    public final double regularizedBeta(double x2, double a2, double b2, int maxIterations) {
        return this.regularizedBeta(x2, a2, b2, DEFAULT_EPSILON, maxIterations);
    }

    @JvmOverloads
    public final double regularizedBeta(double x2, double a2, double b2, double epsilon, int maxIterations) {
        double ret = 0.0;
        if (Double.isNaN(x2) || Double.isNaN(a2) || Double.isNaN(b2) || x2 < 0.0 || x2 > 1.0 || a2 <= 0.0 || b2 <= 0.0) {
            ret = Double.NaN;
        } else if (x2 > (a2 + 1.0) / (a2 + b2 + 2.0)) {
            ret = 1.0 - this.regularizedBeta(1.0 - x2, b2, a2, epsilon, maxIterations);
        } else {
            ContinuedFraction fraction2 = new ContinuedFraction(b2, a2){
                final /* synthetic */ double $b;
                final /* synthetic */ double $a;
                {
                    this.$b = $b;
                    this.$a = $a;
                }

                protected double getB(int n, double x2) {
                    double ret = 0.0;
                    double m = 0.0;
                    if (n % 2 == 0) {
                        m = (double)n / 2.0;
                        ret = m * (this.$b - m) * x2 / ((this.$a + (double)2 * m - 1.0) * (this.$a + (double)2 * m));
                    } else {
                        m = ((double)n - 1.0) / 2.0;
                        ret = -((this.$a + m) * (this.$a + this.$b + m) * x2) / ((this.$a + (double)2 * m) * (this.$a + (double)2 * m + 1.0));
                    }
                    return ret;
                }

                protected double getA(int n, double x2) {
                    return 1.0;
                }
            };
            ret = Math.exp(a2 * Math.log(x2) + b2 * Math.log(1.0 - x2) - Math.log(a2) - this.logBeta(a2, b2, epsilon, maxIterations)) * 1.0 / fraction2.evaluate(x2, epsilon, maxIterations);
        }
        return ret;
    }

    public static /* synthetic */ double regularizedBeta$default(Beta beta, double d, double d2, double d3, double d4, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            d4 = DEFAULT_EPSILON;
        }
        if ((n2 & 0x10) != 0) {
            n = Integer.MAX_VALUE;
        }
        return beta.regularizedBeta(d, d2, d3, d4, n);
    }

    @JvmOverloads
    public final double logBeta(double a2, double b2, double epsilon, int maxIterations) {
        double ret = 0.0;
        ret = Double.isNaN(a2) || Double.isNaN(b2) || a2 <= 0.0 || b2 <= 0.0 ? Double.NaN : Gamma.INSTANCE.logGamma(a2) + Gamma.INSTANCE.logGamma(b2) - Gamma.INSTANCE.logGamma(a2 + b2);
        return ret;
    }

    public static /* synthetic */ double logBeta$default(Beta beta, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d3 = DEFAULT_EPSILON;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        return beta.logBeta(d, d2, d3, n);
    }

    @JvmOverloads
    public final double regularizedBeta(double x2, double a2, double b2, double epsilon) {
        return Beta.regularizedBeta$default(this, x2, a2, b2, epsilon, 0, 16, null);
    }

    @JvmOverloads
    public final double regularizedBeta(double x2, double a2, double b2) {
        return Beta.regularizedBeta$default(this, x2, a2, b2, 0.0, 0, 24, null);
    }

    @JvmOverloads
    public final double logBeta(double a2, double b2, double epsilon) {
        return Beta.logBeta$default(this, a2, b2, epsilon, 0, 8, null);
    }

    @JvmOverloads
    public final double logBeta(double a2, double b2) {
        return Beta.logBeta$default(this, a2, b2, 0.0, 0, 12, null);
    }
}

