/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.HorizontalConstrainedPresentation;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayContentListener;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.InlineInlayRenderer;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.BlockConstrainsModel;
import com.jetbrains.rd.ide.model.ConstrainedInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HorizontalConstraintsModel;
import com.jetbrains.rd.ide.model.InlayConstraintsModel;
import com.jetbrains.rd.ide.model.InlayWithPresentationEventsModel;
import com.jetbrains.rd.ide.model.RootPresentationModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayWithPresentationModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "inlayEventsModel", "Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "textMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendInlayWithPresentationModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final Project project;
    @NotNull
    private final InlayWithPresentationEventsModel inlayEventsModel;
    @NotNull
    private final InlayTextMetricsStorage textMetricsStorage;

    public FrontendInlayWithPresentationModelHandler(@NotNull EditorImpl editor, @Nullable Project project, @NotNull InlayWithPresentationEventsModel inlayEventsModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)inlayEventsModel, (String)"inlayEventsModel");
        this.editor = editor;
        this.project = project;
        this.inlayEventsModel = inlayEventsModel;
        this.textMetricsStorage = new InlayTextMetricsStorage((Editor)this.editor);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof ConstrainedInlayHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        block7: {
            Inlay inlay;
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            ConstrainedInlayHighlighterModel cfr_ignored_0 = (ConstrainedInlayHighlighterModel)model2;
            boolean relatesToPrecedingText = ((ConstrainedInlayHighlighterModel)model2).getConstraints().getRelatesToPrecedingText();
            ((RangeMarkerImpl)highlighter).setStickingToRight(relatesToPrecedingText);
            PresentationFactory factory = new PresentationFactory((Editor)this.editor);
            ScaleAwarePresentationFactory scaleFactory = new ScaleAwarePresentationFactory((Editor)this.editor, factory);
            RootPresentationModel rootModel = ((ConstrainedInlayHighlighterModel)model2).getPresentation();
            InlayPresentation inlayPresentation = FrontendInlayWithPresentationModelSupportKt.access$toPresentation(rootModel.getPresentation(), this.textMetricsStorage, model2.getId(), this.inlayEventsModel, scaleFactory);
            if (inlayPresentation == null) {
                return;
            }
            InlayPresentation presentation = inlayPresentation;
            RecursivelyUpdatingRootPresentation rootPresentation = new RecursivelyUpdatingRootPresentation(presentation);
            if (FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter) != null) {
                Inlay<?> inlay2 = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
                EditorCustomElementRenderer editorCustomElementRenderer = inlay2 != null ? inlay2.getRenderer() : null;
                LinearOrderInlayRenderer linearOrderInlayRenderer = editorCustomElementRenderer instanceof LinearOrderInlayRenderer ? (LinearOrderInlayRenderer)editorCustomElementRenderer : null;
                InlayPresentation root = linearOrderInlayRenderer != null ? linearOrderInlayRenderer.getCachedPresentation() : null;
                RecursivelyUpdatingRootPresentation cfr_ignored_1 = (RecursivelyUpdatingRootPresentation)root;
                RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation = (RecursivelyUpdatingRootPresentation)root;
                if (recursivelyUpdatingRootPresentation != null) {
                    recursivelyUpdatingRootPresentation.update(rootPresentation.getContent(), (Editor)this.editor, (InlayPresentationFactory)factory);
                }
                return;
            }
            InlayConstraintsModel constraintsModel = ((ConstrainedInlayHighlighterModel)model2).getConstraints();
            if (constraintsModel instanceof HorizontalConstraintsModel) {
                constraints = new HorizontalConstraints(constraintsModel.getPriority(), relatesToPrecedingText, ((HorizontalConstraintsModel)constraintsModel).getPlacedAtTheEndOfLine());
                constrainedPresentation = new HorizontalConstrainedPresentation((RootInlayPresentation)rootPresentation, constraints);
                renderer = new InlineInlayRenderer((Collection)CollectionsKt.listOf((Object)constrainedPresentation));
                inlay = constraints.getPlacedAtTheEndOfLine() ? this.editor.getInlayModel().addAfterLineEndElement(model2.getStart(), constraints.getRelatesToPrecedingText(), (EditorCustomElementRenderer)renderer) : this.editor.getInlayModel().addInlineElement(model2.getStart(), constraints.getRelatesToPrecedingText(), constraints.getPriority(), (EditorCustomElementRenderer)renderer);
            } else if (constraintsModel instanceof BlockConstrainsModel) {
                constraints = new BlockConstraints(relatesToPrecedingText, constraintsModel.getPriority(), null, null, 12, null);
                constrainedPresentation = new BlockConstrainedPresentation((RootInlayPresentation)rootPresentation, (BlockConstraints)constraints);
                renderer = new BlockInlayRenderer(factory, (Collection)CollectionsKt.listOf((Object)constrainedPresentation));
                inlay = this.editor.getInlayModel().addBlockElement(model2.getStart(), new InlayProperties().relatesToPrecedingText(relatesToPrecedingText).showAbove(((BlockConstrainsModel)constraintsModel).getShowAbove()).showWhenFolded(((BlockConstrainsModel)constraintsModel).getShowWhenFolded()).priority(constraints.getPriority()), (EditorCustomElementRenderer)renderer);
            } else {
                return;
            }
            Inlay inlay3 = inlay;
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, inlay3);
            Inlay inlay4 = inlay3;
            if (inlay4 == null || (inlay4 = (LinearOrderInlayRenderer)inlay4.getRenderer()) == null) break block7;
            inlay4.setListener((PresentationListener)new InlayContentListener(inlay3));
        }
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        if (!(inlay2.getRenderer() instanceof InlineInlayRenderer)) {
            return false;
        }
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return (HighlighterModel)FrontendInlayWithPresentationModelSupportKt.move((ConstrainedInlayHighlighterModel)model2, startOffset, endOffset);
    }
}

