package com.intellij.thymeleaf.spring.security.springSecurity5;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.beans.AbstractThymeleafDialect;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import org.jetbrains.annotations.NotNull;

final class ThymeleafSpringSecurityDialect5 extends AbstractThymeleafDialect {
  ThymeleafSpringSecurityDialect5() {
    super(ThymeleafSpringSecurityDialect5.class.getResource("Spring-Security-Dialect.xml"));
  }

  @Override
  public boolean isSupported(@NotNull Project project) {
    return JavaPsiFacade.getInstance(project).findPackage("org.thymeleaf.extras.springsecurity5") != null;
  }

  @Override
  public String[] getNamespaces() {
    return ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_5_URIS;
  }

  @Override
  public ThymeleafLanguage getLanguage() {
    return ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS;
  }
}
