/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import java.io.IOException;

public class DataIntElement
extends UserNumber
implements DataNumericElement {
    public DataIntElement() {
        this(0);
    }

    public DataIntElement(Number number) {
        super(number.intValue());
    }

    public DataIntElement(int n) {
        super(n);
    }

    public DataIntElement(TeXNumber teXNumber) {
        super(teXNumber.getValue());
    }

    @Override
    public Object clone() {
        return new DataIntElement(this.getValue());
    }

    @Override
    public byte getDataType() {
        return 1;
    }

    @Override
    public DatumType getDatumType() {
        return DatumType.INTEGER;
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.getValue();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_integer_value:n"));
        teXObjectList2.add(new UserNumber(this.getValue()));
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
    }

    @Override
    public String format() {
        return "" + this.getValue();
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new IntegerContentCommand(string, this.intValue());
    }
}

