//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cCollidable.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cCollidable.hpp"

#include "cMap.hpp"
#include "Intersection.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cCollidable::cCollidable (void):
mCollisionModel (CollisionModel_Ray),
mContactModel (ContactModel_Stop)
{
	// Empty
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cCollidable::~cCollidable (void)
{
	// Empty
};
//==============================================================================
/*
//==============================================================================
//! Object collision test
void 
cCollidable::RayCollision (cCollidable *pOther, Uint32 deltaTime)
{
	dbg::check_ptr (dbg::error, pOther, DBG_HERE);

	// This should be assertion
	if ( pOther == this )
		return;
	
	cVector2f newPosition = GetPosition () + GetVelocity () * deltaTime;
	cVector2f otherPosition = pOther->GetPosition () + pOther->GetVelocity () * deltaTime;

	
	switch ( pOther->GetCollisionModel () )
	{
		case CollisionModel_Ray:
			RayRayIntersection (
			break;
		case CollisionModel_Circle:
			dbg::unimplemented (DBG_HERE);
			break;
		default:
			break;
	}
}
//==============================================================================

//==============================================================================
//! Object collision test
void 
cCollidable::CircleCollision (cCollidable *pOther, Uint32 deltaTime)
{
	dbg::check_ptr (dbg::error, pOther, DBG_HERE);
	
	// This should be assertion
	if ( pOther == this )
		return;
	
	cVector2f newPosition = GetPosition () + GetVelocity () * deltaTime;
	cVector2f otherPosition = pOther->GetPosition () + pOther->GetVelocity () * deltaTime;
	
	switch ( pOther->GetCollisionModel () )
	{
		case CollisionModel_Ray:
			CircleRayIntersection (pOther->GetPosition (), otherPosition, newPosition, GetCollisionRadius ());
			break;
		case CollisionModel_Circle:
			dbg::unimplemented (DBG_HERE);
			break;
		default:
			break;
	}
}
//==============================================================================
*/
//==============================================================================
// EOF
//==============================================================================
