//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cDisplayManager.cpp
// Project: Shooting Star
// Author:
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cDisplayManager.hpp"
#include <stdlib.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//==============================================================================
//! Constructor
//------------------------------------------------------------------------------
cDisplayManager::cDisplayManager (void)
{
};
//==============================================================================

//==============================================================================
//! Destructor
//------------------------------------------------------------------------------
cDisplayManager::~cDisplayManager (void)
{
};
//==============================================================================

//==============================================================================
//! Return singleton
//------------------------------------------------------------------------------
cDisplayManager &
cDisplayManager::GetInstance (void)
{
	static cDisplayManager singleton ;
	return singleton;
}
//==============================================================================


//==============================================================================
//! Set videomode
//------------------------------------------------------------------------------
void cDisplayManager::SetVideoMode( int width, int height, int bpp, Uint32 flags ){

	dbgInfo () << "Trying to set " << width << 'x' << height << 'x' << bpp << " video mode\n";
	mpScreen = SDL_SetVideoMode( width, height, bpp, flags );
	if ( mpScreen == NULL )
	{
		dbgError () << "Unable to set video mode: " << SDL_GetError () << endl;
		throw runtime_error ("Initialization failed");
	}
	dbgInfo () << "Got " << mpScreen->w << 'x' << mpScreen->h << 'x' << (int) mpScreen->format->BitsPerPixel << " video mode\n";

}
//==============================================================================
//==============================================================================
//! Set viewport
//------------------------------------------------------------------------------
void cDisplayManager::SetViewport(  GLint x, GLint y, GLsizei width, GLsizei height ){

	glViewport (x, y, width, height );

}
//==============================================================================
//==============================================================================
//! Set gluortho 
//------------------------------------------------------------------------------
void cDisplayManager::SetOrtho( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top ) {

	gluOrtho2D (left, right, bottom , top);

}
//==============================================================================
//==============================================================================
void
cDisplayManager::BeginFrame (bool clear)
{
	if ( clear )
	{
		// Clear screen and depth buffer
		glClear (GL_COLOR_BUFFER_BIT);
	}

	// Select and reset the modelview matrix
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity();
}
//==============================================================================

//==============================================================================
void
cDisplayManager::EndFrame (void)
{
	// Flip
	SDL_GL_SwapBuffers ();
}
//==============================================================================

//==============================================================================
Uint16
cDisplayManager::GetViewportWidth (void)
{
	GLint viewport[4];
	glGetIntegerv( GL_VIEWPORT, viewport );
	return viewport[2];
}
//==============================================================================
//==============================================================================
Uint16
cDisplayManager::GetViewportHeight (void)
{
	GLint viewport[4];
	glGetIntegerv( GL_VIEWPORT, viewport );
	return viewport[3];
}
//==============================================================================
//==============================================================================
Uint16
cDisplayManager::GetOrthoWidth (void)   // dunno how to get ortho's size so get screen size =)
{
	return mpScreen->w;
}
//==============================================================================
//==============================================================================
Uint16
cDisplayManager::GetOrthoHeight (void)
{
	return mpScreen->h;
}
//==============================================================================


//==============================================================================
// EOF
//==============================================================================
