/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#ifdef PACKAGE_NAME
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE_NAME
#else
#define CMDLINE_PARSER_PACKAGE_NAME PACKAGE
#endif
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

enum enum_action { action__NULL = -1, action_arg_register = 0, action_arg_authenticate };

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * origin_arg;	/**< @brief Origin URL to use..  */
  char * origin_orig;	/**< @brief Origin URL to use. original value given at command line.  */
  const char *origin_help; /**< @brief Origin URL to use. help description.  */
  char * appid_arg;	/**< @brief Application ID to use..  */
  char * appid_orig;	/**< @brief Application ID to use. original value given at command line.  */
  const char *appid_help; /**< @brief Application ID to use. help description.  */
  char * challenge_arg;	/**< @brief Challenge (Base64-URL encoded) string to use..  */
  char * challenge_orig;	/**< @brief Challenge (Base64-URL encoded) string to use. original value given at command line.  */
  const char *challenge_help; /**< @brief Challenge (Base64-URL encoded) string to use. help description.  */
  enum enum_action action_arg;	/**< @brief Action to take..  */
  char * action_orig;	/**< @brief Action to take. original value given at command line.  */
  const char *action_help; /**< @brief Action to take. help description.  */
  char * key_handle_arg;	/**< @brief A file containing a key-handle.  */
  char * key_handle_orig;	/**< @brief A file containing a key-handle original value given at command line.  */
  const char *key_handle_help; /**< @brief A file containing a key-handle help description.  */
  char * user_key_arg;	/**< @brief A file containing the public user-key.  */
  char * user_key_orig;	/**< @brief A file containing the public user-key original value given at command line.  */
  const char *user_key_help; /**< @brief A file containing the public user-key help description.  */
  int debug_flag;	/**< @brief Print debug information to standard error (default=off).  */
  const char *debug_help; /**< @brief Print debug information to standard error help description.  */
  char * x509cert_arg;	/**< @brief A file to write the registration attestation certificate to.  */
  char * x509cert_orig;	/**< @brief A file to write the registration attestation certificate to original value given at command line.  */
  const char *x509cert_help; /**< @brief A file to write the registration attestation certificate to help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int origin_given ;	/**< @brief Whether origin was given.  */
  unsigned int appid_given ;	/**< @brief Whether appid was given.  */
  unsigned int challenge_given ;	/**< @brief Whether challenge was given.  */
  unsigned int action_given ;	/**< @brief Whether action was given.  */
  unsigned int key_handle_given ;	/**< @brief Whether key-handle was given.  */
  unsigned int user_key_given ;	/**< @brief Whether user-key was given.  */
  unsigned int debug_given ;	/**< @brief Whether debug was given.  */
  unsigned int x509cert_given ;	/**< @brief Whether x509cert was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_action_values[];  /**< @brief Possible values for action. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
