/***************************************************************************
                          route.c  -  for routing protos
                             -------------------
    begin                : Tue Apr 2 2002
    copyright            : (C) 2002 by Josiah Zayner
    email                : phric@legions.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _WAND_H
#include "wand.h"
#endif


#ifdef _CON_

int get_igmp_arg(char *arg, char *next_arg, struct igmp *eyeg)
{
  switch((int)arg[2])
  {
    case 't':

    if(next_arg)
    {
      if(strstr(next_arg, "MR"))
      { eyeg->type = IGMP_MRESP; }
      if(strstr(next_arg, "MT"))
      { eyeg->type = IGMP_MTRACE; }
      else if(strstr(next_arg, "M"))
      { eyeg->type = IGMP_MEM_QUERY; }
      else if(strstr(next_arg, "R1"))
      { eyeg->type = IGMP_V1_MEM_REP; }
      else if(strstr(next_arg, "R2"))
      { eyeg->type = IGMP_V2_MEM_REP; }
      else if(strstr(next_arg, "R3"))
      { eyeg->type = IGMP_V3_MEM_REP; }
      else if(strstr(next_arg, "L"))
      { eyeg->type = IGMP_V2_LEAVE_GROUP; }
      else if(strstr(next_arg, "P"))
      { eyeg->type = IGMP_V1_PIM; }
      else if(strstr(next_arg, "D"))
      { eyeg->type = IGMP_DVMRP; }
      else{ eyeg->type = atoi(next_arg); }
    }

    break;

    case 'n':
    if(next_arg)
    {
      if(strstr("i", next_arg)){  }
      if(strstr("r", next_arg)){ }
    }
    else {  }

    break;

    case 'm': /* max resp. time */
    if(next_arg){ eyeg->multi.mrt = atoi(next_arg); }
    break;

    case 'c': /* sub code */
    if(next_arg){ eyeg->multi.code = atoi(next_arg); }
    break;

    case 'a': /* group address */
    if(next_arg)
    {
      if(inet_aton(next_arg, &eyeg->group) == 0)
      {
        fprintf(stderr,"IGMP group address invalid!");
        exit(-1);
      }
    }
    break;

    default:
    fprintf(stderr, "Bad Option: %s, see usage -h\n", arg);
    exit(-1);
    break;
  }

   return 0;
}


/* for RIP arguments */
int get_rip_arg(char *arg,
                char *next_arg,
                struct rip *rip,
                struct rip_ent rip_e[25]
               )
{

  static u_short entry = 0;

  if(arg[4] > 1)
  {
    entry = (atoi(&arg[4]) - 1);
  }


  switch((int)arg[3])
  {

    /* RIP commands */
    case 'c':
     if(next_arg)
     {
       if(strstr(next_arg, "RQ"))
       { rip->comm = 0x01; }
       else if(strstr(next_arg, "RS"))
       { rip->comm = 0x02; }
       else if(strstr(next_arg, "TN"))
       { rip->comm = 0x03; }
       else if(strstr(next_arg, "TF"))
       { rip->comm = 0x04; }
       else if(strstr(next_arg, "SR"))
       { rip->comm = 0x05; }
       else if(strstr(next_arg, "TQ"))
       { rip->comm = 0x06; }
       else if(strstr(next_arg, "TS"))
       { rip->comm = 0x07; }
       else if(strstr(next_arg, "TA"))
       { rip->comm = 0x08; }
       else if(strstr(next_arg, "UQ"))
       { rip->comm = 0x09; }
       else if(strstr(next_arg, "US"))
       { rip->comm = 0x0a; }
       else if(strstr(next_arg, "UA"))
       { rip->comm = 0x0b; }
     }
    break;

    case 'v':
     if(next_arg)
     {
       if(strchr(next_arg, '1'))
         rip->vers = 0x01;
       else if(strchr(next_arg, '2'))
         rip->vers = 0x02;
       else
       {
         fprintf(stderr,"Bad option so we will choose RIP version 2\n");
         rip->vers = 0x02;
       }

     }
    break;

    /*
       this is all for RIP Entries we specify the address
       family for them but only if they choose a, n or h
    */

    case 'a':
    rip_e[entry].addr_fam = 0x0200;
    if(next_arg)
    {
      rip_e[entry].addr = wherefromto(next_arg);
    }
    else
    {
      fprintf(stderr, "No RIP Entry address specified using 127.0.0.1\n");
      rip_e[entry].addr = wherefromto("127.0.0.1");
    }
    break;

    case 'n':
    rip_e[entry].addr_fam = 0x0200;
    if(next_arg)
    {
      rip_e[entry].mask = wherefromto(next_arg);
    }
    else
    {
      fprintf(stderr, "No RIP Entry netmask specified using 255.255.255.0\n");
      rip_e[entry].mask = wherefromto("255.255.255.0");
    }
    break;

    case 'h':
    rip_e[entry].addr_fam = 0x0200;
    if(next_arg)
    {
      rip_e[entry].nhop = wherefromto(next_arg);
    }
    else
    {
      fprintf(stderr, "No RIP Entry next hop specified using 127.0.0.1\n");
      rip_e[entry].nhop = wherefromto("127.0.0.1");
    }
    entry++;
    break;

    case 'm':
    if(next_arg)
    {
      rip_e[entry].metric = atoi(next_arg);

    }
    break;

    case 'r':
    if(next_arg)
    {
      rip_e[entry].route_tag = atoi(next_arg);
    }
    break;

    case 'e':
    rip->comm = 0x02;
    rip_e[entry].addr_fam = 0x0200;
    rip_e[entry].nhop = wherefromto("192.168.0.1");
    rip_e[entry].metric = 0x10;
    rip_e[entry].route_tag = 1;
    rip_e[entry].addr = wherefromto("127.0.0.1");
    rip_e[entry].mask = wherefromto("255.255.255.0");
    break;

  } /* end RIP switch */
  return 0;
}

int get_ospf_arg(char *arg, char *next_arg, struct ospf *oh)
{
   switch((int)arg[2])
   {
     case 'v': /* version */
     oh->vers = atoi(next_arg);
     break;

     case 't': /* type */
     if(next_arg) {
      toupper((int)&next_arg);
     if(strstr("H", next_arg)) {
      oh->type = 0x01;
     }
     else if(strstr("D",	next_arg)) {
      oh->type = 0x02;
     }
     else if(strstr("R", next_arg)) {
      oh->type = 0x03;
     }
     else if(strstr("U", next_arg)) {
      oh->type = 0x04;
     }
     else if(strstr("A", next_arg)) {
      oh->type = 0x05;
     }
      else {
        oh->type = atoi(next_arg);
      }
   }

     break;

     case 'l': /* length */

     break;

     case 'r': /* router id */
     oh->router_id = 0;
     break;

     case 'e': /* area id */
     oh->area_id = 0;
     break;

     case 'a': /* auth type */
     if(strstr(next_arg, "N")) { oh->auth_type = 0; }
     else if(strstr(next_arg, "P")) { oh->auth_type = 0x0001; }
     else if(strstr(next_arg, "C")) { oh->auth_type = 0x0002; }


     break;

     case 'u': /* auth data */
     if(next_arg) {
     memcpy(oh->auth, next_arg, sizeof(next_arg));
     }
     break;
  }



  return 0;
}
#endif /* _CON_ */
