# Hugepages Input Plugin

Transparent Huge Pages (THP) is a Linux memory management system that reduces
the overhead of Translation Lookaside Buffer (TLB) lookups on machines with
large amounts of memory by using larger memory pages.

Consult [the website][website] for more details.

[website]: https://www.kernel.org/doc/html/latest/admin-guide/mm/hugetlbpage.html

## Global configuration options <!-- @/docs/includes/plugin_config.md -->

In addition to the plugin-specific configuration settings, plugins support
additional global and plugin configuration settings. These settings are used to
modify metrics, tags, and field or create aliases and configure ordering, etc.
See the [CONFIGURATION.md][CONFIGURATION.md] for more details.

[CONFIGURATION.md]: ../../../docs/CONFIGURATION.md#plugins

## Configuration

```toml @sample.conf
# Gathers huge pages measurements.
# This plugin ONLY supports Linux
[[inputs.hugepages]]
  ## Supported huge page types:
  ##   - "root"     - based on root huge page control directory:
  ##                  /sys/kernel/mm/hugepages
  ##   - "per_node" - based on per NUMA node directories:
  ##                  /sys/devices/system/node/node[0-9]*/hugepages
  ##   - "meminfo"  - based on /proc/meminfo file
  # types = ["root", "per_node"]
```

## Metrics

### Measurements

**The following measurements are supported by Hugepages plugin:**

- hugepages_root (gathered from `/sys/kernel/mm/hugepages`)
  - tags:
    - size_kb (integer, kB)
  - fields:
    - free (integer)
    - mempolicy (integer)
    - overcommit (integer)
    - reserved (integer)
    - surplus (integer)
    - total (integer)
- hugepages_per_node (gathered from `/sys/devices/system/node/node[0-9]*/hugepages`)
  - tags:
    - size_kb (integer, kB)
    - node (integer)
  - fields:
    - free (integer)
    - surplus (integer)
    - total (integer)
- hugepages_meminfo (gathered from `/proc/meminfo` file)
  - The fields `total`, `free`, `reserved`, and `surplus` are counts of pages
    of default size. Fields with suffix `_kb` are in kilobytes.
  - fields:
    - anonymous_kb (integer, kB)
    - file_kb (integer, kB)
    - free (integer)
    - reserved (integer)
    - shared_kb (integer, kB)
    - size_kb (integer, kB)
    - surplus (integer)
    - tlb_kb (integer, kB)
    - total (integer)

## Example Output

```text
hugepages_root,host=ubuntu,size_kb=1048576 free=0i,mempolicy=8i,overcommit=0i,reserved=0i,surplus=0i,total=8i 1646258020000000000
hugepages_root,host=ubuntu,size_kb=2048 free=883i,mempolicy=2048i,overcommit=0i,reserved=0i,surplus=0i,total=2048i 1646258020000000000
hugepages_per_node,host=ubuntu,size_kb=1048576,node=0 free=0i,surplus=0i,total=4i 1646258020000000000
hugepages_per_node,host=ubuntu,size_kb=2048,node=0 free=434i,surplus=0i,total=1024i 1646258020000000000
hugepages_per_node,host=ubuntu,size_kb=1048576,node=1 free=0i,surplus=0i,total=4i 1646258020000000000
hugepages_per_node,host=ubuntu,size_kb=2048,node=1 free=449i,surplus=0i,total=1024i 1646258020000000000
hugepages_meminfo,host=ubuntu anonymous_kb=0i,file_kb=0i,free=883i,reserved=0i,shared_kb=0i,size_kb=2048i,surplus=0i,tlb_kb=12582912i,total=2048i 1646258020000000000
```
