#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>

/* Length table for lengths 3 to 258, generated by mklen.sh
 * The entries contain :
 *   code - 257 = 0..28 in bits 0..4
 *   bits       = 0..5  in bits 5..7
 *   value      = 0..31 in bits 8..12
 */
static const uint16_t len_code[259] = {
	0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0002, 0x0003, 0x0004, //   0
	0x0005, 0x0006, 0x0007, 0x0028, 0x0128, 0x0029, 0x0129, 0x002a, //   8
	0x012a, 0x002b, 0x012b, 0x004c, 0x014c, 0x024c, 0x034c, 0x004d, //  16
	0x014d, 0x024d, 0x034d, 0x004e, 0x014e, 0x024e, 0x034e, 0x004f, //  24
	0x014f, 0x024f, 0x034f, 0x0070, 0x0170, 0x0270, 0x0370, 0x0470, //  32
	0x0570, 0x0670, 0x0770, 0x0071, 0x0171, 0x0271, 0x0371, 0x0471, //  40
	0x0571, 0x0671, 0x0771, 0x0072, 0x0172, 0x0272, 0x0372, 0x0472, //  48
	0x0572, 0x0672, 0x0772, 0x0073, 0x0173, 0x0273, 0x0373, 0x0473, //  56
	0x0573, 0x0673, 0x0773, 0x0094, 0x0194, 0x0294, 0x0394, 0x0494, //  64
	0x0594, 0x0694, 0x0794, 0x0894, 0x0994, 0x0a94, 0x0b94, 0x0c94, //  72
	0x0d94, 0x0e94, 0x0f94, 0x0095, 0x0195, 0x0295, 0x0395, 0x0495, //  80
	0x0595, 0x0695, 0x0795, 0x0895, 0x0995, 0x0a95, 0x0b95, 0x0c95, //  88
	0x0d95, 0x0e95, 0x0f95, 0x0096, 0x0196, 0x0296, 0x0396, 0x0496, //  96
	0x0596, 0x0696, 0x0796, 0x0896, 0x0996, 0x0a96, 0x0b96, 0x0c96, // 104
	0x0d96, 0x0e96, 0x0f96, 0x0097, 0x0197, 0x0297, 0x0397, 0x0497, // 112
	0x0597, 0x0697, 0x0797, 0x0897, 0x0997, 0x0a97, 0x0b97, 0x0c97, // 120
	0x0d97, 0x0e97, 0x0f97, 0x00b8, 0x01b8, 0x02b8, 0x03b8, 0x04b8, // 128
	0x05b8, 0x06b8, 0x07b8, 0x08b8, 0x09b8, 0x0ab8, 0x0bb8, 0x0cb8, // 136
	0x0db8, 0x0eb8, 0x0fb8, 0x10b8, 0x11b8, 0x12b8, 0x13b8, 0x14b8, // 144
	0x15b8, 0x16b8, 0x17b8, 0x18b8, 0x19b8, 0x1ab8, 0x1bb8, 0x1cb8, // 152
	0x1db8, 0x1eb8, 0x1fb8, 0x00b9, 0x01b9, 0x02b9, 0x03b9, 0x04b9, // 160
	0x05b9, 0x06b9, 0x07b9, 0x08b9, 0x09b9, 0x0ab9, 0x0bb9, 0x0cb9, // 168
	0x0db9, 0x0eb9, 0x0fb9, 0x10b9, 0x11b9, 0x12b9, 0x13b9, 0x14b9, // 176
	0x15b9, 0x16b9, 0x17b9, 0x18b9, 0x19b9, 0x1ab9, 0x1bb9, 0x1cb9, // 184
	0x1db9, 0x1eb9, 0x1fb9, 0x00ba, 0x01ba, 0x02ba, 0x03ba, 0x04ba, // 192
	0x05ba, 0x06ba, 0x07ba, 0x08ba, 0x09ba, 0x0aba, 0x0bba, 0x0cba, // 200
	0x0dba, 0x0eba, 0x0fba, 0x10ba, 0x11ba, 0x12ba, 0x13ba, 0x14ba, // 208
	0x15ba, 0x16ba, 0x17ba, 0x18ba, 0x19ba, 0x1aba, 0x1bba, 0x1cba, // 216
	0x1dba, 0x1eba, 0x1fba, 0x00bb, 0x01bb, 0x02bb, 0x03bb, 0x04bb, // 224
	0x05bb, 0x06bb, 0x07bb, 0x08bb, 0x09bb, 0x0abb, 0x0bbb, 0x0cbb, // 232
	0x0dbb, 0x0ebb, 0x0fbb, 0x10bb, 0x11bb, 0x12bb, 0x13bb, 0x14bb, // 240
	0x15bb, 0x16bb, 0x17bb, 0x18bb, 0x19bb, 0x1abb, 0x1bbb, 0x1cbb, // 248
	0x1dbb, 0x1ebb, 0x001c					        // 256
};

static const uint16_t fixed_huff[288] = {
	0x00c8, 0x08c8, 0x04c8, 0x0cc8, 0x02c8, 0x0ac8, 0x06c8, 0x0ec8, //   0
	0x01c8, 0x09c8, 0x05c8, 0x0dc8, 0x03c8, 0x0bc8, 0x07c8, 0x0fc8, //   8
	0x0028, 0x0828, 0x0428, 0x0c28, 0x0228, 0x0a28, 0x0628, 0x0e28, //  16
	0x0128, 0x0928, 0x0528, 0x0d28, 0x0328, 0x0b28, 0x0728, 0x0f28, //  24
	0x00a8, 0x08a8, 0x04a8, 0x0ca8, 0x02a8, 0x0aa8, 0x06a8, 0x0ea8, //  32
	0x01a8, 0x09a8, 0x05a8, 0x0da8, 0x03a8, 0x0ba8, 0x07a8, 0x0fa8, //  40
	0x0068, 0x0868, 0x0468, 0x0c68, 0x0268, 0x0a68, 0x0668, 0x0e68, //  48
	0x0168, 0x0968, 0x0568, 0x0d68, 0x0368, 0x0b68, 0x0768, 0x0f68, //  56
	0x00e8, 0x08e8, 0x04e8, 0x0ce8, 0x02e8, 0x0ae8, 0x06e8, 0x0ee8, //  64
	0x01e8, 0x09e8, 0x05e8, 0x0de8, 0x03e8, 0x0be8, 0x07e8, 0x0fe8, //  72
	0x0018, 0x0818, 0x0418, 0x0c18, 0x0218, 0x0a18, 0x0618, 0x0e18, //  80
	0x0118, 0x0918, 0x0518, 0x0d18, 0x0318, 0x0b18, 0x0718, 0x0f18, //  88
	0x0098, 0x0898, 0x0498, 0x0c98, 0x0298, 0x0a98, 0x0698, 0x0e98, //  96
	0x0198, 0x0998, 0x0598, 0x0d98, 0x0398, 0x0b98, 0x0798, 0x0f98, // 104
	0x0058, 0x0858, 0x0458, 0x0c58, 0x0258, 0x0a58, 0x0658, 0x0e58, // 112
	0x0158, 0x0958, 0x0558, 0x0d58, 0x0358, 0x0b58, 0x0758, 0x0f58, // 120
	0x00d8, 0x08d8, 0x04d8, 0x0cd8, 0x02d8, 0x0ad8, 0x06d8, 0x0ed8, // 128
	0x01d8, 0x09d8, 0x05d8, 0x0dd8, 0x03d8, 0x0bd8, 0x07d8, 0x0fd8, // 136
	0x0139, 0x1139, 0x0939, 0x1939, 0x0539, 0x1539, 0x0d39, 0x1d39, // 144
	0x0339, 0x1339, 0x0b39, 0x1b39, 0x0739, 0x1739, 0x0f39, 0x1f39, // 152
	0x00b9, 0x10b9, 0x08b9, 0x18b9, 0x04b9, 0x14b9, 0x0cb9, 0x1cb9, // 160
	0x02b9, 0x12b9, 0x0ab9, 0x1ab9, 0x06b9, 0x16b9, 0x0eb9, 0x1eb9, // 168
	0x01b9, 0x11b9, 0x09b9, 0x19b9, 0x05b9, 0x15b9, 0x0db9, 0x1db9, // 176
	0x03b9, 0x13b9, 0x0bb9, 0x1bb9, 0x07b9, 0x17b9, 0x0fb9, 0x1fb9, // 184
	0x0079, 0x1079, 0x0879, 0x1879, 0x0479, 0x1479, 0x0c79, 0x1c79, // 192
	0x0279, 0x1279, 0x0a79, 0x1a79, 0x0679, 0x1679, 0x0e79, 0x1e79, // 200
	0x0179, 0x1179, 0x0979, 0x1979, 0x0579, 0x1579, 0x0d79, 0x1d79, // 208
	0x0379, 0x1379, 0x0b79, 0x1b79, 0x0779, 0x1779, 0x0f79, 0x1f79, // 216
	0x00f9, 0x10f9, 0x08f9, 0x18f9, 0x04f9, 0x14f9, 0x0cf9, 0x1cf9, // 224
	0x02f9, 0x12f9, 0x0af9, 0x1af9, 0x06f9, 0x16f9, 0x0ef9, 0x1ef9, // 232
	0x01f9, 0x11f9, 0x09f9, 0x19f9, 0x05f9, 0x15f9, 0x0df9, 0x1df9, // 240
	0x03f9, 0x13f9, 0x0bf9, 0x1bf9, 0x07f9, 0x17f9, 0x0ff9, 0x1ff9, // 248
	0x0007, 0x0407, 0x0207, 0x0607, 0x0107, 0x0507, 0x0307, 0x0707, // 256
	0x0087, 0x0487, 0x0287, 0x0687, 0x0187, 0x0587, 0x0387, 0x0787, // 264
	0x0047, 0x0447, 0x0247, 0x0647, 0x0147, 0x0547, 0x0347, 0x0747, // 272
	0x0038, 0x0838, 0x0438, 0x0c38, 0x0238, 0x0a38, 0x0638, 0x0e38  // 280
};

void main()
{
	int mlen;
	int word;
	int code;
	int bits1;
	int bits2;

	for (mlen = 0; mlen <= 258; mlen++) {
		word = len_code[mlen];
		code = (word & 31) + 257;
		if (mlen >= 3)
			code = fixed_huff[code];
		else
			code = 0;

		bits1 = code & 15;
		code >>= 4;
		word >>= 5; bits2 = word & 7;

		if (bits2) {
			code |= (word >> 3) << bits1;
			bits1 += bits2;
		}

		printf(" 0x%06x, ", code + (bits1 << 16));
		if ((mlen & 3) == 3 || mlen == 258)
			printf("  /* %d-%d */\n", mlen - 3, mlen);
	}
	exit(0);
}
