/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.HemisphericalProjection;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class ObliqueMercator
extends HemisphericalProjection {
    public static final String WKT_NAME = "Oblique_Mercator";
    public static final String ALTERNATE_WKT_NAME = "hotine_oblique_mercator";
    public static final String CENTER_LON_PROPERTY = "longitude_of_center";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_center";
    public static final String SCALE_FACTOR_PROPERTY = "scale_factor";
    public static final String AZIMUTH_PROPERTY = "azimuth";
    private double _k0;
    private double _alpha;
    private double _e;
    private double _lambdaZ;
    private double _sinAlpha;
    private double _cosAlpha;
    private double _sinGamma0;
    private double _cosGamma0;
    private double _B;
    private double _A;
    private double _E;
    private double[] _subPhi;
    private Coordinate _hemisphereCenter;

    public ObliqueMercator(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double k0, double centralLineAzimuth) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._k0 = k0;
        this._alpha = centralLineAzimuth;
        this._subPhi = new double[4];
        this.computeParameters();
    }

    public ObliqueMercator(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._k0 = parameters.getDimensionlessParameter(SCALE_FACTOR_PROPERTY);
        this._alpha = parameters.getAngularParameter(AZIMUTH_PROPERTY);
        this._subPhi = new double[4];
        this.computeParameters();
    }

    public double getCenterScaleFactor() {
        return this._k0;
    }

    public void setCenterScaleFactor(double newScale) {
        if (newScale != this._k0) {
            this._k0 = newScale;
            this.computeParameters();
        }
    }

    public double getCentralLineAzimuth() {
        return this._alpha;
    }

    public void setCentralLineAzimuth(double newAzimuth) {
        if (newAzimuth != this._alpha) {
            this._alpha = newAzimuth;
            this.computeParameters();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ObliqueMercator proj = (ObliqueMercator)obj;
            return StrictMath.abs(proj._k0 - this._k0) < 1.567855942887398E-7 && StrictMath.abs(proj._alpha - this._alpha) < 1.567855942887398E-7;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)super.hashCode() * Math.round(this._k0 / 1.567855942887398E-7) * Math.round(this._alpha / 1.567855942887398E-7) % Integer.MAX_VALUE);
    }

    private double getT(double phi) {
        double eSinPhi = this._e * StrictMath.sin(phi);
        return StrictMath.tan(0.7853981633974483 - phi / 2.0) / StrictMath.pow((1.0 - eSinPhi) / (1.0 + eSinPhi), this._e / 2.0);
    }

    @Override
    protected Coordinate getHemisphereCenter() {
        return this._hemisphereCenter;
    }

    @Override
    protected double getMaxC() {
        return 1.5707963267948966;
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        double t = this.getT(phi);
        double Q = this._E / StrictMath.pow(t, this._B);
        double S = (Q - 1.0 / Q) / 2.0;
        double T = (Q + 1.0 / Q) / 2.0;
        double V = StrictMath.sin(this._B * GeometryUtils.wrap_longitude(lambda - this._lambdaZ));
        double U = (-V * this._cosGamma0 + S * this._sinGamma0) / T;
        double v = this._A * StrictMath.log((1.0 - U) / (1.0 + U)) / (2.0 * this._B);
        double u = this._A / this._B * StrictMath.atan2(S * this._cosGamma0 + V * this._sinGamma0, StrictMath.cos(this._B * GeometryUtils.wrap_longitude(lambda - this._lambdaZ)));
        storage.x = v * this._cosAlpha + u * this._sinAlpha;
        storage.y = u * this._cosAlpha - v * this._sinAlpha;
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double vp = x * this._cosAlpha - y * this._sinAlpha;
        double up = y * this._cosAlpha + x * this._sinAlpha;
        double Qp = StrictMath.pow(Math.E, -(this._B * vp / this._A));
        double Sp = (Qp - 1.0 / Qp) / 2.0;
        double Tp = (Qp + 1.0 / Qp) / 2.0;
        double Vp = StrictMath.sin(this._B * up / this._A);
        double Up = (Vp * this._cosGamma0 + Sp * this._sinGamma0) / Tp;
        if (StrictMath.abs(Up) == 1.0) {
            storage.y = 1.5707963267948966 * (double)GeometryUtils.sign(Up);
        } else {
            double t = StrictMath.pow(this._E / StrictMath.sqrt((1.0 + Up) / (1.0 - Up)), 1.0 / this._B);
            double chi = 1.5707963267948966 - 2.0 * StrictMath.atan(t);
            storage.y = chi + this._subPhi[0] * StrictMath.sin(2.0 * chi) + this._subPhi[1] * StrictMath.sin(4.0 * chi) + this._subPhi[2] * StrictMath.sin(6.0 * chi) + this._subPhi[3] * StrictMath.sin(8.0 * chi);
        }
        storage.x = this._lambdaZ - StrictMath.atan2(Sp * this._cosGamma0 - Vp * this._sinGamma0, StrictMath.cos(this._B * up / this._A)) / this._B;
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        double sinPhi0 = StrictMath.sin(this._phi0);
        double cosPhi0 = StrictMath.cos(this._phi0);
        this._B = StrictMath.sqrt(1.0 + this._e2 * cosPhi0 * cosPhi0 * cosPhi0 * cosPhi0 / (1.0 - this._e2));
        this._A = this._a * this._B * this._k0 * StrictMath.sqrt(1.0 - this._e2) / (1.0 - this._e2 * sinPhi0 * sinPhi0);
        double t0 = this.getT(this._phi0);
        double D = this._B * StrictMath.sqrt(1.0 - this._e2) / (cosPhi0 * StrictMath.sqrt(1.0 - this._e2 * sinPhi0 * sinPhi0));
        double Dsq = D * D;
        if (Dsq < 1.0) {
            Dsq = 1.0;
        }
        double F = D + StrictMath.sqrt(Dsq - 1.0) * (double)GeometryUtils.sign(this._phi0);
        this._E = F * StrictMath.pow(t0, this._B);
        double G = (F - 1.0 / F) / 2.0;
        this._sinAlpha = StrictMath.sin(this._alpha);
        this._cosAlpha = StrictMath.cos(this._alpha);
        double gamma0 = StrictMath.asin(this._sinAlpha / D);
        this._sinGamma0 = StrictMath.sin(gamma0);
        this._cosGamma0 = StrictMath.cos(gamma0);
        this._lambdaZ = GeometryUtils.wrap_longitude(this._lambda0 - StrictMath.asin(G * StrictMath.tan(gamma0)) / this._B);
        this._subPhi[0] = this._e2 / 2.0 + 5.0 * this._e2 * this._e2 / 24.0 + this._e2 * this._e2 * this._e2 / 12.0 + 13.0 * this._e2 * this._e2 * this._e2 * this._e2 / 360.0;
        this._subPhi[1] = 7.0 * this._e2 * this._e2 / 48.0 + 29.0 * this._e2 * this._e2 * this._e2 / 240.0 + 811.0 * this._e2 * this._e2 * this._e2 * this._e2 / 11520.0;
        this._subPhi[2] = 7.0 * this._e2 * this._e2 * this._e2 / 120.0 + 81.0 * this._e2 * this._e2 * this._e2 * this._e2 / 1120.0;
        this._subPhi[3] = 4279.0 * this._e2 * this._e2 * this._e2 * this._e2 / 161280.0;
        this._hemisphereCenter = new Coordinate(this._phi0, this._lambda0);
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        result.addDimensionlessParameter(SCALE_FACTOR_PROPERTY, this._k0);
        result.addAngularParameter(AZIMUTH_PROPERTY, this._alpha, (Unit<Angle>)SI.RADIAN);
        return result;
    }

    @Override
    public Object clone() {
        ObliqueMercator clone = (ObliqueMercator)super.clone();
        clone._subPhi = (double[])this._subPhi.clone();
        return clone;
    }
}

