/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderUTF8
extends Reader {
    private InputStream is;

    public ReaderUTF8(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        block5: for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.is.read();
            if (n4 < 0) {
                return n3 != 0 ? n3 : -1;
            }
            switch (n4 & 0xF0) {
                case 192: 
                case 208: {
                    cArray[n++] = (char)((n4 & 0x1F) << 6 | this.is.read() & 0x3F);
                    continue block5;
                }
                case 224: {
                    cArray[n++] = (char)((n4 & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F);
                    continue block5;
                }
                case 240: {
                    throw new UnsupportedEncodingException("UTF-32 (or UCS-4) encoding not supported.");
                }
                default: {
                    cArray[n++] = (char)n4;
                }
            }
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        int n = this.is.read();
        if (n < 0) {
            return -1;
        }
        switch (n & 0xF0) {
            case 192: 
            case 208: {
                n = (n & 0x1F) << 6 | this.is.read() & 0x3F;
                break;
            }
            case 224: {
                n = (n & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F;
                break;
            }
            case 240: {
                throw new UnsupportedEncodingException();
            }
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

