/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.text.DecimalFormat;
import org.nlogo.api.SimpleJobOwner;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.nvm.Procedure;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Predef$;
import scala.Serializable;
import scala.UninitializedFieldError;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcDD$sp;

public final class Benchmarker$ {
    public static Benchmarker$ MODULE$;
    private final double Z;
    private final double TOLERANCE;
    private final DecimalFormat formatter;
    private volatile byte bitmap$init$0;

    static {
        new Benchmarker$();
    }

    private double Z() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/workspace/Benchmarker.scala: 11");
        }
        return this.Z;
    }

    private double TOLERANCE() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/workspace/Benchmarker.scala: 12");
        }
        return this.TOLERANCE;
    }

    private DecimalFormat formatter() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/workspace/Benchmarker.scala: 13");
        }
        return this.formatter;
    }

    public void benchmark(AbstractWorkspace workspace, int minTime, int maxTime) {
        ListBuffer times = new ListBuffer();
        Procedure goProcedure = workspace.compileCommands("ca benchmark");
        Procedure resultProcedure = workspace.compileReporter("result");
        SimpleJobOwner owner = new SimpleJobOwner("Benchmarker", workspace.world().mainRNG(), AgentKind$Observer$.MODULE$);
        LongRef lastChatterTime = LongRef.create(0L);
        Benchmarker$.warmUp$1(workspace, minTime, owner, goProcedure, resultProcedure);
        while (!this.done$1(minTime, times, maxTime)) {
            times.$plus$eq(BoxesRunTime.boxToDouble(Benchmarker$.goOnce$1(workspace, owner, goProcedure, resultProcedure)));
            if (this.done$1(minTime, times, maxTime)) continue;
            this.chatter$1(lastChatterTime, times);
        }
        this.debrief$1(lastChatterTime, workspace, times);
    }

    private static final double goOnce$1(AbstractWorkspace workspace$1, SimpleJobOwner owner$1, Procedure goProcedure$1, Procedure resultProcedure$1) {
        workspace$1.runCompiledCommands(owner$1, goProcedure$1);
        double result = BoxesRunTime.unboxToDouble(workspace$1.runCompiledReporter(owner$1, resultProcedure$1));
        Predef$.MODULE$.assert(result > 0.0);
        return result;
    }

    private static final double average$1(ListBuffer times$1) {
        return Benchmarker$.total$1(times$1) / (double)times$1.size();
    }

    private static final double total$1(ListBuffer times$1) {
        return BoxesRunTime.unboxToDouble(times$1.sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    private static final double squareOfDifference$1(ListBuffer times$1) {
        return BoxesRunTime.unboxToDouble(((TraversableForwarder)times$1.map((JFunction1$mcDD$sp & Serializable)time -> package$.MODULE$.pow(time - Benchmarker$.average$1(times$1), 2.0), ListBuffer$.MODULE$.canBuildFrom())).sum(Numeric.DoubleIsFractional$.MODULE$));
    }

    private static final double stddev$1(ListBuffer times$1) {
        return package$.MODULE$.sqrt(Benchmarker$.squareOfDifference$1(times$1) / (double)times$1.size());
    }

    private final int runs$1(ListBuffer times$1) {
        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(2), (int)package$.MODULE$.ceil(package$.MODULE$.pow(this.Z() * Benchmarker$.stddev$1(times$1) / (this.TOLERANCE() * Benchmarker$.average$1(times$1)), 2.0)));
    }

    private static final void warmUp$1(AbstractWorkspace workspace$1, int minTime$1, SimpleJobOwner owner$1, Procedure goProcedure$1, Procedure resultProcedure$1) {
        Predef$.MODULE$.println(new StringBuilder(2).append("(").append(workspace$1.modelNameForDisplay()).append(")").toString());
        System.gc();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)(minTime$1 * 1000)) {
            Benchmarker$.goOnce$1(workspace$1, owner$1, goProcedure$1, resultProcedure$1);
        }
    }

    private final boolean done$1(int minTime$1, ListBuffer times$1, int maxTime$1) {
        return Benchmarker$.total$1(times$1) > (double)minTime$1 && (times$1.size() >= this.runs$1(times$1) || Benchmarker$.total$1(times$1) >= (double)maxTime$1);
    }

    private final void chatter$1(LongRef lastChatterTime$1, ListBuffer times$1) {
        if (System.currentTimeMillis() - lastChatterTime$1.elem > 10000L) {
            Predef$.MODULE$.println(new StringBuilder(18).append(times$1.size()).append("/").append(this.runs$1(times$1)).append(" (mean=").append(this.formatter().format(Benchmarker$.average$1(times$1))).append(", stddev=").append(this.formatter().format(Benchmarker$.stddev$1(times$1))).append(")").toString());
            lastChatterTime$1.elem = System.currentTimeMillis();
        }
    }

    private final void debrief$1(LongRef lastChatterTime$1, AbstractWorkspace workspace$1, ListBuffer times$1) {
        lastChatterTime$1.elem = 0L;
        this.chatter$1(lastChatterTime$1, times$1);
        Predef$.MODULE$.println(new StringBuilder(6).append("@@@ ").append(workspace$1.modelNameForDisplay()).append(": ").append(this.formatter().format(Benchmarker$.average$1(times$1))).append((Object)(times$1.size() < this.runs$1(times$1) ? " (hit time limit)" : "")).toString());
    }

    private Benchmarker$() {
        MODULE$ = this;
        this.Z = 2.3263;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.TOLERANCE = 0.003;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.formatter = new DecimalFormat("0.000");
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }
}

