/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledRequest;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;

public class TransportSetEnabledAction
extends HandledTransportAction<SetEnabledRequest, ActionResponse.Empty> {
    private final Settings settings;
    private final SecurityContext securityContext;
    private final NativeUsersStore usersStore;

    @Inject
    public TransportSetEnabledAction(Settings settings, TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext, NativeUsersStore usersStore) {
        super("cluster:admin/xpack/security/user/set_enabled", transportService, actionFilters, SetEnabledRequest::new);
        this.settings = settings;
        this.securityContext = securityContext;
        this.usersStore = usersStore;
    }

    protected void doExecute(Task task, SetEnabledRequest request, ActionListener<ActionResponse.Empty> listener) {
        String username = request.username();
        if (this.securityContext.getUser().principal().equals(request.username())) {
            listener.onFailure((Exception)new IllegalArgumentException("users may not update the enabled status of their own account"));
            return;
        }
        if (User.isInternalUsername((String)username)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
            return;
        }
        if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.settings)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is anonymous and cannot be modified using the api"));
            return;
        }
        this.usersStore.setEnabled(username, request.enabled(), request.getRefreshPolicy(), (ActionListener<Void>)listener.delegateFailure((l, v) -> l.onResponse((Object)ActionResponse.Empty.INSTANCE)));
    }
}

