/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.oidc;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectLogoutResponse;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationResponse;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.oidc.OpenIdConnectRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectAuthenticator;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectProviderConfiguration;
import org.elasticsearch.xpack.security.authc.oidc.OpenIdConnectToken;
import org.elasticsearch.xpack.security.authc.oidc.RelyingPartyConfiguration;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;

public class OpenIdConnectRealm
extends Realm
implements Releasable {
    public static final String CONTEXT_TOKEN_DATA = "_oidc_tokendata";
    private final OpenIdConnectProviderConfiguration opConfiguration;
    private final RelyingPartyConfiguration rpConfiguration;
    private final OpenIdConnectAuthenticator openIdConnectAuthenticator;
    private final ClaimParser principalAttribute;
    private final ClaimParser groupsAttribute;
    private final ClaimParser dnAttribute;
    private final ClaimParser nameAttribute;
    private final ClaimParser mailAttribute;
    private final Boolean populateUserMetadata;
    private final UserRoleMapper roleMapper;
    private DelegatedAuthorizationSupport delegatedRealms;

    public OpenIdConnectRealm(RealmConfig config, SSLService sslService, UserRoleMapper roleMapper, ResourceWatcherService watcherService) {
        super(config);
        this.roleMapper = roleMapper;
        this.rpConfiguration = this.buildRelyingPartyConfiguration(config);
        this.opConfiguration = this.buildOpenIdConnectProviderConfiguration(config);
        this.principalAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.PRINCIPAL_CLAIM, config, true);
        this.groupsAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.GROUPS_CLAIM, config, false);
        this.dnAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.DN_CLAIM, config, false);
        this.nameAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.NAME_CLAIM, config, false);
        this.mailAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.MAIL_CLAIM, config, false);
        this.populateUserMetadata = (Boolean)config.getSetting(OpenIdConnectRealmSettings.POPULATE_USER_METADATA);
        if (!TokenService.isTokenServiceEnabled(config.settings()).booleanValue()) {
            throw new IllegalStateException("OpenID Connect Realm requires that the token service be enabled (" + XPackSettings.TOKEN_SERVICE_ENABLED_SETTING.getKey() + ")");
        }
        this.openIdConnectAuthenticator = new OpenIdConnectAuthenticator(config, this.opConfiguration, this.rpConfiguration, sslService, watcherService);
    }

    OpenIdConnectRealm(RealmConfig config, OpenIdConnectAuthenticator authenticator, UserRoleMapper roleMapper) {
        super(config);
        this.roleMapper = roleMapper;
        this.rpConfiguration = this.buildRelyingPartyConfiguration(config);
        this.opConfiguration = this.buildOpenIdConnectProviderConfiguration(config);
        this.openIdConnectAuthenticator = authenticator;
        this.principalAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.PRINCIPAL_CLAIM, config, true);
        this.groupsAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.GROUPS_CLAIM, config, false);
        this.dnAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.DN_CLAIM, config, false);
        this.nameAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.NAME_CLAIM, config, false);
        this.mailAttribute = ClaimParser.forSetting(this.logger, OpenIdConnectRealmSettings.MAIL_CLAIM, config, false);
        this.populateUserMetadata = (Boolean)config.getSetting(OpenIdConnectRealmSettings.POPULATE_USER_METADATA);
    }

    public void initialize(Iterable<Realm> realms, XPackLicenseState licenseState) {
        if (this.delegatedRealms != null) {
            throw new IllegalStateException("Realm has already been initialized");
        }
        this.delegatedRealms = new DelegatedAuthorizationSupport(realms, this.config, licenseState);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof OpenIdConnectToken;
    }

    private boolean isTokenForRealm(OpenIdConnectToken oidcToken) {
        if (oidcToken.getAuthenticatingRealm() == null) {
            return true;
        }
        return oidcToken.getAuthenticatingRealm().equals(this.name());
    }

    public AuthenticationToken token(ThreadContext context) {
        return null;
    }

    public void authenticate(AuthenticationToken token, ActionListener<AuthenticationResult> listener) {
        if (token instanceof OpenIdConnectToken && this.isTokenForRealm((OpenIdConnectToken)token)) {
            OpenIdConnectToken oidcToken = (OpenIdConnectToken)token;
            this.openIdConnectAuthenticator.authenticate(oidcToken, (ActionListener<JWTClaimsSet>)ActionListener.wrap(jwtClaimsSet -> this.buildUserFromClaims((JWTClaimsSet)jwtClaimsSet, listener), e -> {
                this.logger.debug("Failed to consume the OpenIdConnectToken ", (Throwable)e);
                if (e instanceof ElasticsearchSecurityException) {
                    listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"Failed to authenticate user with OpenID Connect", (Exception)e));
                } else {
                    listener.onFailure(e);
                }
            }));
        } else {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        }
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }

    private void buildUserFromClaims(JWTClaimsSet claims, ActionListener<AuthenticationResult> authResultListener) {
        String principal = this.principalAttribute.getClaimValue(claims);
        if (Strings.isNullOrEmpty((String)principal)) {
            authResultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)(this.principalAttribute + "not found in " + claims.toJSONObject()), null));
            return;
        }
        HashMap<String, Object> tokenMetadata = new HashMap<String, Object>();
        tokenMetadata.put("id_token_hint", claims.getClaim("id_token_hint"));
        ActionListener wrappedAuthResultListener = ActionListener.wrap(auth -> {
            if (auth.isAuthenticated()) {
                HashMap<String, Map> metadata = new HashMap<String, Map>(auth.getMetadata());
                metadata.put(CONTEXT_TOKEN_DATA, tokenMetadata);
                auth = AuthenticationResult.success((User)auth.getUser(), metadata);
            }
            authResultListener.onResponse(auth);
        }, arg_0 -> authResultListener.onFailure(arg_0));
        if (this.delegatedRealms.hasDelegation()) {
            this.delegatedRealms.resolve(principal, (ActionListener<AuthenticationResult>)wrappedAuthResultListener);
            return;
        }
        Map<Object, Object> userMetadata = this.populateUserMetadata != false ? claims.getClaims().entrySet().stream().filter(entry -> OpenIdConnectRealm.isAllowedTypeForClaim(entry.getValue())).collect(Collectors.toMap(entry -> "oidc(" + (String)entry.getKey() + ")", Map.Entry::getValue)) : Collections.emptyMap();
        List<String> groups = this.groupsAttribute.getClaimValues(claims);
        String dn = this.dnAttribute.getClaimValue(claims);
        String mail = this.mailAttribute.getClaimValue(claims);
        String name = this.nameAttribute.getClaimValue(claims);
        UserRoleMapper.UserData userData = new UserRoleMapper.UserData(principal, dn, groups, userMetadata, this.config);
        this.roleMapper.resolveRoles(userData, ActionListener.wrap(roles -> {
            User user = new User(principal, roles.toArray(Strings.EMPTY_ARRAY), name, mail, userMetadata, true);
            wrappedAuthResultListener.onResponse((Object)AuthenticationResult.success((User)user));
        }, arg_0 -> ((ActionListener)wrappedAuthResultListener).onFailure(arg_0)));
    }

    private RelyingPartyConfiguration buildRelyingPartyConfiguration(RealmConfig config) {
        ResponseType responseType;
        URI postLogoutRedirectUri;
        URI redirectUri;
        String redirectUriString = OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_REDIRECT_URI);
        try {
            redirectUri = new URI(redirectUriString);
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URI:" + OpenIdConnectRealmSettings.RP_REDIRECT_URI.getKey(), (Throwable)e);
        }
        String postLogoutRedirectUriString = (String)config.getSetting(OpenIdConnectRealmSettings.RP_POST_LOGOUT_REDIRECT_URI);
        try {
            postLogoutRedirectUri = new URI(postLogoutRedirectUriString);
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URI:" + OpenIdConnectRealmSettings.RP_POST_LOGOUT_REDIRECT_URI.getKey(), (Throwable)e);
        }
        ClientID clientId = new ClientID(OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_CLIENT_ID));
        SecureString clientSecret = (SecureString)config.getSetting(OpenIdConnectRealmSettings.RP_CLIENT_SECRET);
        if (clientSecret.length() == 0) {
            throw new SettingsException("The configuration setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Setting.AffixSetting)OpenIdConnectRealmSettings.RP_CLIENT_SECRET) + "] is required");
        }
        try {
            responseType = ResponseType.parse((String)OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_RESPONSE_TYPE));
        }
        catch (ParseException e) {
            throw new SettingsException("Invalid value for " + OpenIdConnectRealmSettings.RP_RESPONSE_TYPE.getKey(), (Throwable)e);
        }
        Scope requestedScope = new Scope(((List)config.getSetting(OpenIdConnectRealmSettings.RP_REQUESTED_SCOPES)).toArray(Strings.EMPTY_ARRAY));
        if (!requestedScope.contains("openid")) {
            requestedScope.add("openid");
        }
        JWSAlgorithm signatureAlgorithm = JWSAlgorithm.parse((String)OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_SIGNATURE_ALGORITHM));
        ClientAuthenticationMethod clientAuthenticationMethod = ClientAuthenticationMethod.parse((String)OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_CLIENT_AUTH_METHOD));
        JWSAlgorithm clientAuthJwtAlgorithm = JWSAlgorithm.parse((String)OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_CLIENT_AUTH_JWT_SIGNATURE_ALGORITHM));
        return new RelyingPartyConfiguration(clientId, clientSecret, redirectUri, responseType, requestedScope, signatureAlgorithm, clientAuthenticationMethod, clientAuthJwtAlgorithm, postLogoutRedirectUri);
    }

    private OpenIdConnectProviderConfiguration buildOpenIdConnectProviderConfiguration(RealmConfig config) {
        URI endsessionEndpoint;
        URI userinfoEndpoint;
        URI tokenEndpoint;
        URI authorizationEndpoint;
        Issuer issuer = new Issuer(OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.OP_ISSUER));
        String jwkSetUrl = OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.OP_JWKSET_PATH);
        try {
            authorizationEndpoint = new URI(OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.OP_AUTHORIZATION_ENDPOINT));
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URI: " + OpenIdConnectRealmSettings.OP_AUTHORIZATION_ENDPOINT.getKey(), (Throwable)e);
        }
        String responseType = OpenIdConnectRealm.require(config, (Setting.AffixSetting<String>)OpenIdConnectRealmSettings.RP_RESPONSE_TYPE);
        String tokenEndpointString = (String)config.getSetting(OpenIdConnectRealmSettings.OP_TOKEN_ENDPOINT);
        if (responseType.equals("code") && tokenEndpointString.isEmpty()) {
            throw new SettingsException("The configuration setting [" + OpenIdConnectRealmSettings.OP_TOKEN_ENDPOINT.getConcreteSettingForNamespace(this.name()).getKey() + "] is required when [" + OpenIdConnectRealmSettings.RP_RESPONSE_TYPE.getConcreteSettingForNamespace(this.name()).getKey() + "] is set to \"code\"");
        }
        try {
            tokenEndpoint = tokenEndpointString.isEmpty() ? null : new URI(tokenEndpointString);
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URL: " + OpenIdConnectRealmSettings.OP_TOKEN_ENDPOINT.getKey(), (Throwable)e);
        }
        try {
            userinfoEndpoint = ((String)config.getSetting(OpenIdConnectRealmSettings.OP_USERINFO_ENDPOINT)).isEmpty() ? null : new URI((String)config.getSetting(OpenIdConnectRealmSettings.OP_USERINFO_ENDPOINT));
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URI: " + OpenIdConnectRealmSettings.OP_USERINFO_ENDPOINT.getKey(), (Throwable)e);
        }
        try {
            endsessionEndpoint = ((String)config.getSetting(OpenIdConnectRealmSettings.OP_ENDSESSION_ENDPOINT)).isEmpty() ? null : new URI((String)config.getSetting(OpenIdConnectRealmSettings.OP_ENDSESSION_ENDPOINT));
        }
        catch (URISyntaxException e) {
            throw new SettingsException("Invalid URI: " + OpenIdConnectRealmSettings.OP_ENDSESSION_ENDPOINT.getKey(), (Throwable)e);
        }
        return new OpenIdConnectProviderConfiguration(issuer, jwkSetUrl, authorizationEndpoint, tokenEndpoint, userinfoEndpoint, endsessionEndpoint);
    }

    private static String require(RealmConfig config, Setting.AffixSetting<String> setting) {
        String value = (String)config.getSetting(setting);
        if (value.isEmpty()) {
            throw new SettingsException("The configuration setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, setting) + "] is required");
        }
        return value;
    }

    public OpenIdConnectPrepareAuthenticationResponse buildAuthenticationRequestUri(@Nullable String existingState, @Nullable String existingNonce, @Nullable String loginHint) {
        State state = existingState != null ? new State(existingState) : new State();
        Nonce nonce = existingNonce != null ? new Nonce(existingNonce) : new Nonce();
        AuthenticationRequest.Builder builder = new AuthenticationRequest.Builder(this.rpConfiguration.getResponseType(), this.rpConfiguration.getRequestedScope(), this.rpConfiguration.getClientId(), this.rpConfiguration.getRedirectUri()).endpointURI(this.opConfiguration.getAuthorizationEndpoint()).state(state).nonce(nonce);
        if (Strings.hasText((String)loginHint)) {
            builder.loginHint(loginHint);
        }
        return new OpenIdConnectPrepareAuthenticationResponse(builder.build().toURI().toString(), state.getValue(), nonce.getValue(), this.name());
    }

    public boolean isIssuerValid(String issuer) {
        return this.opConfiguration.getIssuer().getValue().equals(issuer);
    }

    public OpenIdConnectLogoutResponse buildLogoutResponse(JWT idTokenHint) {
        if (this.opConfiguration.getEndsessionEndpoint() != null) {
            State state = new State();
            LogoutRequest logoutRequest = new LogoutRequest(this.opConfiguration.getEndsessionEndpoint(), idTokenHint, this.rpConfiguration.getPostLogoutRedirectUri(), state);
            return new OpenIdConnectLogoutResponse(logoutRequest.toURI().toString());
        }
        return new OpenIdConnectLogoutResponse((String)null);
    }

    public void close() {
        this.openIdConnectAuthenticator.close();
    }

    private static boolean isAllowedTypeForClaim(Object o) {
        return o instanceof String || o instanceof Boolean || o instanceof Number || o instanceof Collection && ((Collection)o).stream().allMatch(c -> c instanceof String || c instanceof Boolean || c instanceof Number);
    }

    static final class ClaimParser {
        private final String name;
        private final Function<JWTClaimsSet, List<String>> parser;

        ClaimParser(String name, Function<JWTClaimsSet, List<String>> parser) {
            this.name = name;
            this.parser = parser;
        }

        List<String> getClaimValues(JWTClaimsSet claims) {
            return this.parser.apply(claims);
        }

        String getClaimValue(JWTClaimsSet claims) {
            List<String> claimValues = this.parser.apply(claims);
            if (claimValues == null || claimValues.isEmpty()) {
                return null;
            }
            return claimValues.get(0);
        }

        public String toString() {
            return this.name;
        }

        private static Collection<String> parseClaimValues(JWTClaimsSet claimsSet, String claimName, String settingKey) {
            Collection<String> values;
            Object claimValueObject = claimsSet.getClaim(claimName);
            if (claimValueObject == null) {
                values = Collections.emptyList();
            } else if (claimValueObject instanceof String) {
                values = Collections.singletonList((String)claimValueObject);
            } else if (claimValueObject instanceof Collection && ((Collection)claimValueObject).stream().allMatch(c -> c instanceof String)) {
                values = (Collection)claimValueObject;
            } else {
                throw new SettingsException("Setting [ " + settingKey + " expects a claim with String or a String Array value");
            }
            return values;
        }

        static ClaimParser forSetting(Logger logger, OpenIdConnectRealmSettings.ClaimSetting setting, RealmConfig realmConfig, boolean required) {
            if (realmConfig.hasSetting(setting.getClaim())) {
                String claimName = (String)realmConfig.getSetting(setting.getClaim());
                if (realmConfig.hasSetting(setting.getPattern())) {
                    Pattern regex = Pattern.compile((String)realmConfig.getSetting(setting.getPattern()));
                    return new ClaimParser("OpenID Connect Claim [" + claimName + "] with pattern [" + regex.pattern() + "] for [" + setting.name(realmConfig) + "]", claims -> {
                        Collection<String> values = ClaimParser.parseClaimValues(claims, claimName, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()));
                        return values.stream().map(s -> {
                            if (s == null) {
                                logger.debug("OpenID Connect Claim [{}] is null", (Object)claimName);
                                return null;
                            }
                            Matcher matcher = regex.matcher((CharSequence)s);
                            if (!matcher.find()) {
                                logger.debug("OpenID Connect Claim [{}] is [{}], which does not match [{}]", (Object)claimName, s, (Object)regex.pattern());
                                return null;
                            }
                            String value = matcher.group(1);
                            if (Strings.isNullOrEmpty((String)value)) {
                                logger.debug("OpenID Connect Claim [{}] is [{}], which does match [{}] but group(1) is empty", (Object)claimName, s, (Object)regex.pattern());
                                return null;
                            }
                            return value;
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                    });
                }
                return new ClaimParser("OpenID Connect Claim [" + claimName + "] for [" + setting.name(realmConfig) + "]", claims -> ClaimParser.parseClaimValues(claims, claimName, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim())).stream().filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (required) {
                throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is required");
            }
            if (realmConfig.hasSetting(setting.getPattern())) {
                throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getPattern()) + "] cannot be set unless [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is also set");
            }
            return new ClaimParser("No OpenID Connect Claim for [" + setting.name(realmConfig) + "]", attributes -> Collections.emptyList());
        }
    }
}

