/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.user.User;

public class RealmUserLookup {
    private final List<? extends Realm> realms;
    private final ThreadContext threadContext;

    public RealmUserLookup(List<? extends Realm> realms, ThreadContext threadContext) {
        this.realms = realms;
        this.threadContext = threadContext;
    }

    public List<Realm> getRealms() {
        return Collections.unmodifiableList(this.realms);
    }

    public boolean hasRealms() {
        return !this.realms.isEmpty();
    }

    public void lookup(String principal, ActionListener<Tuple<User, Realm>> listener) {
        IteratingActionListener userLookupListener = new IteratingActionListener(listener, (realm, lookupUserListener) -> realm.lookupUser(principal, ActionListener.wrap(foundUser -> {
            if (foundUser != null) {
                lookupUserListener.onResponse((Object)new Tuple(foundUser, realm));
            } else {
                lookupUserListener.onResponse(null);
            }
        }, arg_0 -> ((ActionListener)lookupUserListener).onFailure(arg_0))), this.realms, this.threadContext);
        try {
            userLookupListener.run();
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

