/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.MigrateToDataStreamAction;
import org.elasticsearch.xpack.core.action.CreateDataStreamAction;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUserPrivilegesResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.ResolvedIndices;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.authz.IndicesAndAliasesResolver;
import org.elasticsearch.xpack.security.authz.LoadAuthorizedIndicesTimeChecker;
import org.elasticsearch.xpack.security.authz.RBACEngine;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

public class AuthorizationService {
    public static final Setting<Boolean> ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"authc.anonymous.authz_exception"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final AuthorizationEngine.AuthorizationInfo SYSTEM_AUTHZ_INFO = () -> Collections.singletonMap("user.roles", new String[]{"_system"});
    private static final String IMPLIED_INDEX_ACTION = "indices:data/write/index:op_type/index";
    private static final String IMPLIED_CREATE_ACTION = "indices:data/write/index:op_type/create";
    private static final Logger logger = LogManager.getLogger(AuthorizationService.class);
    private final Settings settings;
    private final ClusterService clusterService;
    private final AuditTrailService auditTrailService;
    private final IndicesAndAliasesResolver indicesAndAliasesResolver;
    private final AuthenticationFailureHandler authcFailureHandler;
    private final ThreadContext threadContext;
    private final AnonymousUser anonymousUser;
    private final AuthorizationEngine rbacEngine;
    private final AuthorizationEngine authorizationEngine;
    private final Set<RequestInterceptor> requestInterceptors;
    private final XPackLicenseState licenseState;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;
    private final boolean isAnonymousEnabled;
    private final boolean anonymousAuthzExceptionEnabled;

    public AuthorizationService(Settings settings, CompositeRolesStore rolesStore, FieldPermissionsCache fieldPermissionsCache, ClusterService clusterService, AuditTrailService auditTrailService, AuthenticationFailureHandler authcFailureHandler, ThreadPool threadPool, AnonymousUser anonymousUser, @Nullable AuthorizationEngine authorizationEngine, Set<RequestInterceptor> requestInterceptors, XPackLicenseState licenseState, IndexNameExpressionResolver resolver, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService) {
        this.clusterService = clusterService;
        this.auditTrailService = auditTrailService;
        this.indicesAndAliasesResolver = new IndicesAndAliasesResolver(settings, clusterService, resolver);
        this.authcFailureHandler = authcFailureHandler;
        this.threadContext = threadPool.getThreadContext();
        this.anonymousUser = anonymousUser;
        this.isAnonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.anonymousAuthzExceptionEnabled = (Boolean)ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING.get(settings);
        this.rbacEngine = new RBACEngine(settings, rolesStore, fieldPermissionsCache, new LoadAuthorizedIndicesTimeChecker.Factory(logger, settings, clusterService.getClusterSettings()));
        this.authorizationEngine = authorizationEngine == null ? this.rbacEngine : authorizationEngine;
        this.requestInterceptors = requestInterceptors;
        this.settings = settings;
        this.licenseState = licenseState;
        this.operatorPrivilegesService = operatorPrivilegesService;
    }

    public void checkPrivileges(Authentication authentication, HasPrivilegesRequest request, Collection<ApplicationPrivilegeDescriptor> applicationPrivilegeDescriptors, ActionListener<HasPrivilegesResponse> listener) {
        this.getAuthorizationEngine(authentication).checkPrivileges(authentication, this.getAuthorizationInfoFromContext(), request, applicationPrivilegeDescriptors, (ActionListener)ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadContext));
    }

    public void retrieveUserPrivileges(Authentication authentication, GetUserPrivilegesRequest request, ActionListener<GetUserPrivilegesResponse> listener) {
        this.getAuthorizationEngine(authentication).getUserPrivileges(authentication, this.getAuthorizationInfoFromContext(), request, listener);
    }

    private AuthorizationEngine.AuthorizationInfo getAuthorizationInfoFromContext() {
        return Objects.requireNonNull((AuthorizationEngine.AuthorizationInfo)this.threadContext.getTransient("_authz_info"), "authorization info is missing from context");
    }

    public void authorize(Authentication authentication, String action, TransportRequest originalRequest, ActionListener<Void> listener) {
        AuthorizationEngine.AuthorizationContext enclosingContext = AuthorizationService.extractAuthorizationContext(this.threadContext, action);
        ThreadContext.StoredContext ignore = this.threadContext.newStoredContext(false, AuthorizationServiceField.ACTION_SCOPE_AUTHORIZATION_KEYS);
        try {
            String auditId;
            this.putTransientIfNonExisting("_originating_action_name", action);
            try {
                auditId = this.requireAuditId(authentication, action, originalRequest);
            }
            catch (ElasticsearchSecurityException e) {
                listener.onFailure((Exception)((Object)e));
                if (ignore != null) {
                    ignore.close();
                }
                return;
            }
            TransportRequest unwrappedRequest = this.maybeUnwrapRequest(authentication, originalRequest, action, auditId);
            try {
                this.checkOperatorPrivileges(authentication, action, originalRequest);
            }
            catch (ElasticsearchException e) {
                listener.onFailure((Exception)((Object)e));
                if (ignore != null) {
                    ignore.close();
                }
                return;
            }
            if (SystemUser.is((User)authentication.getUser())) {
                this.authorizeSystemUser(authentication, action, auditId, unwrappedRequest, listener);
            } else {
                AuthorizationEngine.RequestInfo requestInfo = new AuthorizationEngine.RequestInfo(authentication, unwrappedRequest, action, enclosingContext);
                AuthorizationEngine engine = this.getAuthorizationEngine(authentication);
                ContextPreservingActionListener authzInfoListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(authorizationInfo -> {
                    this.threadContext.putTransient("_authz_info", authorizationInfo);
                    this.maybeAuthorizeRunAs(requestInfo, auditId, (AuthorizationEngine.AuthorizationInfo)authorizationInfo, listener);
                }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext);
                engine.resolveAuthorizationInfo(requestInfo, (ActionListener)authzInfoListener);
            }
        }
        finally {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    @Nullable
    private static AuthorizationEngine.AuthorizationContext extractAuthorizationContext(ThreadContext threadContext, String childAction) {
        String originatingAction = (String)threadContext.getTransient("_originating_action_name");
        if (Strings.isNullOrEmpty((String)originatingAction)) {
            return null;
        }
        AuthorizationEngine.AuthorizationInfo authorizationInfo = (AuthorizationEngine.AuthorizationInfo)threadContext.getTransient("_authz_info");
        if (authorizationInfo == null) {
            throw AuthorizationService.internalError("While attempting to authorize action [" + childAction + "], found originating action [" + originatingAction + "] but no authorization info");
        }
        IndicesAccessControl parentAccessControl = (IndicesAccessControl)threadContext.getTransient("_indices_permissions");
        return new AuthorizationEngine.AuthorizationContext(originatingAction, authorizationInfo, parentAccessControl);
    }

    private String requireAuditId(Authentication authentication, String action, TransportRequest originalRequest) {
        String auditId = AuditUtil.extractRequestId(this.threadContext);
        if (auditId == null) {
            if (User.isInternal((User)authentication.getUser())) {
                auditId = AuditUtil.getOrGenerateRequestId(this.threadContext);
            } else {
                this.auditTrailService.get().tamperedRequest(null, authentication, action, originalRequest);
                throw AuthorizationService.internalError("Attempt to authorize action [" + action + "] for [" + authentication.getUser().principal() + "] without an existing request-id");
            }
        }
        return auditId;
    }

    private static ElasticsearchSecurityException internalError(String message) {
        assert (false) : message;
        return new ElasticsearchSecurityException(message, new Object[0]);
    }

    private void checkOperatorPrivileges(Authentication authentication, String action, TransportRequest originalRequest) throws ElasticsearchSecurityException {
        ElasticsearchSecurityException operatorException = this.operatorPrivilegesService.check(authentication, action, originalRequest, this.threadContext);
        if (operatorException != null) {
            throw this.denialException(authentication, action, originalRequest, "because it requires operator privileges", (Exception)((Object)operatorException));
        }
        this.operatorPrivilegesService.maybeInterceptRequest(this.threadContext, originalRequest);
    }

    private void maybeAuthorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        boolean isRunAs = authentication.getUser().isRunAs();
        AuditTrail auditTrail = this.auditTrailService.get();
        if (isRunAs) {
            ContextPreservingActionListener runAsListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(result -> {
                if (result.isGranted()) {
                    if (result.isAuditable()) {
                        auditTrail.runAsGranted(requestId, authentication, action, request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                    }
                    this.authorizeAction(requestInfo, requestId, authzInfo, listener);
                } else {
                    if (result.isAuditable()) {
                        auditTrail.runAsDenied(requestId, authentication, action, request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                    }
                    listener.onFailure((Exception)((Object)this.denialException(authentication, action, request, null)));
                }
            }, e -> {
                auditTrail.runAsDenied(requestId, authentication, action, request, authzInfo.getAuthenticatedUserAuthorizationInfo());
                listener.onFailure((Exception)((Object)this.denialException(authentication, action, request, null)));
            }), (ThreadContext)this.threadContext);
            this.authorizeRunAs(requestInfo, authzInfo, (ActionListener<AuthorizationEngine.AuthorizationResult>)runAsListener);
        } else {
            this.authorizeAction(requestInfo, requestId, authzInfo, listener);
        }
    }

    private void authorizeAction(AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        AuthorizationEngine authzEngine = this.getAuthorizationEngine(authentication);
        AuditTrail auditTrail = this.auditTrailService.get();
        if (ClusterPrivilegeResolver.isClusterAction((String)action)) {
            ContextPreservingActionListener clusterAuthzListener = ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(result -> {
                this.threadContext.putTransient("_indices_permissions", (Object)IndicesAccessControl.allowAll());
                listener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0), requestInfo, requestId, authzInfo), (ThreadContext)this.threadContext);
            authzEngine.authorizeClusterAction(requestInfo, authzInfo, ActionListener.wrap(arg_0 -> AuthorizationService.lambda$authorizeAction$5(action, request, authzEngine, requestInfo, authzInfo, (ActionListener)clusterAuthzListener, arg_0), arg_0 -> ((ActionListener)clusterAuthzListener).onFailure(arg_0)));
        } else if (AuthorizationService.isIndexAction(action)) {
            Metadata metadata = this.clusterService.state().metadata();
            CachingAsyncSupplier resolvedIndicesAsyncSupplier = new CachingAsyncSupplier(resolvedIndicesListener -> {
                ResolvedIndices resolvedIndices = this.indicesAndAliasesResolver.tryResolveWithoutWildcards(action, request);
                if (resolvedIndices != null) {
                    resolvedIndicesListener.onResponse((Object)resolvedIndices);
                } else {
                    authzEngine.loadAuthorizedIndices(requestInfo, authzInfo, (Map)metadata.getIndicesLookup(), ActionListener.wrap(authorizedIndices -> resolvedIndicesListener.onResponse((Object)this.indicesAndAliasesResolver.resolve(action, request, metadata, (Set<String>)authorizedIndices)), e -> {
                        auditTrail.accessDenied(requestId, authentication, action, request, authzInfo);
                        if (e instanceof IndexNotFoundException) {
                            listener.onFailure(e);
                        } else {
                            listener.onFailure((Exception)((Object)this.denialException(authentication, action, request, (Exception)e)));
                        }
                    }));
                }
            });
            authzEngine.authorizeIndexAction(requestInfo, authzInfo, resolvedIndicesAsyncSupplier, (Map)metadata.getIndicesLookup(), (ActionListener)ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(result -> this.handleIndexActionAuthorizationResult((AuthorizationEngine.IndexAuthorizationResult)result, requestInfo, requestId, authzInfo, authzEngine, resolvedIndicesAsyncSupplier, metadata, listener), arg_0 -> listener.onFailure(arg_0), requestInfo, requestId, authzInfo), (ThreadContext)this.threadContext));
        } else {
            logger.warn("denying access as action [{}] is not an index or cluster action", (Object)action);
            auditTrail.accessDenied(requestId, authentication, action, request, authzInfo);
            listener.onFailure((Exception)((Object)this.denialException(authentication, action, request, null)));
        }
    }

    private void handleIndexActionAuthorizationResult(AuthorizationEngine.IndexAuthorizationResult result, AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo, AuthorizationEngine authzEngine, AuthorizationEngine.AsyncSupplier<ResolvedIndices> resolvedIndicesAsyncSupplier, Metadata metadata, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        TransportRequest request = requestInfo.getRequest();
        String action = requestInfo.getAction();
        if (result.getIndicesAccessControl() != null) {
            this.threadContext.putTransient("_indices_permissions", (Object)result.getIndicesAccessControl());
        }
        if (IndexPrivilege.CREATE_INDEX_MATCHER.test(action)) {
            assert (request instanceof CreateIndexRequest || request instanceof MigrateToDataStreamAction.Request || request instanceof CreateDataStreamAction.Request);
            if (request instanceof CreateDataStreamAction.Request || request instanceof MigrateToDataStreamAction.Request || ((CreateIndexRequest)request).aliases().isEmpty()) {
                this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener);
            } else {
                Set aliases = ((CreateIndexRequest)request).aliases();
                AuthorizationEngine.AuthorizationContext parentContext = new AuthorizationEngine.AuthorizationContext(requestInfo.getAction(), authzInfo, result.getIndicesAccessControl());
                AuthorizationEngine.RequestInfo aliasesRequestInfo = new AuthorizationEngine.RequestInfo(authentication, request, "indices:admin/aliases", parentContext);
                authzEngine.authorizeIndexAction(aliasesRequestInfo, authzInfo, ril -> resolvedIndicesAsyncSupplier.getAsync(ActionListener.wrap(resolvedIndices -> {
                    ArrayList<String> aliasesAndIndices = new ArrayList<String>(resolvedIndices.getLocal());
                    for (Alias alias : aliases) {
                        aliasesAndIndices.add(alias.name());
                    }
                    ResolvedIndices withAliases = new ResolvedIndices(aliasesAndIndices, Collections.emptyList());
                    ril.onResponse((Object)withAliases);
                }, arg_0 -> ((ActionListener)ril).onFailure(arg_0))), (Map)metadata.getIndicesLookup(), (ActionListener)ContextPreservingActionListener.wrapPreservingContext(new AuthorizationResultListener(authorizationResult -> this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener), arg_0 -> listener.onFailure(arg_0), aliasesRequestInfo, requestId, authzInfo), (ThreadContext)this.threadContext));
            }
        } else if (action.equals("indices:data/write/bulk[s]")) {
            assert (request instanceof BulkShardRequest) : "Action " + action + " requires " + BulkShardRequest.class + " but was " + request.getClass();
            AuthorizationEngine.AuthorizationContext authzContext = new AuthorizationEngine.AuthorizationContext(requestInfo.getAction(), authzInfo, result.getIndicesAccessControl());
            this.authorizeBulkItems(requestInfo, authzContext, authzEngine, resolvedIndicesAsyncSupplier, metadata, requestId, (ActionListener<Void>)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(ignore -> this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener), arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext));
        } else {
            this.runRequestInterceptors(requestInfo, authzInfo, this.authorizationEngine, listener);
        }
    }

    private void runRequestInterceptors(final AuthorizationEngine.RequestInfo requestInfo, final AuthorizationEngine.AuthorizationInfo authorizationInfo, final AuthorizationEngine authorizationEngine, final ActionListener<Void> listener) {
        if (this.requestInterceptors.isEmpty()) {
            listener.onResponse(null);
        } else {
            final Iterator<RequestInterceptor> requestInterceptorIterator = this.requestInterceptors.iterator();
            requestInterceptorIterator.next().intercept(requestInfo, authorizationEngine, authorizationInfo, (ActionListener<Void>)new ActionListener.Delegating<Void, Void>(listener){

                public void onResponse(Void unused) {
                    if (requestInterceptorIterator.hasNext()) {
                        ((RequestInterceptor)requestInterceptorIterator.next()).intercept(requestInfo, authorizationEngine, authorizationInfo, (ActionListener<Void>)this);
                    } else {
                        listener.onResponse(null);
                    }
                }
            });
        }
    }

    AuthorizationEngine getRunAsAuthorizationEngine(Authentication authentication) {
        return this.getAuthorizationEngineForUser(authentication.getUser().authenticatedUser());
    }

    AuthorizationEngine getAuthorizationEngine(Authentication authentication) {
        return this.getAuthorizationEngineForUser(authentication.getUser());
    }

    private AuthorizationEngine getAuthorizationEngineForUser(User user) {
        if (this.rbacEngine != this.authorizationEngine && this.licenseState.isSecurityEnabled() && Security.AUTHORIZATION_ENGINE_FEATURE.check(this.licenseState)) {
            if (ClientReservedRealm.isReserved((String)user.principal(), (Settings)this.settings) || User.isInternal((User)user)) {
                return this.rbacEngine;
            }
            return this.authorizationEngine;
        }
        return this.rbacEngine;
    }

    private void authorizeSystemUser(Authentication authentication, String action, String requestId, TransportRequest request, ActionListener<Void> listener) {
        AuditTrail auditTrail = this.auditTrailService.get();
        if (SystemUser.isAuthorized((String)action)) {
            this.threadContext.putTransient("_indices_permissions", (Object)IndicesAccessControl.allowAll());
            this.threadContext.putTransient("_authz_info", (Object)SYSTEM_AUTHZ_INFO);
            auditTrail.accessGranted(requestId, authentication, action, request, SYSTEM_AUTHZ_INFO);
            listener.onResponse(null);
        } else {
            auditTrail.accessDenied(requestId, authentication, action, request, SYSTEM_AUTHZ_INFO);
            listener.onFailure((Exception)((Object)this.denialException(authentication, action, request, null)));
        }
    }

    private TransportRequest maybeUnwrapRequest(Authentication authentication, TransportRequest originalRequest, String action, String requestId) {
        TransportRequest request;
        if (originalRequest instanceof TransportReplicationAction.ConcreteShardRequest) {
            request = ((TransportReplicationAction.ConcreteShardRequest)originalRequest).getRequest();
            assert (!TransportActionProxy.isProxyRequest((TransportRequest)request)) : "expected non-proxy request for action: " + action;
        } else {
            request = TransportActionProxy.unwrapRequest((TransportRequest)originalRequest);
            boolean isOriginalRequestProxyRequest = TransportActionProxy.isProxyRequest((TransportRequest)originalRequest);
            boolean isProxyAction = TransportActionProxy.isProxyAction((String)action);
            AuditTrail auditTrail = this.auditTrailService.get();
            if (isProxyAction && !isOriginalRequestProxyRequest) {
                IllegalStateException cause = new IllegalStateException("originalRequest is not a proxy request: [" + originalRequest + "] but action: [" + action + "] is a proxy action");
                auditTrail.accessDenied(requestId, authentication, action, request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
                throw this.denialException(authentication, action, request, cause);
            }
            if (TransportActionProxy.isProxyRequest((TransportRequest)originalRequest) && !TransportActionProxy.isProxyAction((String)action)) {
                IllegalStateException cause = new IllegalStateException("originalRequest is a proxy request for: [" + request + "] but action: [" + action + "] isn't");
                auditTrail.accessDenied(requestId, authentication, action, request, (AuthorizationEngine.AuthorizationInfo)AuthorizationEngine.EmptyAuthorizationInfo.INSTANCE);
                throw this.denialException(authentication, action, request, cause);
            }
        }
        return request;
    }

    private void authorizeRunAs(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener<AuthorizationEngine.AuthorizationResult> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        if (authentication.getLookedUpBy() == null) {
            listener.onResponse((Object)AuthorizationEngine.AuthorizationResult.deny());
        } else {
            AuthorizationEngine runAsAuthzEngine = this.getRunAsAuthorizationEngine(authentication);
            runAsAuthzEngine.authorizeRunAs(requestInfo, authzInfo, listener);
        }
    }

    private void authorizeBulkItems(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationContext bulkAuthzContext, AuthorizationEngine authzEngine, AuthorizationEngine.AsyncSupplier<ResolvedIndices> resolvedIndicesAsyncSupplier, Metadata metadata, String requestId, ActionListener<Void> listener) {
        Authentication authentication = requestInfo.getAuthentication();
        AuthorizationEngine.AuthorizationInfo authzInfo = bulkAuthzContext.getAuthorizationInfo();
        BulkShardRequest request = (BulkShardRequest)requestInfo.getRequest();
        HashMap resolvedIndexNames = new HashMap();
        HashMap actionToIndicesMap = new HashMap();
        AuditTrail auditTrail = this.auditTrailService.get();
        resolvedIndicesAsyncSupplier.getAsync(ActionListener.wrap(overallResolvedIndices -> {
            HashSet localIndices = new HashSet(overallResolvedIndices.getLocal());
            for (BulkItemRequest item : request.items()) {
                String itemAction = AuthorizationService.getAction(item);
                String resolvedIndex = resolvedIndexNames.computeIfAbsent(item.index(), key -> {
                    ResolvedIndices resolvedIndices = this.indicesAndAliasesResolver.resolveIndicesAndAliasesWithoutWildcards(itemAction, (IndicesRequest)item.request());
                    if (resolvedIndices.getRemote().size() != 0) {
                        throw AuthorizationService.illegalArgument("Bulk item should not write to remote indices, but request writes to " + String.join((CharSequence)",", resolvedIndices.getRemote()));
                    }
                    if (resolvedIndices.getLocal().size() != 1) {
                        throw AuthorizationService.illegalArgument("Bulk item should write to exactly 1 index, but request writes to " + String.join((CharSequence)",", resolvedIndices.getLocal()));
                    }
                    String resolved = (String)resolvedIndices.getLocal().get(0);
                    if (!localIndices.contains(resolved)) {
                        throw AuthorizationService.illegalArgument("Found bulk item that writes to index " + resolved + " but the request writes to " + localIndices);
                    }
                    return resolved;
                });
                actionToIndicesMap.compute(itemAction, (key, resolvedIndicesSet) -> {
                    Set localSet = resolvedIndicesSet != null ? resolvedIndicesSet : new HashSet();
                    localSet.add(resolvedIndex);
                    return localSet;
                });
            }
            ActionListener bulkAuthzListener = ActionListener.wrap(collection -> {
                HashMap actionToIndicesAccessControl = new HashMap();
                AtomicBoolean audit = new AtomicBoolean(false);
                collection.forEach(tuple -> {
                    IndicesAccessControl existing = actionToIndicesAccessControl.putIfAbsent((String)tuple.v1(), ((AuthorizationEngine.IndexAuthorizationResult)tuple.v2()).getIndicesAccessControl());
                    if (existing != null) {
                        throw new IllegalStateException("a value already exists for action " + (String)tuple.v1());
                    }
                    if (((AuthorizationEngine.IndexAuthorizationResult)tuple.v2()).isAuditable()) {
                        audit.set(true);
                    }
                });
                for (BulkItemRequest item : request.items()) {
                    String resolvedIndex = (String)resolvedIndexNames.get(item.index());
                    String itemAction = AuthorizationService.getAction(item);
                    IndicesAccessControl indicesAccessControl = (IndicesAccessControl)actionToIndicesAccessControl.get(itemAction);
                    IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(resolvedIndex);
                    if (indexAccessControl == null || !indexAccessControl.isGranted()) {
                        auditTrail.explicitIndexAccessEvent(requestId, AuditLevel.ACCESS_DENIED, authentication, itemAction, resolvedIndex, item.getClass().getSimpleName(), request.remoteAddress(), authzInfo);
                        item.abort(resolvedIndex, (Exception)((Object)this.denialException(authentication, itemAction, (TransportRequest)request, AuthorizationEngine.IndexAuthorizationResult.getFailureDescription(Collections.singletonList(resolvedIndex)), null)));
                        continue;
                    }
                    if (!audit.get()) continue;
                    auditTrail.explicitIndexAccessEvent(requestId, AuditLevel.ACCESS_GRANTED, authentication, itemAction, resolvedIndex, item.getClass().getSimpleName(), request.remoteAddress(), authzInfo);
                }
                listener.onResponse(null);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            ContextPreservingActionListener groupedActionListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)new GroupedActionListener(bulkAuthzListener, actionToIndicesMap.size()), (ThreadContext)this.threadContext);
            actionToIndicesMap.forEach((arg_0, arg_1) -> AuthorizationService.lambda$authorizeBulkItems$20(requestInfo, bulkAuthzContext, authzEngine, authzInfo, metadata, (ActionListener)groupedActionListener, arg_0, arg_1));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static IllegalArgumentException illegalArgument(String message) {
        assert (false) : message;
        return new IllegalArgumentException(message);
    }

    private static boolean isIndexAction(String action) {
        return IndexPrivilege.ACTION_MATCHER.test(action);
    }

    private static String getAction(BulkItemRequest item) {
        DocWriteRequest docWriteRequest = item.request();
        switch (docWriteRequest.opType()) {
            case INDEX: {
                return IMPLIED_INDEX_ACTION;
            }
            case CREATE: {
                return IMPLIED_CREATE_ACTION;
            }
            case UPDATE: {
                return "indices:data/write/update";
            }
            case DELETE: {
                return "indices:data/write/delete";
            }
        }
        throw new IllegalArgumentException("No equivalent action for opType [" + docWriteRequest.opType() + "]");
    }

    private void putTransientIfNonExisting(String key, Object value) {
        Object existing = this.threadContext.getTransient(key);
        if (existing == null) {
            this.threadContext.putTransient(key, value);
        }
    }

    private ElasticsearchSecurityException denialException(Authentication authentication, String action, TransportRequest request, Exception cause) {
        return this.denialException(authentication, action, request, null, cause);
    }

    private ElasticsearchSecurityException denialException(Authentication authentication, String action, TransportRequest request, @Nullable String context, Exception cause) {
        Collection privileges;
        User authUser = authentication.getUser().authenticatedUser();
        if (this.isAnonymousEnabled && this.anonymousUser.equals((Object)authUser) && !this.anonymousAuthzExceptionEnabled) {
            return this.authcFailureHandler.authenticationRequired(action, this.threadContext);
        }
        String userText = "user [" + authUser.principal() + "]";
        if (authentication.getUser().isRunAs()) {
            userText = userText + " run as [" + authentication.getUser().principal() + "]";
        }
        if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType()) {
            String apiKeyId = (String)authentication.getMetadata().get("_security_api_key_id");
            assert (apiKeyId != null) : "api key id must be present in the metadata";
            userText = "API key id [" + apiKeyId + "] of " + userText;
        } else if (!authentication.isServiceAccount()) {
            userText = userText + " with roles [" + Strings.arrayToCommaDelimitedString((Object[])authentication.getUser().roles()) + "]";
        }
        String message = "action [" + action + "] is unauthorized for " + userText;
        if (context != null) {
            message = message + " " + context;
        }
        if (ClusterPrivilegeResolver.isClusterAction((String)action)) {
            Collection privileges2 = ClusterPrivilegeResolver.findPrivilegesThatGrant((String)action, (TransportRequest)request, (Authentication)authentication);
            if (privileges2 != null && privileges2.size() > 0) {
                message = message + ", this action is granted by the cluster privileges [" + Strings.collectionToCommaDelimitedString((Iterable)privileges2) + "]";
            }
        } else if (AuthorizationService.isIndexAction(action) && (privileges = IndexPrivilege.findPrivilegesThatGrant((String)action)) != null && privileges.size() > 0) {
            message = message + ", this action is granted by the index privileges [" + Strings.collectionToCommaDelimitedString((Iterable)privileges) + "]";
        }
        logger.debug(message);
        return Exceptions.authorizationError((String)message, (Exception)cause, (Object[])new Object[0]);
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(ANONYMOUS_AUTHORIZATION_EXCEPTION_SETTING);
        settings.addAll(LoadAuthorizedIndicesTimeChecker.Factory.getSettings());
    }

    private static /* synthetic */ void lambda$authorizeBulkItems$20(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationContext bulkAuthzContext, AuthorizationEngine authzEngine, AuthorizationEngine.AuthorizationInfo authzInfo, Metadata metadata, ActionListener groupedActionListener, String bulkItemAction, Set indices) {
        AuthorizationEngine.RequestInfo bulkItemInfo = new AuthorizationEngine.RequestInfo(requestInfo.getAuthentication(), requestInfo.getRequest(), bulkItemAction, bulkAuthzContext);
        authzEngine.authorizeIndexAction(bulkItemInfo, authzInfo, ril -> ril.onResponse((Object)new ResolvedIndices(new ArrayList(indices), Collections.emptyList())), (Map)metadata.getIndicesLookup(), ActionListener.wrap(indexAuthorizationResult -> groupedActionListener.onResponse((Object)new Tuple((Object)bulkItemAction, indexAuthorizationResult)), arg_0 -> ((ActionListener)groupedActionListener).onFailure(arg_0)));
    }

    private static /* synthetic */ void lambda$authorizeAction$5(String action, TransportRequest request, AuthorizationEngine authzEngine, AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine.AuthorizationInfo authzInfo, ActionListener clusterAuthzListener, AuthorizationEngine.AuthorizationResult result) throws Exception {
        if (!result.isGranted() && "cluster:admin/xpack/security/api_key/query".equals(action)) {
            assert (request instanceof QueryApiKeyRequest) : "request does not match action";
            QueryApiKeyRequest queryApiKeyRequest = (QueryApiKeyRequest)request;
            if (!queryApiKeyRequest.isFilterForCurrentUser()) {
                queryApiKeyRequest.setFilterForCurrentUser();
                authzEngine.authorizeClusterAction(requestInfo, authzInfo, clusterAuthzListener);
                return;
            }
        }
        clusterAuthzListener.onResponse((Object)result);
    }

    private class AuthorizationResultListener<T extends AuthorizationEngine.AuthorizationResult>
    implements ActionListener<T> {
        private final Consumer<T> responseConsumer;
        private final Consumer<Exception> failureConsumer;
        private final AuthorizationEngine.RequestInfo requestInfo;
        private final String requestId;
        private final AuthorizationEngine.AuthorizationInfo authzInfo;

        private AuthorizationResultListener(Consumer<T> responseConsumer, Consumer<Exception> failureConsumer, AuthorizationEngine.RequestInfo requestInfo, String requestId, AuthorizationEngine.AuthorizationInfo authzInfo) {
            this.responseConsumer = responseConsumer;
            this.failureConsumer = failureConsumer;
            this.requestInfo = requestInfo;
            this.requestId = requestId;
            this.authzInfo = authzInfo;
        }

        public void onResponse(T result) {
            if (result.isGranted()) {
                if (result.isAuditable()) {
                    AuthorizationService.this.auditTrailService.get().accessGranted(this.requestId, this.requestInfo.getAuthentication(), this.requestInfo.getAction(), this.requestInfo.getRequest(), this.authzInfo);
                }
                try {
                    this.responseConsumer.accept(result);
                }
                catch (Exception e) {
                    this.failureConsumer.accept(e);
                }
            } else {
                this.handleFailure(result.isAuditable(), result.getFailureContext(), null);
            }
        }

        public void onFailure(Exception e) {
            this.handleFailure(true, null, e);
        }

        private void handleFailure(boolean audit, @Nullable String context, @Nullable Exception e) {
            if (audit) {
                AuthorizationService.this.auditTrailService.get().accessDenied(this.requestId, this.requestInfo.getAuthentication(), this.requestInfo.getAction(), this.requestInfo.getRequest(), this.authzInfo);
            }
            this.failureConsumer.accept((Exception)((Object)AuthorizationService.this.denialException(this.requestInfo.getAuthentication(), this.requestInfo.getAction(), this.requestInfo.getRequest(), context, e)));
        }
    }

    private static class CachingAsyncSupplier<V>
    implements AuthorizationEngine.AsyncSupplier<V> {
        private final AuthorizationEngine.AsyncSupplier<V> asyncSupplier;
        private volatile ListenableFuture<V> valueFuture = null;

        private CachingAsyncSupplier(AuthorizationEngine.AsyncSupplier<V> supplier) {
            this.asyncSupplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getAsync(ActionListener<V> listener) {
            if (this.valueFuture == null) {
                boolean firstInvocation = false;
                CachingAsyncSupplier cachingAsyncSupplier = this;
                synchronized (cachingAsyncSupplier) {
                    if (this.valueFuture == null) {
                        this.valueFuture = new ListenableFuture();
                        firstInvocation = true;
                    }
                }
                if (firstInvocation) {
                    this.asyncSupplier.getAsync(this.valueFuture);
                }
            }
            this.valueFuture.addListener(listener);
        }
    }
}

