/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.TimeoutUtils;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.FilteredMonitoringDoc;

public class IndexStatsCollector
extends Collector {
    public static final Setting<TimeValue> INDEX_STATS_TIMEOUT = IndexStatsCollector.collectionTimeoutSetting("index.stats.timeout");
    private final Client client;

    public IndexStatsCollector(ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        super("index-stats", clusterService, INDEX_STATS_TIMEOUT, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) {
        ArrayList<FilteredMonitoringDoc> results = new ArrayList<FilteredMonitoringDoc>();
        IndicesStatsResponse indicesStatsResponse = (IndicesStatsResponse)((IndicesStatsRequestBuilder)((IndicesStatsRequestBuilder)((IndicesStatsRequestBuilder)this.client.admin().indices().prepareStats(new String[0]).setIndices(this.getCollectionIndices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).clear().setDocs(true).setFieldData(true).setIndexing(true).setMerge(true).setSearch(true).setSegments(true).setStore(true).setRefresh(true).setQueryCache(true).setRequestCache(true).setTimeout(this.getCollectionTimeout())).get();
        TimeoutUtils.ensureNoTimeouts(this.getCollectionTimeout(), (BroadcastResponse)indicesStatsResponse);
        long timestamp = IndexStatsCollector.timestamp();
        String clusterUuid = IndexStatsCollector.clusterUuid(clusterState);
        Metadata metadata = clusterState.metadata();
        RoutingTable routingTable = clusterState.routingTable();
        ArrayList<IndexStats> indicesStats = new ArrayList<IndexStats>();
        for (String indexName : metadata.getConcreteAllIndices()) {
            IndexStats indexStats = indicesStatsResponse.getIndex(indexName);
            if (indexStats == null) continue;
            indicesStats.add(indexStats);
            results.add(new IndexStatsMonitoringDoc(clusterUuid, timestamp, interval, node, indexStats, metadata.index(indexName), routingTable.index(indexName)));
        }
        results.add(new IndicesStatsMonitoringDoc(clusterUuid, timestamp, interval, node, indicesStats));
        return Collections.unmodifiableCollection(results);
    }
}

