/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksAction;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class MlDailyMaintenanceService
implements Releasable {
    private static final Logger LOGGER = LogManager.getLogger(MlDailyMaintenanceService.class);
    private static final int MAX_TIME_OFFSET_MINUTES = 120;
    private final ThreadPool threadPool;
    private final Client client;
    private final ClusterService clusterService;
    private final MlAssignmentNotifier mlAssignmentNotifier;
    private final Supplier<TimeValue> schedulerProvider;
    private volatile Scheduler.Cancellable cancellable;
    private volatile float deleteExpiredDataRequestsPerSecond;

    MlDailyMaintenanceService(Settings settings, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier, Supplier<TimeValue> scheduleProvider) {
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(client);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.mlAssignmentNotifier = Objects.requireNonNull(mlAssignmentNotifier);
        this.schedulerProvider = Objects.requireNonNull(scheduleProvider);
        this.deleteExpiredDataRequestsPerSecond = ((Float)MachineLearning.NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND.get(settings)).floatValue();
    }

    public MlDailyMaintenanceService(Settings settings, ClusterName clusterName, ThreadPool threadPool, Client client, ClusterService clusterService, MlAssignmentNotifier mlAssignmentNotifier) {
        this(settings, threadPool, client, clusterService, mlAssignmentNotifier, () -> MlDailyMaintenanceService.delayToNextTime(clusterName));
    }

    void setDeleteExpiredDataRequestsPerSecond(float value) {
        this.deleteExpiredDataRequestsPerSecond = value;
    }

    private static TimeValue delayToNextTime(ClusterName clusterName) {
        Random random = new Random(clusterName.hashCode());
        int minutesOffset = random.ints(0, 120).findFirst().getAsInt();
        ZonedDateTime now = ZonedDateTime.now(Clock.systemDefaultZone());
        ZonedDateTime next = now.plusDays(1L).toLocalDate().atStartOfDay(now.getZone()).plusMinutes(30L).plusMinutes(minutesOffset);
        return TimeValue.timeValueMillis((long)(next.toInstant().toEpochMilli() - now.toInstant().toEpochMilli()));
    }

    public synchronized void start() {
        LOGGER.debug("Starting ML daily maintenance service");
        this.scheduleNext();
    }

    public synchronized void stop() {
        LOGGER.debug("Stopping ML daily maintenance service");
        if (this.cancellable != null && !this.cancellable.isCancelled()) {
            this.cancellable.cancel();
        }
    }

    boolean isStarted() {
        return this.cancellable != null;
    }

    public void close() {
        this.stop();
    }

    private synchronized void scheduleNext() {
        try {
            this.cancellable = this.threadPool.schedule(this::triggerTasks, this.schedulerProvider.get(), "generic");
        }
        catch (EsRejectedExecutionException e) {
            if (e.isExecutorShutdown()) {
                LOGGER.debug("failed to schedule next maintenance task; shutting down", (Throwable)e);
            }
            throw e;
        }
    }

    private void triggerTasks() {
        try {
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isUpgradeMode()) {
                LOGGER.warn("skipping scheduled [ML] maintenance tasks because upgrade mode is enabled");
                return;
            }
            if (MlMetadata.getMlMetadata((ClusterState)this.clusterService.state()).isResetMode()) {
                LOGGER.warn("skipping scheduled [ML] maintenance tasks because machine learning feature reset is in progress");
                return;
            }
            LOGGER.info("triggering scheduled [ML] maintenance tasks");
            ActionListener finalListener = ActionListener.wrap(unused -> {}, e -> LOGGER.error("An error occurred during [ML] maintenance tasks execution", (Throwable)e));
            ActionListener deleteJobsListener = ActionListener.wrap(unused -> this.triggerDeleteExpiredDataTask((ActionListener<AcknowledgedResponse>)finalListener), e -> {
                LOGGER.info("[ML] maintenance task: triggerDeleteJobsInStateDeletingWithoutDeletionTask failed", (Throwable)e);
                this.triggerDeleteExpiredDataTask((ActionListener<AcknowledgedResponse>)finalListener);
            });
            this.triggerDeleteJobsInStateDeletingWithoutDeletionTask((ActionListener<AcknowledgedResponse>)deleteJobsListener);
            this.auditUnassignedMlTasks();
        }
        finally {
            this.scheduleNext();
        }
    }

    private void triggerDeleteExpiredDataTask(ActionListener<AcknowledgedResponse> finalListener) {
        ActionListener deleteExpiredDataActionListener = ActionListener.wrap(deleteExpiredDataResponse -> {
            if (deleteExpiredDataResponse.isDeleted()) {
                LOGGER.info("Successfully completed [ML] maintenance task: triggerDeleteExpiredDataTask");
            } else {
                LOGGER.info("Halting [ML] maintenance tasks before completion as elapsed time is too great");
            }
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteExpiredDataAction.INSTANCE, (ActionRequest)new DeleteExpiredDataAction.Request(Float.valueOf(this.deleteExpiredDataRequestsPerSecond), TimeValue.timeValueHours((long)8L)), (ActionListener)deleteExpiredDataActionListener);
    }

    public void triggerDeleteJobsInStateDeletingWithoutDeletionTask(ActionListener<AcknowledgedResponse> finalListener) {
        SetOnce jobsInStateDeletingHolder = new SetOnce();
        ActionListener deleteJobsActionListener = ActionListener.wrap(deleteJobsResponses -> {
            List jobIds = deleteJobsResponses.stream().filter(t -> !((AcknowledgedResponse)t.v2()).isAcknowledged()).map(Tuple::v1).map(DeleteJobAction.Request::getJobId).collect(Collectors.toList());
            if (jobIds.isEmpty()) {
                LOGGER.info("Successfully completed [ML] maintenance task: triggerDeleteJobsInStateDeletingWithoutDeletionTask");
            } else {
                LOGGER.info("The following ML jobs could not be deleted: [" + String.join((CharSequence)",", jobIds) + "]");
            }
            finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener listTasksActionListener = ActionListener.wrap(listTasksResponse -> {
            Set jobsWithDeletionTask;
            Set jobsInStateDeleting = (Set)jobsInStateDeletingHolder.get();
            Set jobsInStateDeletingWithoutDeletionTask = Sets.difference((Set)jobsInStateDeleting, jobsWithDeletionTask = listTasksResponse.getTasks().stream().filter(t -> t.getDescription() != null).filter(t -> t.getDescription().startsWith("delete-job-")).map(t -> t.getDescription().substring("delete-job-".length())).collect(Collectors.toSet()));
            if (jobsInStateDeletingWithoutDeletionTask.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            TypedChainTaskExecutor<Tuple> chainTaskExecutor = new TypedChainTaskExecutor<Tuple>(this.threadPool.executor("same"), unused -> true, unused -> true);
            for (String jobId : jobsInStateDeletingWithoutDeletionTask) {
                DeleteJobAction.Request request = new DeleteJobAction.Request(jobId);
                chainTaskExecutor.add(listener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteJobAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)Tuple.tuple((Object)request, (Object)response)), arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
            }
            chainTaskExecutor.execute((ActionListener<List<Tuple>>)deleteJobsActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getJobsActionListener = ActionListener.wrap(getJobsResponse -> {
            Set jobsInStateDeleting = getJobsResponse.getResponse().results().stream().filter(Job::isDeleting).map(Job::getId).collect(Collectors.toSet());
            if (jobsInStateDeleting.isEmpty()) {
                finalListener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            jobsInStateDeletingHolder.set(jobsInStateDeleting);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)ListTasksAction.INSTANCE, (ActionRequest)((ListTasksRequest)new ListTasksRequest().setActions(new String[]{"cluster:admin/xpack/ml/job/delete"})), (ActionListener)listTasksActionListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetJobsAction.INSTANCE, (ActionRequest)new GetJobsAction.Request("*"), (ActionListener)getJobsActionListener);
    }

    private void auditUnassignedMlTasks() {
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        if (tasks != null) {
            this.mlAssignmentNotifier.auditUnassignedMlTasks(state.nodes(), tasks);
        }
    }
}

