/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportDeleteTrainedModelAction
extends AcknowledgedTransportMasterNodeAction<DeleteTrainedModelAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTrainedModelAction.class);
    private final TrainedModelProvider trainedModelProvider;
    private final InferenceAuditor auditor;
    private final IngestService ingestService;

    @Inject
    public TransportDeleteTrainedModelAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TrainedModelProvider configProvider, InferenceAuditor auditor, IngestService ingestService) {
        super("cluster:admin/xpack/ml/inference/delete", transportService, clusterService, threadPool, actionFilters, DeleteTrainedModelAction.Request::new, indexNameExpressionResolver, "same");
        this.trainedModelProvider = configProvider;
        this.ingestService = ingestService;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void masterOperation(final DeleteTrainedModelAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String id = request.getId();
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        Set<String> referencedModels = TransportDeleteTrainedModelAction.getReferencedModelKeys(currentIngestMetadata, this.ingestService);
        if (referencedModels.contains(id)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it is still referenced by ingest processors", RestStatus.CONFLICT, new Object[]{id}));
            return;
        }
        ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState((ClusterState)state);
        final ArrayList<String> modelAliases = new ArrayList<String>();
        for (Map.Entry modelAliasEntry : currentMetadata.modelAliases().entrySet()) {
            if (!((ModelAliasMetadata.ModelAliasEntry)modelAliasEntry.getValue()).getModelId().equals(id)) continue;
            modelAliases.add((String)modelAliasEntry.getKey());
        }
        for (String modelAlias : modelAliases) {
            if (!referencedModels.contains(modelAlias)) continue;
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete model [{}] as it has a model_alias [{}] that is still referenced by ingest processors", RestStatus.CONFLICT, new Object[]{id, modelAlias}));
            return;
        }
        ActionListener nameDeletionListener = ActionListener.wrap(ack -> this.trainedModelProvider.deleteTrainedModel(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            this.auditor.info(request.getId(), "trained model deleted");
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        if (modelAliases.isEmpty()) {
            nameDeletionListener.onResponse((Object)AcknowledgedResponse.of((boolean)true));
            return;
        }
        this.clusterService.submitStateUpdateTask("delete-trained-model-alias", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, nameDeletionListener){

            public ClusterState execute(ClusterState currentState) {
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                ModelAliasMetadata currentMetadata = ModelAliasMetadata.fromState((ClusterState)currentState);
                if (currentMetadata.modelAliases().isEmpty()) {
                    return currentState;
                }
                HashMap newMetadata = new HashMap(currentMetadata.modelAliases());
                logger.info("[{}] delete model model_aliases {}", (Object)request.getId(), (Object)modelAliases);
                modelAliases.forEach(newMetadata::remove);
                ModelAliasMetadata modelAliasMetadata = new ModelAliasMetadata(newMetadata);
                builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("trained_model_alias", (Metadata.Custom)modelAliasMetadata).build());
                return builder.build();
            }
        });
    }

    static Set<String> getReferencedModelKeys(IngestMetadata ingestMetadata, IngestService ingestService) {
        HashSet<String> allReferencedModelKeys = new HashSet<String>();
        if (ingestMetadata == null) {
            return allReferencedModelKeys;
        }
        for (Map.Entry entry : ingestMetadata.getPipelines().entrySet()) {
            String pipelineId = (String)entry.getKey();
            Map config = ((PipelineConfiguration)entry.getValue()).getConfigAsMap();
            try {
                Pipeline pipeline = Pipeline.create((String)pipelineId, (Map)config, (Map)ingestService.getProcessorFactories(), (ScriptService)ingestService.getScriptService());
                pipeline.getProcessors().stream().filter(p -> p instanceof InferenceProcessor).map(p -> (InferenceProcessor)((Object)p)).map(InferenceProcessor::getModelId).forEach(allReferencedModelKeys::add);
            }
            catch (Exception ex) {
                logger.warn((Message)new ParameterizedMessage("failed to load pipeline [{}]", (Object)pipelineId), (Throwable)ex);
            }
        }
        return allReferencedModelKeys;
    }

    protected ClusterBlockException checkBlock(DeleteTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

