/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfigUpdate;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class UpdateDataFrameAnalyticsAction
extends ActionType<PutDataFrameAnalyticsAction.Response> {
    public static final UpdateDataFrameAnalyticsAction INSTANCE = new UpdateDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/update";

    private UpdateDataFrameAnalyticsAction() {
        super(NAME, PutDataFrameAnalyticsAction.Response::new);
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PutDataFrameAnalyticsAction.Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, UpdateDataFrameAnalyticsAction action) {
            super(client, (ActionType)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private DataFrameAnalyticsConfigUpdate update;

        public static Request parseRequest(String id, XContentParser parser) {
            DataFrameAnalyticsConfigUpdate.Builder updateBuilder = (DataFrameAnalyticsConfigUpdate.Builder)DataFrameAnalyticsConfigUpdate.PARSER.apply(parser, null);
            if (updateBuilder.getId() == null) {
                updateBuilder.setId(id);
            } else if (!Strings.isNullOrEmpty((String)id) && !id.equals(updateBuilder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", DataFrameAnalyticsConfig.ID, updateBuilder.getId(), id));
            }
            return new Request(updateBuilder.build());
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.update = new DataFrameAnalyticsConfigUpdate(in);
        }

        public Request(DataFrameAnalyticsConfigUpdate update) {
            this.update = update;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.update.writeTo(out);
        }

        public DataFrameAnalyticsConfigUpdate getUpdate() {
            return this.update;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.update.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.update, request.update);
        }

        public int hashCode() {
            return Objects.hash(this.update);
        }
    }
}

