/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.rest.action;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public abstract class IdpBaseRestHandler
extends BaseRestHandler {
    private static License.OperationMode MINIMUM_ALLOWED_LICENSE = License.OperationMode.ENTERPRISE;
    protected final XPackLicenseState licenseState;

    protected IdpBaseRestHandler(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BaseRestHandler.RestChannelConsumer consumer = this.innerPrepareRequest(request, client);
        if (this.isIdpFeatureAllowed()) {
            return consumer;
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)((Object)LicenseUtils.newComplianceException((String)"Identity Provider"))));
    }

    protected boolean isIdpFeatureAllowed() {
        return this.licenseState.isAllowedByLicense(MINIMUM_ALLOWED_LICENSE);
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;
}

