/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.cli.InstallablePlugin;
import org.elasticsearch.plugins.cli.RemovePluginAction;
import org.elasticsearch.plugins.cli.SyncPluginsAction;

class RemovePluginCommand
extends EnvironmentAwareCommand {
    private final OptionSpec<Void> purgeOption;
    private final OptionSpec<String> arguments;

    RemovePluginCommand() {
        super("removes plugins from Elasticsearch");
        this.purgeOption = this.parser.acceptsAll(Arrays.asList("p", "purge"), "Purge plugin configuration files");
        this.arguments = this.parser.nonOptions("plugin id");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        SyncPluginsAction.ensureNoConfigFile(env);
        List<InstallablePlugin> plugins = this.arguments.values(options).stream().map(InstallablePlugin::new).collect(Collectors.toList());
        RemovePluginAction action = new RemovePluginAction(terminal, env, options.has(this.purgeOption));
        action.execute(plugins);
    }
}

