/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.url.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpResponseInputStream
extends FilterInputStream {
    private final HttpRequestBase request;
    private final CloseableHttpResponse httpResponse;

    public HttpResponseInputStream(HttpRequestBase request, CloseableHttpResponse httpResponse) throws IOException {
        super(httpResponse.getEntity() == null ? EmptyInputStream.INSTANCE : httpResponse.getEntity().getContent());
        this.request = request;
        this.httpResponse = httpResponse;
    }

    public void abort() {
        this.request.abort();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.httpResponse.close();
    }

    private static class EmptyInputStream
    extends InputStream {
        public static final EmptyInputStream INSTANCE = new EmptyInputStream();

        private EmptyInputStream() {
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int readLimit) {
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] buf) {
            return -1;
        }

        @Override
        public int read(byte[] buf, int off, int len) {
            return -1;
        }

        @Override
        public void reset() {
        }

        @Override
        public long skip(long n) {
            return 0L;
        }
    }
}

