/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.transport.Transports;

@ChannelHandler.Sharable
class Netty4HttpRequestHandler
extends SimpleChannelInboundHandler<HttpPipelinedRequest> {
    private final Netty4HttpServerTransport serverTransport;

    Netty4HttpRequestHandler(Netty4HttpServerTransport serverTransport) {
        this.serverTransport = serverTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpPipelinedRequest httpRequest) {
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.serverTransport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        boolean success = false;
        try {
            this.serverTransport.incomingRequest((HttpRequest)httpRequest, channel);
            success = true;
        }
        finally {
            if (!success) {
                httpRequest.release();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.serverTransport.getThreadPool().getThreadContext()));
        Netty4HttpChannel channel = (Netty4HttpChannel)ctx.channel().attr(Netty4HttpServerTransport.HTTP_CHANNEL_KEY).get();
        if (cause instanceof Error) {
            this.serverTransport.onException(channel, new Exception(cause));
        } else {
            this.serverTransport.onException(channel, (Exception)cause);
        }
    }
}

