/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.elasticsearch.common.settings.SecureString;

public final class AESKeyUtils {
    public static final int KEY_LENGTH_IN_BYTES = 32;
    public static final int WRAPPED_KEY_LENGTH_IN_BYTES = 40;
    private static final int KDF_ITER = 61616;
    private static final String KDF_ALGO = "PBKDF2WithHmacSHA512";
    private static final byte[] KEY_ID_PLAINTEXT = "wrapping known text forms key id".getBytes(StandardCharsets.UTF_8);

    public static byte[] wrap(SecretKey wrappingKey, SecretKey keyToWrap) throws GeneralSecurityException {
        assert ("AES".equals(wrappingKey.getAlgorithm()));
        assert ("AES".equals(keyToWrap.getAlgorithm()));
        Cipher c = Cipher.getInstance("AESWrap");
        c.init(3, wrappingKey);
        return c.wrap(keyToWrap);
    }

    public static SecretKey unwrap(SecretKey wrappingKey, byte[] keyToUnwrap) throws GeneralSecurityException {
        assert ("AES".equals(wrappingKey.getAlgorithm()));
        assert (keyToUnwrap.length == 40);
        Cipher c = Cipher.getInstance("AESWrap");
        c.init(4, wrappingKey);
        Key unwrappedKey = c.unwrap(keyToUnwrap, "AES", 3);
        return new SecretKeySpec(unwrappedKey.getEncoded(), "AES");
    }

    public static String computeId(SecretKey secretAESKey) throws GeneralSecurityException {
        byte[] ciphertextOfKnownPlaintext = AESKeyUtils.wrap(secretAESKey, new SecretKeySpec(KEY_ID_PLAINTEXT, "AES"));
        return new String(Base64.getUrlEncoder().withoutPadding().encode(ciphertextOfKnownPlaintext), StandardCharsets.UTF_8);
    }

    public static SecretKey generatePasswordBasedKey(SecureString password, String salt) throws GeneralSecurityException {
        return AESKeyUtils.generatePasswordBasedKey(password, salt.getBytes(StandardCharsets.UTF_8));
    }

    public static SecretKey generatePasswordBasedKey(SecureString password, byte[] salt) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(password.getChars(), salt, 61616, 256);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KDF_ALGO);
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), "AES");
        return secret;
    }
}

