#GLF 1.0
#D p5760 Unit Life Cell in 500x500
#D
#D This is an object which plays the Game of Life on a larger scale. This one
#D is 500 cells on a side, and represents one Cell for the larger scale. You
#D just construct a Life object to be Run by making a rectangular array of
#D these Unit Life Cells, then changing the state of the Cells to be LIVE or
#D DEAD to represent an Object to be run, and then running the whole object.
#D Each Unit Life Cell calculates its new state based on its current state and
#D that of its eight neighboring Cells using the Life rule. So the object
#D calculates the fate of the initial Object which you have put into it. This
#D is rather slow, however, since the object is rather large, and each larger
#D scale Generation takes 5760 generations to compute.
#D
#D The state of the Unit Life Cell is encoded by the presence or absence of a
#D particular glider in the Cell. This glider is contained within the upper
#D left region of the Cell between two long boats. Keeping the glider means
#D that the Cell is LIVE, and deleting the glider means that the Cell is DEAD.
#D This is the only difference between the two states at this particular
#D generation in the cycle. At other generations in the period 5760 cycle,
#D there are more differences between the two states. You can see the state of
#D the Object at any multiple of 5760 generations by seeing which Cells have
#D the presence of the glider between the boats.
#D
#D Multiple Unit Life Cells are aligned using the long boats at the corners of
#D the Cells. You should place a one cell gap between neighboring Cells; this
#D makes the offset between neighboring Cells exactly 500 cells. You should
#D always make a rectangle of Unit Life Cells, since otherwise stray gliders
#D will destroy them.
#D
#D The Unit Life Cell communicates its state to its neighbor Cells by emitting
#D eight gliders to those Cells if the current state of the Cell is LIVE. It
#D detects neighboring Cell states by capturing the incoming eight gliders, if
#D they are present. Then the Unit Life Cell counts the gliders and applies the
#D Life rule to change its state.
#D
#D Here is a detailed description of the construction of the Unit Life Cell:
#D
#D In the upper center is a fanout device made up of many glider guns and a
#D LWSS gun. This construction was originally designed by Bill Gosper. The LWSS
#D stream normally destroys all of the gliders emitted by the guns. But when a
#D LWSS is deleted by an incoming glider, then one glider escapes through the
#D hole from each of the glider guns. There are eight glider guns so as to
#D replicate the current state for each of the neighboring Cells. In addition,
#D the LWSS itself is used to save the current state of this Cell for use in
#D calculating the Life rule.
#D
#D In the left center is a "chute" made up of a number of queen bee pairs.
#D These are detectors for incoming gliders. A reaction between a queen bee
#D pair and an incoming glider results in a block which is out of the way of
#D the queen bees, and within the chute. In this way the incoming gliders (if
#D present) can arrive at various times, and their state is kept steady until
#D all of them are accumulated.
#D
#D At the bottom of the chute is a triggerable glider gun which when triggered
#D sends 10 gliders up the chute from the lower right to the upper left. (Only
#D 8 are necessary but I didn't find such a reaction and 10 is harmless.) These
#D gliders are used to sweep up the blocks which may have been left in the
#D chute by the incoming gliders. Each reaction destroys one block and one
#D glider. So when the gliders arrive at the top of the chute, the time at
#D which the first glider arrives indicates the number of blocks that were
#D swept away, and thus the number of LIVE neighboring Cells.
#D
#D At the top of the chute is a glider stream which when interrupted only
#D allows three of the gliders in the chute through (if present). Number the
#D chute gliders g0, g1, g2, g3, g4, g5, g6, g7, g8, and g9, representing the
#D number of blocks that were present. A glider hitting the stream at the right
#D time deletes three of the gliders in the stream so as to only allow gliders
#D g1, g2, and g3 through (if present).
#D
#D At the middle of the left edge is the logic circuit which calculates the
#D Life rule based on the presence of the gliders g1, g2, and g3, and the
#D presence or absence of another incoming glider which represents this Cell's
#D current state. The logic for calculating the Life rule was designed by Dean
#D Hickerson, and implemented by me. If the new state of the cell is LIVE, then
#D a glider is emitted by the circuit.
#D
#D At the upper right at the end of the LWSS stream is a bit holder, which
#D turns the absence of an LWSS into a boat. This boat holds the current state
#D of this Cell until it is required. At the appropriate time, an incoming
#D glider hits the boat (if present) to start a glider on its journey across
#D the top of the Cell to the Life rule logic.
#D
#D At the lower left, lower right, and upper right are three high period glider
#D guns. These are the "clocks" which run the Unit Life Cell's cycle and
#D determine the length of a Generation. The one at the lower right triggers
#D the stream of 10 gliders to count the number of blocks in the chute. The one
#D at the lower left triggers the opening of the glider stream to let the g1,
#D g2, and g3 gliders through. It also occasionally spits out an extra glider
#D which does no harm. The one at the upper right is used to start the glider
#D representing the current state of the Cell on its journey.
#D
#D The rest of the logic consists of glider turning reactions, and delay
#D reactions in order to route the gliders from the fanout device to the
#D neighboring cell's chute detectors. These were rather tricky to set up so
#D that nothing ran into anything else! Some of the glider turners use a pair
#D of glider guns because the small glider turner has the wrong parity for the
#D output glider.
#D
#D Here are some approximate generation numbers for important events which
#D occur during the 5760 generations which make up one Generation. Some of
#D these events only occur if the Cell or its neigbors are LIVE.
#D
#D 0:     Current state glider starts from pair of long boats
#D 400:  Current state glider arrives at fanout device
#D 600:  Output gliders escape from the fanout device
#D 900:  Missing LWSS turned into boat to hold Cell's current state
#D 1800: First glider arrives at the chute to be turned into a block
#D 4000: Last glider arrives at the chute to be turned into a block
#D .        and the high period glider guns fire
#D 4700: Stream of 10 gliders starts sweep through the chute to count
#D .        the number of blocks in the chute
#D 5200: Gliders from stream react in the Life Logic circuit to calculate
#D .        the new current state glider
#D 5760: New current state glider arrives back at the pair of long boats
#D
#D David I. Bell, January 1996
x = -249, y = -249, width = 499, height = 499
oo495boo$obo493bobo$bobo491bobo$bbo493bo8$191boo$191bo$178bo10bobo103b
oo$177bobo9boo104bo$136bo38boo3bo106bo5bobo$134b3o33boo3boo3bo105b4o3b
oo$133bo36boo3boo3bo104boobobo$133boo42bobo94boo8b3obobbo$178bo95boo9b
oobobo$286b4o$131bo155bo$130bobo$129bo3bo$130b3o250boo$128boo3boo248b
oo9$382b3o$381bo3bo$131boo247bo5bo83boo$131boo247bo5bo83boo$383bo$381b
o3bo$366boo14b3o$366boo15bo$$380boo$381bo$378b3o$366b3o9bo$366b3o$365b
o3bo99b5o$402bobo63bob3obo$364boo3boo23b3o5bo3bo62bo3bo$389boobbobbobo
7bo63b3o$387bobbobboo7bo4bo4boo57bo$386bo8bo10bo5boo$386bo11boobbo3bo$
386bo9bo5bobo$380boo5bobbo5boo75bo$379bobo7boo3bobo76bo$379bo14b3o69bo
5bobo$369boo7boo86bobobbooboo$369bo96boobbo5bo$370b3o100bo$372bo97boo
3boo$413boo21boo$401b3obbo5bo3bo19boo$397bo3bo9bo5bo3boo$395bobo4bo8bo
3boboobboo$393boo16bo5bo$30bo362boo17bo3bo$30b3o200bo159boo18boo$33bo
197bobo37bo30bo86boo4bobo$32boo189boo4boo40b3o28b3o83bobo6bo$223boo4b
oo43bo30bo82bo78bo8bo$229boo31boo9boo29boo81boo45booboboo25boo7b3o$34b
3o194bobo8boo18boo200bo3bo5b5o$34b3o196bo8bobo189bo5bo22boboo6bobobobo
$33bo3bo206bo61b3o147boo5bobo7boo3boo$32bo5bo187bo17boo60b3o126booboo
15bobo$33bo3bo187bobo77bo3bo127bo17bo$34b3o178boo6boo3bo44booboboo174b
oo8boo7boo$214bobo4boobo3bo44bo5bo24boo3boo133bo19boo7boo$213b3o4b3obo
3bo45bo3bo150boo12bo28bo$204boo6b3o4bobboobobo8boo37b3o144b3o4boo12b3o
6boo18b3o$204boo7b3o4boo4bo9bobo182b5o6boo18boo22bo$214bobo21bo20boo3b
oo154bobo3bo5b3o37b5o$215boo21boo180boo3bo6boo7b3o30boo$260bo3bo147boo
15boo$32boo195bo31b3o149bo15boo$33bo193bobo31b3o149bobo7bo47boo3boo$
30b3o195boo44bo34boo103boo7bobo46b5o$30bo242bo35bo116boo4boo18bo19boob
oo$223boo48b3o34b3o95boo16boo4boo17b3o18booboo$138boo82bobo87bo95boo
16boo22b5o18b3o$139bo72bo11bo198bobo23bobobobo$139bobo9bo60bobo45bo
162bo25boo3boo$140boo8boo49boo12boo9boo31b3o$42bo106boo4boo44boo12boo
9boo31b3o14b5o$42b3o103b3o4boobboo54boo6boo42boo6bob3obo$45bo103boo4b
oobboo51bobo7b3o32boo3boo3boo7bo3bo127b3o62boo$44boo104boo60bo10boo32b
oo3boo13b3o127booboo61boo$151bo74boo5boo43bo128booboo18boo22boo$226boo
5bobo171b5o17bobo22bo$235bo8bo29bo5boo124boo3boo17bo24b3o$235boo5bobo
27bobo5bo159bo16bo$226bo16boo28boo6b3o156boo$226bobo33boo19bo151boo4b
oo$44boo3boo158boo18boo31bo147bo24boo4b3o7boo$47bo159bo3bo17boo32b3o
144bo20bo3boo4boo8boo$44bo5bo155bo5bo16boo34bo145bo18b3o7boo$45booboo
151boobboobo3bo8bo4bobo4boo168boo24bo3bo6bo$46bobo152boo3bo5bo9bo3bo6b
obo165bobbo5bo13boobbob3obo$47bo159bo3bo5bobb3o12bo164bo9bo13boo3b5o$
47bo67bo93boo24boo155boo6bo13boo$114bobo275boo6bo12bobo8bo$115bobo283b
obbo9bo8bobo$116bobo104boo178boo18bobo$117boo103bobo199bo$46boo176bo4b
o29bo29bo$46boo179bobo27bobo27bobo$120b3o105boo28boo28boo131booboboo$
122bo85bobo210bo5bo$121bo85bobbo3boo206bo3bo$198boo6boo5b3oboobboo200b
3o4boo$125boo71boo4boo3bo3bo3bo3bobo206boo$125bobo78boo5bobo8bo$126bob
o78bobbobboo6bobbo$127bobo78bobo13bo$128bo92bobo6boo$221boo7bobo193boo
$232bo148bo4bo39bo$232boo145boob4oboo38b3o$222bobo156bo4bo42bo$221bobb
o19bo29bo29bo$211bo8boo20bobo27bobo27bobo$210bobo5boo3bo19boo28boo28b
oo$210boobo6boo$198boo10booboo6bobbo5boo$198boo10boobo8bobo5bobo154bo$
210bobo19bo102boo48bobo$211bo20boo102bo46boo$336bobo6bo37boo$163boo57b
oo113boo4bobo37boo$163boo57boo118bobo34boo4bobo$160boo10bo4bo163bobbo
11boo20bobo6bo$148bobo8b3o10bo4bobo162bobo11boo20bo$148bo3bo7boo10bo7b
oo13boo146bobo31boo16boo3boo$132bo19bo10boobboo11boo14bo148bo49boo3boo
$130b4o14bo4bo9boobbobboo8boo14bobo5boo9b3o11bo29bo29bo29bo76b5o19boo$
129boboboo4bo12bo15b4o5bobo4boo11boo5bobbo9bo9bobo27bobo27bobo27bobo
77bobo21bo$124boobbobbob3o5boobo3bo3bo16bo7bo6bobo21bo7bo5bo5boo28boo
28boo28boo101bobo6bo$124boo3boboboo5b4obobbobo35bo21bo12b4o172b3o22boo
4bobo$130b4o6boobboo40boo20bo11boobobo200boo18boo$132bo36boo9boo22bobb
o11b3obobbo199boo17bo3bo$25boo6boo125bobo5bobbobb3obbobbo21boo14boobob
oo199boo16bo5bo$24bobbo4bobbo124boo6b3obb5obb3o38b4ob3o166boo31bobo4bo
8bo3boboobboo$24bobbo4bobbo125bo9b9o42bo4bobo166bo33bo3bo9bo5bo3boo$
24bobbo4bobbo134bo9bo48bo163b3o38b3obbo5bo3bo$25boo6boo115bobo17boo7b
oo48boo162bo52boo$151boo$151bo$$162b4o26b4o26b4o26b4o26b4o26b4o26b4o
26b4o26b4o$161bo3bo25bo3bo25bo3bo25bo3bo25bo3bo25bo3bo25bo3bo25bo3bo
25bo3bo21boo$136boo27bo29bo29bo29bo29bo29bo29bo29bo29bo21boo$137bo23bo
bbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo$137bobo4bo
8bobbo285bo$138boo3bobo10bo282b4o$141boo3bo5boo3bobbo57boo206boo10b4o
9boo$37boo102boo3bo4boboboo3b4o54bo207bobo9bobbo9boo$38bo102boo3bo14b
4o5boo35boo7bobo198b3oboo4b3o8b4o5bo$35b3o56boo47bobo5boo8bobbo5boo35b
3o6boo4b3o27b3o27b3o27b3o102b4obbo4b3o8b4o4bo$35bo56bo3bo47bo16b4o28bo
15boobo11bo29bo29bo29bo106boo4b3o12bo$91bo5bo13boo47b4o27bobo4b3o8bobb
o10bo29bo29bo29bo112bobo$86boobboobo3bo13boo47bo29bobo16boobo213boo$
86boo3bo5bo10boo74boo3bobbo7bobboobb3o$92bo3bo10b3o74boo4bobo7bo3bobb
oo$94boo12boo81bobo6bobbo$99bobo9boo5boo73bo8boo$99boo10boo5bobo$100bo
19bo$120boo5$196boo9b3o11boo14b3o27b3o27b3o$105boo9bo71bo7bobbo9bo11bo
17bo29bo29bo$104b4o7bobo69bo3boo7bo7bo5bo4bobo16bo29bo29bo$99bobobbobb
3o5boobo68bo5bo6bo12b4ob3o$98bobbobboo9booboo3boo63b5o7bo11booboboo$
97boo9bo6boobo4boo71bobbo11b3obobbo$95boo3bo8bo5bobo78boo14boobobo$67b
o16bobo10boo10bo6bo96b4o$62b3oboobboo12boo5boo5bobbo112bo$62b4o4boo13b
o4bobo6bobo119boo$66boo22bo130bo$89boo119bobo6bobo$208bo3bo6boo$200bo
7bo$199b4o4bo4bo$198boobobo4bo13b3o27b3o27b3o$160bo26boo8b3obobbo3bo3b
o11bo29bo29bo$158b3o26boo9boobobo6bobo10bo29bo29bo$157bo41b4o$157boo
41bo$23bo187bo$19boobboob3o34boo144bobo$19boo4b4o26bo7bobo3bobo138boo$
23boo30b3o5bo5boo$13boo15b3o25bo11bo143boo$13boo17bo24boo131boo22boo$
31bo159bo$36bo154bobo6bobo21boo47boo$34b3o155boo5bobbo3boo16bo48b3o$
33bo50bo68b5o31bo8boo5b3oboobboo7bobo$33boo49b3o65bob3obo28b3o6boo3bo
3bo3bo3bobo6boo13b3o27b3o5b3o$12b3o72bo65bo3bo28bo11boo5bobo8bo22bo29b
o5boboo$11booboo50bo19boo66b3o29boo11bobbobboo6bobbo21bo29bo6b4o$11boo
boo50b3o86bo44bobo13bo25boo$11b5o4boo47bo143bobo27bo$10boo3boo22bobbob
oobobbo17boo143boo28bobo5bobo$20bobbo15b4oboob4o27boo8b3o27boo104boo
18boo3bo3bo5b3o$24bo5b3o6bobboboobobbo27bobo6booboo26bo35boo68bo24bo7b
obobbobboo$16bo5bo6bo3bo44bo8booboo24bobo35boo27b3o4boo25bo4bobo23bo4b
o7boobbobbo15boo9boo183boo$15boboo9bo5bo52b5o24boo23bo40bo3bo4bo24bobo
3boo25bo19bo13boo9bobo183bo$15bo12bo5bo51boo3boo46b3o49bobo5boo15boobo
29bo3bobb3o10bo8bo6bo7b3o174boo6bobo$79boo57bo42bo5bo4boo5bobo14booboo
30bobo15bo7bobo12b3o174bobo5b3o$15boobo9bo41b3o5bobo57boo41boo3boo14bo
13boobo45bobbo6boo3bo12b3o163boo7bo6b3o$13bobbo11boo39bo3bo6bo5bo112bo
bbo13bobo46boo8boo3bo13bobo5boo155boo7bobbobbobbo$13bobo12boo38bo5bo9b
oobo114bo8bo5bo57boo3bo14boo5bobo163bo6boo$27boobbo36bo5bo12bo20boo74b
o14bobo7bobo10b3o52bobo24bo164bobo$28bobo76bobo73bobo13boo9boo12bo53bo
25boo164boo$29boo43bo9boboo21bo26bo46bobo37bo$73boo11bobbo45b3o47bo$
14b3o56boo12bobo44b5o46bo$13bo3bo8boo3boo38bobboo57bobobobo42bobbo$12b
o5bo7boo3boo39bobo58boo3boo43boo32boo116bo$13bo3bo54boo38boo103boo116b
3o$14b3o11b3o69b3o8b3o40boo182bo$14b3o11b3o55b3o13bo5boboo24bo17bo49bo
22boo108boo$29bo40boo3boo8bo3bo11bo6bobbo4b3o16boboo4boo7bobo49bobo20b
o$70boo3boo7bo5bo17boboo5boboo14bo7bobo6boo39boo12boo9boo5bobo$85bo3bo
13boo6b3o3boboo15bobbo6bo46boo12boo9boo5boo$15boo55b3o11b3o13bobo7boo
4bobo19bobbobbo60boo6boo$15boo55b3o11b3o13bo35boo6bo57bobo7b3o$73bo19b
oo6boo40bobo16bo41bo10boo120boo3boo$28boo54boo6bobo48boo15b3o55boo120b
o$28boo55bo8bo22boo3boo35bo58boo117bo5bo$82b3o35bo38boo30boo145booboo$
70boo10bo34bo5bo67bo147bobo$71bo46booboo33b3o21bobo6bobo148bo9bobo$68b
3o48bobo34b3o21bo3bo4boo149bo8bobbo$68bo51bo34bo3bo24bo163boo$85b3o32b
o33bo5bo9boo8bo4bo160boo3bo82bo$87bo67bo3bo10boo12bo163boo82b3o$76bo9b
o10boo57b3o21bo3bo164bobbo5boo71bo$75bobo19bo19boo61bobo167bobo5bobo
70boo$63boo10boobo8bobo5bobo20bo241bo47bo$63boo10booboo6bobbo5boo18b3o
13bo70boo19boo135boo44b3o$75boobo6boo28bo13bobo43boo26bo19bo128bo52bo$
75bobo5boo3bo39bobo44bo27bobo7boo6bobo126b3o52boo22bo$76bo8boo40bobbo
10bo26bo4bobo28boo5bobbo6boo126bo77booboo35boo19boo$86bobbo38bobo11bo
24bobo3boo35bo138boo117bo19bo$87bobo34boo3bobo10bo13boo9boobo39bo6bo
208bo5bo35bobo6bo8bobo$123bobo5bo35booboo38bo7boo127bo121boo6b4o5boo$
123bo43boobo40bobbo131bobo77booboboo45b4o$122boo43bobo13bo29boo130bo3b
o128bobbo$168bo12b3o161b5o128b4o$180bo163boo3boo49boo3boo70b4o$181bo
163b5o51b5o71bo$178bobbo164b3o52booboo$139b5o33bo169bo53booboo$138bob
3obo31bo3bo221b3o21boo$139bo3bo34bo248bo$140b3o32bo5bo242b3o$141bo33bo
5bo242bo$176bo3bo219boo$138boo37b3o221bo$139bo204boo52b3o$136b3o13boo
191bo52bo$136bo15bobo41boo144b3o$153b3o40bo145bo$154b3o32bo4bobo$153b
3o32b4ob3o50boo20boo$145boo5bobo32booboboo53bo20bo$144bobo5boo32b3obo
bbo53bobo6boo8bobo$144bo42boobobo55boo6bobbo6boo$143boo43b4o12bo55bo$
161b3o25bo12b3o48bo6bo$160bo3bo36bo49boo7bo$201boo53bobbo$159bo5bo90b
oo$159boo3boo5$196boo3boo$159boo36b5o$160bo36booboo$157b3o12bo24booboo
$108bo9boo37bo12b4o24b3o16boo$107bobo7b4o48boboboo42bo$106boboo6bobobo
bbobo42bobbob3o31bobo5bobo$100boo3booboo7booboobobbo41booboboo31bobbo
5boo$100boo4boboo7boobo5boo38b3ob4o31boo$107bobo8boo4bo3boo35bobo4bo
30boo3bo$108bo7b3o7boo37bo39boo$118bo4bobbo5boo30boo40bobbo$116bo6bobo
6bobo72bobo$117boo15bo$134boo46b3o$181bo3bo$180bo5bo$180bo5bo$100boo9b
oo70bo29boo$100bobo9boo67bo3bo25bobbo$91b3oboo4b3o7bo6bo65bo11bo7bo5bo
7b5o$91b4obbo4b3o12bobo60bobbo10b4o5boo5bo6bo5bo$95boo4b3o12bo3boo58bo
12boboboo4boo5bo7boo3bo$100bobo13bo3boo40bo18bo10bobbob3o11bobbo7bo$
100boo14bo3boo40b3o13b3o11booboboo14boo$117bobo3boo40bo12bo11b3ob4o$
34bo83bo4bobo38boo23bobo4bo$34b3o88bo63bo25bo$37bo87boo41bo19boo25b3o$
36boo130bo49bo$191bo17boo6boo$38b3o150b3o15bobo$38b3o123boo3boo23bo14b
o$37bo3bo123b5o23boo$36bo5bo123b3o$20bo16bo3bo125bo$20b3o15b3o$23bo
171b3o$22boo170booboo17b3o$194booboo17bo19boo$194b5o18bo18boo$40boobo
149boo3boo$41boo121boo$165bo$22boo3boo133b3o46boo23bo$22bo5bo133bo48b
oo11boo9b3o$224bobo7bo3bo$23bo3bobboo192bo8bob3obo$24b3o4boo8bo192b5o$
30bo9b3o155boo$39b5o154bo$38bobobobo154b3o72bobo$38boo3boo156bo70bo3bo
$231b3o38bo$231bo33boo4bo4bo$27bo13bo190bo32boo5bo$25booboo10bobo229bo
3bo7boo$40bobo231bobo7bobo$24bo5bo10bo244bo$40boo244boo$24booboboo9boo
230boo$40boo230bo$233b3o28bo5bobo$232bo3bo26bobo4boo$231bo5bo24bo3boo$
231booboboo24bo3boo$262bo3boo$253boo8bobo$252bobo9bo$27boo21boo200bo$
27boo22bo199boo$51bobo8boo167boo$52boo7bobo168bo$60bo6boo160b3o$60bobb
obbobboboo156bo$60bo6boobboo$61bobo$62boo259bo$318bo4b4o$318bo5b4o$
276bo36boo9bobbo$271bo4b4o33boo9b4o$271bo5b4o42b4o5boo$266boo9bobbo42b
o8bobo$266boo9b4o53bo49boo$276b4o5boo47boo48boo$276bo8bobo$287bo$287b
oo98bo$386bo$386bo3$79boo301boo3boo$79b3o303bo$81boobo5boo290bo5bo$81b
obbo5boo291booboo$81boobo299bobo$71boo6b3o303bo8bo$70bobo6boo304bo6bob
o$70bo320bobo11boo$69boo319bobbo11boo$107bo283bobo$107b3o282bobo$110bo
283bo16bo$109boo273bo24b3o$383bobo22bo$112bo271boo22boo$111bobo$110bo
3bo290b3o$111b3o291b3o$109boo3boo288bo3bo$403bo5bobboo$79boo294boo27bo
3bo3boo$79boo294boo28b3o$378boo$66boo31boo277b3o5boo$66boo14bo14bo3bo
276boo6boo$81bo9boo3bo5bo265boo5boo$81bo9boobboobo3bo264bobo5boo35b3o$
96bo5bo264bo14boo27booboo$97bo3bo264boo12bo3bo11bo14booboo$77boo3boobb
o12boo273boo3bo5bo9bobo13b5o$80bo5b3o285boobboobo3bo10boo12boo3boo$77b
o5bo5bo23boo264bo5bo20boo$78booboo5boo23boo265bo3bo21boo$65b3o11bobo
300boo42bo$64bo3bo11bo344bobo$63bo5bo10bo344boobo4boo$63bo5bo355booboo
3boo$66bo358boobo$64bo3bo21b3o27bobo267b3o32bobo$65b3o21bo3bo26bo3bo
264bo3bo32bo$66bo21bo5bo29bo287bo$76bobo9booboboo15boo8bo4bo262bo5bo
16bobo$76boo32boo12bo263boo3boo17boo$63b3o11bo3b3o36bo3bo3boo$63b3o14b
o3bo6bo28bobo5bobo$62bo3bo12bo5bo4bobo18boo17bo260bo26boo$70bobo6boobo
boo4bobo9boo7bobbo15boo258bobo25bobo$61boo3boo3boo18bo9b3o11bo6boo266b
obo25bo$71bo30boboo9bo6boo268bo12boo5bo$90boo23bo276bo11b3o3bo3bo$90b
oo13bo5bobbo274bobbo8boboo5bo$111boo182bo94boo9bobbo4bo5bo$84boo18bo
188b3o105boboo9boo$84bo20bo186bo103boo6b3o11bo$85b3o17bo186boo101bobo
7boo11b3o$66boo19bo307bo25bo$66bo327boo24boo$67b3o$69bo33boo3boo179b3o
$104b5o179booboo$104booboo179booboo16bo$73bobboo15bobo8booboo179b5o14b
3o$72bo3boobboo11bobbo8b3o179boo3boo12bo114boo$72bo7boo14boo208boo109b
oobboo$73b4o17bo3boo187boo15b3o110boo$96boo190boo13bobo$85boo6bobbo5b
oo4boo175booboo12bo3bo$84bobo6bobo6bobo3bo193b5o145boo$84bo19bo4b3o
180boo7boo3boo112boo18b3obbo5bo3bo$83boo19boo5bo173bo8bo7b5o114boo13bo
3bo9bo5bo3boo$287boobobo10b3o104bo9bo13bobo4bo8bo3boboobboo$304bo105bo
bo19boo16bo5bo$398boo11bobo9boo7boo17bo3bo$299boo97boo11bobbo7b3o7boo
18boo$299bobo109bobo5boboo5boo4bobo$299bo110bobo6bobbo4bobbo5bo$287b3o
120bo8boboo5boo$208bo77bo3bo131b3o$203bo4b4o73bo5bo131boo$203bo5b4o73b
o3bo$198boo9bobbo74b3o$198boo9b4o74b3o$208b4o5boo82b3o$208bo8bobo70boo
8bo3bo$219bo70bo$219boo70b3o5bo5bo$293bo5boo3boo3$302bo$301bobo$301bob
o$303bo$303bo$300bobbo$301boo10$bbo493bo$bobo491bobo$obo493bobo$oo495b
oo!
