%ifdef CONFIG
{
  "RegData": {
    "XMM1": ["0x48510f254d2f5b7f", "0x2b5774313ad348ea"],
    "XMM2": ["0x30a9567b1f6d776b", "0x673d5d0730c6762c"],
    "XMM3": ["0x41159b533d5b4c09", "0xca64724c74043978"],
    "XMM4": ["0x24426b4c72f2101c", "0x656780205f15c767"],
    "XMM5": ["0x4f1694df78236612", "0x19826b033d3c78c0"],
    "XMM6": ["0x00f9589268e0127f", "0x1e7d27031e881972"],
    "XMM7": ["0x1c4c4322f8f65504", "0x07f565f98b1bb7bc"],
    "XMM8": ["0x10c41f28710f2147", "0x09925e327f5e2938"]
  },
  "HostFeatures": ["SSE4.1"]
}
%endif

lea rdx, [rel .data]
lea rdi, [rel .mask]

movaps xmm1, [rdx + 16 * 0]
movaps xmm2, [rdx + 16 * 1]
movaps xmm3, [rdx + 16 * 2]
movaps xmm4, [rdx + 16 * 3]
movaps xmm5, [rdx + 16 * 4]
movaps xmm6, [rdx + 16 * 5]
movaps xmm7, [rdx + 16 * 6]
movaps xmm8, [rdx + 16 * 7]

; pblend uses xmm0 implicitly
movaps xmm0, [rdx + 16 * 0]
pblendvb xmm1, [rdx + 16 * 8]
movaps xmm0, [rdx + 16 * 1]
pblendvb xmm2, [rdx + 16 * 9]
movaps xmm0, [rdx + 16 * 2]
pblendvb xmm3, [rdx + 16 * 10]
movaps xmm0, [rdx + 16 * 3]
pblendvb xmm4, [rdx + 16 * 11]
movaps xmm0, [rdx + 16 * 4]
pblendvb xmm5, [rdx + 16 * 12]
movaps xmm0, [rdx + 16 * 5]
pblendvb xmm6, [rdx + 16 * 13]
movaps xmm0, [rdx + 16 * 6]
pblendvb xmm7, [rdx + 16 * 14]
movaps xmm0, [rdx + 16 * 7]
pblendvb xmm8, [rdx + 16 * 15]

hlt

align 16
; 256bytes of random data
.data:
db 0x7f, 0xa4, 0x2f, 0x4d, 0x25, 0x0f, 0x51, 0x48, 0x86, 0x48, 0x97, 0x3a, 0x31, 0x74, 0x57, 0x2b
db 0x6b, 0xe8, 0x6d, 0x1f, 0xde, 0x56, 0xb5, 0x30, 0x2c, 0x76, 0xae, 0x30, 0xf3, 0x9a, 0xd2, 0x67
db 0x09, 0xad, 0xe8, 0x3d, 0x53, 0xb9, 0x15, 0xb6, 0x90, 0xb8, 0x04, 0x74, 0xa3, 0x72, 0x64, 0xb7
db 0xad, 0x10, 0xf1, 0x72, 0x4c, 0x6b, 0x42, 0x24, 0x67, 0xa5, 0x15, 0xd4, 0xf2, 0x89, 0x67, 0x8a
db 0x12, 0x66, 0x23, 0x78, 0x81, 0xf8, 0x96, 0x89, 0xa9, 0xa2, 0x3c, 0x3d, 0x82, 0x6b, 0xa2, 0x19
db 0xb0, 0x12, 0x97, 0x68, 0xab, 0x58, 0xf6, 0x00, 0x72, 0x19, 0xd2, 0x1e, 0x03, 0x9d, 0x7d, 0xc9
db 0xc8, 0x55, 0xdf, 0x98, 0x22, 0x43, 0x86, 0x1c, 0xcc, 0xe9, 0x1b, 0x89, 0xda, 0xfe, 0x9b, 0xb2
db 0x47, 0x21, 0x0f, 0x71, 0x28, 0xbd, 0xb0, 0x88, 0x38, 0xac, 0xb5, 0x7f, 0x88, 0x5e, 0xe9, 0xc4
db 0xe4, 0x5b, 0x3e, 0xd0, 0x2a, 0x8c, 0xdf, 0xa7, 0xea, 0x95, 0xd3, 0xc2, 0xee, 0xd1, 0x70, 0x6c
db 0x18, 0x77, 0xc1, 0x38, 0x7b, 0xfc, 0xa9, 0x58, 0x92, 0xe8, 0xc6, 0xcd, 0x07, 0x5d, 0x3d, 0x76
db 0xf4, 0x4c, 0x5b, 0x25, 0x7f, 0x9b, 0x02, 0x41, 0x78, 0x39, 0x9e, 0x3e, 0x4c, 0xa2, 0x79, 0xca
db 0x1c, 0xe9, 0xf2, 0x9a, 0xaf, 0x6d, 0xfa, 0x57, 0x10, 0xc7, 0xfd, 0x5f, 0x20, 0x80, 0xf5, 0x65
db 0x3c, 0x77, 0xfb, 0xa8, 0xdf, 0x94, 0x16, 0x4f, 0xc0, 0x78, 0x00, 0x76, 0x03, 0x8c, 0x82, 0x10
db 0x7f, 0x07, 0xe0, 0x02, 0x92, 0xbb, 0xf9, 0x2e, 0xfa, 0x3d, 0x88, 0xc8, 0x24, 0x27, 0xa6, 0x1e
db 0x04, 0x90, 0xf6, 0xf8, 0x76, 0x0a, 0x4c, 0x94, 0xbc, 0xb7, 0x8d, 0x8b, 0xf9, 0x65, 0xf5, 0x07
db 0x7f, 0xc1, 0x37, 0x78, 0xa1, 0x1f, 0xc4, 0x10, 0x6c, 0x29, 0x5e, 0x7e, 0x32, 0x24, 0x92, 0x09
.mask:
db 0xb5, 0xdb, 0xca, 0x08, 0x0a, 0xae, 0x17, 0xb6, 0x54, 0x0d, 0xd3, 0xa1, 0x1d, 0x28, 0x25, 0xd3
db 0x02, 0xf5, 0xce, 0x94, 0x2e, 0x56, 0x01, 0xf4, 0xae, 0x81, 0xbe, 0x50, 0x70, 0x45, 0x83, 0x18
db 0x33, 0x46, 0x60, 0x4e, 0x29, 0xe4, 0x49, 0xae, 0xc2, 0x0e, 0x70, 0xcd, 0x2a, 0x6f, 0xb8, 0x9d
db 0x47, 0x1e, 0x8e, 0x94, 0x81, 0xaa, 0x12, 0xe4, 0x8e, 0x77, 0x48, 0x34, 0x63, 0x8f, 0x4c, 0x57
db 0x34, 0xf9, 0x5b, 0x37, 0x76, 0x9f, 0xff, 0x8c, 0x6b, 0xf2, 0x6e, 0xd0, 0x15, 0x61, 0x4e, 0x0f
db 0xe2, 0xa7, 0xd0, 0x73, 0x7f, 0xf0, 0xae, 0xe7, 0x48, 0x32, 0x2a, 0x56, 0xc3, 0x29, 0x12, 0x4f
db 0x7d, 0x5b, 0x37, 0xc2, 0x83, 0x74, 0xd2, 0xf9, 0xcc, 0x98, 0x0a, 0x3c, 0x3c, 0x38, 0xd9, 0x4d
