﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-messaging/model/InvocationType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace ChimeSDKMessaging {
namespace Model {
namespace InvocationTypeMapper {

static const int ASYNC_HASH = HashingUtils::HashString("ASYNC");

InvocationType GetInvocationTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ASYNC_HASH) {
    return InvocationType::ASYNC;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<InvocationType>(hashCode);
  }

  return InvocationType::NOT_SET;
}

Aws::String GetNameForInvocationType(InvocationType enumValue) {
  switch (enumValue) {
    case InvocationType::NOT_SET:
      return {};
    case InvocationType::ASYNC:
      return "ASYNC";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace InvocationTypeMapper
}  // namespace Model
}  // namespace ChimeSDKMessaging
}  // namespace Aws
