#define _LARGEFILE64_SOURCE
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "conf.h"
#include "error.h"
#include "sa.h"
#include "db.h"
#include "split.h"
#include "stats.h"
#include "utils.h"
#include "br.h"


int main(int argc, char *argv[])
{
	char *conf_file = "btail.conf";

	if (argc > 2)
	{
		fprintf(stderr, "Usage: %s [configurationfile]\n", argv[0]);
		return 1;
	}
	else if (argc == 2)
	{
		conf_file = argv[1];
	}

	conf *config = load_config(conf_file);

	int fd = open64(config -> logfile, O_RDONLY);
	if (fd == -1)
	{
		fprintf(stderr, "Error opening file %s: %s\n", config -> logfile, strerror(errno));
		return 3;
	}
	buffered_reader	br(fd);

	void *c_db_handle  = open_database(config -> conf_db_parameters, DB_OPEN_READ);
	void *wg_db_handle = open_database(config -> good_db_parameters, DB_OPEN_READ);
	void *wb_db_handle = open_database(config -> bad_db_parameters,  DB_OPEN_READ);

	char *dummy = retrieve_from_database(c_db_handle, "bad");
	int n_bad_lines = atoi(dummy);
	free(dummy);

	dummy = retrieve_from_database(c_db_handle, "good");
	int n_good_lines = atoi(dummy);
	free(dummy);

	for(;;)
	{
		char *line;

		for(;;)
		{
			line = br.read_line();

			if (line) break;

			usleep(100000);
		}

		double value = calculate(wg_db_handle, wb_db_handle, line, n_good_lines, n_bad_lines);

		if (value < 0.0)
			printf("%.4f\t%s\n", value, line);

		free(line);
	}

	close_database(wb_db_handle);
	close_database(wg_db_handle);
	close_database(c_db_handle);

	return 0;
}
