/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.eso.cpl.ScriptSyntax;
import org.eso.cpl.gui.ExtensionFileFilter;

public class CommandSequence {
    private final ScriptSyntax syntax_;
    private Map macros_ = new HashMap();
    private StringBuffer buffer_ = new StringBuffer();

    public CommandSequence(ScriptSyntax syntax) {
        this.syntax_ = syntax;
        this.append(this.syntax_.startScript());
        this.append(this.syntax_.blankLine());
        String header = new StringBuffer().append("Written by ").append(this.getClass().getName()).append(" for ").append(System.getProperty("user.name")).append(" at ").append(new Date()).toString();
        this.append(this.syntax_.commentLine(header));
    }

    public void invokeCommand(String text) {
        this.append(this.syntax_.invokeCommand(text));
    }

    public void defineMacro(String name, String value) {
        if (!this.macros_.containsKey(name = this.syntax_.namify(name)) || !value.equals(this.macros_.get(name))) {
            this.macros_.put(name, value);
            this.append(this.syntax_.defineMacro(name, value));
        }
    }

    public void defineMacro(String name, List valueLines) {
        this.defineMacro(name, valueLines.toArray(new String[0]));
    }

    public void defineMacro(String name, String[] valueLines) {
        name = this.syntax_.namify(name);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < valueLines.length; ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(valueLines[i]);
        }
        String effectiveValue = buf.toString();
        if (!this.macros_.containsKey(name) || !effectiveValue.equals(this.macros_.get(name))) {
            this.macros_.put(name, effectiveValue);
            this.append(this.syntax_.defineMacro(name, valueLines));
        }
    }

    public String useMacro(String name) {
        name = this.syntax_.namify(name);
        return this.syntax_.useMacro(name);
    }

    public String quoteWord(String text) {
        return this.syntax_.quoteWord(text);
    }

    public void commentLine(String text) {
        this.append(this.syntax_.commentLine(text));
    }

    public void blankLine() {
        this.append(this.syntax_.blankLine());
    }

    public StringBuffer getBuffer() {
        return this.buffer_;
    }

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.syntax_.getExtension(), this.syntax_.getName() + " files");
    }

    public String getSyntaxName() {
        return this.syntax_.getName();
    }

    private void append(String text) {
        this.buffer_.append(text);
    }
}

