/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.File;
import java.io.IOException;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameType;

public class Frame {
    private File file_;
    private String tag_;
    private FrameType type_;
    private FrameGroup group_;
    private FrameLevel level_;
    private String canonicalPath_;

    public Frame() {
    }

    public Frame(File file) {
        this.setFile(file);
    }

    public Frame(Frame frame) {
        this();
        this.setFile(frame.getFile());
        this.setTag(frame.getTag());
        this.setType(frame.getType());
        this.setGroup(frame.getGroup());
        this.setLevel(frame.getLevel());
    }

    public File getFile() {
        return this.file_;
    }

    public String getCanonicalPath() {
        return this.canonicalPath_;
    }

    public void setFile(File file) {
        this.file_ = file;
        try {
            this.canonicalPath_ = this.file_.getCanonicalPath();
        }
        catch (IOException e2) {
            this.canonicalPath_ = this.file_.getAbsolutePath();
        }
    }

    public String getTag() {
        return this.tag_;
    }

    public void setTag(String tag) {
        this.tag_ = tag;
    }

    public FrameType getType() {
        return this.type_;
    }

    public void setType(FrameType type) {
        this.type_ = type;
    }

    public FrameGroup getGroup() {
        return this.group_;
    }

    public void setGroup(FrameGroup group) {
        this.group_ = group;
    }

    public FrameLevel getLevel() {
        return this.level_;
    }

    public void setLevel(FrameLevel level) {
        this.level_ = level;
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Frame other = (Frame)obj;
        return Frame.sameValue(this.canonicalPath_, other.canonicalPath_) && Frame.sameValue(this.tag_, other.tag_) && Frame.sameValue(this.group_, other.group_) && Frame.sameValue(this.level_, other.level_) && Frame.sameValue(this.type_, other.type_);
    }

    public int hashCode() {
        int result = 23;
        result = 17 * result + Frame.hashValue(this.canonicalPath_);
        result = 17 * result + Frame.hashValue(this.tag_);
        result = 17 * result + Frame.hashValue(this.group_);
        result = 17 * result + Frame.hashValue(this.level_);
        result = 17 * result + Frame.hashValue(this.type_);
        return result;
    }

    private static boolean sameValue(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    private static int hashValue(Object o) {
        return o == null ? -1 : o.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getFile().getPath());
        if (this.group_ != null) {
            buf.append(" group=").append(this.group_);
        }
        if (this.level_ != null) {
            buf.append(" level=").append(this.level_);
        }
        if (this.type_ != null) {
            buf.append(" type=").append(this.type_);
        }
        if (this.tag_ != null) {
            buf.append(" tag=\"").append(this.tag_).append('\"');
        }
        return buf.toString();
    }
}

