/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.eso.gasgano.gui.PropertyCellEditor;
import org.eso.gasgano.gui.PropertyEditorSubPanel;
import org.eso.gasgano.properties.GasProp;

public class DBPanel
extends PropertyEditorSubPanel
implements ActionListener {
    private GasProp gpi;
    private JButton insertRow;
    private JButton deleteRow;
    private JTable table;
    private JScrollPane scrollPane;
    private JCheckBox obsStatReq;
    private JCheckBox databaseReq;
    private JTextField obServerUrl;
    private JTextField obUserName;
    private JTextField dbServerUrl;
    private JTextField dbServerId;
    private JTextField dbUserName;
    private JPanel lowerPanel;
    private Vector obManagedVector = new Vector();
    private Vector dbManagedVector = new Vector();
    private ATModel tableModel;

    public DBPanel(GasProp gp) {
        JPanel buttonsPanel = new JPanel();
        JPanel jpDataBase = new JPanel(new BorderLayout());
        JPanel jpDataBaseMain = new JPanel(new BorderLayout());
        JPanel jpTable = new JPanel(new BorderLayout());
        JPanel jplo = new JPanel();
        JPanel jpro = new JPanel();
        JPanel jpld = new JPanel();
        JPanel jprd = new JPanel();
        this.table = new JTable();
        this.tableModel = new ATModel(gp);
        this.table.setModel(this.tableModel);
        this.table.setDefaultEditor(this.table.getColumnClass(1), new PropertyCellEditor());
        DefaultTableCellRenderer colorColumnRenderer = new DefaultTableCellRenderer();
        colorColumnRenderer.setBackground(Color.pink);
        this.table.setCellSelectionEnabled(false);
        TableColumn mColumn = this.table.getColumn("Label");
        mColumn.setMinWidth(200);
        mColumn.setCellRenderer(colorColumnRenderer);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(100, 240));
        this.scrollPane.setMaximumSize(new Dimension(100, 240));
        this.insertRow = new JButton("Insert Row");
        this.insertRow.addActionListener(this);
        this.deleteRow = new JButton("Delete Row");
        this.deleteRow.addActionListener(this);
        this.obServerUrl = new JTextField(20);
        this.obUserName = new JTextField(20);
        this.dbServerUrl = new JTextField(20);
        this.dbServerId = new JTextField(20);
        this.dbUserName = new JTextField(20);
        this.obsStatReq = new JCheckBox("Display OB Status (from database)");
        this.obsStatReq.addActionListener(this);
        this.databaseReq = new JCheckBox("Read observations from database");
        this.databaseReq.addActionListener(this);
        buttonsPanel.add(this.insertRow);
        buttonsPanel.add(this.deleteRow);
        jpTable.add((Component)this.scrollPane, "North");
        jpTable.add((Component)buttonsPanel, "South");
        jplo.setLayout(new GridLayout(2, 1));
        jplo.setBorder(new EmptyBorder(3, 3, 3, 3));
        jpro.setLayout(new GridLayout(2, 1));
        jpro.setBorder(new EmptyBorder(3, 3, 3, 3));
        jplo.add(new JLabel("server URL:", 4));
        jplo.add(new JLabel("username:", 4));
        jpro.add(this.obServerUrl);
        jpro.add(this.obUserName);
        this.addToManaged(this.obServerUrl, this.obManagedVector);
        this.addToManaged(this.obUserName, this.obManagedVector);
        jpDataBase.add((Component)jplo, "West");
        jpDataBase.add((Component)jpro, "Center");
        jpDataBaseMain.setBorder(new EmptyBorder(10, 3, 20, 3));
        jpDataBaseMain.add((Component)this.obsStatReq, "North");
        jpDataBaseMain.add((Component)jpDataBase, "South");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)jpDataBaseMain, "Center");
        this.add((Component)jpTable, "South");
        buttonsPanel = new JPanel();
        jpDataBase = new JPanel(new BorderLayout());
        jpDataBaseMain = new JPanel(new BorderLayout());
        jpDataBaseMain.setBorder(new EmptyBorder(10, 3, 10, 3));
        jpld.setLayout(new GridLayout(3, 1));
        jpld.setBorder(new EmptyBorder(3, 3, 3, 3));
        jprd.setLayout(new GridLayout(3, 1));
        jprd.setBorder(new EmptyBorder(3, 3, 3, 3));
        jpld.add(new JLabel("server URL:", 4));
        jpld.add(new JLabel("server ID:", 4));
        jpld.add(new JLabel("username:", 4));
        jprd.add(this.dbServerUrl);
        jprd.add(this.dbServerId);
        jprd.add(this.dbUserName);
        this.addToManaged(this.dbServerUrl, this.dbManagedVector);
        this.addToManaged(this.dbServerId, this.dbManagedVector);
        this.addToManaged(this.dbUserName, this.dbManagedVector);
        jpDataBase.add((Component)jpld, "West");
        jpDataBase.add((Component)jprd, "Center");
        jpDataBaseMain.add((Component)this.databaseReq, "North");
        jpDataBaseMain.add((Component)jpDataBase, "South");
        this.add((Component)jpDataBaseMain, "North");
        this.loadProperties(gp);
    }

    @Override
    public void loadProperties(GasProp gp) {
        String urlString;
        JComponent placeHolder;
        int i;
        this.gpi = gp;
        this.table.getDefaultEditor(this.table.getColumnClass(0)).cancelCellEditing();
        this.tableModel.loadProperties(gp);
        if (gp.getProperty("OB_STATUS_FROM_DB_REQUIRED") != null && gp.getProperty("OB_STATUS_FROM_DB_REQUIRED").equals("true")) {
            this.obsStatReq.setSelected(true);
            for (i = 0; i < this.obManagedVector.size(); ++i) {
                placeHolder = null;
                placeHolder = (JComponent)this.obManagedVector.elementAt(i);
                placeHolder.setEnabled(true);
            }
        }
        if ((urlString = gp.getProperty("DB_SERVER_URL")).startsWith("jdbc:sybase:Tds:")) {
            this.obServerUrl.setText(urlString.substring(16, urlString.length()));
        } else {
            this.obServerUrl.setText(urlString);
        }
        this.obUserName.setText(gp.getProperty("DB_USER_NAME"));
        if (gp.getProperty("DBOBS_REQUIRED") != null && gp.getProperty("DBOBS_REQUIRED").equals("true")) {
            this.databaseReq.setSelected(true);
            for (i = 0; i < this.dbManagedVector.size(); ++i) {
                placeHolder = null;
                placeHolder = (JComponent)this.dbManagedVector.elementAt(i);
                placeHolder.setEnabled(true);
            }
        }
        if ((urlString = gp.getProperty("DBOBS_SERVER_URL")).startsWith("jdbc:sybase:Tds:")) {
            this.dbServerUrl.setText(urlString.substring(16, urlString.length()));
        } else {
            this.dbServerUrl.setText(urlString);
        }
        this.dbServerId.setText(gp.getProperty("DBOBS_SERVER_ID"));
        this.dbUserName.setText(gp.getProperty("DBOBS_USERID"));
    }

    private void addToManaged(JComponent jc, Vector manVect) {
        jc.setEnabled(false);
        manVect.addElement(jc);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        block12: {
            int i;
            JComponent placeHolder = null;
            if (e2.getSource() == this.deleteRow) {
                this.dbPanelDeleteSelectedRow();
            } else if (e2.getSource() == this.insertRow) {
                this.dbPanelInsertBlankRow();
            }
            if (e2.getSource() == this.obsStatReq) {
                if (this.obsStatReq.isSelected()) {
                    this.gpi.put("OB_STATUS_FROM_DB_REQUIRED", "true");
                    for (i = 0; i < this.obManagedVector.size(); ++i) {
                        placeHolder = (JComponent)this.obManagedVector.elementAt(i);
                        placeHolder.setEnabled(true);
                    }
                } else {
                    this.gpi.put("OB_STATUS_FROM_DB_REQUIRED", "false");
                    for (i = 0; i < this.obManagedVector.size(); ++i) {
                        placeHolder = (JComponent)this.obManagedVector.elementAt(i);
                        placeHolder.setEnabled(false);
                    }
                }
            }
            if (e2.getSource() != this.databaseReq) break block12;
            if (this.databaseReq.isSelected()) {
                this.gpi.put("DBOBS_REQUIRED", "true");
                for (i = 0; i < this.dbManagedVector.size(); ++i) {
                    placeHolder = (JComponent)this.dbManagedVector.elementAt(i);
                    placeHolder.setEnabled(true);
                }
            } else {
                this.gpi.put("DBOBS_REQUIRED", "false");
                for (i = 0; i < this.dbManagedVector.size(); ++i) {
                    placeHolder = (JComponent)this.dbManagedVector.elementAt(i);
                    placeHolder.setEnabled(false);
                }
            }
        }
    }

    @Override
    public String saveProperties() {
        String rc = null;
        this.table.getDefaultEditor(this.table.getColumnClass(0)).stopCellEditing();
        String urlString = this.obServerUrl.getText();
        if (!urlString.startsWith("jdbc:sybase:Tds:")) {
            this.gpi.put("DB_SERVER_URL", "jdbc:sybase:Tds:" + urlString);
        } else {
            this.gpi.put("DB_SERVER_URL", urlString);
        }
        this.gpi.put("DB_USER_NAME", this.obUserName.getText());
        this.finishEditing();
        urlString = this.dbServerUrl.getText();
        if (!urlString.startsWith("jdbc:sybase:Tds:")) {
            this.gpi.put("DBOBS_SERVER_URL", "jdbc:sybase:Tds:" + urlString);
        } else {
            this.gpi.put("DBOBS_SERVER_URL", urlString);
        }
        this.gpi.put("DBOBS_SERVER_ID", this.dbServerId.getText());
        this.gpi.put("DBOBS_USERID", this.dbUserName.getText());
        if (this.databaseReq.isSelected() && (this.dbServerUrl.getText().length() == 0 || this.dbUserName.getText().length() == 0 || this.dbServerId.getText().length() == 0)) {
            rc = "One or more of the required observations database fields is blank.";
        }
        if (this.obsStatReq.isSelected() && (this.obServerUrl.getText().length() == 0 || this.obUserName.getText().length() == 0)) {
            rc = "One or more of the required OB Status database fields is blank.";
        }
        return rc;
    }

    private void dbPanelDeleteSelectedRow() {
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        this.tableModel.removeRow(selRow);
    }

    private void dbPanelInsertBlankRow() {
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        this.tableModel.insertRow(selRow);
    }

    public void editingStopped(ChangeEvent e2) {
    }

    public void editingCanceled(ChangeEvent e2) {
    }

    public void finishEditing() {
        if (this.table.isEditing()) {
            TableCellEditor comp = this.table.getCellEditor();
            if (comp != null && comp instanceof DefaultCellEditor) {
                ((DefaultCellEditor)comp).stopCellEditing();
            }
            this.table.clearSelection();
        }
    }

    @Override
    public int restartRequired() {
        return 0;
    }

    class ATModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"OB Status", "Label"};
        private GasProp gpi;

        ATModel(GasProp gp) {
            this.loadProperties(gp);
        }

        void loadProperties(GasProp gp) {
            this.gpi = gp;
            if (this.gpi.obsStatus.size() == 0) {
                this.insertRow(0);
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        public int getColumnWidth(int column) {
            if (column == 0) {
                return 170;
            }
            return 170;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.gpi.obsStatus.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.gpi.obsStatus.elementAt(row).toString();
            }
            return this.gpi.obsStatusMeaning.elementAt(row).toString();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                this.gpi.obsStatus.setElementAt((String)aValue, row);
            } else {
                this.gpi.obsStatusMeaning.setElementAt((String)aValue, row);
            }
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public void removeRow(int rowNum) {
            block2: {
                try {
                    DBPanel.this.table.getDefaultEditor(DBPanel.this.table.getColumnClass(1)).stopCellEditing();
                    this.gpi.obsStatus.removeElementAt(rowNum);
                    this.gpi.obsStatusMeaning.removeElementAt(rowNum);
                    this.fireTableDataChanged();
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    if (!DBPanel.this.isDebug()) break block2;
                    System.out.println("GasPropEditor: array out of bound");
                }
            }
        }

        public void insertRow(int rowNum) {
            block2: {
                try {
                    this.gpi.obsStatus.insertElementAt("", rowNum);
                    this.gpi.obsStatusMeaning.insertElementAt("", rowNum);
                    this.fireTableDataChanged();
                }
                catch (ArrayIndexOutOfBoundsException e2) {
                    if (!DBPanel.this.isDebug()) break block2;
                    System.out.println("GasPropEditor: array out of bound");
                }
            }
        }
    }
}

