/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTGreaterThan
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTGreaterThan.class);

    public ASTGreaterThan(int id) {
        super(id);
    }

    public ASTGreaterThan(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 30;
    }

    Object greaterThan(Object leftOperand, Object rightOperand) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator '>' may not be used for \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " > " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    Boolean greaterThan(UndefinedFITSValue leftOperand, Object rightOperand) {
        String message = this.getNodeLocationString() + "Operator '>' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " > " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.warn(message);
        return new Boolean(false);
    }

    Boolean greaterThan(Object leftOperand, UndefinedFITSValue rightOperand) {
        String message = this.getNodeLocationString() + "Operator '>' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " > " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.warn(message);
        return new Boolean(false);
    }

    Boolean greaterThan(BigDecimal leftOperand, BigDecimal rightOperand) {
        return new Boolean(leftOperand.compareTo(rightOperand) > 0);
    }

    Boolean greaterThan(BigDecimal leftOperand, BigInteger rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " > " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedRightOperand = new BigDecimal(rightOperand);
        return new Boolean(leftOperand.compareTo(promotedRightOperand) > 0);
    }

    Boolean greaterThan(BigInteger leftOperand, BigDecimal rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " > " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedLeftOperand = new BigDecimal(leftOperand);
        return new Boolean(promotedLeftOperand.compareTo(rightOperand) > 0);
    }

    Boolean greaterThan(BigInteger leftOperand, BigInteger rightOperand) {
        return new Boolean(leftOperand.compareTo(rightOperand) > 0);
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        state.stack[--state.top] = this.dispatch(this.getClass(), "greaterThan", new Object[]{state.stack[state.top], state.stack[state.top + 1]});
    }
}

