/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eso.oca.fits.KeywordNotFoundException;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedValueException;
import org.eso.oca.parser.ASTActionRule;
import org.eso.oca.parser.ASTAddition;
import org.eso.oca.parser.ASTBetween;
import org.eso.oca.parser.ASTBooleanConst;
import org.eso.oca.parser.ASTDivision;
import org.eso.oca.parser.ASTEquals;
import org.eso.oca.parser.ASTExecute;
import org.eso.oca.parser.ASTFloatConst;
import org.eso.oca.parser.ASTGreaterThan;
import org.eso.oca.parser.ASTGreaterThanOrEqual;
import org.eso.oca.parser.ASTIfStatement;
import org.eso.oca.parser.ASTInputFileKeyword;
import org.eso.oca.parser.ASTIntConst;
import org.eso.oca.parser.ASTIs;
import org.eso.oca.parser.ASTKeyword;
import org.eso.oca.parser.ASTLessThan;
import org.eso.oca.parser.ASTLessThanOrEqual;
import org.eso.oca.parser.ASTLike;
import org.eso.oca.parser.ASTLogicalAnd;
import org.eso.oca.parser.ASTLogicalNot;
import org.eso.oca.parser.ASTLogicalOr;
import org.eso.oca.parser.ASTMaxRet;
import org.eso.oca.parser.ASTMetaKeyword;
import org.eso.oca.parser.ASTMetaKeywordDefinition;
import org.eso.oca.parser.ASTMinRet;
import org.eso.oca.parser.ASTMultiplication;
import org.eso.oca.parser.ASTNotEquals;
import org.eso.oca.parser.ASTPossiblyEquals;
import org.eso.oca.parser.ASTPriority;
import org.eso.oca.parser.ASTProduct;
import org.eso.oca.parser.ASTProductKeyword;
import org.eso.oca.parser.ASTProductKeywordDefinition;
import org.eso.oca.parser.ASTRecipe;
import org.eso.oca.parser.ASTRegexp;
import org.eso.oca.parser.ASTRemainder;
import org.eso.oca.parser.ASTSelectAssociateStatement;
import org.eso.oca.parser.ASTSelectExecuteStatement;
import org.eso.oca.parser.ASTStart;
import org.eso.oca.parser.ASTStringConst;
import org.eso.oca.parser.ASTSubtraction;
import org.eso.oca.parser.ASTTypeConst;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.OcaVisitorState;
import org.eso.oca.parser.SelectAssociateState;
import org.eso.oca.parser.SimpleNode;

public class SqlVisitor
implements OcaParserVisitor {
    static Logger logger = Logger.getLogger(SqlVisitor.class);
    private Map<String, String> rawFilesMapping;
    private Map<String, String> calibFilesMapping;
    private String rawTable;
    private String calibTable;

    public SqlVisitor(Map<String, String> rawFilesMapping, Map<String, String> calibFilesMapping, String rawTable, String calibTable) {
        this.rawFilesMapping = rawFilesMapping;
        this.calibFilesMapping = calibFilesMapping;
        this.rawTable = rawTable;
        this.calibTable = calibTable;
    }

    @Override
    public Object visit(SimpleNode node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(SimpleNode) not implemented");
    }

    @Override
    public Object visit(ASTStart node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTStart) not implemented");
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTIfStatement) not implemented");
    }

    @Override
    public Object visit(ASTExecute node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTExecute) not implemented");
    }

    @Override
    public Object visit(ASTActionRule node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        state.action = node.name;
        node.childrenAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTMinRet node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        state.minRet = node.value;
        return data;
    }

    @Override
    public Object visit(ASTMaxRet node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        state.maxRet = node.value;
        return data;
    }

    @Override
    public Object visit(ASTRecipe node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        state.recipe = node.name;
        return data;
    }

    @Override
    public Object visit(ASTProduct node, Object data) throws OcaVisitorException {
        return data;
    }

    @Override
    public Object visit(ASTMetaKeywordDefinition node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTMetaKeywordDefinition) not implemented");
    }

    @Override
    public Object visit(ASTMetaKeyword node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTMetaKeyword) not implemented");
    }

    @Override
    public Object visit(ASTLogicalOr node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" or ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTLogicalAnd node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        SimpleNode child0 = (SimpleNode)node.jjtGetChild(0);
        SimpleNode child1 = (SimpleNode)node.jjtGetChild(1);
        if (node.precedence() > child0.precedence()) {
            selectState.whereClause.append("(");
            child0.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child0.jjtAccept(this, data);
        }
        selectState.whereClause.append(" and ");
        if (node.precedence() > child1.precedence()) {
            selectState.whereClause.append("(");
            child1.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child1.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEquals node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" = ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTBetween node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" between ");
        node.jjtGetChild(1).jjtAccept(this, data);
        selectState.whereClause.append(" and ");
        node.jjtGetChild(2).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTNotEquals node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" != ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTLessThan node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" < ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTGreaterThan node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" > ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTLessThanOrEqual node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" <= ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTGreaterThanOrEqual node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" >= ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTLike node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" like ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTAddition node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" + ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTSubtraction node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" - ");
        node.jjtGetChild(1).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTMultiplication node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        SimpleNode child0 = (SimpleNode)node.jjtGetChild(0);
        SimpleNode child1 = (SimpleNode)node.jjtGetChild(1);
        if (node.precedence() > child0.precedence()) {
            selectState.whereClause.append("(");
            child0.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child0.jjtAccept(this, data);
        }
        selectState.whereClause.append(" * ");
        if (node.precedence() > child1.precedence()) {
            selectState.whereClause.append("(");
            child1.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child1.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTDivision node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        SimpleNode child0 = (SimpleNode)node.jjtGetChild(0);
        SimpleNode child1 = (SimpleNode)node.jjtGetChild(1);
        if (node.precedence() > child0.precedence()) {
            selectState.whereClause.append("(");
            child0.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child0.jjtAccept(this, data);
        }
        selectState.whereClause.append(" / ");
        if (node.precedence() > child1.precedence()) {
            selectState.whereClause.append("(");
            child1.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child1.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTRemainder node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        SimpleNode child0 = (SimpleNode)node.jjtGetChild(0);
        SimpleNode child1 = (SimpleNode)node.jjtGetChild(1);
        if (node.precedence() > child0.precedence()) {
            selectState.whereClause.append("(");
            child0.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child0.jjtAccept(this, data);
        }
        selectState.whereClause.append(" % ");
        if (node.precedence() > child1.precedence()) {
            selectState.whereClause.append("(");
            child1.jjtAccept(this, data);
            selectState.whereClause.append(")");
        } else {
            child1.jjtAccept(this, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTKeyword node, Object data) throws OcaVisitorException {
        Map<String, String> mappings;
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        if (selectState.getDataSource().equals(this.rawTable)) {
            mappings = this.rawFilesMapping;
        } else if (selectState.getDataSource().equals(this.calibTable)) {
            mappings = this.calibFilesMapping;
        } else {
            throw new OcaVisitorException("Unsupported data source: " + selectState.getDataSource());
        }
        String fitsKeyword = TypedHeaderCard.formatKey(node.name, 3);
        String keyword = mappings.get(fitsKeyword);
        if (keyword == null) {
            throw new OcaVisitorException("Keyword " + fitsKeyword + " not found in metadata mapping");
        }
        selectState.whereClause.append(keyword);
        return data;
    }

    @Override
    public Object visit(ASTIntConst node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.whereClause.append(node.value.toString());
        return data;
    }

    @Override
    public Object visit(ASTFloatConst node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.whereClause.append(node.value.toString());
        return data;
    }

    @Override
    public Object visit(ASTStringConst node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.whereClause.append("'" + node.value.toString() + "'");
        return data;
    }

    @Override
    public Object visit(ASTSelectExecuteStatement node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTSelectExecuteStatement) not implemented");
    }

    @Override
    public Object visit(ASTSelectAssociateStatement node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        state.selects.add(new SelectAssociateState());
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.minRet = state.minRet;
        selectState.maxRet = state.maxRet;
        selectState.addToInput = node.addToInput;
        selectState.alias = node.alias;
        if (node.dataSource.equals("rawFiles")) {
            selectState.dataSource = this.rawTable;
        } else if (node.dataSource.equals("calibFiles")) {
            selectState.dataSource = this.calibTable;
        } else {
            throw new OcaVisitorException("Unrecognized data source: " + node.dataSource);
        }
        node.childrenAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTProductKeywordDefinition node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTProductKeywordDefinition) not implemented");
    }

    @Override
    public Object visit(ASTProductKeyword node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTProductKeyword) not implemented");
    }

    @Override
    public Object visit(ASTInputFileKeyword node, Object data) throws OcaVisitorException {
        String value;
        String thisMethod = "SqlVisitor::visit(ASTInputFileKeyword)";
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        if (state.getExemplar() == null) {
            throw new OcaVisitorException("Null exemplar");
        }
        String columnName = this.rawFilesMapping.get(TypedHeaderCard.formatKey(node.name, 3));
        try {
            value = state.getExemplar().getKeywordValueForSQL(node.name);
        }
        catch (KeywordNotFoundException e2) {
            logger.warn("SqlVisitor::visit(ASTInputFileKeyword) - keyword " + node.name + " not found in exemplar");
            value = state.getNullValueForColumn(columnName, selectState.dataSource.toString());
        }
        catch (UndefinedValueException e3) {
            logger.debug("SqlVisitor::visit(ASTInputFileKeyword) - keyword " + node.name + " has undefined value in exemplar");
            value = state.getNullValueForColumn(columnName, selectState.dataSource.toString());
        }
        selectState.whereClause.append(value.toString());
        return data;
    }

    @Override
    public Object visit(ASTPossiblyEquals node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.whereClause.append(" ( ");
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" is null or ");
        node.jjtGetChild(1).jjtAccept(this, data);
        selectState.whereClause.append(" is null or ");
        node.jjtGetChild(0).jjtAccept(this, data);
        selectState.whereClause.append(" = ");
        node.jjtGetChild(1).jjtAccept(this, data);
        selectState.whereClause.append(" ) ");
        return data;
    }

    @Override
    public Object visit(ASTIs node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTIs) not implemented");
    }

    @Override
    public Object visit(ASTTypeConst node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTTypeConst) not implemented");
    }

    @Override
    public Object visit(ASTBooleanConst node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTBooleanConst) not implemented");
    }

    @Override
    public Object visit(ASTRegexp node, Object data) throws OcaVisitorException {
        throw new OcaVisitorException("SqlVisitor::visit(ASTRegexp) not implemented");
    }

    @Override
    public Object visit(ASTLogicalNot node, Object data) throws OcaVisitorException {
        OcaVisitorState state = (OcaVisitorState)data;
        SelectAssociateState selectState = state.selects.elementAt(state.selects.size() - 1);
        selectState.whereClause.append(" NOT ");
        node.jjtGetChild(0).jjtAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTPriority node, Object data) throws OcaVisitorException {
        return null;
    }
}

