/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.dal.ArchiveStatisticsDAO;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.SybaseConnectionService;

public class ArchiveStatisticsDAOSyb
implements ArchiveStatisticsDAO {
    private static final Logger logger = Logger.getLogger(ArchiveStatisticsDAOSyb.class);
    private String d_dbUrl;
    private String d_dbUsername;
    private String d_dbPassword;
    private String d_dataProducts;
    private String d_dtsFiles;
    private String d_pastageFiles;
    private String d_paFiles;
    private String d_saFiles;
    private String d_transferRequests;
    private String d_usbDiskFiles;
    private boolean stopQueries = false;
    private int executingQueries = 0;
    private Object executingQueriesLock = new Object();
    public static final String FILE_ID = "file_id";
    public static final String FILE_DATE = "file_date";
    public static final String FILE_SIZE = "file_size";
    public static final String FILE_PRIORITY = "file_priority";

    public ArchiveStatisticsDAOSyb(String dbUrl, String dbUsername, String dbPassword, String data_products, String dts_files, String pastage_files, String pa_files, String sa_files, String transfer_requests, String usbDiskFiles) throws DAOException {
        this.d_dataProducts = data_products;
        this.d_dtsFiles = dts_files;
        this.d_pastageFiles = pastage_files;
        this.d_paFiles = pa_files;
        this.d_saFiles = sa_files;
        this.d_transferRequests = transfer_requests;
        this.d_usbDiskFiles = usbDiskFiles;
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
    }

    @Override
    public List<Map<String, String>> fromOLASToDT(int days) throws DAOException {
        Double epoch = 0.001 * (double)System.currentTimeMillis();
        Double starting_point = ArchiveStatisticsDAOSyb.epochToMjd(epoch - (double)(days * 24 * 60 * 60));
        Double ending_point = ArchiveStatisticsDAOSyb.epochToMjd(epoch - 3600.0);
        String query = "SELECT dp.dp_id AS file_id, ";
        query = query + " dateadd(ss, (dp.mjd_obs- 40587.) * (24*60*60), '01 Jan 1970') AS file_date FROM " + this.d_dtsFiles + " dts ";
        query = query + " RIGHT OUTER JOIN " + this.d_dataProducts + " dp ON dp.dp_id = dts.file_id ";
        query = query + " WHERE dts.file_id = NULL AND dp.dp_id NOT LIKE 'APEX%' AND dp.dp_id NOT LIKE 'WFCAM%'";
        query = query + " AND dp.mjd_obs BETWEEN " + String.valueOf(starting_point) + " AND " + String.valueOf(ending_point);
        query = query + " ORDER BY dp.mjd_obs";
        logger.debug("ArchiveStatistics::fromOLASToDT - " + query);
        return this.executeQuery(query);
    }

    @Override
    public List<Map<String, String>> fromDTToPAStage(int days) throws DAOException {
        Long now = System.currentTimeMillis();
        String expDate = new SimpleDateFormat("dd MMM yyyy").format(new Date(now - (long)days * 24L * 3600L * 1000L));
        String query = "SELECT dts.file_id, dts.ingestion_date AS file_date, trq.transfer_priority AS file_priority, dts.file_size AS file_size ";
        query = query + " FROM " + this.d_dtsFiles + " dts LEFT OUTER JOIN " + this.d_pastageFiles + " ";
        query = query + " pa ON dts.file_id = pa.file_id ";
        query = query + " LEFT OUTER JOIN " + this.d_transferRequests + " trq ON dts.file_id = trq.file_id ";
        query = query + " WHERE pa.file_id = NULL and dts.ingestion_date > '" + expDate + "'";
        query = query + " ORDER BY dts.ingestion_date";
        logger.debug("ArchiveStatistics::fromDTToPAStage - " + query);
        return this.executeQuery(query);
    }

    @Override
    public List<Map<String, String>> fromPAStageToPA(int days) throws DAOException {
        Long now = System.currentTimeMillis();
        String expDate = new SimpleDateFormat("dd MMM yyyy").format(new Date(now - (long)days * 24L * 3600L * 1000L));
        String query = "SELECT dts.file_id, dts.ingestion_date AS file_date, trq.transfer_priority AS file_priority, dts.file_size AS file_size ";
        query = query + " FROM " + this.d_pastageFiles + " dts LEFT OUTER JOIN " + this.d_paFiles + " ";
        query = query + " pa ON dts.file_id = pa.file_id ";
        query = query + " LEFT OUTER JOIN " + this.d_transferRequests + " trq ON dts.file_id = trq.file_id ";
        query = query + " WHERE pa.file_id = NULL and dts.ingestion_date > '" + expDate + "'";
        query = query + " ORDER BY dts.ingestion_date";
        logger.debug("ArchiveStatistics::fromDTToPAStage - " + query);
        return this.executeQuery(query);
    }

    @Override
    public List<Map<String, String>> fromPAToSA(int days) throws DAOException {
        Long now = System.currentTimeMillis();
        String expDate = new SimpleDateFormat("dd MMM yyyy").format(new Date(now - (long)days * 24L * 3600L * 1000L));
        String query = "SELECT pa.file_id, pa.ingestion_date AS file_date, pa.file_size AS file_size ";
        query = query + " FROM " + this.d_paFiles + " pa LEFT OUTER JOIN " + this.d_saFiles + " nfs ON pa.file_id = nfs.file_id ";
        query = query + " WHERE nfs.file_id = NULL and pa.ingestion_date > '" + expDate + "'";
        query = query + " ORDER BY pa.ingestion_date";
        logger.debug("ArchiveStatistics::fromPAToSA - " + query);
        List<Map<String, String>> res = this.executeQuery(query);
        Iterator<Map<String, String>> iter = res.iterator();
        while (iter.hasNext()) {
            if (!iter.next().get(FILE_ID).contains("_")) continue;
            iter.remove();
        }
        return res;
    }

    @Override
    public SortedMap<Timestamp, Double> bandwidthUsage(Timestamp start, Timestamp stop, int step) throws DAOException {
        TreeMap<Timestamp, Double> ret_res = new TreeMap<Timestamp, Double>();
        String query = "SELECT submission_time, last_update_time, size, uncompressed_size ";
        query = query + "FROM " + this.d_transferRequests + " WHERE transfer_status = 6 ";
        query = query + "AND submission_time BETWEEN dateadd(ss, " + (long)((double)start.getTime() * 0.001) + ", '01 Jan 1970') ";
        query = query + "AND dateadd(ss, " + (long)((double)stop.getTime() * 0.001) + ", '01 Jan 1970') ";
        query = query + "AND transfer_catg in ('too', 'rawfile') ORDER BY submission_time";
        logger.debug("ArchiveStatistics::bandwidthUsage - " + query);
        logger.debug("start time: " + start + ", end time: " + stop);
        try {
            Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
            ResultSet res = SybaseConnectionService.executeStatement(conn, query);
            Long startTime = start.getTime();
            int interval = (int)((stop.getTime() - start.getTime()) / 60000L);
            for (int index = 0; index < interval / step; ++index) {
                Timestamp beginDate = new Timestamp(startTime + (long)(index * step * 60 * 1000));
                ret_res.put(beginDate, 0.0);
            }
            try {
                while (res.next()) {
                    Long update = res.getTimestamp("last_update_time").getTime();
                    Timestamp endTransmission = new Timestamp(update + (long)TimeZone.getDefault().getOffset(update));
                    Long submission = res.getTimestamp("submission_time").getTime();
                    Timestamp beginTransmission = new Timestamp(submission + (long)TimeZone.getDefault().getOffset(submission));
                    logger.debug("begin transmission: " + beginTransmission + ", end transmission: " + endTransmission);
                    if (beginTransmission.equals(endTransmission)) continue;
                    Double beginIndex = 1.0 * (double)(beginTransmission.getTime() - startTime) / (double)(step * 60 * 1000);
                    Timestamp beginDate = new Timestamp(startTime + beginIndex.longValue() * (long)step * 60L * 1000L);
                    Double endIndex = 1.0 * (double)(endTransmission.getTime() - startTime) / (double)(step * 60 * 1000);
                    for (long i = beginIndex.longValue(); i <= endIndex.longValue(); ++i) {
                        Double bytes = 1.0 * (double)res.getLong("size");
                        if (beginIndex.longValue() != endIndex.longValue()) {
                            bytes = 1.0 * (double)res.getLong("size") * (Math.min(endIndex, (double)(i + 1L)) - Math.max(beginIndex, (double)i)) / (endIndex - beginIndex);
                        }
                        if (ret_res.get(beginDate) == null) {
                            ret_res.put(beginDate, 0.0);
                        }
                        ret_res.put(beginDate, (Double)ret_res.get(beginDate) + bytes);
                    }
                }
            }
            catch (SQLException e2) {
                throw new DAOException("Error while parsing result set. Reason: " + e2.getMessage());
            }
            conn.close();
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (ConnectionServiceException e4) {
            throw new DAOException(e4.getMessage());
        }
        catch (IllegalArgumentException e5) {
            throw new DAOException(e5.getMessage());
        }
        for (Timestamp d2 : ret_res.keySet()) {
            ret_res.put(d2, (Double)ret_res.get(d2) / (double)(1024 * step * 60));
        }
        return ret_res;
    }

    @Override
    public List<Map<String, String>> transmissionTime(Timestamp start, Timestamp stop) throws DAOException {
        String query = "SELECT submission_time, last_update_time, size, uncompressed_size, transfer_priority ";
        query = query + "FROM " + this.d_transferRequests + " WHERE transfer_status = 6 AND ";
        query = query + "submission_time BETWEEN dateadd(ss, " + (long)((double)start.getTime() * 0.001) + ", '01 Jan 1970') ";
        query = query + "AND dateadd(ss, " + (long)((double)stop.getTime() * 0.001) + ", '01 Jan 1970') ";
        query = query + "AND transfer_catg in ('too', 'rawfile') ORDER BY submission_time";
        logger.debug("ArchiveStatistics::transmissionTime - " + query);
        return this.executeQuery(query);
    }

    @Override
    public String orignameToFileId(String origname) throws DAOException {
        String res;
        String query = "SELECT dp_id from " + this.d_dataProducts + " WHERE origfile='" + origname + "'";
        try {
            logger.debug("ArchiveStatistics::orignameToFileId - " + query);
            res = this.executeQuery(query).get(0).get("dp_id");
            logger.debug("file_id of " + origname + " is " + res);
        }
        catch (IndexOutOfBoundsException e2) {
            throw new DAOException(e2.getMessage());
        }
        return res;
    }

    @Override
    public boolean searchInOLAS(String fileId) throws DAOException {
        return this.searchInTable(fileId, this.d_dataProducts);
    }

    @Override
    public boolean searchInPA(String fileId) throws DAOException {
        return this.searchInTable(fileId, this.d_paFiles);
    }

    @Override
    public boolean searchInSA(String fileId) throws DAOException {
        return this.searchInTable(fileId, this.d_saFiles);
    }

    @Override
    public boolean searchInStagingGarching(String fileId) throws DAOException {
        String query = "SELECT file_id FROM " + this.d_transferRequests;
        query = query + " WHERE (transfer_status = 5 OR transfer_status = 6) ";
        query = query + " AND file_id = '" + fileId + "'";
        logger.debug("ArchiveStatistics::searchInTable - " + query);
        List<Map<String, String>> res = this.executeQuery(query);
        logger.debug("Found " + res.size() + " records of " + fileId + " in " + this.d_transferRequests);
        return res.size() > 0;
    }

    @Override
    public boolean searchInStagingChile(String fileId) throws DAOException {
        return this.searchInTable(fileId, this.d_dtsFiles);
    }

    public boolean searchInTable(String fileId, String table) throws DAOException {
        String field = FILE_ID;
        if (table == this.d_dataProducts) {
            field = "dp_id";
        }
        String query = "SELECT * FROM " + table + " WHERE " + field + "='" + fileId + "'";
        logger.debug("ArchiveStatistics::searchInTable - " + query);
        List<Map<String, String>> res = this.executeQuery(query);
        logger.debug("Found " + res.size() + " records of " + fileId + " in " + table);
        return res.size() > 0;
    }

    @Override
    public String searchInUSBDisks(String fileId) throws DAOException {
        String query = "SELECT logical_name FROM " + this.d_usbDiskFiles + " WHERE file_id = '" + fileId + "'";
        logger.debug("ArchiveStatistics::searchInUSBDisks - " + query);
        List<Map<String, String>> res = this.executeQuery(query);
        logger.debug("Found " + res.size() + " records of " + fileId + " in " + this.d_usbDiskFiles);
        if (res.size() == 0) {
            return "---";
        }
        String disks = "";
        for (Map<String, String> disk : res) {
            disks = disks + ", " + disk.get("logical_name");
        }
        return disks.substring(2);
    }

    public static Double epochToMjd(Double epoch) {
        return 40587.0 + epoch / 86400.0;
    }

    public static Double mjdToEpoch(Double mjd) {
        return (mjd - 40587.0) * 86400.0;
    }

    public void stopAllQueries() {
        String logHead = "stopAllQueries() - ";
        this.stopQueries = true;
        logger.debug("stopAllQueries() - Waiting for queries to terminate ...");
        while (this.executingQueries > 0) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e2) {
                logger.error("stopAllQueries() - Cannot sleep between pollings: " + e2.getMessage());
            }
        }
        logger.debug("stopAllQueries() - All queries terminated.");
        this.stopQueries = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, String>> executeQuery(String query) throws DAOException {
        Object object = this.executingQueriesLock;
        synchronized (object) {
            ++this.executingQueries;
        }
        String logHead = "executeQuery() - ";
        ArrayList<Map<String, String>> ret_val = null;
        try {
            Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
            PreparedStatement sqlStatement = conn.prepareStatement(query);
            sqlStatement.execute();
            ResultSet res = sqlStatement.getResultSet();
            ret_val = new ArrayList<Map<String, String>>();
            try {
                ResultSetMetaData rsmd = res.getMetaData();
                int numColumns = rsmd.getColumnCount();
                ArrayList<String> columns = new ArrayList<String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    columns.add(rsmd.getColumnName(i));
                }
                while (res.next()) {
                    if (this.stopQueries) {
                        sqlStatement.cancel();
                        logger.debug("executeQuery() - query and records fetching stopped for query [" + query + "].");
                        break;
                    }
                    HashMap<String, String> temp = new HashMap<String, String>();
                    for (String s : columns) {
                        temp.put(s, res.getString(s));
                    }
                    ret_val.add(temp);
                }
            }
            catch (SQLException e2) {
                throw new DAOException("Error while parsing result set. Reason: " + e2.getMessage());
            }
            conn.close();
        }
        catch (SQLException e3) {
            throw new DAOException(e3.getMessage());
        }
        catch (ConnectionServiceException e4) {
            throw new DAOException(e4.getMessage());
        }
        catch (IllegalArgumentException e5) {
            throw new DAOException(e5.getMessage());
        }
        finally {
            Object object2 = this.executingQueriesLock;
            synchronized (object2) {
                --this.executingQueries;
            }
        }
        return ret_val;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            ArchiveStatisticsDAOSyb dao = new ArchiveStatisticsDAOSyb("acdb.hq.eso.org:2025", "sara", "sara_ps", "observations..data_products", "sara..dts_files", "sara..dts_files_pastage", "sara..pa_files", "ngas..ngas_files_safe", "sara..transfer_requests", "sara..usb_disk_files");
            int days = 40;
            List<Map<String, String>> res = null;
            res = dao.fromOLASToDT(days);
            if (res != null) {
                System.out.println("Not in DT: " + res.size());
            }
            TreeMap<Integer, Integer> files = new TreeMap<Integer, Integer>();
            files.put(10, 0);
            files.put(30, 0);
            files.put(40, 0);
            files.put(50, 0);
            files.put(100, 0);
            res = null;
            res = dao.fromDTToPAStage(days);
            if (res != null) {
                block2: for (Map<String, String> map : res) {
                    if (map.get(FILE_PRIORITY) == null) {
                        map.put(FILE_PRIORITY, "60");
                    }
                    Integer tp = Integer.valueOf(map.get(FILE_PRIORITY));
                    for (Integer p : files.keySet()) {
                        if (tp > p) continue;
                        files.put(p, (Integer)files.get(p) + 1);
                        continue block2;
                    }
                }
                System.out.println("Not in PA Stage: " + res.size());
                for (Integer p : files.keySet()) {
                    System.out.println("\tpriority higher than " + p + ": " + files.get(p));
                }
            }
            if ((res = dao.fromPAStageToPA(days)) != null) {
                for (Map<String, String> map : res) {
                    for (String k : map.keySet()) {
                        System.out.print(k + ": " + map.get(k) + " ");
                    }
                    System.out.println();
                }
                System.out.println("Not in PA: " + res.size());
            }
            res = null;
            res = dao.fromPAToSA(days);
            if (res != null) {
                System.out.println("Not in SA: " + res.size());
            }
            if ((res = null) != null) {
                System.out.println(res.size());
            }
        }
        catch (DAOException e2) {
            System.out.println(e2.getMessage());
        }
    }
}

