/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.datatransfer;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.datatransfer.TransferRequest;
import org.eso.util.datatransfer.TransferRequestException;
import org.eso.util.datatransfer.TransferRequestValidator;

public class DefaultTransferRequestValidator
implements TransferRequestValidator {
    private static final String[] mandatoryKeywords = new String[]{"FILEID", "FILENAME", "SIZE"};
    static Logger logger = Logger.getLogger(DefaultTransferRequestValidator.class);

    @Override
    public boolean isValid(TransferRequest tr) {
        boolean ret = true;
        for (int i = 0; i < mandatoryKeywords.length; ++i) {
            String keyword = mandatoryKeywords[i];
            if (tr.containsKey(keyword)) continue;
            ret = false;
            String message = "DefaultTransferRequestValidator::isValid() -  Mandatory keyword " + keyword + " is missing.";
            logger.error(message);
        }
        return ret;
    }

    public static void main(String[] args) throws TransferRequestException {
        BasicConfigurator.configure();
        TransferRequest tr = new TransferRequest();
        tr.setProperty("FILENAME", "pippo");
        DefaultTransferRequestValidator trv = new DefaultTransferRequestValidator();
        if (!trv.isValid(tr)) {
            logger.error("TransferRequest is not valid");
        } else {
            logger.info("TransferRequest is valid.");
        }
    }
}

