/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import org.apache.log4j.Logger;

public final class WrappedString {
    static final Logger logger = Logger.getLogger(WrappedString.class);
    private static final String classLogName = "WrappedString";
    public static final int STANDARD_OUTPUT_LINE_WIDTH = 78;
    public static final int ISO_TAB_LENGTH = 8;
    public static final String WHITESPACE = " \n\r\t\f";
    private final String wrappedString;

    public WrappedString(String sourceString) throws NullPointerException {
        String methodLogName = "WrappedString::WrappedString(String)";
        logger.trace("WrappedString::WrappedString(String)");
        this.wrappedString = WrappedString.wrapText("", sourceString, 78, 8, WHITESPACE);
    }

    public WrappedString(String leftMarginString, String sourceString) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "WrappedString::WrappedString(String, String)";
        logger.trace("WrappedString::WrappedString(String, String)");
        this.wrappedString = WrappedString.wrapText(leftMarginString, sourceString, 78, 8, WHITESPACE);
    }

    public WrappedString(String leftMarginString, String sourceString, int lineWidth, int tabLength, String whitespace) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "WrappedString::WrappedString(String, String, int, int, String)";
        logger.trace("WrappedString::WrappedString(String, String, int, int, String)");
        this.wrappedString = WrappedString.wrapText(leftMarginString, sourceString, lineWidth, tabLength, whitespace);
    }

    public String toString() {
        String methodLogName = "WrappedString::toString()";
        logger.trace("WrappedString::toString()");
        return this.wrappedString;
    }

    private static String wrapText(String leftMarginString, String sourceString, int lineWidth, int tabLength, String whitespace) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "WrappedString::wrapText()";
        logger.trace("WrappedString::wrapText()");
        if (leftMarginString == null || sourceString == null || whitespace == null) {
            String message = "WrappedString::wrapText() - leftMarginString [" + leftMarginString + "], sourceString[" + sourceString + "] and whitespace [" + whitespace + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (lineWidth <= leftMarginString.length()) {
            String message = "WrappedString::wrapText() - lineWidth [" + lineWidth + "] must be longer than leftMarginString [" + leftMarginString.length() + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (tabLength < 0) {
            String message = "WrappedString::wrapText() - tabLength [" + tabLength + "] must not be negative.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        logger.debug("WrappedString::wrapText() - wrapping text to width [" + lineWidth + "].");
        int sourceStringLength = sourceString.length();
        StringBuilder wrappedText = new StringBuilder(sourceStringLength + sourceStringLength / (lineWidth -= leftMarginString.length()) * (leftMarginString.length() + 1));
        wrappedText.append(leftMarginString);
        int lineStart = 0;
        int lineLength = 0;
        int previousBreak = 0;
        boolean forceNewLine = false;
        for (int i = 0; i < sourceStringLength; ++i) {
            if (whitespace.indexOf(sourceString.charAt(i)) > -1) {
                previousBreak = i;
            }
            if (sourceString.charAt(i) == '\t') {
                lineLength += tabLength;
            } else if (sourceString.charAt(i) == '\n') {
                forceNewLine = true;
            } else {
                ++lineLength;
            }
            if (!forceNewLine && (lineLength <= lineWidth || previousBreak == lineStart)) continue;
            wrappedText.append(sourceString.substring(lineStart, previousBreak));
            wrappedText.append('\n');
            wrappedText.append(leftMarginString);
            lineLength = i - previousBreak;
            lineStart = ++previousBreak;
            forceNewLine = false;
        }
        wrappedText.append(sourceString.substring(lineStart));
        return wrappedText.toString();
    }
}

