/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.stream;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eso.util.stream.Message;
import org.eso.util.stream.Module;
import org.eso.util.stream.Task;

public abstract class ProcessingTask
implements Task,
Runnable {
    static final Logger logger = Logger.getLogger(ProcessingTask.class);
    private static final String classLogName = "ProcessingTask";
    private Module containingModule = null;
    private final String taskName;
    private final int numTaskThreads;
    private final Thread[] taskThreads;
    private final Semaphore threadPermits = new Semaphore(0);
    private boolean taskClosureEnabled = false;
    private final BlockingQueue<Message> msgQueue;
    private final long maxBlockPeriod;
    private Task nextTask = null;

    public ProcessingTask(String taskName, int numTaskThreads, long maxBlockPeriod) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "ProcessingTask::ProcessingTask() [for task " + taskName + "]";
        logger.trace(methodLogName + ".");
        if (taskName == null) {
            String message = methodLogName + " - taskName must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (numTaskThreads < 1) {
            String message = methodLogName + " - numTaskThreads must not be less than 1.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.taskName = taskName;
        this.numTaskThreads = numTaskThreads;
        this.maxBlockPeriod = maxBlockPeriod;
        this.threadPermits.release(numTaskThreads);
        this.taskThreads = new Thread[numTaskThreads];
        this.msgQueue = new LinkedBlockingQueue<Message>();
    }

    public ProcessingTask(String taskName, int numTaskThreads, long maxBlockPeriod, Comparator<Message> messagePriorityComparator) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "ProcessingTask::ProcessingTask() [for task " + taskName + "]";
        logger.trace(methodLogName + ".");
        if (taskName == null || messagePriorityComparator == null) {
            String message = methodLogName + " - taskName [" + taskName + "] and messagePriorityComparator [" + messagePriorityComparator + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (numTaskThreads < 1) {
            String message = methodLogName + " - numTaskThreads must not be less than 1.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.taskName = taskName;
        this.numTaskThreads = numTaskThreads;
        this.maxBlockPeriod = maxBlockPeriod;
        this.threadPermits.release(numTaskThreads);
        this.taskThreads = new Thread[numTaskThreads];
        this.msgQueue = new PriorityBlockingQueue<Message>(11, messagePriorityComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void open() {
        String methodLogName = "ProcessingTask::open() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        logger.debug(methodLogName + " - opening task with " + this.numTaskThreads + (this.numTaskThreads == 1 ? " thread." : " threads."));
        if (!this.isOpen()) {
            logger.debug(methodLogName + " - disabling task closure.");
            this.taskClosureEnabled = false;
            String threadName = null;
            for (int i = 0; i < this.numTaskThreads; ++i) {
                threadName = this.taskName + (this.numTaskThreads == 1 ? "" : "[" + i + "]");
                logger.debug(methodLogName + " - starting task thread [" + threadName + "].");
                this.taskThreads[i] = new Thread((Runnable)this, threadName);
                this.taskThreads[i].start();
            }
            boolean interruptDetected = Thread.interrupted();
            Semaphore semaphore = this.threadPermits;
            synchronized (semaphore) {
                while (this.threadPermits.availablePermits() != 0) {
                    try {
                        this.threadPermits.wait();
                    }
                    catch (InterruptedException ie) {
                        logger.debug(methodLogName + " - interrupt received whilst waiting" + " for all task threads to exit.");
                        interruptDetected = true;
                    }
                }
            }
            if (interruptDetected) {
                Thread.currentThread().interrupt();
            }
            logger.debug(methodLogName + " - task open.");
        } else {
            logger.debug(methodLogName + " - task already open.");
        }
    }

    @Override
    public final synchronized boolean isOpen() {
        String methodLogName = "ProcessingTask::isOpen() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.threadPermits.availablePermits() != this.numTaskThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void close() {
        String methodLogName = "ProcessingTask::close() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        logger.debug(methodLogName + " - closing task.");
        if (this.isOpen()) {
            logger.debug(methodLogName + " - enabling task closure.");
            this.taskClosureEnabled = true;
            boolean callerIsTaskThread = false;
            logger.debug(methodLogName + " - interrupting task threads.");
            Thread currentThread = Thread.currentThread();
            for (int i = 0; i < this.numTaskThreads; ++i) {
                if (currentThread == this.taskThreads[i]) {
                    callerIsTaskThread = true;
                }
                this.taskThreads[i].interrupt();
            }
            boolean interruptDetected = Thread.interrupted();
            int requiredPermits = callerIsTaskThread ? this.numTaskThreads - 1 : this.numTaskThreads;
            Semaphore semaphore = this.threadPermits;
            synchronized (semaphore) {
                while (this.threadPermits.availablePermits() != requiredPermits) {
                    try {
                        this.threadPermits.wait();
                    }
                    catch (InterruptedException ie) {
                        logger.debug(methodLogName + " - interrupt received whilst waiting" + " for all task threads to exit.");
                        interruptDetected = true;
                    }
                }
            }
            if (interruptDetected) {
                currentThread.interrupt();
            }
            logger.debug(methodLogName + (callerIsTaskThread ? " - task closing." : " - task closed."));
        } else {
            logger.debug(methodLogName + " - task already closed.");
        }
    }

    @Override
    public final synchronized void restart() {
        String methodLogName = "ProcessingTask::restart() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        boolean callerIsTaskThread = false;
        for (int i = 0; i < this.numTaskThreads; ++i) {
            if (Thread.currentThread() != this.taskThreads[i]) continue;
            callerIsTaskThread = true;
        }
        if (callerIsTaskThread) {
            String logMessage = methodLogName + " - this method must not be called from a task thread.";
            logger.fatal(logMessage);
            throw new AssertionError((Object)logMessage);
        }
        logger.debug(methodLogName + " - restarting task.");
        this.close();
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws IllegalStateException {
        Object logMessage;
        String methodLogName = "ProcessingTask::run() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        logger.debug(methodLogName + " - task thread started.");
        Message message = null;
        LinkedList<Message> msgList = new LinkedList<Message>();
        Semaphore semaphore = this.threadPermits;
        synchronized (semaphore) {
            if (!this.threadPermits.tryAcquire()) {
                String logMessage2 = methodLogName + " - unable to acquire thread permit.";
                logger.fatal(logMessage2);
                throw new AssertionError((Object)logMessage2);
            }
            this.threadPermits.notify();
        }
        do {
            if (!msgList.isEmpty()) {
                logMessage = methodLogName + " - message list not empty [" + msgList.size() + " elements] at start of task thread loop.";
                logger.fatal(logMessage);
                throw new AssertionError(logMessage);
            }
            logger.debug(methodLogName + " - waiting on message queue.");
            message = this.get(this.maxBlockPeriod);
            if (message == null) {
                logger.debug(methodLogName + " - no messages available.");
            } else {
                if (message.getMessageType() == 0) {
                    logger.debug(methodLogName + " - stream shutdown command received;" + " initiating task closure.");
                    this.close();
                }
                if (this.canProcessMessage(message)) {
                    logger.debug(methodLogName + " - message received for this task to process.");
                    msgList.add(message);
                    message = null;
                }
            }
            logger.debug(methodLogName + " - starting task-specific processing.");
            this.process(msgList);
            logger.debug(methodLogName + " - task-specific processing complete.");
            if (!msgList.isEmpty()) {
                logger.debug(methodLogName + " - forwarding processed messages to next task.");
            }
            while (!msgList.isEmpty()) {
                this.putNext(msgList.getFirst());
                msgList.removeFirst();
            }
            if (message == null) continue;
            logger.debug(methodLogName + " - forwarding unprocessed message to next task.");
            this.putNext(message);
        } while (!Thread.interrupted());
        if (this.taskClosureEnabled) {
            logger.debug(methodLogName + " - task thread interrupted;" + " task closure in progress. Terminating now.");
            logMessage = this.threadPermits;
            synchronized (logMessage) {
                this.threadPermits.release();
                if (this.threadPermits.availablePermits() > this.numTaskThreads) {
                    String logMessage3 = methodLogName + " - too many thread permits released.";
                    logger.fatal(logMessage3);
                    throw new AssertionError((Object)logMessage3);
                }
                this.threadPermits.notify();
            }
        } else {
            logMessage = methodLogName + " - task thread received an unexpected interrupt.";
            logger.fatal(logMessage);
            throw new IllegalStateException((String)logMessage);
        }
    }

    @Override
    public final Message get() {
        String methodLogName = "ProcessingTask::get() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.get(0L);
    }

    @Override
    public final Message get(long timeout) {
        String methodLogName = "ProcessingTask::get(long) [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        Message message = null;
        try {
            message = timeout == 0L ? this.msgQueue.take() : this.msgQueue.poll(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            logger.debug(methodLogName + " - interrupt received whilst waiting for message.");
            Thread.currentThread().interrupt();
        }
        if (message == null) {
            logger.debug(methodLogName + " - no message retrieved.");
        } else {
            logger.debug(methodLogName + " - message retrieved.");
        }
        return message;
    }

    @Override
    public final void put(Message message) {
        String methodLogName = "ProcessingTask::put() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        if (this.canProcessMessage(message) || !message.permitsFastForwarding()) {
            boolean interruptDetected = Thread.interrupted();
            while (true) {
                try {
                    this.msgQueue.put(message);
                    logger.debug(methodLogName + " - added message to queue.");
                }
                catch (InterruptedException ie) {
                    logger.debug(methodLogName + " - interrupt received whilst waiting" + " to queue a message.");
                    interruptDetected = true;
                    continue;
                }
                break;
            }
            if (interruptDetected) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.putNext(message);
        }
    }

    @Override
    public final void putNext(Message message) {
        String methodLogName = "ProcessingTask::putNext() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        logger.debug(methodLogName + " - forwarding message to next task.");
        this.nextTask.put(message);
    }

    @Override
    public final String getTaskName() {
        String methodLogName = "ProcessingTask::getTaskName() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.taskName;
    }

    public final int getNumTaskThreads() {
        String methodLogName = "ProcessingTask::getNumTaskThreads() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.numTaskThreads;
    }

    public final long getMaxBlockPeriod() {
        String methodLogName = "ProcessingTask::getMaxBlockPeriod() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.maxBlockPeriod;
    }

    @Override
    public final Task getNextTask() {
        String methodLogName = "ProcessingTask::getNextTask() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.nextTask;
    }

    @Override
    public final Task setNextTask(Task task) {
        String methodLogName = "ProcessingTask::setNextTask() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        if (this.isOpen()) {
            String logMessage = methodLogName + " - task must not be open when calling this method.";
            logger.fatal(logMessage);
            throw new AssertionError((Object)logMessage);
        }
        Task oldTask = this.nextTask;
        this.nextTask = task;
        logger.debug(methodLogName + " - next task set [previously: " + (oldTask == null ? "null][now: " : oldTask.getTaskName() + "][now: ") + (this.nextTask == null ? "null]." : this.nextTask.getTaskName() + "]."));
        return oldTask;
    }

    @Override
    public final Module getContainingModule() {
        String methodLogName = "ProcessingTask::getContainingModule() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        return this.containingModule;
    }

    @Override
    public final Module setContainingModule(Module module) {
        String methodLogName = "ProcessingTask::setContainingModule() [for task " + this.taskName + "]";
        logger.trace(methodLogName + ".");
        if (this.isOpen()) {
            String logMessage = methodLogName + " - task must not be open when calling this method.";
            logger.fatal(logMessage);
            throw new AssertionError((Object)logMessage);
        }
        Module oldModule = this.containingModule;
        this.containingModule = module;
        logger.debug(methodLogName + " - containing module set.");
        return oldModule;
    }

    protected abstract boolean canProcessMessage(Message var1);

    protected abstract void process(List<Message> var1);
}

