/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.spreadsheet.renderer;

import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.HasTaskIndicators;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.pm.graphic.spreadsheet.renderer.IndicatorsComponent;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.strings.Messages;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TaskIndicatorsComponent
extends IndicatorsComponent {
    private static final long serialVersionUID = 192992920101L;
    protected JLabel calendar;
    protected JLabel constraint;
    protected JLabel invalidCalendar;
    protected JLabel notes;
    protected JLabel completed;
    protected JLabel empty;
    protected JLabel missedDeadline;
    protected JLabel parentAssignment;
    protected JLabel subproject;
    protected JLabel invalidProject;
    protected JLabel delegated;
    protected JLabel delegatedMe;
    Field constraintTypeField = Configuration.getFieldFromId("Field.constraintType");
    Field constraintDateField = Configuration.getFieldFromId("Field.constraintDate");
    Field deadlineField = Configuration.getFieldFromId("Field.deadline");
    Field finish = Configuration.getFieldFromId("Field.finish");

    @Override
    public boolean acceptValue(Object object) {
        return TaskIndicatorsComponent.acceptTask(object);
    }

    public static boolean acceptTask(Object object) {
        return object instanceof HasTaskIndicators;
    }

    @Override
    public void init() {
        this.calendar = new JLabel(" ", IconManager.getIcon("indicator.calendar"), 4);
        this.calendar.setOpaque(false);
        this.constraint = new JLabel(" ", IconManager.getIcon("indicator.constraint"), 4);
        this.constraint.setOpaque(false);
        this.invalidCalendar = new JLabel(" ", IconManager.getIcon("indicator.invalidCalendar"), 4);
        this.invalidCalendar.setOpaque(false);
        this.notes = new JLabel(" ", IconManager.getIcon("indicator.note"), 4);
        this.notes.setOpaque(false);
        this.parentAssignment = new JLabel(" ", IconManager.getIcon("indicator.parentAssignment"), 4);
        this.parentAssignment.setOpaque(false);
        this.completed = new JLabel(" ", IconManager.getIcon("indicator.completed"), 4);
        this.completed.setOpaque(false);
        this.missedDeadline = new JLabel(" ", IconManager.getIcon("indicator.missedDeadline"), 4);
        this.missedDeadline.setOpaque(false);
        this.subproject = new JLabel(" ", IconManager.getIcon("indicator.subproject"), 4);
        this.subproject.setOpaque(false);
        this.invalidProject = new JLabel(" ", IconManager.getIcon("indicator.invalidProject"), 4);
        this.invalidProject.setOpaque(false);
        this.delegated = new JLabel(" ", IconManager.getIcon("indicator.delegated"), 4);
        this.delegated.setOpaque(false);
        this.delegatedMe = new JLabel(" ", IconManager.getIcon("indicator.delegatedMe"), 4);
        this.delegatedMe.setOpaque(false);
    }

    @Override
    public void setIndicators(Object object, JComponent jComponent, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        String string;
        long l;
        HasTaskIndicators hasTaskIndicators = (HasTaskIndicators)object;
        if (hasTaskIndicators.getWorkCalendar() != null) {
            this.setLook(this.calendar, bl, bl2);
            jComponent.add(this.calendar);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.TheCalendar") + hasTaskIndicators.getWorkCalendar().getName() + Messages.getString("TaskIndicatorsComponent.isAssignedToTheTask"));
        }
        if ((l = hasTaskIndicators.getConstraintDate()) != 0L) {
            this.setLook(this.constraint, bl, bl2);
            jComponent.add(this.constraint);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisTaskHasA") + this.constraintTypeField.getText(hasTaskIndicators, null) + Messages.getString("TaskIndicatorsComponent.constraintOn") + this.constraintDateField.getText(hasTaskIndicators, null) + "<br>");
        }
        if (hasTaskIndicators.isInvalidIntersectionCalendar()) {
            this.setLook(this.invalidCalendar, bl, bl2);
            jComponent.add(this.invalidCalendar);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.TheIntersection"));
        }
        if ((string = hasTaskIndicators.getNotes()) != null && string.length() > 0) {
            this.setLook(this.notes, bl, bl2);
            jComponent.add(this.notes);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.Notes") + string + "'<br>");
        }
        if (hasTaskIndicators.isComplete()) {
            this.setLook(this.completed, bl, bl2);
            jComponent.add(this.completed);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.TheTaskWasCompletedOn") + this.finish.getText(hasTaskIndicators, null) + "<br>");
        }
        if (hasTaskIndicators.isParentWithAssignments()) {
            this.setLook(this.parentAssignment, bl, bl2);
            jComponent.add(this.parentAssignment);
            stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisParentTaskHasResources") + ((NormalTask)hasTaskIndicators).getResourceNames() + "<br>");
        }
        if (hasTaskIndicators instanceof Task) {
            Task task = (Task)((Object)hasTaskIndicators);
            if (task.isSubproject()) {
                SubProj subProj = (SubProj)((Object)task);
                if (subProj.isValid()) {
                    this.setLook(this.subproject, bl, bl2);
                    jComponent.add(this.subproject);
                    stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisTasksRepresentsThe") + (subProj.isSubprojectOpen() ? Messages.getString("TaskIndicatorsComponent.opened") : Messages.getString("TaskIndicatorsComponent.unopened")) + Messages.getString("TaskIndicatorsComponent.subproject") + ((Task)((Object)subProj)).getName());
                } else {
                    this.setLook(this.invalidProject, bl, bl2);
                    jComponent.add(this.invalidProject);
                    stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisSubprojectIsNotValid"));
                }
            }
            if (task.isMissedDeadline()) {
                this.setLook(this.missedDeadline, bl, bl2);
                jComponent.add(this.missedDeadline);
                stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisTaskFinishesOn") + this.finish.getText(hasTaskIndicators, null) + Messages.getString("TaskIndicatorsComponent.whichIsAfterItsDeadline") + this.deadlineField.getText(hasTaskIndicators, null));
            }
            if (task.getDelegatedTo() != null) {
                if (task.isDelegatedToUser()) {
                    this.setLook(this.delegatedMe, bl, bl2);
                    jComponent.add(this.delegatedMe);
                    stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisTaskHasBeenDelegatedToYou"));
                } else {
                    this.setLook(this.delegated, bl, bl2);
                    jComponent.add(this.delegated);
                    stringBuffer.append(Messages.getString("TaskIndicatorsComponent.ThisTaskHasBeenDelegatedTo") + task.getDelegatedTo().getName());
                }
            }
        }
    }
}

