package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/authorization/mgmt/2020-10-01/authorization"

// ApprovalSettings the approval settings.
type ApprovalSettings struct {
	// IsApprovalRequired - Determines whether approval is required or not.
	IsApprovalRequired *bool `json:"isApprovalRequired,omitempty"`
	// IsApprovalRequiredForExtension - Determines whether approval is required for assignment extension.
	IsApprovalRequiredForExtension *bool `json:"isApprovalRequiredForExtension,omitempty"`
	// IsRequestorJustificationRequired - Determine whether requestor justification is required.
	IsRequestorJustificationRequired *bool `json:"isRequestorJustificationRequired,omitempty"`
	// ApprovalMode - The type of rule. Possible values include: 'ApprovalModeSingleStage', 'ApprovalModeSerial', 'ApprovalModeParallel', 'ApprovalModeNoApproval'
	ApprovalMode ApprovalMode `json:"approvalMode,omitempty"`
	// ApprovalStages - The approval stages of the request.
	ApprovalStages *[]ApprovalStage `json:"approvalStages,omitempty"`
}

// ApprovalStage the approval stage.
type ApprovalStage struct {
	// ApprovalStageTimeOutInDays - The time in days when approval request would be timed out
	ApprovalStageTimeOutInDays *int32 `json:"approvalStageTimeOutInDays,omitempty"`
	// IsApproverJustificationRequired - Determines whether approver need to provide justification for his decision.
	IsApproverJustificationRequired *bool `json:"isApproverJustificationRequired,omitempty"`
	// EscalationTimeInMinutes - The time in minutes when the approval request would be escalated if the primary approver does not approve
	EscalationTimeInMinutes *int32 `json:"escalationTimeInMinutes,omitempty"`
	// PrimaryApprovers - The primary approver of the request.
	PrimaryApprovers *[]UserSet `json:"primaryApprovers,omitempty"`
	// IsEscalationEnabled - The value determine whether escalation feature is enabled.
	IsEscalationEnabled *bool `json:"isEscalationEnabled,omitempty"`
	// EscalationApprovers - The escalation approver of the request.
	EscalationApprovers *[]UserSet `json:"escalationApprovers,omitempty"`
}

// ClassicAdministrator classic Administrators
type ClassicAdministrator struct {
	// ID - The ID of the administrator.
	ID *string `json:"id,omitempty"`
	// Name - The name of the administrator.
	Name *string `json:"name,omitempty"`
	// Type - The type of the administrator.
	Type *string `json:"type,omitempty"`
	// ClassicAdministratorProperties - Properties for the classic administrator.
	*ClassicAdministratorProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClassicAdministrator.
func (ca ClassicAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ca.ID != nil {
		objectMap["id"] = ca.ID
	}
	if ca.Name != nil {
		objectMap["name"] = ca.Name
	}
	if ca.Type != nil {
		objectMap["type"] = ca.Type
	}
	if ca.ClassicAdministratorProperties != nil {
		objectMap["properties"] = ca.ClassicAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClassicAdministrator struct.
func (ca *ClassicAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var classicAdministratorProperties ClassicAdministratorProperties
				err = json.Unmarshal(*v, &classicAdministratorProperties)
				if err != nil {
					return err
				}
				ca.ClassicAdministratorProperties = &classicAdministratorProperties
			}
		}
	}

	return nil
}

// ClassicAdministratorListResult classicAdministrator list result information.
type ClassicAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of administrators.
	Value *[]ClassicAdministrator `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClassicAdministratorListResultIterator provides access to a complete listing of ClassicAdministrator
// values.
type ClassicAdministratorListResultIterator struct {
	i    int
	page ClassicAdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClassicAdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClassicAdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClassicAdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClassicAdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClassicAdministratorListResultIterator) Response() ClassicAdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClassicAdministratorListResultIterator) Value() ClassicAdministrator {
	if !iter.page.NotDone() {
		return ClassicAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClassicAdministratorListResultIterator type.
func NewClassicAdministratorListResultIterator(page ClassicAdministratorListResultPage) ClassicAdministratorListResultIterator {
	return ClassicAdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (calr ClassicAdministratorListResult) IsEmpty() bool {
	return calr.Value == nil || len(*calr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (calr ClassicAdministratorListResult) hasNextLink() bool {
	return calr.NextLink != nil && len(*calr.NextLink) != 0
}

// classicAdministratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (calr ClassicAdministratorListResult) classicAdministratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !calr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(calr.NextLink)))
}

// ClassicAdministratorListResultPage contains a page of ClassicAdministrator values.
type ClassicAdministratorListResultPage struct {
	fn   func(context.Context, ClassicAdministratorListResult) (ClassicAdministratorListResult, error)
	calr ClassicAdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClassicAdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClassicAdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.calr)
		if err != nil {
			return err
		}
		page.calr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClassicAdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClassicAdministratorListResultPage) NotDone() bool {
	return !page.calr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClassicAdministratorListResultPage) Response() ClassicAdministratorListResult {
	return page.calr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClassicAdministratorListResultPage) Values() []ClassicAdministrator {
	if page.calr.IsEmpty() {
		return nil
	}
	return *page.calr.Value
}

// Creates a new instance of the ClassicAdministratorListResultPage type.
func NewClassicAdministratorListResultPage(cur ClassicAdministratorListResult, getNextPage func(context.Context, ClassicAdministratorListResult) (ClassicAdministratorListResult, error)) ClassicAdministratorListResultPage {
	return ClassicAdministratorListResultPage{
		fn:   getNextPage,
		calr: cur,
	}
}

// ClassicAdministratorProperties classic Administrator properties.
type ClassicAdministratorProperties struct {
	// EmailAddress - The email address of the administrator.
	EmailAddress *string `json:"emailAddress,omitempty"`
	// Role - The role of the administrator.
	Role *string `json:"role,omitempty"`
}

// CloudError an error response from the service.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
}

// EligibleChildResource eligible child resource
type EligibleChildResource struct {
	// ID - READ-ONLY; The resource scope Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EligibleChildResource.
func (ecr EligibleChildResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EligibleChildResourcesListResult eligible child resources list operation result.
type EligibleChildResourcesListResult struct {
	autorest.Response `json:"-"`
	// Value - Eligible child resource list.
	Value *[]EligibleChildResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EligibleChildResourcesListResultIterator provides access to a complete listing of EligibleChildResource
// values.
type EligibleChildResourcesListResultIterator struct {
	i    int
	page EligibleChildResourcesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EligibleChildResourcesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EligibleChildResourcesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EligibleChildResourcesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EligibleChildResourcesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EligibleChildResourcesListResultIterator) Response() EligibleChildResourcesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EligibleChildResourcesListResultIterator) Value() EligibleChildResource {
	if !iter.page.NotDone() {
		return EligibleChildResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EligibleChildResourcesListResultIterator type.
func NewEligibleChildResourcesListResultIterator(page EligibleChildResourcesListResultPage) EligibleChildResourcesListResultIterator {
	return EligibleChildResourcesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ecrlr EligibleChildResourcesListResult) IsEmpty() bool {
	return ecrlr.Value == nil || len(*ecrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ecrlr EligibleChildResourcesListResult) hasNextLink() bool {
	return ecrlr.NextLink != nil && len(*ecrlr.NextLink) != 0
}

// eligibleChildResourcesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ecrlr EligibleChildResourcesListResult) eligibleChildResourcesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ecrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ecrlr.NextLink)))
}

// EligibleChildResourcesListResultPage contains a page of EligibleChildResource values.
type EligibleChildResourcesListResultPage struct {
	fn    func(context.Context, EligibleChildResourcesListResult) (EligibleChildResourcesListResult, error)
	ecrlr EligibleChildResourcesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EligibleChildResourcesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EligibleChildResourcesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ecrlr)
		if err != nil {
			return err
		}
		page.ecrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EligibleChildResourcesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EligibleChildResourcesListResultPage) NotDone() bool {
	return !page.ecrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EligibleChildResourcesListResultPage) Response() EligibleChildResourcesListResult {
	return page.ecrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EligibleChildResourcesListResultPage) Values() []EligibleChildResource {
	if page.ecrlr.IsEmpty() {
		return nil
	}
	return *page.ecrlr.Value
}

// Creates a new instance of the EligibleChildResourcesListResultPage type.
func NewEligibleChildResourcesListResultPage(cur EligibleChildResourcesListResult, getNextPage func(context.Context, EligibleChildResourcesListResult) (EligibleChildResourcesListResult, error)) EligibleChildResourcesListResultPage {
	return EligibleChildResourcesListResultPage{
		fn:    getNextPage,
		ecrlr: cur,
	}
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExpandedProperties expanded info of resource, role and principal
type ExpandedProperties struct {
	// Scope - Details of the resource scope
	Scope *ExpandedPropertiesScope `json:"scope,omitempty"`
	// RoleDefinition - Details of role definition
	RoleDefinition *ExpandedPropertiesRoleDefinition `json:"roleDefinition,omitempty"`
	// Principal - Details of the principal
	Principal *ExpandedPropertiesPrincipal `json:"principal,omitempty"`
}

// ExpandedPropertiesPrincipal details of the principal
type ExpandedPropertiesPrincipal struct {
	// ID - Id of the principal
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the principal
	DisplayName *string `json:"displayName,omitempty"`
	// Email - Email id of the principal
	Email *string `json:"email,omitempty"`
	// Type - Type of the principal
	Type *string `json:"type,omitempty"`
}

// ExpandedPropertiesRoleDefinition details of role definition
type ExpandedPropertiesRoleDefinition struct {
	// ID - Id of the role definition
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the role definition
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of the role definition
	Type *string `json:"type,omitempty"`
}

// ExpandedPropertiesScope details of the resource scope
type ExpandedPropertiesScope struct {
	// ID - Scope id of the resource
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the resource
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of the resource
	Type *string `json:"type,omitempty"`
}

// Permission role definition permissions.
type Permission struct {
	// Actions - Allowed actions.
	Actions *[]string `json:"actions,omitempty"`
	// NotActions - Denied actions.
	NotActions *[]string `json:"notActions,omitempty"`
	// DataActions - Allowed Data actions.
	DataActions *[]string `json:"dataActions,omitempty"`
	// NotDataActions - Denied Data actions.
	NotDataActions *[]string `json:"notDataActions,omitempty"`
}

// PermissionGetResult permissions information.
type PermissionGetResult struct {
	autorest.Response `json:"-"`
	// Value - An array of permissions.
	Value *[]Permission `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// PermissionGetResultIterator provides access to a complete listing of Permission values.
type PermissionGetResultIterator struct {
	i    int
	page PermissionGetResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PermissionGetResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PermissionGetResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PermissionGetResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PermissionGetResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PermissionGetResultIterator) Response() PermissionGetResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PermissionGetResultIterator) Value() Permission {
	if !iter.page.NotDone() {
		return Permission{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PermissionGetResultIterator type.
func NewPermissionGetResultIterator(page PermissionGetResultPage) PermissionGetResultIterator {
	return PermissionGetResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pgr PermissionGetResult) IsEmpty() bool {
	return pgr.Value == nil || len(*pgr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pgr PermissionGetResult) hasNextLink() bool {
	return pgr.NextLink != nil && len(*pgr.NextLink) != 0
}

// permissionGetResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pgr PermissionGetResult) permissionGetResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pgr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pgr.NextLink)))
}

// PermissionGetResultPage contains a page of Permission values.
type PermissionGetResultPage struct {
	fn  func(context.Context, PermissionGetResult) (PermissionGetResult, error)
	pgr PermissionGetResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PermissionGetResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PermissionGetResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pgr)
		if err != nil {
			return err
		}
		page.pgr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PermissionGetResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PermissionGetResultPage) NotDone() bool {
	return !page.pgr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PermissionGetResultPage) Response() PermissionGetResult {
	return page.pgr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PermissionGetResultPage) Values() []Permission {
	if page.pgr.IsEmpty() {
		return nil
	}
	return *page.pgr.Value
}

// Creates a new instance of the PermissionGetResultPage type.
func NewPermissionGetResultPage(cur PermissionGetResult, getNextPage func(context.Context, PermissionGetResult) (PermissionGetResult, error)) PermissionGetResultPage {
	return PermissionGetResultPage{
		fn:  getNextPage,
		pgr: cur,
	}
}

// PolicyAssignmentProperties expanded info of resource scope, role definition and policy
type PolicyAssignmentProperties struct {
	// Scope - Details of the resource scope
	Scope *PolicyAssignmentPropertiesScope `json:"scope,omitempty"`
	// RoleDefinition - Details of role definition
	RoleDefinition *PolicyAssignmentPropertiesRoleDefinition `json:"roleDefinition,omitempty"`
	// Policy - Details of the policy
	Policy *PolicyAssignmentPropertiesPolicy `json:"policy,omitempty"`
}

// PolicyAssignmentPropertiesPolicy details of the policy
type PolicyAssignmentPropertiesPolicy struct {
	// ID - Id of the policy
	ID             *string    `json:"id,omitempty"`
	LastModifiedBy *Principal `json:"lastModifiedBy,omitempty"`
	// LastModifiedDateTime - The last modified date time.
	LastModifiedDateTime *date.Time `json:"lastModifiedDateTime,omitempty"`
}

// PolicyAssignmentPropertiesRoleDefinition details of role definition
type PolicyAssignmentPropertiesRoleDefinition struct {
	// ID - Id of the role definition
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the role definition
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of the role definition
	Type *string `json:"type,omitempty"`
}

// PolicyAssignmentPropertiesScope details of the resource scope
type PolicyAssignmentPropertiesScope struct {
	// ID - Scope id of the resource
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the resource
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of the resource
	Type *string `json:"type,omitempty"`
}

// PolicyProperties expanded info of resource scope
type PolicyProperties struct {
	// Scope - READ-ONLY; Details of the resource scope
	Scope *PolicyPropertiesScope `json:"scope,omitempty"`
}

// MarshalJSON is the custom marshaler for PolicyProperties.
func (pp PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PolicyPropertiesScope details of the resource scope
type PolicyPropertiesScope struct {
	// ID - Scope id of the resource
	ID *string `json:"id,omitempty"`
	// DisplayName - Display name of the resource
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of the resource
	Type *string `json:"type,omitempty"`
}

// Principal the name of the entity last modified it
type Principal struct {
	// ID - The id of the principal made changes
	ID *string `json:"id,omitempty"`
	// DisplayName - The name of the principal made changes
	DisplayName *string `json:"displayName,omitempty"`
	// Type - Type of principal such as user , group etc
	Type *string `json:"type,omitempty"`
	// Email - Email of principal
	Email *string `json:"email,omitempty"`
}

// ProviderOperation operation
type ProviderOperation struct {
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// DisplayName - The operation display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The operation description.
	Description *string `json:"description,omitempty"`
	// Origin - The operation origin.
	Origin *string `json:"origin,omitempty"`
	// Properties - The operation properties.
	Properties interface{} `json:"properties,omitempty"`
}

// ProviderOperationsMetadata provider Operations metadata
type ProviderOperationsMetadata struct {
	autorest.Response `json:"-"`
	// ID - The provider id.
	ID *string `json:"id,omitempty"`
	// Name - The provider name.
	Name *string `json:"name,omitempty"`
	// Type - The provider type.
	Type *string `json:"type,omitempty"`
	// DisplayName - The provider display name.
	DisplayName *string `json:"displayName,omitempty"`
	// ResourceTypes - The provider resource types
	ResourceTypes *[]ResourceType `json:"resourceTypes,omitempty"`
	// Operations - The provider operations.
	Operations *[]ProviderOperation `json:"operations,omitempty"`
}

// ProviderOperationsMetadataListResult provider operations metadata list
type ProviderOperationsMetadataListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of providers.
	Value *[]ProviderOperationsMetadata `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderOperationsMetadataListResultIterator provides access to a complete listing of
// ProviderOperationsMetadata values.
type ProviderOperationsMetadataListResultIterator struct {
	i    int
	page ProviderOperationsMetadataListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderOperationsMetadataListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationsMetadataListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderOperationsMetadataListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderOperationsMetadataListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderOperationsMetadataListResultIterator) Response() ProviderOperationsMetadataListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderOperationsMetadataListResultIterator) Value() ProviderOperationsMetadata {
	if !iter.page.NotDone() {
		return ProviderOperationsMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderOperationsMetadataListResultIterator type.
func NewProviderOperationsMetadataListResultIterator(page ProviderOperationsMetadataListResultPage) ProviderOperationsMetadataListResultIterator {
	return ProviderOperationsMetadataListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pomlr ProviderOperationsMetadataListResult) IsEmpty() bool {
	return pomlr.Value == nil || len(*pomlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pomlr ProviderOperationsMetadataListResult) hasNextLink() bool {
	return pomlr.NextLink != nil && len(*pomlr.NextLink) != 0
}

// providerOperationsMetadataListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pomlr ProviderOperationsMetadataListResult) providerOperationsMetadataListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !pomlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pomlr.NextLink)))
}

// ProviderOperationsMetadataListResultPage contains a page of ProviderOperationsMetadata values.
type ProviderOperationsMetadataListResultPage struct {
	fn    func(context.Context, ProviderOperationsMetadataListResult) (ProviderOperationsMetadataListResult, error)
	pomlr ProviderOperationsMetadataListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderOperationsMetadataListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationsMetadataListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pomlr)
		if err != nil {
			return err
		}
		page.pomlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderOperationsMetadataListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderOperationsMetadataListResultPage) NotDone() bool {
	return !page.pomlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderOperationsMetadataListResultPage) Response() ProviderOperationsMetadataListResult {
	return page.pomlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderOperationsMetadataListResultPage) Values() []ProviderOperationsMetadata {
	if page.pomlr.IsEmpty() {
		return nil
	}
	return *page.pomlr.Value
}

// Creates a new instance of the ProviderOperationsMetadataListResultPage type.
func NewProviderOperationsMetadataListResultPage(cur ProviderOperationsMetadataListResult, getNextPage func(context.Context, ProviderOperationsMetadataListResult) (ProviderOperationsMetadataListResult, error)) ProviderOperationsMetadataListResultPage {
	return ProviderOperationsMetadataListResultPage{
		fn:    getNextPage,
		pomlr: cur,
	}
}

// ResourceType resource Type
type ResourceType struct {
	// Name - The resource type name.
	Name *string `json:"name,omitempty"`
	// DisplayName - The resource type display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Operations - The resource type operations.
	Operations *[]ProviderOperation `json:"operations,omitempty"`
}

// RoleAssignment role Assignments
type RoleAssignment struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role assignment ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role assignment name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role assignment type.
	Type *string `json:"type,omitempty"`
	// Properties - Role assignment properties.
	Properties *RoleAssignmentPropertiesWithScope `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignment.
func (ra RoleAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.Properties != nil {
		objectMap["properties"] = ra.Properties
	}
	return json.Marshal(objectMap)
}

// RoleAssignmentCreateParameters role assignment create parameters.
type RoleAssignmentCreateParameters struct {
	// Properties - Role assignment properties.
	Properties *RoleAssignmentProperties `json:"properties,omitempty"`
}

// RoleAssignmentFilter role Assignments filter
type RoleAssignmentFilter struct {
	// PrincipalID - Returns role assignment of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
}

// RoleAssignmentListResult role assignment list operation result.
type RoleAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Role assignment list.
	Value *[]RoleAssignment `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentListResultIterator provides access to a complete listing of RoleAssignment values.
type RoleAssignmentListResultIterator struct {
	i    int
	page RoleAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentListResultIterator) Response() RoleAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentListResultIterator) Value() RoleAssignment {
	if !iter.page.NotDone() {
		return RoleAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentListResultIterator type.
func NewRoleAssignmentListResultIterator(page RoleAssignmentListResultPage) RoleAssignmentListResultIterator {
	return RoleAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ralr RoleAssignmentListResult) IsEmpty() bool {
	return ralr.Value == nil || len(*ralr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ralr RoleAssignmentListResult) hasNextLink() bool {
	return ralr.NextLink != nil && len(*ralr.NextLink) != 0
}

// roleAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ralr RoleAssignmentListResult) roleAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ralr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ralr.NextLink)))
}

// RoleAssignmentListResultPage contains a page of RoleAssignment values.
type RoleAssignmentListResultPage struct {
	fn   func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)
	ralr RoleAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ralr)
		if err != nil {
			return err
		}
		page.ralr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentListResultPage) NotDone() bool {
	return !page.ralr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentListResultPage) Response() RoleAssignmentListResult {
	return page.ralr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentListResultPage) Values() []RoleAssignment {
	if page.ralr.IsEmpty() {
		return nil
	}
	return *page.ralr.Value
}

// Creates a new instance of the RoleAssignmentListResultPage type.
func NewRoleAssignmentListResultPage(cur RoleAssignmentListResult, getNextPage func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)) RoleAssignmentListResultPage {
	return RoleAssignmentListResultPage{
		fn:   getNextPage,
		ralr: cur,
	}
}

// RoleAssignmentProperties role assignment properties.
type RoleAssignmentProperties struct {
	// RoleDefinitionID - The role definition ID used in the role assignment.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID assigned to the role. This maps to the ID inside the Active Directory. It can point to a user, service principal, or security group.
	PrincipalID *string `json:"principalId,omitempty"`
}

// RoleAssignmentPropertiesWithScope role assignment properties with scope.
type RoleAssignmentPropertiesWithScope struct {
	// Scope - The role assignment scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
}

// RoleAssignmentSchedule role Assignment schedule
type RoleAssignmentSchedule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role assignment schedule Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role assignment schedule name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role assignment schedule type.
	Type *string `json:"type,omitempty"`
	// RoleAssignmentScheduleProperties - Role assignment schedule properties.
	*RoleAssignmentScheduleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentSchedule.
func (ras RoleAssignmentSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ras.RoleAssignmentScheduleProperties != nil {
		objectMap["properties"] = ras.RoleAssignmentScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentSchedule struct.
func (ras *RoleAssignmentSchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ras.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ras.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ras.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleAssignmentScheduleProperties RoleAssignmentScheduleProperties
				err = json.Unmarshal(*v, &roleAssignmentScheduleProperties)
				if err != nil {
					return err
				}
				ras.RoleAssignmentScheduleProperties = &roleAssignmentScheduleProperties
			}
		}
	}

	return nil
}

// RoleAssignmentScheduleFilter role assignment schedule filter
type RoleAssignmentScheduleFilter struct {
	// PrincipalID - Returns role assignment schedule of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role assignment schedule of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Status - Returns role assignment schedule instances of the specific status.
	Status *string `json:"status,omitempty"`
}

// RoleAssignmentScheduleInstance information about current or upcoming role assignment schedule instance
type RoleAssignmentScheduleInstance struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role assignment schedule instance ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role assignment schedule instance name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role assignment schedule instance type.
	Type *string `json:"type,omitempty"`
	// RoleAssignmentScheduleInstanceProperties - Role assignment schedule instance properties.
	*RoleAssignmentScheduleInstanceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentScheduleInstance.
func (rasi RoleAssignmentScheduleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rasi.RoleAssignmentScheduleInstanceProperties != nil {
		objectMap["properties"] = rasi.RoleAssignmentScheduleInstanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentScheduleInstance struct.
func (rasi *RoleAssignmentScheduleInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rasi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rasi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rasi.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleAssignmentScheduleInstanceProperties RoleAssignmentScheduleInstanceProperties
				err = json.Unmarshal(*v, &roleAssignmentScheduleInstanceProperties)
				if err != nil {
					return err
				}
				rasi.RoleAssignmentScheduleInstanceProperties = &roleAssignmentScheduleInstanceProperties
			}
		}
	}

	return nil
}

// RoleAssignmentScheduleInstanceFilter role assignment schedule instance filter
type RoleAssignmentScheduleInstanceFilter struct {
	// PrincipalID - Returns role assignment schedule instances of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role assignment schedule instances of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Status - Returns role assignment schedule instances of the specific status.
	Status *string `json:"status,omitempty"`
	// RoleAssignmentScheduleID - Returns role assignment schedule instances belonging to a specific role assignment schedule.
	RoleAssignmentScheduleID *string `json:"roleAssignmentScheduleId,omitempty"`
}

// RoleAssignmentScheduleInstanceListResult role assignment schedule instance list operation result.
type RoleAssignmentScheduleInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - Role assignment schedule instance list.
	Value *[]RoleAssignmentScheduleInstance `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentScheduleInstanceListResultIterator provides access to a complete listing of
// RoleAssignmentScheduleInstance values.
type RoleAssignmentScheduleInstanceListResultIterator struct {
	i    int
	page RoleAssignmentScheduleInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentScheduleInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentScheduleInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentScheduleInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentScheduleInstanceListResultIterator) Response() RoleAssignmentScheduleInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentScheduleInstanceListResultIterator) Value() RoleAssignmentScheduleInstance {
	if !iter.page.NotDone() {
		return RoleAssignmentScheduleInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentScheduleInstanceListResultIterator type.
func NewRoleAssignmentScheduleInstanceListResultIterator(page RoleAssignmentScheduleInstanceListResultPage) RoleAssignmentScheduleInstanceListResultIterator {
	return RoleAssignmentScheduleInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rasilr RoleAssignmentScheduleInstanceListResult) IsEmpty() bool {
	return rasilr.Value == nil || len(*rasilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rasilr RoleAssignmentScheduleInstanceListResult) hasNextLink() bool {
	return rasilr.NextLink != nil && len(*rasilr.NextLink) != 0
}

// roleAssignmentScheduleInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rasilr RoleAssignmentScheduleInstanceListResult) roleAssignmentScheduleInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rasilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rasilr.NextLink)))
}

// RoleAssignmentScheduleInstanceListResultPage contains a page of RoleAssignmentScheduleInstance values.
type RoleAssignmentScheduleInstanceListResultPage struct {
	fn     func(context.Context, RoleAssignmentScheduleInstanceListResult) (RoleAssignmentScheduleInstanceListResult, error)
	rasilr RoleAssignmentScheduleInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentScheduleInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rasilr)
		if err != nil {
			return err
		}
		page.rasilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentScheduleInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentScheduleInstanceListResultPage) NotDone() bool {
	return !page.rasilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentScheduleInstanceListResultPage) Response() RoleAssignmentScheduleInstanceListResult {
	return page.rasilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentScheduleInstanceListResultPage) Values() []RoleAssignmentScheduleInstance {
	if page.rasilr.IsEmpty() {
		return nil
	}
	return *page.rasilr.Value
}

// Creates a new instance of the RoleAssignmentScheduleInstanceListResultPage type.
func NewRoleAssignmentScheduleInstanceListResultPage(cur RoleAssignmentScheduleInstanceListResult, getNextPage func(context.Context, RoleAssignmentScheduleInstanceListResult) (RoleAssignmentScheduleInstanceListResult, error)) RoleAssignmentScheduleInstanceListResultPage {
	return RoleAssignmentScheduleInstanceListResultPage{
		fn:     getNextPage,
		rasilr: cur,
	}
}

// RoleAssignmentScheduleInstanceProperties role assignment schedule properties with scope.
type RoleAssignmentScheduleInstanceProperties struct {
	// Scope - The role assignment schedule scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RoleAssignmentScheduleID - Id of the master role assignment schedule
	RoleAssignmentScheduleID *string `json:"roleAssignmentScheduleId,omitempty"`
	// OriginRoleAssignmentID - Role Assignment Id in external system
	OriginRoleAssignmentID *string `json:"originRoleAssignmentId,omitempty"`
	// Status - The status of the role assignment schedule instance. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// StartDateTime - The startDateTime of the role assignment schedule instance
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - The endDateTime of the role assignment schedule instance
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// LinkedRoleEligibilityScheduleID - roleEligibilityScheduleId used to activate
	LinkedRoleEligibilityScheduleID *string `json:"linkedRoleEligibilityScheduleId,omitempty"`
	// LinkedRoleEligibilityScheduleInstanceID - roleEligibilityScheduleInstanceId linked to this roleAssignmentScheduleInstance
	LinkedRoleEligibilityScheduleInstanceID *string `json:"linkedRoleEligibilityScheduleInstanceId,omitempty"`
	// AssignmentType - Assignment type of the role assignment schedule. Possible values include: 'AssignmentTypeActivated', 'AssignmentTypeAssigned'
	AssignmentType AssignmentType `json:"assignmentType,omitempty"`
	// MemberType - Membership type of the role assignment schedule. Possible values include: 'MemberTypeInherited', 'MemberTypeDirect', 'MemberTypeGroup'
	MemberType MemberType `json:"memberType,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - DateTime when role assignment schedule was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ExpandedProperties - Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// RoleAssignmentScheduleListResult role assignment schedule list operation result.
type RoleAssignmentScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - Role assignment schedule list.
	Value *[]RoleAssignmentSchedule `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentScheduleListResultIterator provides access to a complete listing of RoleAssignmentSchedule
// values.
type RoleAssignmentScheduleListResultIterator struct {
	i    int
	page RoleAssignmentScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentScheduleListResultIterator) Response() RoleAssignmentScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentScheduleListResultIterator) Value() RoleAssignmentSchedule {
	if !iter.page.NotDone() {
		return RoleAssignmentSchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentScheduleListResultIterator type.
func NewRoleAssignmentScheduleListResultIterator(page RoleAssignmentScheduleListResultPage) RoleAssignmentScheduleListResultIterator {
	return RoleAssignmentScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (raslr RoleAssignmentScheduleListResult) IsEmpty() bool {
	return raslr.Value == nil || len(*raslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (raslr RoleAssignmentScheduleListResult) hasNextLink() bool {
	return raslr.NextLink != nil && len(*raslr.NextLink) != 0
}

// roleAssignmentScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (raslr RoleAssignmentScheduleListResult) roleAssignmentScheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !raslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(raslr.NextLink)))
}

// RoleAssignmentScheduleListResultPage contains a page of RoleAssignmentSchedule values.
type RoleAssignmentScheduleListResultPage struct {
	fn    func(context.Context, RoleAssignmentScheduleListResult) (RoleAssignmentScheduleListResult, error)
	raslr RoleAssignmentScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.raslr)
		if err != nil {
			return err
		}
		page.raslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentScheduleListResultPage) NotDone() bool {
	return !page.raslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentScheduleListResultPage) Response() RoleAssignmentScheduleListResult {
	return page.raslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentScheduleListResultPage) Values() []RoleAssignmentSchedule {
	if page.raslr.IsEmpty() {
		return nil
	}
	return *page.raslr.Value
}

// Creates a new instance of the RoleAssignmentScheduleListResultPage type.
func NewRoleAssignmentScheduleListResultPage(cur RoleAssignmentScheduleListResult, getNextPage func(context.Context, RoleAssignmentScheduleListResult) (RoleAssignmentScheduleListResult, error)) RoleAssignmentScheduleListResultPage {
	return RoleAssignmentScheduleListResultPage{
		fn:    getNextPage,
		raslr: cur,
	}
}

// RoleAssignmentScheduleProperties role assignment schedule properties with scope.
type RoleAssignmentScheduleProperties struct {
	// Scope - The role assignment schedule scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RoleAssignmentScheduleRequestID - The id of roleAssignmentScheduleRequest used to create this roleAssignmentSchedule
	RoleAssignmentScheduleRequestID *string `json:"roleAssignmentScheduleRequestId,omitempty"`
	// LinkedRoleEligibilityScheduleID - The id of roleEligibilitySchedule used to activated this roleAssignmentSchedule
	LinkedRoleEligibilityScheduleID *string `json:"linkedRoleEligibilityScheduleId,omitempty"`
	// AssignmentType - Assignment type of the role assignment schedule. Possible values include: 'AssignmentTypeActivated', 'AssignmentTypeAssigned'
	AssignmentType AssignmentType `json:"assignmentType,omitempty"`
	// MemberType - Membership type of the role assignment schedule. Possible values include: 'MemberTypeInherited', 'MemberTypeDirect', 'MemberTypeGroup'
	MemberType MemberType `json:"memberType,omitempty"`
	// Status - The status of the role assignment schedule. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// StartDateTime - Start DateTime when role assignment schedule
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - End DateTime when role assignment schedule
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - DateTime when role assignment schedule was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// UpdatedOn - DateTime when role assignment schedule was modified
	UpdatedOn *date.Time `json:"updatedOn,omitempty"`
	// ExpandedProperties - Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// RoleAssignmentScheduleRequest role Assignment schedule request
type RoleAssignmentScheduleRequest struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role assignment schedule request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role assignment schedule request name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role assignment schedule request type.
	Type *string `json:"type,omitempty"`
	// RoleAssignmentScheduleRequestProperties - Role assignment schedule request properties.
	*RoleAssignmentScheduleRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentScheduleRequest.
func (rasr RoleAssignmentScheduleRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rasr.RoleAssignmentScheduleRequestProperties != nil {
		objectMap["properties"] = rasr.RoleAssignmentScheduleRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleAssignmentScheduleRequest struct.
func (rasr *RoleAssignmentScheduleRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rasr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rasr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rasr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleAssignmentScheduleRequestProperties RoleAssignmentScheduleRequestProperties
				err = json.Unmarshal(*v, &roleAssignmentScheduleRequestProperties)
				if err != nil {
					return err
				}
				rasr.RoleAssignmentScheduleRequestProperties = &roleAssignmentScheduleRequestProperties
			}
		}
	}

	return nil
}

// RoleAssignmentScheduleRequestFilter role assignment schedule request filter
type RoleAssignmentScheduleRequestFilter struct {
	// PrincipalID - Returns role assignment requests of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role assignment requests of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// RequestorID - Returns role assignment requests created by specific principal.
	RequestorID *string `json:"requestorId,omitempty"`
	// Status - Returns role assignment requests of specific status.
	Status *string `json:"status,omitempty"`
}

// RoleAssignmentScheduleRequestListResult role assignment schedule request list operation result.
type RoleAssignmentScheduleRequestListResult struct {
	autorest.Response `json:"-"`
	// Value - Role assignment schedule request list.
	Value *[]RoleAssignmentScheduleRequest `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleAssignmentScheduleRequestListResultIterator provides access to a complete listing of
// RoleAssignmentScheduleRequest values.
type RoleAssignmentScheduleRequestListResultIterator struct {
	i    int
	page RoleAssignmentScheduleRequestListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleAssignmentScheduleRequestListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleAssignmentScheduleRequestListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleAssignmentScheduleRequestListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleAssignmentScheduleRequestListResultIterator) Response() RoleAssignmentScheduleRequestListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleAssignmentScheduleRequestListResultIterator) Value() RoleAssignmentScheduleRequest {
	if !iter.page.NotDone() {
		return RoleAssignmentScheduleRequest{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleAssignmentScheduleRequestListResultIterator type.
func NewRoleAssignmentScheduleRequestListResultIterator(page RoleAssignmentScheduleRequestListResultPage) RoleAssignmentScheduleRequestListResultIterator {
	return RoleAssignmentScheduleRequestListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rasrlr RoleAssignmentScheduleRequestListResult) IsEmpty() bool {
	return rasrlr.Value == nil || len(*rasrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rasrlr RoleAssignmentScheduleRequestListResult) hasNextLink() bool {
	return rasrlr.NextLink != nil && len(*rasrlr.NextLink) != 0
}

// roleAssignmentScheduleRequestListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rasrlr RoleAssignmentScheduleRequestListResult) roleAssignmentScheduleRequestListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rasrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rasrlr.NextLink)))
}

// RoleAssignmentScheduleRequestListResultPage contains a page of RoleAssignmentScheduleRequest values.
type RoleAssignmentScheduleRequestListResultPage struct {
	fn     func(context.Context, RoleAssignmentScheduleRequestListResult) (RoleAssignmentScheduleRequestListResult, error)
	rasrlr RoleAssignmentScheduleRequestListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleAssignmentScheduleRequestListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rasrlr)
		if err != nil {
			return err
		}
		page.rasrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleAssignmentScheduleRequestListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleAssignmentScheduleRequestListResultPage) NotDone() bool {
	return !page.rasrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleAssignmentScheduleRequestListResultPage) Response() RoleAssignmentScheduleRequestListResult {
	return page.rasrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleAssignmentScheduleRequestListResultPage) Values() []RoleAssignmentScheduleRequest {
	if page.rasrlr.IsEmpty() {
		return nil
	}
	return *page.rasrlr.Value
}

// Creates a new instance of the RoleAssignmentScheduleRequestListResultPage type.
func NewRoleAssignmentScheduleRequestListResultPage(cur RoleAssignmentScheduleRequestListResult, getNextPage func(context.Context, RoleAssignmentScheduleRequestListResult) (RoleAssignmentScheduleRequestListResult, error)) RoleAssignmentScheduleRequestListResultPage {
	return RoleAssignmentScheduleRequestListResultPage{
		fn:     getNextPage,
		rasrlr: cur,
	}
}

// RoleAssignmentScheduleRequestProperties role assignment schedule request properties with scope.
type RoleAssignmentScheduleRequestProperties struct {
	// Scope - READ-ONLY; The role assignment schedule request scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - READ-ONLY; The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RequestType - The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc. Possible values include: 'RequestTypeAdminAssign', 'RequestTypeAdminRemove', 'RequestTypeAdminUpdate', 'RequestTypeAdminExtend', 'RequestTypeAdminRenew', 'RequestTypeSelfActivate', 'RequestTypeSelfDeactivate', 'RequestTypeSelfExtend', 'RequestTypeSelfRenew'
	RequestType RequestType `json:"requestType,omitempty"`
	// Status - READ-ONLY; The status of the role assignment schedule request. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// ApprovalID - READ-ONLY; The approvalId of the role assignment schedule request.
	ApprovalID *string `json:"approvalId,omitempty"`
	// TargetRoleAssignmentScheduleID - The resultant role assignment schedule id or the role assignment schedule id being updated
	TargetRoleAssignmentScheduleID *string `json:"targetRoleAssignmentScheduleId,omitempty"`
	// TargetRoleAssignmentScheduleInstanceID - The role assignment schedule instance id being updated
	TargetRoleAssignmentScheduleInstanceID *string `json:"targetRoleAssignmentScheduleInstanceId,omitempty"`
	// ScheduleInfo - Schedule info of the role assignment schedule
	ScheduleInfo *RoleAssignmentScheduleRequestPropertiesScheduleInfo `json:"scheduleInfo,omitempty"`
	// LinkedRoleEligibilityScheduleID - The linked role eligibility schedule id - to activate an eligibility.
	LinkedRoleEligibilityScheduleID *string `json:"linkedRoleEligibilityScheduleId,omitempty"`
	// Justification - Justification for the role assignment
	Justification *string `json:"justification,omitempty"`
	// TicketInfo - Ticket Info of the role assignment
	TicketInfo *RoleAssignmentScheduleRequestPropertiesTicketInfo `json:"ticketInfo,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - READ-ONLY; DateTime when role assignment schedule request was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// RequestorID - READ-ONLY; Id of the user who created this request
	RequestorID *string `json:"requestorId,omitempty"`
	// ExpandedProperties - READ-ONLY; Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleAssignmentScheduleRequestProperties.
func (rasrp RoleAssignmentScheduleRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rasrp.RoleDefinitionID != nil {
		objectMap["roleDefinitionId"] = rasrp.RoleDefinitionID
	}
	if rasrp.PrincipalID != nil {
		objectMap["principalId"] = rasrp.PrincipalID
	}
	if rasrp.RequestType != "" {
		objectMap["requestType"] = rasrp.RequestType
	}
	if rasrp.TargetRoleAssignmentScheduleID != nil {
		objectMap["targetRoleAssignmentScheduleId"] = rasrp.TargetRoleAssignmentScheduleID
	}
	if rasrp.TargetRoleAssignmentScheduleInstanceID != nil {
		objectMap["targetRoleAssignmentScheduleInstanceId"] = rasrp.TargetRoleAssignmentScheduleInstanceID
	}
	if rasrp.ScheduleInfo != nil {
		objectMap["scheduleInfo"] = rasrp.ScheduleInfo
	}
	if rasrp.LinkedRoleEligibilityScheduleID != nil {
		objectMap["linkedRoleEligibilityScheduleId"] = rasrp.LinkedRoleEligibilityScheduleID
	}
	if rasrp.Justification != nil {
		objectMap["justification"] = rasrp.Justification
	}
	if rasrp.TicketInfo != nil {
		objectMap["ticketInfo"] = rasrp.TicketInfo
	}
	if rasrp.Condition != nil {
		objectMap["condition"] = rasrp.Condition
	}
	if rasrp.ConditionVersion != nil {
		objectMap["conditionVersion"] = rasrp.ConditionVersion
	}
	return json.Marshal(objectMap)
}

// RoleAssignmentScheduleRequestPropertiesScheduleInfo schedule info of the role assignment schedule
type RoleAssignmentScheduleRequestPropertiesScheduleInfo struct {
	// StartDateTime - Start DateTime of the role assignment schedule.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// Expiration - Expiration of the role assignment schedule
	Expiration *RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration `json:"expiration,omitempty"`
}

// RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration of the role assignment schedule
type RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration struct {
	// Type - Type of the role assignment schedule expiration. Possible values include: 'TypeAfterDuration', 'TypeAfterDateTime', 'TypeNoExpiration'
	Type Type `json:"type,omitempty"`
	// EndDateTime - End DateTime of the role assignment schedule.
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// Duration - Duration of the role assignment schedule in TimeSpan.
	Duration *string `json:"duration,omitempty"`
}

// RoleAssignmentScheduleRequestPropertiesTicketInfo ticket Info of the role assignment
type RoleAssignmentScheduleRequestPropertiesTicketInfo struct {
	// TicketNumber - Ticket number for the role assignment
	TicketNumber *string `json:"ticketNumber,omitempty"`
	// TicketSystem - Ticket system name for the role assignment
	TicketSystem *string `json:"ticketSystem,omitempty"`
}

// RoleDefinition role definition.
type RoleDefinition struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role definition ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role definition name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role definition type.
	Type *string `json:"type,omitempty"`
	// RoleDefinitionProperties - Role definition properties.
	*RoleDefinitionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleDefinition.
func (rd RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RoleDefinitionProperties != nil {
		objectMap["properties"] = rd.RoleDefinitionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleDefinition struct.
func (rd *RoleDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleDefinitionProperties RoleDefinitionProperties
				err = json.Unmarshal(*v, &roleDefinitionProperties)
				if err != nil {
					return err
				}
				rd.RoleDefinitionProperties = &roleDefinitionProperties
			}
		}
	}

	return nil
}

// RoleDefinitionFilter role Definitions filter
type RoleDefinitionFilter struct {
	// RoleName - Returns role definition with the specific name.
	RoleName *string `json:"roleName,omitempty"`
}

// RoleDefinitionListResult role definition list operation result.
type RoleDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - Role definition list.
	Value *[]RoleDefinition `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleDefinitionListResultIterator provides access to a complete listing of RoleDefinition values.
type RoleDefinitionListResultIterator struct {
	i    int
	page RoleDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleDefinitionListResultIterator) Response() RoleDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleDefinitionListResultIterator) Value() RoleDefinition {
	if !iter.page.NotDone() {
		return RoleDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleDefinitionListResultIterator type.
func NewRoleDefinitionListResultIterator(page RoleDefinitionListResultPage) RoleDefinitionListResultIterator {
	return RoleDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdlr RoleDefinitionListResult) IsEmpty() bool {
	return rdlr.Value == nil || len(*rdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdlr RoleDefinitionListResult) hasNextLink() bool {
	return rdlr.NextLink != nil && len(*rdlr.NextLink) != 0
}

// roleDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdlr RoleDefinitionListResult) roleDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdlr.NextLink)))
}

// RoleDefinitionListResultPage contains a page of RoleDefinition values.
type RoleDefinitionListResultPage struct {
	fn   func(context.Context, RoleDefinitionListResult) (RoleDefinitionListResult, error)
	rdlr RoleDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdlr)
		if err != nil {
			return err
		}
		page.rdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleDefinitionListResultPage) NotDone() bool {
	return !page.rdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleDefinitionListResultPage) Response() RoleDefinitionListResult {
	return page.rdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleDefinitionListResultPage) Values() []RoleDefinition {
	if page.rdlr.IsEmpty() {
		return nil
	}
	return *page.rdlr.Value
}

// Creates a new instance of the RoleDefinitionListResultPage type.
func NewRoleDefinitionListResultPage(cur RoleDefinitionListResult, getNextPage func(context.Context, RoleDefinitionListResult) (RoleDefinitionListResult, error)) RoleDefinitionListResultPage {
	return RoleDefinitionListResultPage{
		fn:   getNextPage,
		rdlr: cur,
	}
}

// RoleDefinitionProperties role definition properties.
type RoleDefinitionProperties struct {
	// RoleName - The role name.
	RoleName *string `json:"roleName,omitempty"`
	// Description - The role definition description.
	Description *string `json:"description,omitempty"`
	// RoleType - The role type.
	RoleType *string `json:"type,omitempty"`
	// Permissions - Role definition permissions.
	Permissions *[]Permission `json:"permissions,omitempty"`
	// AssignableScopes - Role definition assignable scopes.
	AssignableScopes *[]string `json:"assignableScopes,omitempty"`
}

// RoleEligibilitySchedule role eligibility schedule
type RoleEligibilitySchedule struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role eligibility schedule Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role eligibility schedule name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role eligibility schedule type.
	Type *string `json:"type,omitempty"`
	// RoleEligibilityScheduleProperties - role eligibility schedule properties.
	*RoleEligibilityScheduleProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleEligibilitySchedule.
func (res RoleEligibilitySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if res.RoleEligibilityScheduleProperties != nil {
		objectMap["properties"] = res.RoleEligibilityScheduleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleEligibilitySchedule struct.
func (res *RoleEligibilitySchedule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				res.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				res.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				res.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleEligibilityScheduleProperties RoleEligibilityScheduleProperties
				err = json.Unmarshal(*v, &roleEligibilityScheduleProperties)
				if err != nil {
					return err
				}
				res.RoleEligibilityScheduleProperties = &roleEligibilityScheduleProperties
			}
		}
	}

	return nil
}

// RoleEligibilityScheduleFilter role eligibility schedule filter
type RoleEligibilityScheduleFilter struct {
	// PrincipalID - Returns role eligibility schedule of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role eligibility schedule of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Status - Returns role eligibility schedule of the specific status.
	Status *string `json:"status,omitempty"`
}

// RoleEligibilityScheduleInstance information about current or upcoming role eligibility schedule instance
type RoleEligibilityScheduleInstance struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role eligibility schedule instance ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role eligibility schedule instance name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role eligibility schedule instance type.
	Type *string `json:"type,omitempty"`
	// RoleEligibilityScheduleInstanceProperties - Role eligibility schedule instance properties.
	*RoleEligibilityScheduleInstanceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleEligibilityScheduleInstance.
func (resi RoleEligibilityScheduleInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if resi.RoleEligibilityScheduleInstanceProperties != nil {
		objectMap["properties"] = resi.RoleEligibilityScheduleInstanceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleEligibilityScheduleInstance struct.
func (resi *RoleEligibilityScheduleInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				resi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				resi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				resi.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleEligibilityScheduleInstanceProperties RoleEligibilityScheduleInstanceProperties
				err = json.Unmarshal(*v, &roleEligibilityScheduleInstanceProperties)
				if err != nil {
					return err
				}
				resi.RoleEligibilityScheduleInstanceProperties = &roleEligibilityScheduleInstanceProperties
			}
		}
	}

	return nil
}

// RoleEligibilityScheduleInstanceFilter role eligibility schedule instance filter
type RoleEligibilityScheduleInstanceFilter struct {
	// PrincipalID - Returns role eligibility schedule instances of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role eligibility schedule instances of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// Status - Returns role eligibility schedule instances of the specific status.
	Status *string `json:"status,omitempty"`
	// RoleEligibilityScheduleID - Returns role eligibility schedule instances belonging to a specific role eligibility schedule.
	RoleEligibilityScheduleID *string `json:"roleEligibilityScheduleId,omitempty"`
}

// RoleEligibilityScheduleInstanceListResult role eligibility schedule instance list operation result.
type RoleEligibilityScheduleInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - Role eligibility schedule instance list.
	Value *[]RoleEligibilityScheduleInstance `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleEligibilityScheduleInstanceListResultIterator provides access to a complete listing of
// RoleEligibilityScheduleInstance values.
type RoleEligibilityScheduleInstanceListResultIterator struct {
	i    int
	page RoleEligibilityScheduleInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleEligibilityScheduleInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleEligibilityScheduleInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleEligibilityScheduleInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleEligibilityScheduleInstanceListResultIterator) Response() RoleEligibilityScheduleInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleEligibilityScheduleInstanceListResultIterator) Value() RoleEligibilityScheduleInstance {
	if !iter.page.NotDone() {
		return RoleEligibilityScheduleInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleEligibilityScheduleInstanceListResultIterator type.
func NewRoleEligibilityScheduleInstanceListResultIterator(page RoleEligibilityScheduleInstanceListResultPage) RoleEligibilityScheduleInstanceListResultIterator {
	return RoleEligibilityScheduleInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (resilr RoleEligibilityScheduleInstanceListResult) IsEmpty() bool {
	return resilr.Value == nil || len(*resilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (resilr RoleEligibilityScheduleInstanceListResult) hasNextLink() bool {
	return resilr.NextLink != nil && len(*resilr.NextLink) != 0
}

// roleEligibilityScheduleInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (resilr RoleEligibilityScheduleInstanceListResult) roleEligibilityScheduleInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !resilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(resilr.NextLink)))
}

// RoleEligibilityScheduleInstanceListResultPage contains a page of RoleEligibilityScheduleInstance values.
type RoleEligibilityScheduleInstanceListResultPage struct {
	fn     func(context.Context, RoleEligibilityScheduleInstanceListResult) (RoleEligibilityScheduleInstanceListResult, error)
	resilr RoleEligibilityScheduleInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleEligibilityScheduleInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.resilr)
		if err != nil {
			return err
		}
		page.resilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleEligibilityScheduleInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleEligibilityScheduleInstanceListResultPage) NotDone() bool {
	return !page.resilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleEligibilityScheduleInstanceListResultPage) Response() RoleEligibilityScheduleInstanceListResult {
	return page.resilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleEligibilityScheduleInstanceListResultPage) Values() []RoleEligibilityScheduleInstance {
	if page.resilr.IsEmpty() {
		return nil
	}
	return *page.resilr.Value
}

// Creates a new instance of the RoleEligibilityScheduleInstanceListResultPage type.
func NewRoleEligibilityScheduleInstanceListResultPage(cur RoleEligibilityScheduleInstanceListResult, getNextPage func(context.Context, RoleEligibilityScheduleInstanceListResult) (RoleEligibilityScheduleInstanceListResult, error)) RoleEligibilityScheduleInstanceListResultPage {
	return RoleEligibilityScheduleInstanceListResultPage{
		fn:     getNextPage,
		resilr: cur,
	}
}

// RoleEligibilityScheduleInstanceProperties role eligibility schedule properties with scope.
type RoleEligibilityScheduleInstanceProperties struct {
	// Scope - The role eligibility schedule scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RoleEligibilityScheduleID - Id of the master role eligibility schedule
	RoleEligibilityScheduleID *string `json:"roleEligibilityScheduleId,omitempty"`
	// Status - The status of the role eligibility schedule instance. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// StartDateTime - The startDateTime of the role eligibility schedule instance
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - The endDateTime of the role eligibility schedule instance
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// MemberType - Membership type of the role eligibility schedule. Possible values include: 'MemberTypeInherited', 'MemberTypeDirect', 'MemberTypeGroup'
	MemberType MemberType `json:"memberType,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - DateTime when role eligibility schedule was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ExpandedProperties - Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// RoleEligibilityScheduleListResult role eligibility schedule list operation result.
type RoleEligibilityScheduleListResult struct {
	autorest.Response `json:"-"`
	// Value - role eligibility schedule list.
	Value *[]RoleEligibilitySchedule `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleEligibilityScheduleListResultIterator provides access to a complete listing of
// RoleEligibilitySchedule values.
type RoleEligibilityScheduleListResultIterator struct {
	i    int
	page RoleEligibilityScheduleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleEligibilityScheduleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleEligibilityScheduleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleEligibilityScheduleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleEligibilityScheduleListResultIterator) Response() RoleEligibilityScheduleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleEligibilityScheduleListResultIterator) Value() RoleEligibilitySchedule {
	if !iter.page.NotDone() {
		return RoleEligibilitySchedule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleEligibilityScheduleListResultIterator type.
func NewRoleEligibilityScheduleListResultIterator(page RoleEligibilityScheduleListResultPage) RoleEligibilityScheduleListResultIterator {
	return RoleEligibilityScheduleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (reslr RoleEligibilityScheduleListResult) IsEmpty() bool {
	return reslr.Value == nil || len(*reslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (reslr RoleEligibilityScheduleListResult) hasNextLink() bool {
	return reslr.NextLink != nil && len(*reslr.NextLink) != 0
}

// roleEligibilityScheduleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (reslr RoleEligibilityScheduleListResult) roleEligibilityScheduleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !reslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(reslr.NextLink)))
}

// RoleEligibilityScheduleListResultPage contains a page of RoleEligibilitySchedule values.
type RoleEligibilityScheduleListResultPage struct {
	fn    func(context.Context, RoleEligibilityScheduleListResult) (RoleEligibilityScheduleListResult, error)
	reslr RoleEligibilityScheduleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleEligibilityScheduleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.reslr)
		if err != nil {
			return err
		}
		page.reslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleEligibilityScheduleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleEligibilityScheduleListResultPage) NotDone() bool {
	return !page.reslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleEligibilityScheduleListResultPage) Response() RoleEligibilityScheduleListResult {
	return page.reslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleEligibilityScheduleListResultPage) Values() []RoleEligibilitySchedule {
	if page.reslr.IsEmpty() {
		return nil
	}
	return *page.reslr.Value
}

// Creates a new instance of the RoleEligibilityScheduleListResultPage type.
func NewRoleEligibilityScheduleListResultPage(cur RoleEligibilityScheduleListResult, getNextPage func(context.Context, RoleEligibilityScheduleListResult) (RoleEligibilityScheduleListResult, error)) RoleEligibilityScheduleListResultPage {
	return RoleEligibilityScheduleListResultPage{
		fn:    getNextPage,
		reslr: cur,
	}
}

// RoleEligibilityScheduleProperties role eligibility schedule properties with scope.
type RoleEligibilityScheduleProperties struct {
	// Scope - The role eligibility schedule scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RoleEligibilityScheduleRequestID - The id of roleEligibilityScheduleRequest used to create this roleAssignmentSchedule
	RoleEligibilityScheduleRequestID *string `json:"roleEligibilityScheduleRequestId,omitempty"`
	// MemberType - Membership type of the role eligibility schedule. Possible values include: 'MemberTypeInherited', 'MemberTypeDirect', 'MemberTypeGroup'
	MemberType MemberType `json:"memberType,omitempty"`
	// Status - The status of the role eligibility schedule. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// StartDateTime - Start DateTime when role eligibility schedule
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// EndDateTime - End DateTime when role eligibility schedule
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - DateTime when role eligibility schedule was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// UpdatedOn - DateTime when role eligibility schedule was modified
	UpdatedOn *date.Time `json:"updatedOn,omitempty"`
	// ExpandedProperties - Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// RoleEligibilityScheduleRequest role Eligibility schedule request
type RoleEligibilityScheduleRequest struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role eligibility schedule request ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role eligibility schedule request name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role eligibility schedule request type.
	Type *string `json:"type,omitempty"`
	// RoleEligibilityScheduleRequestProperties - Role eligibility schedule request properties.
	*RoleEligibilityScheduleRequestProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleEligibilityScheduleRequest.
func (resr RoleEligibilityScheduleRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if resr.RoleEligibilityScheduleRequestProperties != nil {
		objectMap["properties"] = resr.RoleEligibilityScheduleRequestProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleEligibilityScheduleRequest struct.
func (resr *RoleEligibilityScheduleRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				resr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				resr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				resr.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleEligibilityScheduleRequestProperties RoleEligibilityScheduleRequestProperties
				err = json.Unmarshal(*v, &roleEligibilityScheduleRequestProperties)
				if err != nil {
					return err
				}
				resr.RoleEligibilityScheduleRequestProperties = &roleEligibilityScheduleRequestProperties
			}
		}
	}

	return nil
}

// RoleEligibilityScheduleRequestFilter role eligibility schedule request filter
type RoleEligibilityScheduleRequestFilter struct {
	// PrincipalID - Returns role eligibility requests of the specific principal.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - Returns role eligibility requests of the specific role definition.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// RequestorID - Returns role eligibility requests created by specific principal.
	RequestorID *string `json:"requestorId,omitempty"`
	// Status - Returns role eligibility requests of specific status.
	Status *string `json:"status,omitempty"`
}

// RoleEligibilityScheduleRequestListResult role eligibility schedule request list operation result.
type RoleEligibilityScheduleRequestListResult struct {
	autorest.Response `json:"-"`
	// Value - Role eligibility schedule request list.
	Value *[]RoleEligibilityScheduleRequest `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleEligibilityScheduleRequestListResultIterator provides access to a complete listing of
// RoleEligibilityScheduleRequest values.
type RoleEligibilityScheduleRequestListResultIterator struct {
	i    int
	page RoleEligibilityScheduleRequestListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleEligibilityScheduleRequestListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleEligibilityScheduleRequestListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleEligibilityScheduleRequestListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleEligibilityScheduleRequestListResultIterator) Response() RoleEligibilityScheduleRequestListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleEligibilityScheduleRequestListResultIterator) Value() RoleEligibilityScheduleRequest {
	if !iter.page.NotDone() {
		return RoleEligibilityScheduleRequest{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleEligibilityScheduleRequestListResultIterator type.
func NewRoleEligibilityScheduleRequestListResultIterator(page RoleEligibilityScheduleRequestListResultPage) RoleEligibilityScheduleRequestListResultIterator {
	return RoleEligibilityScheduleRequestListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (resrlr RoleEligibilityScheduleRequestListResult) IsEmpty() bool {
	return resrlr.Value == nil || len(*resrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (resrlr RoleEligibilityScheduleRequestListResult) hasNextLink() bool {
	return resrlr.NextLink != nil && len(*resrlr.NextLink) != 0
}

// roleEligibilityScheduleRequestListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (resrlr RoleEligibilityScheduleRequestListResult) roleEligibilityScheduleRequestListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !resrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(resrlr.NextLink)))
}

// RoleEligibilityScheduleRequestListResultPage contains a page of RoleEligibilityScheduleRequest values.
type RoleEligibilityScheduleRequestListResultPage struct {
	fn     func(context.Context, RoleEligibilityScheduleRequestListResult) (RoleEligibilityScheduleRequestListResult, error)
	resrlr RoleEligibilityScheduleRequestListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleEligibilityScheduleRequestListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleRequestListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.resrlr)
		if err != nil {
			return err
		}
		page.resrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleEligibilityScheduleRequestListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleEligibilityScheduleRequestListResultPage) NotDone() bool {
	return !page.resrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleEligibilityScheduleRequestListResultPage) Response() RoleEligibilityScheduleRequestListResult {
	return page.resrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleEligibilityScheduleRequestListResultPage) Values() []RoleEligibilityScheduleRequest {
	if page.resrlr.IsEmpty() {
		return nil
	}
	return *page.resrlr.Value
}

// Creates a new instance of the RoleEligibilityScheduleRequestListResultPage type.
func NewRoleEligibilityScheduleRequestListResultPage(cur RoleEligibilityScheduleRequestListResult, getNextPage func(context.Context, RoleEligibilityScheduleRequestListResult) (RoleEligibilityScheduleRequestListResult, error)) RoleEligibilityScheduleRequestListResultPage {
	return RoleEligibilityScheduleRequestListResultPage{
		fn:     getNextPage,
		resrlr: cur,
	}
}

// RoleEligibilityScheduleRequestProperties role eligibility schedule request properties with scope.
type RoleEligibilityScheduleRequestProperties struct {
	// Scope - READ-ONLY; The role eligibility schedule request scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition ID.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PrincipalID - The principal ID.
	PrincipalID *string `json:"principalId,omitempty"`
	// PrincipalType - READ-ONLY; The principal type of the assigned principal ID. Possible values include: 'PrincipalTypeUser', 'PrincipalTypeGroup', 'PrincipalTypeServicePrincipal', 'PrincipalTypeForeignGroup', 'PrincipalTypeDevice'
	PrincipalType PrincipalType `json:"principalType,omitempty"`
	// RequestType - The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc. Possible values include: 'RequestTypeAdminAssign', 'RequestTypeAdminRemove', 'RequestTypeAdminUpdate', 'RequestTypeAdminExtend', 'RequestTypeAdminRenew', 'RequestTypeSelfActivate', 'RequestTypeSelfDeactivate', 'RequestTypeSelfExtend', 'RequestTypeSelfRenew'
	RequestType RequestType `json:"requestType,omitempty"`
	// Status - READ-ONLY; The status of the role eligibility schedule request. Possible values include: 'StatusAccepted', 'StatusPendingEvaluation', 'StatusGranted', 'StatusDenied', 'StatusPendingProvisioning', 'StatusProvisioned', 'StatusPendingRevocation', 'StatusRevoked', 'StatusCanceled', 'StatusFailed', 'StatusPendingApprovalProvisioning', 'StatusPendingApproval', 'StatusFailedAsResourceIsLocked', 'StatusPendingAdminDecision', 'StatusAdminApproved', 'StatusAdminDenied', 'StatusTimedOut', 'StatusProvisioningStarted', 'StatusInvalid', 'StatusPendingScheduleCreation', 'StatusScheduleCreated', 'StatusPendingExternalProvisioning'
	Status Status `json:"status,omitempty"`
	// ApprovalID - READ-ONLY; The approvalId of the role eligibility schedule request.
	ApprovalID *string `json:"approvalId,omitempty"`
	// ScheduleInfo - Schedule info of the role eligibility schedule
	ScheduleInfo *RoleEligibilityScheduleRequestPropertiesScheduleInfo `json:"scheduleInfo,omitempty"`
	// TargetRoleEligibilityScheduleID - The resultant role eligibility schedule id or the role eligibility schedule id being updated
	TargetRoleEligibilityScheduleID *string `json:"targetRoleEligibilityScheduleId,omitempty"`
	// TargetRoleEligibilityScheduleInstanceID - The role eligibility schedule instance id being updated
	TargetRoleEligibilityScheduleInstanceID *string `json:"targetRoleEligibilityScheduleInstanceId,omitempty"`
	// Justification - Justification for the role eligibility
	Justification *string `json:"justification,omitempty"`
	// TicketInfo - Ticket Info of the role eligibility
	TicketInfo *RoleEligibilityScheduleRequestPropertiesTicketInfo `json:"ticketInfo,omitempty"`
	// Condition - The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'
	Condition *string `json:"condition,omitempty"`
	// ConditionVersion - Version of the condition. Currently accepted value is '2.0'
	ConditionVersion *string `json:"conditionVersion,omitempty"`
	// CreatedOn - READ-ONLY; DateTime when role eligibility schedule request was created
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// RequestorID - READ-ONLY; Id of the user who created this request
	RequestorID *string `json:"requestorId,omitempty"`
	// ExpandedProperties - READ-ONLY; Additional properties of principal, scope and role definition
	ExpandedProperties *ExpandedProperties `json:"expandedProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleEligibilityScheduleRequestProperties.
func (resrp RoleEligibilityScheduleRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if resrp.RoleDefinitionID != nil {
		objectMap["roleDefinitionId"] = resrp.RoleDefinitionID
	}
	if resrp.PrincipalID != nil {
		objectMap["principalId"] = resrp.PrincipalID
	}
	if resrp.RequestType != "" {
		objectMap["requestType"] = resrp.RequestType
	}
	if resrp.ScheduleInfo != nil {
		objectMap["scheduleInfo"] = resrp.ScheduleInfo
	}
	if resrp.TargetRoleEligibilityScheduleID != nil {
		objectMap["targetRoleEligibilityScheduleId"] = resrp.TargetRoleEligibilityScheduleID
	}
	if resrp.TargetRoleEligibilityScheduleInstanceID != nil {
		objectMap["targetRoleEligibilityScheduleInstanceId"] = resrp.TargetRoleEligibilityScheduleInstanceID
	}
	if resrp.Justification != nil {
		objectMap["justification"] = resrp.Justification
	}
	if resrp.TicketInfo != nil {
		objectMap["ticketInfo"] = resrp.TicketInfo
	}
	if resrp.Condition != nil {
		objectMap["condition"] = resrp.Condition
	}
	if resrp.ConditionVersion != nil {
		objectMap["conditionVersion"] = resrp.ConditionVersion
	}
	return json.Marshal(objectMap)
}

// RoleEligibilityScheduleRequestPropertiesScheduleInfo schedule info of the role eligibility schedule
type RoleEligibilityScheduleRequestPropertiesScheduleInfo struct {
	// StartDateTime - Start DateTime of the role eligibility schedule.
	StartDateTime *date.Time `json:"startDateTime,omitempty"`
	// Expiration - Expiration of the role eligibility schedule
	Expiration *RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration `json:"expiration,omitempty"`
}

// RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration expiration of the role eligibility
// schedule
type RoleEligibilityScheduleRequestPropertiesScheduleInfoExpiration struct {
	// Type - Type of the role eligibility schedule expiration. Possible values include: 'TypeAfterDuration', 'TypeAfterDateTime', 'TypeNoExpiration'
	Type Type `json:"type,omitempty"`
	// EndDateTime - End DateTime of the role eligibility schedule.
	EndDateTime *date.Time `json:"endDateTime,omitempty"`
	// Duration - Duration of the role eligibility schedule in TimeSpan.
	Duration *string `json:"duration,omitempty"`
}

// RoleEligibilityScheduleRequestPropertiesTicketInfo ticket Info of the role eligibility
type RoleEligibilityScheduleRequestPropertiesTicketInfo struct {
	// TicketNumber - Ticket number for the role eligibility
	TicketNumber *string `json:"ticketNumber,omitempty"`
	// TicketSystem - Ticket system name for the role eligibility
	TicketSystem *string `json:"ticketSystem,omitempty"`
}

// RoleManagementPolicy role management policy
type RoleManagementPolicy struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role management policy Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role management policy name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role management policy type.
	Type *string `json:"type,omitempty"`
	// RoleManagementPolicyProperties - Role management policy properties.
	*RoleManagementPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicy.
func (rmp RoleManagementPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmp.RoleManagementPolicyProperties != nil {
		objectMap["properties"] = rmp.RoleManagementPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleManagementPolicy struct.
func (rmp *RoleManagementPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmp.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleManagementPolicyProperties RoleManagementPolicyProperties
				err = json.Unmarshal(*v, &roleManagementPolicyProperties)
				if err != nil {
					return err
				}
				rmp.RoleManagementPolicyProperties = &roleManagementPolicyProperties
			}
		}
	}

	return nil
}

// RoleManagementPolicyApprovalRule the role management policy approval rule.
type RoleManagementPolicyApprovalRule struct {
	// Setting - The approval setting
	Setting *ApprovalSettings `json:"setting,omitempty"`
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) MarshalJSON() ([]byte, error) {
	rmpar.RuleType = RuleTypeRoleManagementPolicyApprovalRule
	objectMap := make(map[string]interface{})
	if rmpar.Setting != nil {
		objectMap["setting"] = rmpar.Setting
	}
	if rmpar.ID != nil {
		objectMap["id"] = rmpar.ID
	}
	if rmpar.Target != nil {
		objectMap["target"] = rmpar.Target
	}
	if rmpar.RuleType != "" {
		objectMap["ruleType"] = rmpar.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return &rmpar, true
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return nil, false
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyApprovalRule.
func (rmpar RoleManagementPolicyApprovalRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmpar, true
}

// RoleManagementPolicyAssignment role management policy
type RoleManagementPolicyAssignment struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The role management policy Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The role management policy name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The role management policy type.
	Type *string `json:"type,omitempty"`
	// RoleManagementPolicyAssignmentProperties - Role management policy properties.
	*RoleManagementPolicyAssignmentProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyAssignment.
func (rmpa RoleManagementPolicyAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmpa.RoleManagementPolicyAssignmentProperties != nil {
		objectMap["properties"] = rmpa.RoleManagementPolicyAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleManagementPolicyAssignment struct.
func (rmpa *RoleManagementPolicyAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmpa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmpa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmpa.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var roleManagementPolicyAssignmentProperties RoleManagementPolicyAssignmentProperties
				err = json.Unmarshal(*v, &roleManagementPolicyAssignmentProperties)
				if err != nil {
					return err
				}
				rmpa.RoleManagementPolicyAssignmentProperties = &roleManagementPolicyAssignmentProperties
			}
		}
	}

	return nil
}

// RoleManagementPolicyAssignmentListResult role management policy assignment list operation result.
type RoleManagementPolicyAssignmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Role management policy assignment list.
	Value *[]RoleManagementPolicyAssignment `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleManagementPolicyAssignmentListResultIterator provides access to a complete listing of
// RoleManagementPolicyAssignment values.
type RoleManagementPolicyAssignmentListResultIterator struct {
	i    int
	page RoleManagementPolicyAssignmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleManagementPolicyAssignmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleManagementPolicyAssignmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleManagementPolicyAssignmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleManagementPolicyAssignmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleManagementPolicyAssignmentListResultIterator) Response() RoleManagementPolicyAssignmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleManagementPolicyAssignmentListResultIterator) Value() RoleManagementPolicyAssignment {
	if !iter.page.NotDone() {
		return RoleManagementPolicyAssignment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleManagementPolicyAssignmentListResultIterator type.
func NewRoleManagementPolicyAssignmentListResultIterator(page RoleManagementPolicyAssignmentListResultPage) RoleManagementPolicyAssignmentListResultIterator {
	return RoleManagementPolicyAssignmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmpalr RoleManagementPolicyAssignmentListResult) IsEmpty() bool {
	return rmpalr.Value == nil || len(*rmpalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmpalr RoleManagementPolicyAssignmentListResult) hasNextLink() bool {
	return rmpalr.NextLink != nil && len(*rmpalr.NextLink) != 0
}

// roleManagementPolicyAssignmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmpalr RoleManagementPolicyAssignmentListResult) roleManagementPolicyAssignmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rmpalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmpalr.NextLink)))
}

// RoleManagementPolicyAssignmentListResultPage contains a page of RoleManagementPolicyAssignment values.
type RoleManagementPolicyAssignmentListResultPage struct {
	fn     func(context.Context, RoleManagementPolicyAssignmentListResult) (RoleManagementPolicyAssignmentListResult, error)
	rmpalr RoleManagementPolicyAssignmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleManagementPolicyAssignmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleManagementPolicyAssignmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmpalr)
		if err != nil {
			return err
		}
		page.rmpalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleManagementPolicyAssignmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleManagementPolicyAssignmentListResultPage) NotDone() bool {
	return !page.rmpalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleManagementPolicyAssignmentListResultPage) Response() RoleManagementPolicyAssignmentListResult {
	return page.rmpalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleManagementPolicyAssignmentListResultPage) Values() []RoleManagementPolicyAssignment {
	if page.rmpalr.IsEmpty() {
		return nil
	}
	return *page.rmpalr.Value
}

// Creates a new instance of the RoleManagementPolicyAssignmentListResultPage type.
func NewRoleManagementPolicyAssignmentListResultPage(cur RoleManagementPolicyAssignmentListResult, getNextPage func(context.Context, RoleManagementPolicyAssignmentListResult) (RoleManagementPolicyAssignmentListResult, error)) RoleManagementPolicyAssignmentListResultPage {
	return RoleManagementPolicyAssignmentListResultPage{
		fn:     getNextPage,
		rmpalr: cur,
	}
}

// RoleManagementPolicyAssignmentProperties role management policy assignment properties with scope.
type RoleManagementPolicyAssignmentProperties struct {
	// Scope - The role management policy scope.
	Scope *string `json:"scope,omitempty"`
	// RoleDefinitionID - The role definition of management policy assignment.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
	// PolicyID - The policy id role management policy assignment.
	PolicyID *string `json:"policyId,omitempty"`
	// EffectiveRules - READ-ONLY; The readonly computed rule applied to the policy.
	EffectiveRules *[]BasicRoleManagementPolicyRule `json:"effectiveRules,omitempty"`
	// PolicyAssignmentProperties - READ-ONLY; Additional properties of scope, role definition and policy
	PolicyAssignmentProperties *PolicyAssignmentProperties `json:"policyAssignmentProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyAssignmentProperties.
func (rmpap RoleManagementPolicyAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmpap.Scope != nil {
		objectMap["scope"] = rmpap.Scope
	}
	if rmpap.RoleDefinitionID != nil {
		objectMap["roleDefinitionId"] = rmpap.RoleDefinitionID
	}
	if rmpap.PolicyID != nil {
		objectMap["policyId"] = rmpap.PolicyID
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleManagementPolicyAssignmentProperties struct.
func (rmpap *RoleManagementPolicyAssignmentProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "scope":
			if v != nil {
				var scope string
				err = json.Unmarshal(*v, &scope)
				if err != nil {
					return err
				}
				rmpap.Scope = &scope
			}
		case "roleDefinitionId":
			if v != nil {
				var roleDefinitionID string
				err = json.Unmarshal(*v, &roleDefinitionID)
				if err != nil {
					return err
				}
				rmpap.RoleDefinitionID = &roleDefinitionID
			}
		case "policyId":
			if v != nil {
				var policyID string
				err = json.Unmarshal(*v, &policyID)
				if err != nil {
					return err
				}
				rmpap.PolicyID = &policyID
			}
		case "effectiveRules":
			if v != nil {
				effectiveRules, err := unmarshalBasicRoleManagementPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				rmpap.EffectiveRules = &effectiveRules
			}
		case "policyAssignmentProperties":
			if v != nil {
				var policyAssignmentProperties PolicyAssignmentProperties
				err = json.Unmarshal(*v, &policyAssignmentProperties)
				if err != nil {
					return err
				}
				rmpap.PolicyAssignmentProperties = &policyAssignmentProperties
			}
		}
	}

	return nil
}

// RoleManagementPolicyAuthenticationContextRule the role management policy authentication context rule.
type RoleManagementPolicyAuthenticationContextRule struct {
	// IsEnabled - The value indicating if rule is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// ClaimValue - The claim value.
	ClaimValue *string `json:"claimValue,omitempty"`
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) MarshalJSON() ([]byte, error) {
	rmpacr.RuleType = RuleTypeRoleManagementPolicyAuthenticationContextRule
	objectMap := make(map[string]interface{})
	if rmpacr.IsEnabled != nil {
		objectMap["isEnabled"] = rmpacr.IsEnabled
	}
	if rmpacr.ClaimValue != nil {
		objectMap["claimValue"] = rmpacr.ClaimValue
	}
	if rmpacr.ID != nil {
		objectMap["id"] = rmpacr.ID
	}
	if rmpacr.Target != nil {
		objectMap["target"] = rmpacr.Target
	}
	if rmpacr.RuleType != "" {
		objectMap["ruleType"] = rmpacr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return &rmpacr, true
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return nil, false
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyAuthenticationContextRule.
func (rmpacr RoleManagementPolicyAuthenticationContextRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmpacr, true
}

// RoleManagementPolicyEnablementRule the role management policy enablement rule.
type RoleManagementPolicyEnablementRule struct {
	// EnabledRules - The list of enabled rules.
	EnabledRules *[]EnablementRules `json:"enabledRules,omitempty"`
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) MarshalJSON() ([]byte, error) {
	rmper.RuleType = RuleTypeRoleManagementPolicyEnablementRule
	objectMap := make(map[string]interface{})
	if rmper.EnabledRules != nil {
		objectMap["enabledRules"] = rmper.EnabledRules
	}
	if rmper.ID != nil {
		objectMap["id"] = rmper.ID
	}
	if rmper.Target != nil {
		objectMap["target"] = rmper.Target
	}
	if rmper.RuleType != "" {
		objectMap["ruleType"] = rmper.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return &rmper, true
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return nil, false
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyEnablementRule.
func (rmper RoleManagementPolicyEnablementRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmper, true
}

// RoleManagementPolicyExpirationRule the role management policy expiration rule.
type RoleManagementPolicyExpirationRule struct {
	// IsExpirationRequired - The value indicating whether expiration is required.
	IsExpirationRequired *bool `json:"isExpirationRequired,omitempty"`
	// MaximumDuration - The maximum duration of expiration in timespan.
	MaximumDuration *string `json:"maximumDuration,omitempty"`
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) MarshalJSON() ([]byte, error) {
	rmper.RuleType = RuleTypeRoleManagementPolicyExpirationRule
	objectMap := make(map[string]interface{})
	if rmper.IsExpirationRequired != nil {
		objectMap["isExpirationRequired"] = rmper.IsExpirationRequired
	}
	if rmper.MaximumDuration != nil {
		objectMap["maximumDuration"] = rmper.MaximumDuration
	}
	if rmper.ID != nil {
		objectMap["id"] = rmper.ID
	}
	if rmper.Target != nil {
		objectMap["target"] = rmper.Target
	}
	if rmper.RuleType != "" {
		objectMap["ruleType"] = rmper.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return &rmper, true
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return nil, false
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyExpirationRule.
func (rmper RoleManagementPolicyExpirationRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmper, true
}

// RoleManagementPolicyListResult role management policy list operation result.
type RoleManagementPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - Role management policy list.
	Value *[]RoleManagementPolicy `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RoleManagementPolicyListResultIterator provides access to a complete listing of RoleManagementPolicy
// values.
type RoleManagementPolicyListResultIterator struct {
	i    int
	page RoleManagementPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RoleManagementPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleManagementPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RoleManagementPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RoleManagementPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RoleManagementPolicyListResultIterator) Response() RoleManagementPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RoleManagementPolicyListResultIterator) Value() RoleManagementPolicy {
	if !iter.page.NotDone() {
		return RoleManagementPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RoleManagementPolicyListResultIterator type.
func NewRoleManagementPolicyListResultIterator(page RoleManagementPolicyListResultPage) RoleManagementPolicyListResultIterator {
	return RoleManagementPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmplr RoleManagementPolicyListResult) IsEmpty() bool {
	return rmplr.Value == nil || len(*rmplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmplr RoleManagementPolicyListResult) hasNextLink() bool {
	return rmplr.NextLink != nil && len(*rmplr.NextLink) != 0
}

// roleManagementPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmplr RoleManagementPolicyListResult) roleManagementPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rmplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmplr.NextLink)))
}

// RoleManagementPolicyListResultPage contains a page of RoleManagementPolicy values.
type RoleManagementPolicyListResultPage struct {
	fn    func(context.Context, RoleManagementPolicyListResult) (RoleManagementPolicyListResult, error)
	rmplr RoleManagementPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RoleManagementPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleManagementPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmplr)
		if err != nil {
			return err
		}
		page.rmplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RoleManagementPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RoleManagementPolicyListResultPage) NotDone() bool {
	return !page.rmplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RoleManagementPolicyListResultPage) Response() RoleManagementPolicyListResult {
	return page.rmplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RoleManagementPolicyListResultPage) Values() []RoleManagementPolicy {
	if page.rmplr.IsEmpty() {
		return nil
	}
	return *page.rmplr.Value
}

// Creates a new instance of the RoleManagementPolicyListResultPage type.
func NewRoleManagementPolicyListResultPage(cur RoleManagementPolicyListResult, getNextPage func(context.Context, RoleManagementPolicyListResult) (RoleManagementPolicyListResult, error)) RoleManagementPolicyListResultPage {
	return RoleManagementPolicyListResultPage{
		fn:    getNextPage,
		rmplr: cur,
	}
}

// RoleManagementPolicyNotificationRule the role management policy notification rule.
type RoleManagementPolicyNotificationRule struct {
	// NotificationType - The type of notification. Possible values include: 'NotificationDeliveryMechanismEmail'
	NotificationType NotificationDeliveryMechanism `json:"notificationType,omitempty"`
	// NotificationLevel - The notification level. Possible values include: 'NotificationLevelNone', 'NotificationLevelCritical', 'NotificationLevelAll'
	NotificationLevel NotificationLevel `json:"notificationLevel,omitempty"`
	// RecipientType - The recipient type. Possible values include: 'RecipientTypeRequestor', 'RecipientTypeApprover', 'RecipientTypeAdmin'
	RecipientType RecipientType `json:"recipientType,omitempty"`
	// NotificationRecipients - The list of notification recipients.
	NotificationRecipients *[]string `json:"notificationRecipients,omitempty"`
	// IsDefaultRecipientsEnabled - Determines if the notification will be sent to the recipient type specified in the policy rule.
	IsDefaultRecipientsEnabled *bool `json:"isDefaultRecipientsEnabled,omitempty"`
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) MarshalJSON() ([]byte, error) {
	rmpnr.RuleType = RuleTypeRoleManagementPolicyNotificationRule
	objectMap := make(map[string]interface{})
	if rmpnr.NotificationType != "" {
		objectMap["notificationType"] = rmpnr.NotificationType
	}
	if rmpnr.NotificationLevel != "" {
		objectMap["notificationLevel"] = rmpnr.NotificationLevel
	}
	if rmpnr.RecipientType != "" {
		objectMap["recipientType"] = rmpnr.RecipientType
	}
	if rmpnr.NotificationRecipients != nil {
		objectMap["notificationRecipients"] = rmpnr.NotificationRecipients
	}
	if rmpnr.IsDefaultRecipientsEnabled != nil {
		objectMap["isDefaultRecipientsEnabled"] = rmpnr.IsDefaultRecipientsEnabled
	}
	if rmpnr.ID != nil {
		objectMap["id"] = rmpnr.ID
	}
	if rmpnr.Target != nil {
		objectMap["target"] = rmpnr.Target
	}
	if rmpnr.RuleType != "" {
		objectMap["ruleType"] = rmpnr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return &rmpnr, true
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return nil, false
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyNotificationRule.
func (rmpnr RoleManagementPolicyNotificationRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmpnr, true
}

// RoleManagementPolicyProperties role management policy properties with scope.
type RoleManagementPolicyProperties struct {
	// Scope - The role management policy scope.
	Scope *string `json:"scope,omitempty"`
	// DisplayName - The role management policy display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The role management policy description.
	Description *string `json:"description,omitempty"`
	// IsOrganizationDefault - The role management policy is default policy.
	IsOrganizationDefault *bool      `json:"isOrganizationDefault,omitempty"`
	LastModifiedBy        *Principal `json:"lastModifiedBy,omitempty"`
	// LastModifiedDateTime - READ-ONLY; The last modified date time.
	LastModifiedDateTime *date.Time `json:"lastModifiedDateTime,omitempty"`
	// Rules - The rule applied to the policy.
	Rules *[]BasicRoleManagementPolicyRule `json:"rules,omitempty"`
	// EffectiveRules - READ-ONLY; The readonly computed rule applied to the policy.
	EffectiveRules *[]BasicRoleManagementPolicyRule `json:"effectiveRules,omitempty"`
	// PolicyProperties - READ-ONLY; Additional properties of scope
	PolicyProperties *PolicyProperties `json:"policyProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyProperties.
func (rmpp RoleManagementPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmpp.Scope != nil {
		objectMap["scope"] = rmpp.Scope
	}
	if rmpp.DisplayName != nil {
		objectMap["displayName"] = rmpp.DisplayName
	}
	if rmpp.Description != nil {
		objectMap["description"] = rmpp.Description
	}
	if rmpp.IsOrganizationDefault != nil {
		objectMap["isOrganizationDefault"] = rmpp.IsOrganizationDefault
	}
	if rmpp.LastModifiedBy != nil {
		objectMap["lastModifiedBy"] = rmpp.LastModifiedBy
	}
	if rmpp.Rules != nil {
		objectMap["rules"] = rmpp.Rules
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RoleManagementPolicyProperties struct.
func (rmpp *RoleManagementPolicyProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "scope":
			if v != nil {
				var scope string
				err = json.Unmarshal(*v, &scope)
				if err != nil {
					return err
				}
				rmpp.Scope = &scope
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				rmpp.DisplayName = &displayName
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				rmpp.Description = &description
			}
		case "isOrganizationDefault":
			if v != nil {
				var isOrganizationDefault bool
				err = json.Unmarshal(*v, &isOrganizationDefault)
				if err != nil {
					return err
				}
				rmpp.IsOrganizationDefault = &isOrganizationDefault
			}
		case "lastModifiedBy":
			if v != nil {
				var lastModifiedBy Principal
				err = json.Unmarshal(*v, &lastModifiedBy)
				if err != nil {
					return err
				}
				rmpp.LastModifiedBy = &lastModifiedBy
			}
		case "lastModifiedDateTime":
			if v != nil {
				var lastModifiedDateTime date.Time
				err = json.Unmarshal(*v, &lastModifiedDateTime)
				if err != nil {
					return err
				}
				rmpp.LastModifiedDateTime = &lastModifiedDateTime
			}
		case "rules":
			if v != nil {
				rules, err := unmarshalBasicRoleManagementPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				rmpp.Rules = &rules
			}
		case "effectiveRules":
			if v != nil {
				effectiveRules, err := unmarshalBasicRoleManagementPolicyRuleArray(*v)
				if err != nil {
					return err
				}
				rmpp.EffectiveRules = &effectiveRules
			}
		case "policyProperties":
			if v != nil {
				var policyProperties PolicyProperties
				err = json.Unmarshal(*v, &policyProperties)
				if err != nil {
					return err
				}
				rmpp.PolicyProperties = &policyProperties
			}
		}
	}

	return nil
}

// BasicRoleManagementPolicyRule the role management policy rule.
type BasicRoleManagementPolicyRule interface {
	AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool)
	AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool)
	AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool)
	AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool)
	AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool)
	AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool)
}

// RoleManagementPolicyRule the role management policy rule.
type RoleManagementPolicyRule struct {
	// ID - The id of the rule.
	ID *string `json:"id,omitempty"`
	// Target - The target of the current rule.
	Target *RoleManagementPolicyRuleTarget `json:"target,omitempty"`
	// RuleType - Possible values include: 'RuleTypeRoleManagementPolicyRule', 'RuleTypeRoleManagementPolicyApprovalRule', 'RuleTypeRoleManagementPolicyAuthenticationContextRule', 'RuleTypeRoleManagementPolicyEnablementRule', 'RuleTypeRoleManagementPolicyExpirationRule', 'RuleTypeRoleManagementPolicyNotificationRule'
	RuleType RuleType `json:"ruleType,omitempty"`
}

func unmarshalBasicRoleManagementPolicyRule(body []byte) (BasicRoleManagementPolicyRule, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["ruleType"] {
	case string(RuleTypeRoleManagementPolicyApprovalRule):
		var rmpar RoleManagementPolicyApprovalRule
		err := json.Unmarshal(body, &rmpar)
		return rmpar, err
	case string(RuleTypeRoleManagementPolicyAuthenticationContextRule):
		var rmpacr RoleManagementPolicyAuthenticationContextRule
		err := json.Unmarshal(body, &rmpacr)
		return rmpacr, err
	case string(RuleTypeRoleManagementPolicyEnablementRule):
		var rmper RoleManagementPolicyEnablementRule
		err := json.Unmarshal(body, &rmper)
		return rmper, err
	case string(RuleTypeRoleManagementPolicyExpirationRule):
		var rmper RoleManagementPolicyExpirationRule
		err := json.Unmarshal(body, &rmper)
		return rmper, err
	case string(RuleTypeRoleManagementPolicyNotificationRule):
		var rmpnr RoleManagementPolicyNotificationRule
		err := json.Unmarshal(body, &rmpnr)
		return rmpnr, err
	default:
		var rmpr RoleManagementPolicyRule
		err := json.Unmarshal(body, &rmpr)
		return rmpr, err
	}
}
func unmarshalBasicRoleManagementPolicyRuleArray(body []byte) ([]BasicRoleManagementPolicyRule, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rmprArray := make([]BasicRoleManagementPolicyRule, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rmpr, err := unmarshalBasicRoleManagementPolicyRule(*rawMessage)
		if err != nil {
			return nil, err
		}
		rmprArray[index] = rmpr
	}
	return rmprArray, nil
}

// MarshalJSON is the custom marshaler for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) MarshalJSON() ([]byte, error) {
	rmpr.RuleType = RuleTypeRoleManagementPolicyRule
	objectMap := make(map[string]interface{})
	if rmpr.ID != nil {
		objectMap["id"] = rmpr.ID
	}
	if rmpr.Target != nil {
		objectMap["target"] = rmpr.Target
	}
	if rmpr.RuleType != "" {
		objectMap["ruleType"] = rmpr.RuleType
	}
	return json.Marshal(objectMap)
}

// AsRoleManagementPolicyApprovalRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyApprovalRule() (*RoleManagementPolicyApprovalRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyAuthenticationContextRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyAuthenticationContextRule() (*RoleManagementPolicyAuthenticationContextRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyEnablementRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyEnablementRule() (*RoleManagementPolicyEnablementRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyExpirationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyExpirationRule() (*RoleManagementPolicyExpirationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyNotificationRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyNotificationRule() (*RoleManagementPolicyNotificationRule, bool) {
	return nil, false
}

// AsRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsRoleManagementPolicyRule() (*RoleManagementPolicyRule, bool) {
	return &rmpr, true
}

// AsBasicRoleManagementPolicyRule is the BasicRoleManagementPolicyRule implementation for RoleManagementPolicyRule.
func (rmpr RoleManagementPolicyRule) AsBasicRoleManagementPolicyRule() (BasicRoleManagementPolicyRule, bool) {
	return &rmpr, true
}

// RoleManagementPolicyRuleTarget the role management policy rule target.
type RoleManagementPolicyRuleTarget struct {
	// Caller - The caller of the setting.
	Caller *string `json:"caller,omitempty"`
	// Operations - The type of operation.
	Operations *[]string `json:"operations,omitempty"`
	// Level - The assignment level to which rule is applied.
	Level *string `json:"level,omitempty"`
	// TargetObjects - The list of target objects.
	TargetObjects *[]string `json:"targetObjects,omitempty"`
	// InheritableSettings - The list of inheritable settings.
	InheritableSettings *[]string `json:"inheritableSettings,omitempty"`
	// EnforcedSettings - The list of enforced settings.
	EnforcedSettings *[]string `json:"enforcedSettings,omitempty"`
}

// UserSet the detail of a user.
type UserSet struct {
	// UserType - The type of user. Possible values include: 'UserTypeUser', 'UserTypeGroup'
	UserType UserType `json:"userType,omitempty"`
	// IsBackup - The value indicating whether the user is a backup fallback approver
	IsBackup *bool `json:"isBackup,omitempty"`
	// ID - The object id of the user.
	ID *string `json:"id,omitempty"`
	// Description - The description of the user.
	Description *string `json:"description,omitempty"`
}
