#!/bin/sh

TEST=`type type|grep not`
if test -n "$TEST"; then
  WHICH=which
else
  WHICH=type
fi

echo "On some systems, you may need to change /bin/sh to point to bash"
echo
echo "Please submit the following information with your bug report: "
echo "--------------------------------------------------------------"
OS=`uname -s 2>/dev/null`
echo "OS             : $OS" 
REL=`uname -r 2>/dev/null`
echo "OS RELEASE     : $REL"
HW=`uname -m 2>/dev/null`
echo "HARDWARE       : $HW"

TEST=`$WHICH gcc 2>/dev/null`
if test -n "$TEST"; then
  VERS=`gcc --version 2>/dev/null | head -n 1`
  echo "gcc            : $VERS"
else
  echo "gcc            : Not Found";
fi

TEST=`$WHICH gmake 2>/dev/null`
if test -n "$TEST" ; then
	gmake --version 2>/dev/null |\
		awk -F, '{print $1}' |\
		awk '/GNU Make/{print "GNU gmake      :",$NF}'
else
  TEST=`make --version 2>/dev/null`
  if test -n "$TEST"; then
		make --version 2>/dev/null |\
			awk -F, '{print $1}' |\
			awk '/GNU Make/{print "make           :",$NF}'
  else
		echo "make           : Not Found"
  fi
fi

TEST=`$WHICH autoconf 2>/dev/null`
if test -n "$TEST"; then
  autoconf --version |\
    head -n 1 |\
    awk '{\
	if (length($4) == 0) {\
		print "autoconf       : "$3\
	} else {\
		print "autoconf       : "$4\
	}}'
else
  echo "autoconf       : Not Found"
fi

TEST=`$WHICH automake 2>/dev/null`
if test -n "$TEST"; then
  automake --version 2>/dev/null |\
    head -n 1 |\
    awk '{print "automake       : "$4}'
else
  echo "automake       : Not Found"
fi

TEST=`$WHICH libtool 2>/dev/null`
if test -n "$TEST"; then
  libtool --version 2>/dev/null |\
    head -n 1 |\
    awk '{print "libtool        : "$4}'
else
  echo "libtool        : Not Found"
fi

TEST=`$WHICH pkg-config 2> /dev/null`
if test -n "$TEST"; then
  pkg-config --version 2> /dev/null | \
    awk '{print "pkg-config     : "$1}'
else
  echo "pkg-config     : Not Found"
fi

TEST=`$WHICH pkg-config 2> /dev/null`
if test -n "$TEST"; then
  pkg-config --modversion glib-2.0 2> /dev/null | \
    awk '{print "glib2          : "$1}'
else
  echo "glib2          : Not Found"
fi

TEST=`$WHICH X 2> /dev/null`
if test -n "$TEST"; then
  X -version | \
    awk '{print "X          : "$1}'
else
  echo "X          : Not Found"
fi

echo "fglrx          :"
dmesg | grep fglrx | uniq
echo "NVIDIA         :"
dmesg | grep NVIDIA | uniq
echo "agpgart        :"
dmesg | grep agpgart | uniq


echo "--------------------------------------------------------------"
